/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.nio.ch.DevPollArrayWrapper;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.Util;

class DevPollSelectorImpl
extends SelectorImpl {
    protected int fd0;
    protected int fd1;
    DevPollArrayWrapper pollWrapper;
    private Map<Integer, SelectionKeyImpl> fdToKey;
    private boolean closed = false;
    private Object closeLock = new Object();
    private Object interruptLock = new Object();
    private boolean interruptTriggered = false;

    DevPollSelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        int[] nArray = new int[2];
        IOUtil.initPipe(nArray, false);
        this.fd0 = nArray[0];
        this.fd1 = nArray[1];
        this.pollWrapper = new DevPollArrayWrapper();
        this.pollWrapper.initInterrupt(this.fd0, this.fd1);
        this.fdToKey = new HashMap<Integer, SelectionKeyImpl>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSelect(long l) throws IOException {
        Object object;
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        try {
            this.begin();
            this.pollWrapper.poll(l);
            object = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.end();
            throw throwable;
        }
        this.end();
        this.processDeregisterQueue();
        int n = this.updateSelectedKeys();
        if (this.pollWrapper.interrupted()) {
            this.pollWrapper.putReventOps(this.pollWrapper.interruptedIndex(), 0);
            object = this.interruptLock;
            synchronized (object) {
                this.pollWrapper.clearInterrupted();
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return n;
    }

    private int updateSelectedKeys() {
        int n = this.pollWrapper.updated;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.pollWrapper.getDescriptor(i);
            SelectionKeyImpl selectionKeyImpl = this.fdToKey.get(n3);
            if (selectionKeyImpl == null) continue;
            int n4 = this.pollWrapper.getReventOps(i);
            if (this.selectedKeys.contains(selectionKeyImpl)) {
                if (!selectionKeyImpl.channel.translateAndSetReadyOps(n4, selectionKeyImpl)) continue;
                ++n2;
                continue;
            }
            selectionKeyImpl.channel.translateAndSetReadyOps(n4, selectionKeyImpl);
            if ((selectionKeyImpl.nioReadyOps() & selectionKeyImpl.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(selectionKeyImpl);
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implClose() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Iterator iterator = this.interruptLock;
        synchronized (iterator) {
            this.interruptTriggered = true;
        }
        FileDispatcher.closeIntFD(this.fd0);
        FileDispatcher.closeIntFD(this.fd1);
        this.pollWrapper.release(this.fd0);
        this.pollWrapper.closeDevPollFD();
        this.selectedKeys = null;
        iterator = this.keys.iterator();
        while (iterator.hasNext()) {
            SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)iterator.next();
            this.deregister(selectionKeyImpl);
            SelectableChannel selectableChannel = selectionKeyImpl.channel();
            if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
                ((SelChImpl)((Object)selectableChannel)).kill();
            }
            iterator.remove();
        }
        this.fd0 = -1;
        this.fd1 = -1;
    }

    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        int n = IOUtil.fdVal(selectionKeyImpl.channel.getFD());
        this.fdToKey.put(n, selectionKeyImpl);
        this.keys.add(selectionKeyImpl);
    }

    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        int n = selectionKeyImpl.getIndex();
        assert (n >= 0);
        int n2 = selectionKeyImpl.channel.getFDVal();
        this.fdToKey.remove(n2);
        this.pollWrapper.release(n2);
        selectionKeyImpl.setIndex(-1);
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        SelectableChannel selectableChannel = selectionKeyImpl.channel();
        if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
            ((SelChImpl)((Object)selectableChannel)).kill();
        }
    }

    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        int n2 = IOUtil.fdVal(selectionKeyImpl.channel.getFD());
        this.pollWrapper.setInterest(n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.pollWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    static {
        Util.load();
    }
}

