/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.TCPClient;
import sun.security.krb5.internal.UDPClient;

public abstract class KrbKdcReq {
    private static final int DEFAULT_KDC_PORT = 88;
    private static final int DEFAULT_KDC_RETRY_LIMIT = 3;
    public static final int DEFAULT_KDC_TIMEOUT;
    private static final boolean DEBUG;
    private static int udpPrefLimit;
    protected byte[] obuf;
    protected byte[] ibuf;

    public String send(String string) throws IOException, KrbException {
        boolean bl = udpPrefLimit > 0 && this.obuf != null && this.obuf.length > udpPrefLimit;
        return this.send(string, bl);
    }

    public String send(String string, boolean bl) throws IOException, KrbException {
        if (this.obuf == null) {
            return null;
        }
        Exception exception = null;
        Config config = Config.getInstance();
        if (string == null && (string = config.getDefaultRealm()) == null) {
            throw new KrbException(60, "Cannot find default realm");
        }
        int n = this.getKdcTimeout(string);
        String string2 = config.getKDCList(string);
        if (string2 == null) {
            throw new KrbException("Cannot get kdc for realm " + string);
        }
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            try {
                this.send(string, string3, bl);
                break;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        if (this.ibuf == null && exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (KrbException)exception;
        }
        return string3;
    }

    public void send(String string, String string2, boolean bl) throws IOException, KrbException {
        Object object;
        int n;
        if (this.obuf == null) {
            return;
        }
        Object var4_4 = null;
        int n2 = 88;
        int n3 = this.getKdcTimeout(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        String string3 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens() && (n = KrbKdcReq.parsePositiveIntString((String)(object = stringTokenizer.nextToken()))) > 0) {
            n2 = n;
        }
        if (DEBUG) {
            System.out.println(">>> KrbKdcReq send: kdc=" + string3 + (bl ? " TCP:" : " UDP:") + n2 + ", timeout=" + n3 + ", number of retries =" + 3 + ", #bytes=" + this.obuf.length);
        }
        object = new KdcCommunication(string3, n2, bl, n3, this.obuf);
        try {
            this.ibuf = (byte[])AccessController.doPrivileged(object);
            if (DEBUG) {
                System.out.println(">>> KrbKdcReq send: #bytes read=" + (this.ibuf != null ? this.ibuf.length : 0));
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (KrbException)exception;
        }
        if (DEBUG) {
            System.out.println(">>> KrbKdcReq send: #bytes read=" + (this.ibuf != null ? this.ibuf.length : 0));
        }
    }

    private int getKdcTimeout(String string) {
        int n = DEFAULT_KDC_TIMEOUT;
        if (string == null) {
            return n;
        }
        int n2 = -1;
        try {
            String string2 = Config.getInstance().getDefault("kdc_timeout", string);
            n2 = KrbKdcReq.parsePositiveIntString(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 > 0) {
            n = n2;
        }
        return n;
    }

    private static int parsePositiveIntString(String string) {
        if (string == null) {
            return -1;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
        if (n >= 0) {
            return n;
        }
        return -1;
    }

    static {
        int n;
        block2: {
            DEBUG = Krb5.DEBUG;
            udpPrefLimit = -1;
            n = -1;
            try {
                Config config = Config.getInstance();
                String string = config.getDefault("kdc_timeout", "libdefaults");
                n = KrbKdcReq.parsePositiveIntString(string);
                string = config.getDefault("udp_preference_limit", "libdefaults");
                udpPrefLimit = KrbKdcReq.parsePositiveIntString(string);
            }
            catch (Exception exception) {
                if (!DEBUG) break block2;
                System.out.println("Exception in getting kdc_timeout value, using default value " + exception.getMessage());
            }
        }
        DEFAULT_KDC_TIMEOUT = n > 0 ? n : 30000;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KdcCommunication
    implements PrivilegedExceptionAction<byte[]> {
        private String kdc;
        private int port;
        private boolean useTCP;
        private int timeout;
        private byte[] obuf;

        public KdcCommunication(String string, int n, boolean bl, int n2, byte[] byArray) {
            this.kdc = string;
            this.port = n;
            this.useTCP = bl;
            this.timeout = n2;
            this.obuf = byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] run() throws IOException, KrbException {
            byte[] byArray = null;
            if (this.useTCP) {
                TCPClient tCPClient = new TCPClient(this.kdc, this.port);
                try {
                    tCPClient.send(this.obuf);
                    byArray = tCPClient.receive();
                }
                finally {
                    tCPClient.close();
                }
            } else {
                for (int i = 1; i <= 3; ++i) {
                    UDPClient uDPClient = new UDPClient(this.kdc, this.port, this.timeout);
                    if (DEBUG) {
                        System.out.println(">>> KDCCommunication: kdc=" + this.kdc + (this.useTCP ? " TCP:" : " UDP:") + this.port + ", timeout=" + this.timeout + ",Attempt =" + i + ", #bytes=" + this.obuf.length);
                    }
                    uDPClient.send(this.obuf);
                    try {
                        byArray = uDPClient.receive();
                        break;
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        if (DEBUG) {
                            System.out.println("SocketTimeOutException with attempt: " + i);
                        }
                        if (i != 3) continue;
                        byArray = null;
                        throw socketTimeoutException;
                    }
                }
            }
            return byArray;
        }
    }
}

