#if 0
#include "polarssl/config.h"
#include "polarssl/aes.h"
#include "polarssl/sha2.h"

#include <linux/cdev.h>
#include <linux/types.h>
#include <linux/fs.h>
#include <linux/device.h>
#include <linux/slab.h>
#include <linux/delay.h>
#include <asm/uaccess.h>
#endif

#include "../aes_pollar.h"


//AES key table
static unsigned char default_AESkey[] = {
0xAD,0x93,0x00,0xC4,0x8E,0x50,0x20,0xC5,0x3F,0xBF,0x23,0x32,0x80,0x5A,0xC6,0xDF,
0x2F,0x7D,0x49,0xD9,0x15,0x8B,0x7F,0x04,0x2C,0x80,0xB0,0x62,0x78,0x25,0x8D,0x9C,
0x13,0x22,0x02,0x4A,0x55,0x23,0xBB,0xCB,0xF1,0xFB,0x2A,0xCC,0xBB,0x95,0xF4,0x50,
0xAE,0x08,0xD7,0xFB,0x80,0xF2,0x64,0x72,0xE3,0x3C,0xC4,0xB4,0xA3,0x50,0xD9,0xF1,
0x2A,0xDE,0xFC,0xD7,0x67,0xC8,0xDE,0xD0,0xF0,0x1E,0xE8,0x12,0xF9,0x57,0x25,0x36,
0x6D,0x71,0xD2,0xF8,0x1E,0x32,0x25,0x59,0x89,0x80,0xA3,0x59,0xD4,0xB6,0xDA,0x00,
0x8D,0xB8,0x5B,0x95,0x96,0x47,0x07,0xBD,0xED,0x68,0xDF,0xB9,0xD5,0x93,0x34,0x8F,
0xC6,0x66,0x06,0x64,0x94,0xCC,0x27,0x29,0x3A,0x8F,0x58,0x2E,0x70,0x7D,0x22,0xE7,
0x9D,0x62,0xAA,0xD1,0x0C,0xD2,0xD7,0x76,0xBD,0x40,0xCD,0x87,0x4E,0xC8,0x4C,0x80,
0x86,0xC2,0xB8,0x97,0xA3,0xDC,0x8F,0x8C,0x45,0xCC,0x26,0x40,0xBD,0xEB,0x3F,0xAF,
0x55,0x1E,0x88,0xFC,0x38,0xC0,0x06,0x1C,0xDA,0xDB,0xE4,0xFA,0x2B,0xFB,0x6D,0x6F,
0x19,0x62,0x0A,0xC4,0xEA,0xF0,0xE3,0x47,0xDB,0x47,0x83,0xE8,0x50,0x17,0xDF,0xA8,
0x29,0x37,0xB4,0x0A,0x19,0x1B,0x2D,0xDB,0x86,0xC8,0xBB,0xD1,0x52,0xD5,0x8F,0xC8,
0x2B,0xBC,0xE7,0x8A,0xF4,0xA1,0xE2,0x4D,0xAC,0xFC,0xB2,0x6F,0xDA,0x82,0xAB,0x86,
0xB7,0x95,0x6B,0xD7,0xA9,0x07,0xC7,0xB8,0x2D,0xBF,0x86,0xB4,0xBF,0xF4,0xC8,0xFD,
0x50,0x43,0xEB,0x8D,0xAB,0x16,0x91,0xBB,0x6B,0x5E,0x60,0x21,0x57,0x44,0x61,0x06,
};


/* function: polarssl_aes_algorithm
 * mode: AES_DECRYPT, AES_ENCRYPT
 * way: 0: 128bit, 1:192bit,2:256bit
 * output: 
 * input:
 * size: input buf size
 * keyiv: iv
 * keykey: key
 * */
int polarssl_aes_algorithm(int mode,int way,unsigned char *output,unsigned char *input,int size,unsigned char *keyiv,unsigned char *keykey)
{
	unsigned char iv[16];
	unsigned char key[32];
	//unsigned char buf[64];
	
	aes_context ctx;
	if((way <0)||(way > 2)){
		return -1;
	}
	if((output == NULL)||(input == NULL)||(keyiv == NULL)||(keykey == NULL)||(size&0xf) || (size == 0)){
		return -1;
	}
	//size = ((size+15)>>4)<<4;
	ctx.nr = 0;
	ctx.rk = 0;
	memset(ctx.buf,0,sizeof(ctx.buf));
	
	memcpy( key, keykey, 32 );
	
	memcpy( iv , keyiv, 16 );
	//memcpy( buf, input, 16 );
	if( mode == AES_DECRYPT ){
		
		aes_setkey_dec( &ctx, key, 128 + way * 64 );
		
		aes_crypt_cbc( &ctx, mode, size, iv, input, output );
	}
	else {
		aes_setkey_enc( &ctx, key, 128 + way * 64 );
		aes_crypt_cbc( &ctx, mode, size, iv, input, output );
	}
	return 0;
}
int aes_algorithm_decrypt(unsigned char *output,unsigned char *input,int size,unsigned char *keyiv,unsigned char *keykey)
{
	int ret;
	ret = polarssl_aes_algorithm(AES_DECRYPT,2,output,input,size,keyiv,keykey);
	return ret;
}
int aes_algorithm_encrypt(unsigned char *output,unsigned char *input,int size,unsigned char *keyiv,unsigned char *keykey)
{
	int ret;
	
	ret = polarssl_aes_algorithm(AES_ENCRYPT,2,output,input,size,keyiv,keykey);
	return ret;
}

int aml_aes_encrypt(unsigned char *output,unsigned char *input,int size)
{
	int ret;
	unsigned char *keyiv, *keykey;
	keyiv = &default_AESkey[0];
	keykey = &default_AESkey[16];
	ret = aes_algorithm_encrypt(output,input,size,keyiv,keykey);
	return ret;
}
int aml_aes_decrypt(unsigned char *output,unsigned char *input,int size)
{
	int ret;
	unsigned char *keyiv, *keykey;
	keyiv = &default_AESkey[0];
	keykey = &default_AESkey[16];
	ret = aes_algorithm_decrypt(output,input,size,keyiv,keykey);
	return ret;
}


/******hash sha256*************/
/* sha2_calculate
 * mode: 0:256bit, 1:224bit
 * buf :
 * len :
 * hash:
 * */
int  sha2_calculate(int mode,unsigned char *buf,int len,unsigned char *hash)
{
#if 1
	int ret;
	unsigned char sha2sum[32];
	extern int sha2_sum( unsigned char outbuf[32],const unsigned char *pbuff, int nLen );
	ret = sha2_sum(sha2sum,buf,len);
	memcpy(hash,sha2sum,32);
	return ret;
#else
	sha2_context ctx;
	unsigned char sha2sum[32];

	if(mode < 0 || mode > 1){
		return -1;
	}
	if((buf == NULL) || (len <=0) ||(hash == NULL)){
		return -1;
	}
	sha2_starts( &ctx, mode );
	sha2_update(&ctx,buf,len);
	sha2_finish( &ctx, sha2sum );
	memcpy(hash,sha2sum,32);
	return 0;
#endif
}

int hash_sha256(unsigned char *buf,int len,unsigned char *hash)
{
	int ret;
	ret = sha2_calculate(0,buf,len,hash);
	return ret;
}



