# coding: binary
# Generated by generate-specs
require 'helper'

describe_moneta "shared_tcp" do
  def features
    [:create, :increment]
  end

  def new_store
    Moneta.build do
      use(:Shared, port: 9001) do
        adapter :PStore, file: File.join(make_tempdir, 'shared_tcp')
      end
    end
  end

  def load_value(value)
    Marshal.load(value)
  end

  include_context 'setup_store'
  it_should_behave_like 'concurrent_create'
  it_should_behave_like 'concurrent_increment'
  it_should_behave_like 'create'
  it_should_behave_like 'features'
  it_should_behave_like 'increment'
  it_should_behave_like 'multiprocess'
  it_should_behave_like 'null_stringkey_stringvalue'
  it_should_behave_like 'null_pathkey_stringvalue'
  it_should_behave_like 'persist_stringkey_stringvalue'
  it_should_behave_like 'persist_pathkey_stringvalue'
  it_should_behave_like 'returndifferent_stringkey_stringvalue'
  it_should_behave_like 'returndifferent_pathkey_stringvalue'
  it_should_behave_like 'store_stringkey_stringvalue'
  it_should_behave_like 'store_pathkey_stringvalue'
  it_should_behave_like 'store_large'
  it 'shares values' do
    store['shared_key'] = 'shared_value'
    second = new_store
    second.key?('shared_key').should be_true
    second['shared_key'].should == 'shared_value'
    second.close
  end

end
