/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");
Components.utils.import("resource://gre/modules/Services.jsm");
Components.utils.import("resource://gre/modules/FileUtils.jsm");

function ProfileMigrator() {
}

ProfileMigrator.prototype = {
  migrate: function PM_migrate(aStartup) {
    // By opening the wizard with a supplied migrator, it will automatically
    // migrate from it.
    let [key, migrator] = this._getDefaultMigrator();
    if (!key)
        return;

    let params = Components.classes["@mozilla.org/array;1"]
                           .createInstance(Components.interfaces.nsIMutableArray);
    params.appendElement(this._toString(key), false);
    params.appendElement(migrator, false);
    params.appendElement(aStartup, false);

    Services.ww.openWindow(null,
                           "chrome://communicator/content/migration/migration.xul",
                           "_blank",
                           "chrome,dialog,modal,centerscreen,titlebar",
                           params);
  },

  _toString: function PM__toString(aStr) {
    let str = Components.classes["@mozilla.org/supports-string;1"]
                         .createInstance(Components.interfaces.nsISupportsString);
    str.data = aStr;
    return str;
  },

  _getMigratorIfSourceExists: function PM__getMigratorIfSourceExists(aKey) {
    let cid = "@mozilla.org/profile/migrator;1?app=suite&type=" + aKey;
    let migrator = Components.classes[cid]
                             .createInstance(Components.interfaces
                                                       .nsISuiteProfileMigrator);
    if (migrator.sourceExists)
      return migrator;
    return null;
  },

  // We don't yet support checking for the default browser on all platforms,
  // needless to say we don't have migrators for all browsers.  Thus, for each
  // platform, there's a fallback list of migrators used in these cases.
  _PLATFORM_FALLBACK_LIST:
     ["thunderbird"],

  _getDefaultMigrator: function PM__getDefaultMigrator() {
    let migratorsOrdered = Array.slice(this._PLATFORM_FALLBACK_LIST);
//@line 120 "/mnt/earmv6hf/pkgsrc/www/seamonkey/work.earmv6hf/seamonkey-2.49.4/suite/profile/migration/src/SuiteProfileMigrator.js"
    for (let key of migratorsOrdered) {
      let migrator = this._getMigratorIfSourceExists(key);
      if (migrator)
        return [key, migrator];
    }

    return ["", null];
  },

  QueryInterface: XPCOMUtils.generateQI([Components.interfaces.nsIProfileMigrator]),
  classDescription: "Profile Migrator",
  contractID: "@mozilla.org/toolkit/profile-migrator;1",
  classID: Components.ID("{d5148b7c-ba4e-4f7a-a80b-1ae48b90b910}"),
};

var NSGetFactory = XPCOMUtils.generateNSGetFactory([ProfileMigrator]);
