'\"
'\" Copyright (c) 2008 Arnulf Wiedemann
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH delegation n 4.0 itcl "[incr\ Tcl]"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
itcl::delegation \- delegate methods, procs or options to other objects
.PP
Parts of this description are "borrowed" from Tcl extension [snit], as the functionality is mostly identical.
.SH WARNING!
This is new functionality in [incr Tcl] where the API can still change!!
.SH SYNOPSIS
.nf
\fBdelegate method \fImethodName\fB to \fIcomponentName\fR ?\fBas \fItargetName\fR?
\fBdelegate method \fImethodName\fR ?\fBto \fIcomponentName\fR? \fBusing \fIpattern\fR
\fBdelegate method \fI* ?\fBto \fIcomponentName\fR? ?\fBusing \fIpattern\fR? ?\fBexcept \fImethodName methodName ...\fR?

\fBdelegate proc \fIprocName\fB to \fIcomponentName\fR ?\fBas \fItargetName\fR?
\fBdelegate proc \fIprocName\fR ?\fBto \fIcomponentName\fR? \fBusing \fIpattern\fR
\fBdelegate proc \fI*\fR ?\fBto \fIcomponentName\fR? ?\fBusing \fIpattern\fR? ?\fBexcept \fIprocName procName ...\fR?

\fBdelegate option \fIoptionSpec\fB to \fIcomponentName\fR
\fBdelegate option \fIoptionSpec\fB to \fIcomponentName\fR \fBas \fItargetname\fR?
\fBdelegate option \fI* \fBto \fIcomponentName\fR
\fBdelegate option \fI* \fBto \fIcomponentName\fR \fBexcept \fIoptionName optionname ...\fR
.fi
.BE

.SH DESCRIPTION
.PP
The \fBdelegate\fR command is used inside an \fB[incr\ Tcl]\fR
extendedclass/widget/widgetadaptor definition to delegate
methods/procs/options to other objects for handling.
.TP
\fBdelegate method \fImethodName\fB to \fIcomponentName\fR ?\fBas \fItargetName\fR?
.
This form of delegate method delegates method methodName to component
componentName. That is, when method methdoNameame is called on an instance of
this type, the method and its arguments will be passed to the named component's
command instead. That is, the following statement
.RS
.PP
.CS
delegate method wag to tail
.CE
.PP
is roughly equivalent to this explicitly defined method:
.PP
.CS
method wag {args} {
    uplevel $tail wag $args
}
.CE
.PP
The optional \fBas\fR clause allows you to specify the delegated method
name and possibly add some arguments:
.PP
.CS
delegate method wagtail to tail as "wag briskly"
.CE
.PP
A method cannot be both locally defined and delegated. 
.RE
.TP
\fBdelegate method \fImethodName\fR ?\fBto \fIcomponentName\fR? \fBusing \fIpattern\fR
.
In this form of the delegate statement, the \fBusing\fR clause is used to
specify the precise form of the command to which method name name is delegated.
The \fBto\fR clause is optional, since the chosen command might not involve
any particular component.
.RS
.PP
The value of the using clause is a list that may contain any or all of the
following substitution codes; these codes are substituted with the described
value to build the delegated command prefix. Note that the following two
statements are equivalent:
.PP
.CS
delegate method wag to tail
delegate method wag to tail using "%c %m"
.CE
.PP
Each element of the list becomes a single element of the delegated command 
--it is never reparsed as a string.
.PP
Substitutions:
.TP
\fB%%\fR
.
This is replaced with a single "%". Thus, to pass the string "%c" to the
command as an argument, you'd write "%%c".
.TP
\fB%c\fR
.
This is replaced with the named component's command. 
.TP
\fB%j\fR
.
This is replaced by the method name; if the name consists of multiple tokens,
they are joined by underscores ("_").
.TP
\fB%m\fR
.
This is replaced with the final token of the method name; if the method name
has one token, this is identical to \fB%M\fR.
.TP
\fB%M\fR
.
This is replaced by the method name; if the name consists of multiple tokens,
they are joined by space characters.
.TP
\fB%n\fR
.
This is replaced with the name of the instance's private namespace.
.TP
\fB%s\fR
.
This is replaced with the name of the instance command. 
.TP
\fB%t\fR
.
This is replaced with the fully qualified type name. 
.TP
\fB%w\fR
.
This is replaced with the original name of the instance command; for Itcl
widgets and widget adaptors, it will be the Tk window name. It remains
constant, even if the instance command is renamed.
.RE
.TP
\fBdelegate method \fI*\fR ?\fBto \fIcomponentName\fR? ?\fBusing \fIpattern\fR? ?\fBexcept \fImethodName methodName ...\fR?
.
In this form all unknown method names are delegeted to the specified
component. The except clause can be used to specify a list of exceptions,
i.e., method names that will not be so delegated. The using clause
is defined as given above. In this form, the statement must
contain the to clause, the using clause, or both.
.RS
.PP
In fact, the "*" can be a list of two or more tokens whose last element
is "*", as in the following example:
.PP
.CS
delegate method {tail *} to tail
.CE
.PP
This implicitly defines the method tail whose subcommands will be
delegated to the tail component. 
.PP
The definitions for \fBdelegate proc\fR ... are the same as for method,
the only difference being, that this is for procs.
.RE
.TP
\fBdelegate option \fInamespec\fB to \fIcomp\fR
.TP
\fBdelegate option namespec to comp as target\fR
.TP
\fBdelegate option * to \fIcomp\fR
.TP
\fBdelegate option * to \fIcomp \fBexcept \fIexceptions\fR
.
Defines a delegated option; the namespec is defined as for the option
statement. When the configure, configurelist, or cget instance method is
used to set or retrieve the option's value, the equivalent configure or
cget command will be applied to the component as though the option was
defined with the following \fB-configuremethod\fR and \fB-cgetmethod\fR:
.RS
.PP
.CS
method ConfigureMethod {option value} {
    $comp configure $option $value
}

method CgetMethod {option} {
    return [$comp cget $option]
}
.CE
.PP
Note that delegated options never appear in the \fBitcl_options\fR array.
If the as clause is specified, then the target option name is used in place
of name.
.RE
.TP
\fBdelegate \fIoption\fB *\fR ?\fBexcept\fI optionName optionName ...\fR?
.
This form delegates all unknown options to the specified component.
The except clause can be used to specify a list of exceptions,
i.e., option names that will not be so delegated.
.RS
.PP
\fBWarning:\fR options can only be delegated to a component if it supports the
\fBconfigure\fR and \fBcget\fR instance methods.
.PP
An option cannot be both locally defined and delegated. TBD: Continue from here.
.RE
.SH KEYWORDS
delegation, option, method, proc
