#!/usr/pkg/bin/ruby22

require "rss"

feeds = []
verbose = false
encoding = "UTF-8"

def error(exception)
  mark = "=" * 20
  mark = "#{mark} error #{mark}"
  STDERR.puts mark
  STDERR.puts exception.class
  STDERR.puts exception.message
  STDERR.puts exception.backtrace
  STDERR.puts mark
end

before_time = Time.now
ARGV.each do |fname|
  if fname == '-v'
    verbose = true
    next
  end
  rss = nil
  f = File.new(fname).read
  begin
    ## do validate parse
    rss = RSS::Parser.parse(f)
  rescue RSS::InvalidRSSError
    error($!) if verbose
    ## do non validate parse for invalid RSS 1.0
    begin
      rss = RSS::Parser.parse(f, false)
    rescue RSS::Error
      ## invalid RSS.
      error($!) if verbose
    end
  rescue RSS::Error
    error($!) if verbose
  end
  if rss.nil?
    STDERR.puts "#{fname} does not include RSS 1.0 or 0.9x/2.0"
  else
    begin
      rss.output_encoding = encoding
    rescue RSS::UnknownConversionMethodError
      error($!) if verbose
    end
    feeds << rss
  end
end
processing_time = Time.now - before_time

rss = RSS::Maker.make("1.0") do |maker|
  maker.encoding = encoding
  maker.channel.about = "http://example.com/blend.rdf"
  maker.channel.title = "blended feeds"
  maker.channel.link = "http://example.com/"
  maker.channel.description = "blended feeds generated by RSS Parser"

  feeds.each do |feed|
    feed.items.each do |item|
      item.setup_maker(maker.items)
    end
  end

  maker.items.each do |item|
    item.title ||= "UNKNOWN"
    item.link ||= "UNKNOWN"
  end

  maker.items.do_sort = true
  maker.items.max_size = 15
end
puts rss

STDERR.puts "Used XML parser: #{RSS::Parser.default_parser}"
STDERR.puts "Processing time: #{processing_time}s"
