#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <md5.h>
#include "rtld.h"

void apply_checksum(Obj_Entry *first);
static int _apply_checksum(Obj_Entry *);

void
apply_checksum(Obj_Entry *first)
{
	Obj_Entry *obj = first;

	Needed_Entry *needed;
		
	if (_apply_checksum(first) != 0) {
		printf("%s: no checksum entry found\n",
		    first->path);
		return;
	}

	for (needed = obj->needed; needed != NULL; needed = needed->next)
		if (needed->obj->write && _apply_checksum(needed->obj) != 0)
			printf("%s: no checksum entry found\n",
			    needed->obj->path);
}

static int
_apply_checksum(Obj_Entry *obj)
{
	Elf_Ehdr *eh;
	Elf_Phdr *ph, *phlimit;

	eh = (Elf_Ehdr *)obj->mapbase;
	ph = (Elf_Phdr *)(obj->mapbase + eh->e_phoff);
	phlimit = ph + eh->e_phnum;
	for (; ph < phlimit; ph++) {
		if (ph->p_type == PT_NB_CKSUM) {
			u_int32_t *ptr = (u_int32_t *)(obj->mapbase +
			    ph->p_offset);
			if (ptr[0] == 0) {
				u_int32_t cval, clen;
				struct stat sb;
				char *buf;
				int fd = open(obj->path, O_RDONLY);
				fstat(fd, &sb);
				if ((buf = (char *)malloc(sb.st_size)) == NULL)
					err(0, "%s", obj->path);
				if (read(fd, buf, sb.st_size) != sb.st_size)
					errx(0, "%s: read error", obj->path);
				cval = crc32(0, NULL, 0);
				cval = crc32(cval, buf, sb.st_size);
				printf("CRC32 (%s) = 0x%x\n", obj->path, cval);
				ptr[0] = cval;
				cval = adler32(0, NULL, 0);
				cval = adler32(cval, buf, sb.st_size);
				printf("Adler32 (%s) = 0x%x\n", obj->path, cval);
				ptr[1] = cval;
				msync(obj->mapbase, obj->textsize, MS_ASYNC);
				free(buf);
			}
			return 0;
		}
	}
	
	return -1;
}
