/*	$NecBSD: fontmaru.h,v 1.6 1998/03/14 07:09:41 kmatsuda Exp $	*/
/*	$NetBSD$	*/

/*
 * [NetBSD for NEC PC-98 series]
 *  Copyright (c) 1994, 1995, 1996, 1997, 1998
 *	NetBSD/pc98 porting staff. All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

struct FontList fontmarulist[]= {
	{
	  0x2129, FONTGAIJI, 0,
	  {
	  0x0000, 0x0FE0, 0x1010, 0x1008, 0x1008, 0x1008, 0x0010, 0x0060,
	  0x0080, 0x0080, 0x0080, 0x0080, 0x0000, 0x0080, 0x0080, 0x0000,
	  },
	  0,
	},

	{
	  0x212a, FONTGAIJI, 0,
	  {
	  0x0000, 0x01E0, 0x03F0, 0x03F0, 0x03F0, 0x03E0, 0x01C0, 0x01C0,
	  0x0180, 0x0180, 0x0100, 0x0100, 0x0000, 0x0300, 0x0300, 0x0000,
	  },
	  0,
	},

	{
	  0x2141, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0702, 0x0884,
	  0x7088, 0x0070, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x216f, FONTGAIJI, 0,
	  {
	  0x0000, 0x2002, 0x1004, 0x0808, 0x0410, 0x1FFC, 0x0140, 0x0080,
	  0x0080, 0x1FFC, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000,
	  },
	  0,
	},

	{
	  0x2170, FONTGAIJI, 0,
	  {
	  0x0080, 0x03E0, 0x0490, 0x0888, 0x0880, 0x0880, 0x0480, 0x03F0,
	  0x0088, 0x0084, 0x0084, 0x1084, 0x0888, 0x07F0, 0x0080, 0x0000,
	  },
	  0,
	},

	{
	  0x2174, FONTGAIJI, 0,
	  {
	  0x0000, 0x0210, 0x0210, 0x0210, 0x0210, 0x1FFC, 0x0420, 0x0420,
	  0x0420, 0x0420, 0x0420, 0x3FF8, 0x0840, 0x0840, 0x0840, 0x0840,
	  },
	  0,
	},

	{
	  0x2175, FONTGAIJI, 0,
	  {
	  0x0000, 0x07E0, 0x0810, 0x1008, 0x1008, 0x1008, 0x0810, 0x0460,
	  0x0780, 0x1902, 0x2082, 0x2044, 0x2028, 0x1030, 0x0FCE, 0x0000,
	  },
	  0,
	},

	{
	  0x2177, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x03E0, 0x0C18, 0x1004, 0x11E4, 0x2212, 0x2412,
	  0x2412, 0x2424, 0x23D8, 0x1000, 0x0C18, 0x03E0, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2179, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0080, 0x0140, 0x0220, 0x7C1E, 0x2004,
	  0x1008, 0x0810, 0x0408, 0x0888, 0x1364, 0x3C1E, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x217a, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0080, 0x01C0, 0x03E0, 0x7FFE, 0x3FFC,
	  0x1FF8, 0x0FF0, 0x07F8, 0x0FF8, 0x1F7C, 0x3C1E, 0x0000, 0x0000,
	  },
	  0,
	},

#if 0	/* no space! */
	{
	  0x2274, FONTGAIJI, 0,
	  {
	  0x0020, 0x0420, 0x0420, 0x043c, 0x07fc, 0x3fe0, 0x3c20, 0x0420,
	  0x0420, 0x043c, 0x07fc, 0x3fe0, 0x3c20, 0x0420, 0x0420, 0x0400,
	  },
	  0,
	},
#endif

	{
	  0x2275, FONTGAIJI, 0,
	  {
	  0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x0400, 0x05e0, 0x0630,
	  0x0430, 0x0430, 0x0430, 0x0460, 0x04c0, 0x0500, 0x0600, 0x0400,
	  },
	  0,
	},

	{
	  0x2276, FONTGAIJI, 0,
	  {
	  0x0080, 0x0080, 0x00c0, 0x00e0, 0x00b0, 0x0098, 0x008c, 0x0084,
	  0x0084, 0x0088, 0x0090, 0x0080, 0x0f80, 0x1f80, 0x1f00, 0x0e00,
	  },
	  0,
	},

	{
	  0x2330, FONTGAIJI, 0,
	  {
	  0x0000, 0x03E0, 0x0410, 0x0808, 0x0804, 0x1004, 0x1004, 0x1004,
	  0x1004, 0x1004, 0x1004, 0x1004, 0x0808, 0x0408, 0x03F0, 0x0000,
	  },
	  0,
	},

#if 0	/* no space! */
	{
	  0x2331, FONTGAIJI, 0,
	  {
	  0x0000, 0x0300, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
	  0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x01C0, 0x0000,
	  },
	  0,
	},
#endif

	{
	  0x2332, FONTGAIJI, 0,
	  {
	  0x0000, 0x07F0, 0x0808, 0x1004, 0x1004, 0x0004, 0x0004, 0x0008,
	  0x0030, 0x00C0, 0x0300, 0x0400, 0x0800, 0x1000, 0x1FFC, 0x0000,
	  },
	  0,
	},

	{
	  0x2333, FONTGAIJI, 0,
	  {
	  0x0000, 0x07F0, 0x0808, 0x1004, 0x0004, 0x0004, 0x0008, 0x00F0,
	  0x0008, 0x0004, 0x0004, 0x2004, 0x2004, 0x1008, 0x0FF0, 0x0000,
	  },
	  0,
	},

	{
	  0x2334, FONTGAIJI, 0,
	  {
	  0x0000, 0x0010, 0x0030, 0x0050, 0x0090, 0x0110, 0x0210, 0x0410,
	  0x0810, 0x1010, 0x1010, 0x0FFC, 0x0010, 0x0010, 0x0010, 0x0000,
	  },
	  0,
	},

	{
	  0x2335, FONTGAIJI, 0,
	  {
	  0x0000, 0x0FF8, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x07F0,
	  0x0008, 0x0004, 0x0004, 0x0004, 0x0804, 0x0408, 0x03F0, 0x0000,
	  },
	  0,
	},

	{
	  0x2336, FONTGAIJI, 0,
	  {
	  0x0000, 0x03F0, 0x0408, 0x0800, 0x0800, 0x1000, 0x1000, 0x17F0,
	  0x1808, 0x1004, 0x1004, 0x1004, 0x1004, 0x0808, 0x07F0, 0x0000,
	  },
	  0,
	},

	{
	  0x2337, FONTGAIJI, 0,
	  {
	  0x0000, 0x3FFC, 0x2004, 0x0004, 0x0008, 0x0010, 0x0010, 0x0020,
	  0x0020, 0x0040, 0x0040, 0x0040, 0x0080, 0x0080, 0x0080, 0x0000,
	  },
	  0,
	},

	{
	  0x2338, FONTGAIJI, 0,
	  {
	  0x0000, 0x07F0, 0x0808, 0x1004, 0x1004, 0x1004, 0x0808, 0x07F0,
	  0x0808, 0x1004, 0x1004, 0x1004, 0x1004, 0x0808, 0x07F0, 0x0000,
	  },
	  0,
	},

	{
	  0x2339, FONTGAIJI, 0,
	  {
	  0x0000, 0x03F0, 0x0408, 0x0804, 0x1004, 0x1004, 0x2004, 0x2004,
	  0x2008, 0x1018, 0x0FF0, 0x0010, 0x0010, 0x0010, 0x0010, 0x0000,
	  },
	  0,
	},

	{
	  0x2421, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0200, 0x0200, 0x1FF8,
	  0x0200, 0x0210, 0x07E0, 0x0A50, 0x1248, 0x1188, 0x1108, 0x0E10, 0x0000,
	  },
	  0,
	},

	{
	  0x2422, FONTGAIJI, 0,
	  {
	  0x0000, 0x0100, 0x0100, 0x3FFE, 0x0100, 0x0104, 0x03F4,
	  0x0D08, 0x110C, 0x2112, 0x2112, 0x20A2, 0x20A2, 0x1042, 0x0884, 0x0700,
	  },
	  0,
	},

	{
	  0x2423, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	  0x0000, 0x1008, 0x2008, 0x2004, 0x2004, 0x2104, 0x1204, 0x0C00, 0x0000,
	  },
	  0,
	},

	{
	  0x2424, FONTGAIJI, 0,
	  {
	  0x0000, 0x1000, 0x1008, 0x1008, 0x2004, 0x2004, 0x2002,
	  0x2002, 0x2002, 0x2002, 0x2104, 0x1104, 0x1208, 0x0A00, 0x0400, 0x0000,
	  },
	  0,
	},

	{
	  0x2425, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0040, 0x0000,
	  0x03E0, 0x0C10, 0x1008, 0x0008, 0x0008, 0x0008, 0x0010, 0x0020, 0x00C0,
	  },
	  0,
	},

	{
	  0x2426, FONTGAIJI, 0,
	  {
	  0x0000, 0x0380, 0x0060, 0x0010, 0x0000, 0x03E0, 0x0C18,
	  0x3004, 0x0002, 0x0002, 0x0002, 0x0004, 0x0004, 0x0018, 0x0060, 0x0180,
	  },
	  0,
	},

	{
	  0x2427, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0600, 0x0180,
	  0x0000, 0x1FF0, 0x00C0, 0x0300, 0x0C00, 0x1004, 0x2008, 0x2F30, 0x30C0,
	  },
	  0,
	},

	{
	  0x2428, FONTGAIJI, 0,
	  {
	  0x0000, 0x0600, 0x0180, 0x0000, 0x3FF0, 0x0020, 0x0040,
	  0x0080, 0x0100, 0x0200, 0x0400, 0x0802, 0x1002, 0x3E04, 0x6188, 0x0070,
	  },
	  0,
	},

	{
	  0x2429, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100,
	  0x1FE0, 0x0108, 0x0104, 0x0FE0, 0x1118, 0x2104, 0x2104, 0x2204, 0x1C08,
	  },
	  0,
	},

	{
	  0x242a, FONTGAIJI, 0,
	  {
	  0x0000, 0x0100, 0x0100, 0x3FF0, 0x0104, 0x0102, 0x0102,
	  0x0FF0, 0x1108, 0x2104, 0x4102, 0x4102, 0x4102, 0x4102, 0x2204, 0x1C08,
	  },
	  0,
	},

	{
	  0x242b, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0100, 0x0100, 0x0200, 0x7F08, 0x0484,
	  0x0844, 0x1022, 0x1022, 0x2022, 0x2020, 0x4040, 0x4080, 0x0300, 0x0000,
	  },
	  0,
	},

	{
	  0x242c, FONTGAIJI, 0,
	  {
	  0x0000, 0x0004, 0x0112, 0x0108, 0x0200, 0x7F08, 0x0484,
	  0x0844, 0x1022, 0x1022, 0x2022, 0x2020, 0x4040, 0x4080, 0x0300, 0x0000,
	  },
	  0,
	},

	{
	  0x242d, FONTGAIJI, 0,
	  {
	  0x0000, 0x0200, 0x0100, 0x3FFC, 0x0080, 0x0040, 0x0020,
	  0x3FFC, 0x0010, 0x0008, 0x03FC, 0x0C00, 0x1000, 0x1000, 0x0806, 0x07F8,
	  },
	  0,
	},

	{
	  0x242e, FONTGAIJI, 0,
	  {
	  0x000A, 0x020A, 0x010A, 0x3FFC, 0x0080, 0x0040, 0x0020,
	  0x3FFC, 0x0010, 0x0008, 0x03FC, 0x0C00, 0x1000, 0x1000, 0x0806, 0x07F8,
	  },
	  0,
	},

	{
	  0x242f, FONTGAIJI, 0,
	  {
	  0x0000, 0x0040, 0x0180, 0x0200, 0x0400, 0x0800, 0x1000,
	  0x2000, 0x2000, 0x1000, 0x0C00, 0x0300, 0x00C0, 0x0030, 0x0008, 0x0000,
	  },
	  0,
	},

	{
	  0x2430, FONTGAIJI, 0,
	  {
	  0x0000, 0x0040, 0x0180, 0x0200, 0x0414, 0x0814, 0x1014,
	  0x2000, 0x2000, 0x1000, 0x0C00, 0x0300, 0x00C0, 0x0030, 0x0008, 0x0000,
	  },
	  0,
	},

	{
	  0x2431, FONTGAIJI, 0,
	  {
	  0x0000, 0x0040, 0x0020, 0x4020, 0x4020, 0x43FC, 0x4020,
	  0x4020, 0x4020, 0x4020, 0x2020, 0x2040, 0x2040, 0x0080, 0x0100, 0x0000,
	  },
	  0,
	},

	{
	  0x2432, FONTGAIJI, 0,
	  {
	  0x0000, 0x0045, 0x0025, 0x4020, 0x4020, 0x43FC, 0x4020,
	  0x4020, 0x4020, 0x4020, 0x2020, 0x2040, 0x2040, 0x0080, 0x0100, 0x0000,
	  },
	  0,
	},

	{
	  0x2433, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0FE0, 0x1010, 0x0008, 0x0010, 0x0020,
	  0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x2004, 0x1808, 0x07F0, 0x0000,
	  },
	  0,
	},

	{
	  0x2434, FONTGAIJI, 0,
	  {
	  0x0005, 0x0005, 0x0FE5, 0x1010, 0x0008, 0x0010, 0x0020,
	  0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x2004, 0x1808, 0x07F0, 0x0000,
	  },
	  0,
	},

	{
	  0x2435, FONTGAIJI, 0,
	  {
	  0x0000, 0x0100, 0x0100, 0x0080, 0x3FFC, 0x0040, 0x0020,
	  0x0020, 0x0010, 0x03F8, 0x0C00, 0x1000, 0x1000, 0x080C, 0x07F0, 0x0000,
	  },
	  0,
	},

	{
	  0x2436, FONTGAIJI, 0,
	  {
	  0x0000, 0x010A, 0x010A, 0x008A, 0x3FFC, 0x0040, 0x0020,
	  0x0020, 0x0010, 0x03F8, 0x0C00, 0x1000, 0x1000, 0x080C, 0x07F0, 0x0000,
	  },
	  0,
	},

	{
	  0x2437, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000,
	  0x1000, 0x1000, 0x1000, 0x1004, 0x1004, 0x0808, 0x0430, 0x03C0, 0x0000,
	  },
	  0,
	},

	{
	  0x2438, FONTGAIJI, 0,
	  {
	  0x0000, 0x0050, 0x1050, 0x1050, 0x1000, 0x1000, 0x1000,
	  0x1000, 0x1000, 0x1000, 0x1004, 0x1004, 0x0808, 0x0430, 0x03C0, 0x0000,
	  },
	  0,
	},

	{
	  0x2439, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0020, 0x0020, 0x0020, 0x7FFF, 0x0020,
	  0x0F20, 0x10A0, 0x2060, 0x2060, 0x2060, 0x10A0, 0x0F20, 0x0020, 0x0040,
	  },
	  0,
	},

	{
	  0x243a, FONTGAIJI, 0,
	  {
	  0x0005, 0x0005, 0x0025, 0x0020, 0x0020, 0x7FFF, 0x0020,
	  0x0F20, 0x10A0, 0x2060, 0x2060, 0x2060, 0x10A0, 0x0F20, 0x0020, 0x0040,
	  },
	  0,
	},

	{
	  0x243b, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0820, 0x0820, 0x0820, 0x3FFC,
	  0x0820, 0x0820, 0x0820, 0x0800, 0x0800, 0x0800, 0x040C, 0x03F0, 0x0000,
	  },
	  0,
	},

	{
	  0x243c, FONTGAIJI, 0,
	  {
	  0x0000, 0x0005, 0x0005, 0x0825, 0x0820, 0x0820, 0x3FFC,
	  0x0820, 0x0820, 0x0820, 0x0800, 0x0800, 0x0800, 0x040C, 0x03F0, 0x0000,
	  },
	  0,
	},

	{
	  0x243d, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x2030, 0x2040, 0x1980, 0x0600, 0x0800,
	  0x1000, 0x7FFC, 0x00C0, 0x0300, 0x0400, 0x0800, 0x0800, 0x07FC, 0x0000,
	  },
	  0,
	},

	{
	  0x243e, FONTGAIJI, 0,
	  {
	  0x0000, 0x0005, 0x2025, 0x2045, 0x1980, 0x0600, 0x0800,
	  0x1000, 0x7FFC, 0x00C0, 0x0300, 0x0400, 0x0800, 0x0800, 0x07FC, 0x0000,
	  },
	  0,
	},

	{
	  0x243f, FONTGAIJI, 0,
	  {
	  0x0000, 0x0400, 0x0400, 0x7FE0, 0x0800, 0x0800, 0x0800,
	  0x11F8, 0x1004, 0x1004, 0x1000, 0x2200, 0x2200, 0x2100, 0x20FC, 0x0000,
	  },
	  0,
	},

	{
	  0x2440, FONTGAIJI, 0,
	  {
	  0x0000, 0x040A, 0x040A, 0x7FEA, 0x0800, 0x0800, 0x0800,
	  0x11F8, 0x1004, 0x1004, 0x1000, 0x2200, 0x2200, 0x2100, 0x20FC, 0x0000,
	  },
	  0,
	},

	{
	  0x2441, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0800, 0x0800, 0x7FF0, 0x0800, 0x0800,
	  0x0800, 0x0BF0, 0x0C08, 0x0004, 0x0004, 0x0004, 0x0008, 0x0030, 0x07C0,
	  },
	  0,
	},

	{
	  0x2442, FONTGAIJI, 0,
	  {
	  0x0000, 0x000A, 0x080A, 0x080A, 0x7FF0, 0x0800, 0x0800,
	  0x0800, 0x0BF0, 0x0C08, 0x0004, 0x0004, 0x0004, 0x0008, 0x0030, 0x07C0,
	  },
	  0,
	},

	{
	  0x2443, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	  0x0000, 0x0FF0, 0x3008, 0x0004, 0x0004, 0x0004, 0x0018, 0x00E0, 0x0000,
	  },
	  0,
	},

	{
	  0x2444, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1FF0, 0x6008,
	  0x0004, 0x0002, 0x0002, 0x0002, 0x0004, 0x0008, 0x0030, 0x03C0, 0x0000,
	  },
	  0,
	},

	{
	  0x2445, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x000A, 0x000A, 0x000A, 0x1FF0, 0x6008,
	  0x0004, 0x0002, 0x0002, 0x0002, 0x0004, 0x0008, 0x0030, 0x03C0, 0x0000,
	  },
	  0,
	},

	{
	  0x2446, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x1FE0, 0x601C, 0x0018, 0x0060, 0x0180,
	  0x0200, 0x0400, 0x0800, 0x0800, 0x0800, 0x0400, 0x0304, 0x00F8, 0x0000,
	  },
	  0,
	},

	{
	  0x2447, FONTGAIJI, 0,
	  {
	  0x0005, 0x0005, 0x1FE5, 0x601C, 0x0018, 0x0060, 0x0180,
	  0x0200, 0x0400, 0x0800, 0x0800, 0x0800, 0x0400, 0x0304, 0x00F8, 0x0000,
	  },
	  0,
	},

	{
	  0x2448, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x2000, 0x2000, 0x2000, 0x1000, 0x10F0,
	  0x1700, 0x1800, 0x2000, 0x4000, 0x4000, 0x4000, 0x2004, 0x1FF8, 0x0000,
	  },
	  0,
	},

	{
	  0x2449, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x2028, 0x2028, 0x2028, 0x1000, 0x10F0,
	  0x1700, 0x1800, 0x2000, 0x4000, 0x4000, 0x4000, 0x2004, 0x1FF8, 0x0000,
	  },
	  0,
	},

	{
	  0x244a, FONTGAIJI, 0,
	  {
	  0x0400, 0x0400, 0x0800, 0xFF80, 0x0870, 0x100C, 0x1012,
	  0x1010, 0x21D0, 0x2230, 0x2418, 0x0416, 0x0411, 0x0220, 0x01C0, 0x0000,
	  },
	  0,
	},

	{
	  0x244b, FONTGAIJI, 0,
	  {
	  0x0000, 0x2000, 0x23E0, 0x4418, 0x4004, 0x4008, 0x4010,
	  0x4000, 0x4000, 0x4000, 0x4000, 0x4400, 0x4400, 0x2302, 0x20FC, 0x0000,
	  },
	  0,
	},

	{
	  0x244c, FONTGAIJI, 0,
	  {
	  0x0000, 0x1020, 0x1020, 0x1020, 0x13E0, 0x1C30, 0x2848,
	  0x2844, 0x4842, 0x4882, 0x451A, 0x4526, 0x4223, 0x2222, 0x1C1C, 0x0000,
	  },
	  0,
	},

	{
	  0x244d, FONTGAIJI, 0,
	  {
	  0x0000, 0x0800, 0x0800, 0x7C00, 0x0A00, 0x0C00, 0x0BF0,
	  0x1C08, 0x2804, 0x0804, 0x0804, 0x0874, 0x088C, 0x0906, 0x0889, 0x0870,
	  },
	  0,
	},

	{
	  0x244e, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x03F8, 0x0C44, 0x1042, 0x2042, 0x2041,
	  0x4041, 0x4041, 0x4081, 0x4081, 0x2082, 0x1102, 0x0E04, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x244f, FONTGAIJI, 0,
	  {
	  0x0000, 0x0020, 0x4020, 0x4020, 0x47FC, 0x4020, 0x4020,
	  0x4020, 0x4020, 0x43A0, 0x4470, 0x4828, 0x4824, 0x4442, 0x2380, 0x0000,
	  },
	  0,
	},

	{
	  0x2450, FONTGAIJI, 0,
	  {
	  0x0000, 0x0025, 0x4025, 0x4025, 0x47F8, 0x4020, 0x4020,
	  0x4020, 0x4020, 0x43A0, 0x4470, 0x4828, 0x4824, 0x4442, 0x2380, 0x0000,
	  },
	  0,
	},

	{
	  0x2451, FONTGAIJI, 0,
	  {
	  0x0006, 0x0029, 0x4029, 0x4026, 0x47F8, 0x4020, 0x4020,
	  0x4020, 0x4020, 0x43A0, 0x4470, 0x4828, 0x4824, 0x4442, 0x2380, 0x0000,
	  },
	  0,
	},

	{
	  0x2452, FONTGAIJI, 0,
	  {
	  0x0000, 0x7C00, 0x0200, 0x0400, 0x0800, 0x1000, 0x2000,
	  0x2010, 0x4028, 0x4024, 0x4040, 0x4080, 0x2300, 0x1C00, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2453, FONTGAIJI, 0,
	  {
	  0x0000, 0x7C00, 0x0200, 0x0400, 0x0809, 0x1009, 0x2000,
	  0x2010, 0x4028, 0x4024, 0x4040, 0x4080, 0x2300, 0x1C00, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2454, FONTGAIJI, 0,
	  {
	  0x0000, 0x7C00, 0x0200, 0x0406, 0x0809, 0x1009, 0x2006,
	  0x2010, 0x4028, 0x4024, 0x4040, 0x4080, 0x2300, 0x1C00, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2455, FONTGAIJI, 0,
	  {
	  0x0000, 0x0F80, 0x0040, 0x0040, 0x0180, 0x0200, 0x0410,
	  0x2408, 0x2304, 0x2082, 0x2042, 0x2022, 0x4022, 0x4020, 0x03C0, 0x0000,
	  },
	  0,
	},

	{
	  0x2456, FONTGAIJI, 0,
	  {
	  0x0000, 0x0F8A, 0x004A, 0x004A, 0x0180, 0x0200, 0x0410,
	  0x2408, 0x2304, 0x2082, 0x2042, 0x2022, 0x4022, 0x4020, 0x03C0, 0x0000,
	  },
	  0,
	},

	{
	  0x2457, FONTGAIJI, 0,
	  {
	  0x0006, 0x0F89, 0x0049, 0x0046, 0x0180, 0x0200, 0x0410,
	  0x2408, 0x2304, 0x2082, 0x2042, 0x2022, 0x4022, 0x4020, 0x03C0, 0x0000,
	  },
	  0,
	},

	{
	  0x2458, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0780, 0x0840, 0x1020, 0x2010, 0x2010,
	  0x4008, 0x4008, 0x4004, 0x0004, 0x0002, 0x0002, 0x0001, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2459, FONTGAIJI, 0,
	  {
	  0x0000, 0x000A, 0x078A, 0x084A, 0x1020, 0x2010, 0x2010,
	  0x4008, 0x4008, 0x4004, 0x0004, 0x0002, 0x0002, 0x0001, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x245a, FONTGAIJI, 0,
	  {
	  0x000C, 0x0012, 0x0792, 0x084C, 0x1020, 0x2010, 0x2010,
	  0x4008, 0x4008, 0x4004, 0x0004, 0x0002, 0x0002, 0x0001, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x245b, FONTGAIJI, 0,
	  {
	  0x0000, 0x4000, 0x47FE, 0x4020, 0x4020, 0x4020, 0x47FE,
	  0x4020, 0x4020, 0x43A0, 0x4460, 0x4830, 0x4828, 0x4444, 0x2380, 0x0000,
	  },
	  0,
	},

	{
	  0x245c, FONTGAIJI, 0,
	  {
	  0x0000, 0x4005, 0x47F5, 0x4025, 0x4020, 0x4020, 0x47FE,
	  0x4020, 0x4020, 0x43A0, 0x4460, 0x4830, 0x4828, 0x4444, 0x2380, 0x0000,
	  },
	  0,
	},

	{
	  0x245d, FONTGAIJI, 0,
	  {
	  0x0006, 0x4009, 0x47F9, 0x4026, 0x4020, 0x4020, 0x47FE,
	  0x4020, 0x4020, 0x43A0, 0x4460, 0x4830, 0x4828, 0x4444, 0x2380, 0x0000,
	  },
	  0,
	},

	{
	  0x245e, FONTGAIJI, 0,
	  {
	  0x0000, 0x0080, 0x0080, 0x3FFC, 0x0080, 0x0080, 0x3FFC,
	  0x0080, 0x0080, 0x1E80, 0x21C0, 0x40B0, 0x408C, 0x2102, 0x1E00, 0x0000,
	  },
	  0,
	},

	{
	  0x245f, FONTGAIJI, 0,
	  {
	  0x0000, 0x1E00, 0x0100, 0x0088, 0x0088, 0x0088, 0x0088,
	  0x0088, 0x0FFE, 0x1088, 0x2088, 0x2088, 0x2108, 0x1108, 0x0E10, 0x0000,
	  },
	  0,
	},

	{
	  0x2460, FONTGAIJI, 0,
	  {
	  0x0000, 0x0100, 0x0100, 0x3FF0, 0x0100, 0x0100, 0x0104,
	  0x1D04, 0x2302, 0x4100, 0x4100, 0x4101, 0x2282, 0x1C44, 0x0038, 0x0000,
	  },
	  0,
	},

	{
	  0x2461, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0410, 0x0410, 0x0410, 0x0FF0, 0x1438,
	  0x2424, 0x2442, 0x4442, 0x4282, 0x4284, 0x4104, 0x2208, 0x1C30, 0x0000,
	  },
	  0,
	},

	{
	  0x2462, FONTGAIJI, 0,
	  {
	  0x0000, 0x0400, 0x0400, 0x0400, 0x7FE0, 0x0400, 0x0400,
	  0x0400, 0x7FE0, 0x0400, 0x0404, 0x0404, 0x0404, 0x0208, 0x01F0, 0x0000,
	  },
	  0,
	},

	{
	  0x2463, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	  0x0000, 0x0240, 0x0240, 0x1FF8, 0x0244, 0x0244, 0x0208, 0x0100, 0x0000,
	  },
	  0,
	},

	{
	  0x2464, FONTGAIJI, 0,
	  {
	  0x0000, 0x1040, 0x1040, 0x1040, 0x1040, 0xFFFC, 0x0842,
	  0x0841, 0x0801, 0x0802, 0x0404, 0x0400, 0x0400, 0x0400, 0x0400, 0x0000,
	  },
	  0,
	},

	{
	  0x2465, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	  0x0080, 0x13E0, 0x1490, 0x1888, 0x1088, 0x1090, 0x14A0, 0x03C0, 0x0080,
	  },
	  0,
	},

	{
	  0x2466, FONTGAIJI, 0,
	  {
	  0x0000, 0x0040, 0x0040, 0x21F0, 0x2648, 0x2844, 0x3042,
	  0x2042, 0x2042, 0x2042, 0x2444, 0x2448, 0x0250, 0x01E0, 0x0040, 0x0080,
	  },
	  0,
	},

	{
	  0x2467, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100,
	  0x0100, 0x01F0, 0x0100, 0x0100, 0x1F00, 0x2180, 0x2260, 0x1C10, 0x0000,
	  },
	  0,
	},

	{
	  0x2468, FONTGAIJI, 0,
	  {
	  0x0000, 0x0080, 0x0080, 0x0080, 0x00FC, 0x0080, 0x0080,
	  0x0080, 0x0080, 0x0F80, 0x10C0, 0x20B0, 0x2088, 0x1104, 0x0E00, 0x0000,
	  },
	  0,
	},

	{
	  0x2469, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x03C0, 0x1038, 0x1000, 0x1000, 0x13F0,
	  0x1C08, 0x0004, 0x0004, 0x0004, 0x0008, 0x0070, 0x0F80, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x246a, FONTGAIJI, 0,
	  {
	  0x0000, 0x0810, 0x1008, 0x1008, 0x1008, 0x1008, 0x1008,
	  0x0E08, 0x0008, 0x0008, 0x0008, 0x0010, 0x0020, 0x00C0, 0x0F00, 0x0000,
	  },
	  0,
	},

	{
	  0x246b, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0FC0, 0x0020, 0x0040, 0x0080, 0x0300,
	  0x07E0, 0x0018, 0x0004, 0x0002, 0x07E2, 0x0814, 0x0818, 0x07E0, 0x0000,
	  },
	  0,
	},

	{
	  0x246c, FONTGAIJI, 0,
	  {
	  0x0000, 0x0400, 0x0400, 0x0400, 0x7E00, 0x05F0, 0x0E08,
	  0x3408, 0x0410, 0x0410, 0x0420, 0x0440, 0x0441, 0x0442, 0x043C, 0x0000,
	  },
	  0,
	},

	{
	  0x246d, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0FC0, 0x0020, 0x0040, 0x0080, 0x0300,
	  0x07E0, 0x0018, 0x0004, 0x0002, 0x0002, 0x0004, 0x1808, 0x07F0, 0x0000,
	  },
	  0,
	},

	{
	  0x246e, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	  0x0000, 0x0400, 0x3C00, 0x07E0, 0x0C18, 0x3404, 0x0404, 0x0404, 0x0408,
	  },
	  0,
	},

	{
	  0x246f, FONTGAIJI, 0,
	  {
	  0x0000, 0x0400, 0x0400, 0x7E00, 0x05F0, 0x0608, 0x0C04,
	  0x3404, 0x0402, 0x0402, 0x0402, 0x0402, 0x0402, 0x0404, 0x0404, 0x0408,
	  },
	  0,
	},

	{
	  0x2470, FONTGAIJI, 0,
	  {
	  0x0000, 0x07F8, 0x0008, 0x0010, 0x0010, 0x0020, 0x01E0,
	  0x0E58, 0x1084, 0x2104, 0x2204, 0x4404, 0x4874, 0x288C, 0x108A, 0x0070,
	  },
	  0,
	},

	{
	  0x2471, FONTGAIJI, 0,
	  {
	  0x0000, 0x0FF8, 0x0008, 0x0010, 0x03E0, 0x0010, 0x0008,
	  0x0F08, 0x1090, 0x1060, 0x0FC0, 0x0000, 0x1864, 0x269C, 0x4112, 0x8212,
	  },
	  0,
	},

	{
	  0x2472, FONTGAIJI, 0,
	  {
	  0x0000, 0x0100, 0x0100, 0x0100, 0x3FF0, 0x0100, 0x0100,
	  0x0100, 0x07F0, 0x1880, 0x2080, 0x2000, 0x2000, 0x100C, 0x0FF0, 0x0000,
	  },
	  0,
	},

	{
	  0x2473, FONTGAIJI, 0,
	  {
	  0x0000, 0x0200, 0x0400, 0x0800, 0x1000, 0x1000, 0x2000,
	  0x2000, 0x2008, 0x4004, 0x4002, 0x4002, 0x4782, 0x7844, 0x4038, 0x0000,
	  },
	  0,
	},

	{
	  0x2521, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1FF0,
	  0x2008, 0x0004, 0x0104, 0x0118, 0x01E0, 0x0100, 0x0200, 0x0C00, 0x0000,
	  },
	  0,
	},

	{
	  0x2522, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0FF0, 0x700C, 0x0002, 0x0102,
	  0x0102, 0x010C, 0x01F0, 0x0100, 0x0100, 0x0200, 0x0200, 0x0400, 0x0000,
	  },
	  0,
	},

	{
	  0x2523, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	  0x0030, 0x00C0, 0x0180, 0x0680, 0x1880, 0x0080, 0x0080, 0x0080, 0x0000,
	  },
	  0,
	},

	{
	  0x2524, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x000C, 0x0070, 0x0180, 0x0680,
	  0x1880, 0x2080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0000,
	  },
	  0,
	},

	{
	  0x2525, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100,
	  0x0100, 0x0FE0, 0x1010, 0x1010, 0x0010, 0x0020, 0x0040, 0x0780, 0x0000,
	  },
	  0,
	},

	{
	  0x2526, FONTGAIJI, 0,
	  {
	  0x0000, 0x0100, 0x0100, 0x0100, 0x1FF0, 0x2008, 0x4004,
	  0x4004, 0x4004, 0x2004, 0x0004, 0x0008, 0x0010, 0x0060, 0x0F80, 0x0000,
	  },
	  0,
	},

	{
	  0x2527, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	  0x0000, 0x0000, 0x0FE0, 0x0100, 0x0100, 0x0100, 0x0100, 0x1FF0, 0x0000,
	  },
	  0,
	},

	{
	  0x2528, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x3FF8, 0x0084, 0x0080,
	  0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x3FFC, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2529, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080, 0x0080,
	  0x1FF0, 0x0080, 0x0180, 0x0280, 0x0480, 0x0880, 0x1080, 0x0080, 0x0000,
	  },
	  0,
	},

	{
	  0x252a, FONTGAIJI, 0,
	  {
	  0x0000, 0x0040, 0x0040, 0x0040, 0x3FFC, 0x0040, 0x0040,
	  0x00C0, 0x0140, 0x0640, 0x0840, 0x3040, 0x0040, 0x0040, 0x0040, 0x0000,
	  },
	  0,
	},

	{
	  0x252b, FONTGAIJI, 0,
	  {
	  0x0000, 0x0100, 0x0100, 0x0100, 0x3FF8, 0x0104, 0x0204,
	  0x0204, 0x0204, 0x0404, 0x0408, 0x0408, 0x0808, 0x0810, 0x1010, 0x0000,
	  },
	  0,
	},

	{
	  0x252c, FONTGAIJI, 0,
	  {
	  0x0000, 0x0105, 0x0105, 0x0105, 0x3FF0, 0x0108, 0x0204,
	  0x0204, 0x0204, 0x0404, 0x0408, 0x0408, 0x0808, 0x0810, 0x1010, 0x0000,
	  },
	  0,
	},

	{
	  0x252d, FONTGAIJI, 0,
	  {
	  0x0000, 0x0200, 0x0200, 0x0200, 0x3FF8, 0x0100, 0x0100,
	  0x0100, 0x3FF8, 0x0080, 0x0080, 0x0080, 0x0080, 0x0040, 0x0040, 0x0000,
	  },
	  0,
	},

	{
	  0x252e, FONTGAIJI, 0,
	  {
	  0x000A, 0x020A, 0x020A, 0x0200, 0x3FF8, 0x0100, 0x0100,
	  0x0100, 0x3FF8, 0x0080, 0x0080, 0x0080, 0x0080, 0x0040, 0x0040, 0x0000,
	  },
	  0,
	},

	{
	  0x252f, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0FF0, 0x0808, 0x1008, 0x1008,
	  0x2008, 0x0008, 0x0008, 0x0010, 0x0010, 0x0020, 0x00C0, 0x0700, 0x0000,
	  },
	  0,
	},

	{
	  0x2530, FONTGAIJI, 0,
	  {
	  0x0005, 0x0005, 0x0005, 0x0FF0, 0x0808, 0x1008, 0x1008,
	  0x2008, 0x0008, 0x0008, 0x0010, 0x0010, 0x0020, 0x00C0, 0x0700, 0x0000,
	  },
	  0,
	},

	{
	  0x2531, FONTGAIJI, 0,
	  {
	  0x0000, 0x1000, 0x1000, 0x1000, 0x1FF8, 0x1020, 0x1020,
	  0x1020, 0x2020, 0x2020, 0x0020, 0x0040, 0x0040, 0x0080, 0x1F00, 0x0000,
	  },
	  0,
	},

	{
	  0x2532, FONTGAIJI, 0,
	  {
	  0x0000, 0x1005, 0x1005, 0x1005, 0x1FF8, 0x1020, 0x1020,
	  0x1020, 0x2020, 0x2020, 0x0020, 0x0040, 0x0040, 0x0080, 0x1F00, 0x0000,
	  },
	  0,
	},

	{
	  0x2533, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x1FF0, 0x0008, 0x0004, 0x0004,
	  0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x1FF8, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2534, FONTGAIJI, 0,
	  {
	  0x0000, 0x0005, 0x0005, 0x1FF5, 0x0008, 0x0004, 0x0004,
	  0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x1FF8, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2535, FONTGAIJI, 0,
	  {
	  0x0000, 0x1020, 0x1020, 0x1020, 0x7FFC, 0x1020, 0x1020,
	  0x1020, 0x0820, 0x0020, 0x0020, 0x0040, 0x0040, 0x2180, 0x1E00, 0x0000,
	  },
	  0,
	},

	{
	  0x2536, FONTGAIJI, 0,
	  {
	  0x0005, 0x1025, 0x1025, 0x1020, 0x7FFC, 0x1020, 0x1020,
	  0x1020, 0x0820, 0x0020, 0x0020, 0x0040, 0x0040, 0x2180, 0x1E00, 0x0000,
	  },
	  0,
	},

	{
	  0x2537, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x3000, 0x0C00, 0x0200, 0x0000,
	  0x3002, 0x0C02, 0x0204, 0x0004, 0x0008, 0x0030, 0x60C0, 0x1F00, 0x0000,
	  },
	  0,
	},

	{
	  0x2538, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x3014, 0x0C14, 0x0214, 0x0000,
	  0x3002, 0x0C02, 0x0204, 0x0004, 0x0008, 0x0030, 0x60C0, 0x1F00, 0x0000,
	  },
	  0,
	},

	{
	  0x2539, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x3FE0, 0x4010, 0x0010, 0x0020, 0x0020,
	  0x0040, 0x0040, 0x0080, 0x0180, 0x0240, 0x0C30, 0x1008, 0x6006, 0x0000,
	  },
	  0,
	},

	{
	  0x253a, FONTGAIJI, 0,
	  {
	  0x0000, 0x0005, 0x3FE5, 0x4015, 0x0010, 0x0020, 0x0020,
	  0x0040, 0x0040, 0x0080, 0x0180, 0x0240, 0x0C30, 0x1008, 0x6006, 0x0000,
	  },
	  0,
	},

	{
	  0x253b, FONTGAIJI, 0,
	  {
	  0x0000, 0x0800, 0x0800, 0x0800, 0x09FC, 0x3E02, 0x0802,
	  0x0802, 0x0804, 0x0808, 0x0830, 0x0802, 0x0402, 0x03FC, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x253c, FONTGAIJI, 0,
	  {
	  0x0005, 0x0805, 0x0805, 0x0800, 0x09FC, 0x3E02, 0x0802,
	  0x0802, 0x0804, 0x0808, 0x0830, 0x0802, 0x0402, 0x03FC, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x253d, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x2004, 0x2004, 0x1004, 0x1004, 0x0804,
	  0x0604, 0x0004, 0x0008, 0x0008, 0x0010, 0x0020, 0x10C0, 0x0F00, 0x0000,
	  },
	  0,
	},

	{
	  0x253e, FONTGAIJI, 0,
	  {
	  0x0005, 0x0005, 0x2005, 0x2000, 0x1004, 0x1004, 0x0804,
	  0x0604, 0x0004, 0x0008, 0x0008, 0x0010, 0x0020, 0x10C0, 0x0F00, 0x0000,
	  },
	  0,
	},

	{
	  0x253f, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x07F8, 0x0404, 0x0804, 0x1004,
	  0x1004, 0x0104, 0x0108, 0x0088, 0x0070, 0x0020, 0x0040, 0x0F80, 0x0000,
	  },
	  0,
	},

	{
	  0x2540, FONTGAIJI, 0,
	  {
	  0x0005, 0x0005, 0x0005, 0x07F8, 0x0404, 0x0804, 0x1004,
	  0x1004, 0x0104, 0x0108, 0x0088, 0x0070, 0x0020, 0x0040, 0x0F80, 0x0000,
	  },
	  0,
	},

	{
	  0x2541, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0060, 0x0180, 0x0680, 0x1880, 0x0080,
	  0x0080, 0x3FFE, 0x0080, 0x0080, 0x0080, 0x0080, 0x0100, 0x1E00, 0x0000,
	  },
	  0,
	},

	{
	  0x2542, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0065, 0x0185, 0x0685, 0x1880, 0x0080,
	  0x0080, 0x3FFE, 0x0080, 0x0080, 0x0080, 0x0080, 0x0100, 0x1E00, 0x0000,
	  },
	  0,
	},

	{
	  0x2543, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	  0x0000, 0x0410, 0x2410, 0x2210, 0x1210, 0x1020, 0x00C0, 0x0F00, 0x0000,
	  },
	  0,
	},

	{
	  0x2544, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0200, 0x2204, 0x2204, 0x2104, 0x1104,
	  0x1104, 0x1004, 0x0004, 0x0008, 0x0008, 0x0010, 0x0060, 0x1F80, 0x0000,
	  },
	  0,
	},

	{
	  0x2545, FONTGAIJI, 0,
	  {
	  0x0005, 0x0005, 0x0205, 0x2200, 0x2204, 0x2104, 0x1104,
	  0x1104, 0x1004, 0x0004, 0x0008, 0x0008, 0x0010, 0x0060, 0x1F80, 0x0000,
	  },
	  0,
	},

	{
	  0x2546, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x1FF8, 0x0000, 0x0000, 0x0000, 0x3FFC,
	  0x0020, 0x0020, 0x0020, 0x0020, 0x0040, 0x0040, 0x0180, 0x1E00, 0x0000,
	  },
	  0,
	},

	{
	  0x2547, FONTGAIJI, 0,
	  {
	  0x0005, 0x0005, 0x1FF5, 0x0000, 0x0000, 0x0000, 0x3FFC,
	  0x0020, 0x0020, 0x0020, 0x0020, 0x0040, 0x0040, 0x0180, 0x1E00, 0x0000,
	  },
	  0,
	},

	{
	  0x2548, FONTGAIJI, 0,
	  {
	  0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
	  0x0C00, 0x0B00, 0x08C0, 0x0830, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000,
	  },
	  0,
	},

	{
	  0x2549, FONTGAIJI, 0,
	  {
	  0x0000, 0x0850, 0x0850, 0x0850, 0x0800, 0x0800, 0x0800,
	  0x0C00, 0x0B00, 0x08C0, 0x0830, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000,
	  },
	  0,
	},

	{
	  0x254a, FONTGAIJI, 0,
	  {
	  0x0000, 0x0040, 0x0040, 0x0020, 0x0020, 0x0020, 0x3FFC,
	  0x0020, 0x0020, 0x0020, 0x0020, 0x0040, 0x0040, 0x0180, 0x1E00, 0x0000,
	  },
	  0,
	},

	{
	  0x254b, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0FF8, 0x0000, 0x0000,
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3FFE, 0x0000, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x254c, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x1FF0, 0x0008, 0x0008, 0x0010,
	  0x0C10, 0x0320, 0x00A0, 0x0040, 0x00B0, 0x0108, 0x0604, 0x3800, 0x0000,
	  },
	  0,
	},

	{
	  0x254d, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0080, 0x0080, 0x0080, 0x1FF8, 0x0010,
	  0x0020, 0x0040, 0x01B0, 0x068C, 0x1882, 0x0080, 0x0080, 0x0080, 0x0000,
	  },
	  0,
	},

	{
	  0x254e, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
	  0x0008, 0x0008, 0x0010, 0x0010, 0x0020, 0x00C0, 0x0300, 0x1C00, 0x0000,
	  },
	  0,
	},

	{
	  0x254f, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0020, 0x0010, 0x0810, 0x0808, 0x0808,
	  0x1008, 0x1004, 0x1004, 0x2004, 0x2002, 0x2002, 0x2002, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2550, FONTGAIJI, 0,
	  {
	  0x000A, 0x000A, 0x002A, 0x0010, 0x0810, 0x0808, 0x0808,
	  0x1008, 0x1004, 0x1004, 0x2004, 0x2002, 0x2002, 0x2002, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2551, FONTGAIJI, 0,
	  {
	  0x0006, 0x0009, 0x0029, 0x0016, 0x0810, 0x0808, 0x0808,
	  0x1008, 0x1004, 0x1004, 0x2004, 0x2002, 0x2002, 0x2002, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2552, FONTGAIJI, 0,
	  {
	  0x0000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x21F8,
	  0x3E00, 0x2000, 0x2000, 0x2000, 0x2000, 0x1004, 0x0FF8, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2553, FONTGAIJI, 0,
	  {
	  0x0000, 0x2005, 0x2005, 0x2005, 0x2000, 0x2000, 0x21F8,
	  0x3E00, 0x2000, 0x2000, 0x2000, 0x2000, 0x1004, 0x0FF8, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2554, FONTGAIJI, 0,
	  {
	  0x0006, 0x2009, 0x2009, 0x2006, 0x2000, 0x2000, 0x21F8,
	  0x3E00, 0x2000, 0x2000, 0x2000, 0x2000, 0x1004, 0x0FF8, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2555, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x3FF0, 0x0008, 0x0004, 0x0004,
	  0x0004, 0x0004, 0x0008, 0x0008, 0x0010, 0x0020, 0x00C0, 0x0F00, 0x0000,
	  },
	  0,
	},

	{
	  0x2556, FONTGAIJI, 0,
	  {
	  0x0005, 0x0005, 0x0005, 0x3FF0, 0x0008, 0x0004, 0x0004,
	  0x0004, 0x0004, 0x0008, 0x0008, 0x0010, 0x0020, 0x00C0, 0x0F00, 0x0000,
	  },
	  0,
	},

	{
	  0x2557, FONTGAIJI, 0,
	  {
	  0x0006, 0x0009, 0x0009, 0x3FF6, 0x0008, 0x0004, 0x0004,
	  0x0004, 0x0004, 0x0008, 0x0008, 0x0010, 0x0020, 0x00C0, 0x0F00, 0x0000,
	  },
	  0,
	},

	{
	  0x2558, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0780, 0x0840, 0x1020, 0x1010, 0x2008,
	  0x2008, 0x4004, 0x4004, 0x4002, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2559, FONTGAIJI, 0,
	  {
	  0x000A, 0x000A, 0x078A, 0x0840, 0x1020, 0x1010, 0x2008,
	  0x2008, 0x4004, 0x4004, 0x4002, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x255a, FONTGAIJI, 0,
	  {
	  0x000C, 0x0012, 0x0792, 0x084C, 0x1020, 0x1010, 0x2008,
	  0x2008, 0x4004, 0x4004, 0x4002, 0x0002, 0x0002, 0x0000, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x255b, FONTGAIJI, 0,
	  {
	  0x0000, 0x0080, 0x0080, 0x0080, 0x0080, 0x3FFC, 0x0080,
	  0x0080, 0x0080, 0x0890, 0x1088, 0x2084, 0x2084, 0x2082, 0x0080, 0x0000,
	  },
	  0,
	},

	{
	  0x255c, FONTGAIJI, 0,
	  {
	  0x0000, 0x0085, 0x0085, 0x0085, 0x0080, 0x3FFC, 0x0080,
	  0x0080, 0x0080, 0x0890, 0x1088, 0x2084, 0x2084, 0x2082, 0x0080, 0x0000,
	  },
	  0,
	},

	{
	  0x255d, FONTGAIJI, 0,
	  {
	  0x0006, 0x0089, 0x0089, 0x0086, 0x0080, 0x3FFC, 0x0080,
	  0x0080, 0x0080, 0x0890, 0x1088, 0x2084, 0x2084, 0x2082, 0x0080, 0x0000,
	  },
	  0,
	},

	{
	  0x255e, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0FF8, 0x3004, 0x0002, 0x0002, 0x0002,
	  0x0004, 0x0208, 0x0110, 0x00A0, 0x0040, 0x0020, 0x0010, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x255f, FONTGAIJI, 0,
	  {
	  0x0000, 0x0E00, 0x01C0, 0x0030, 0x0008, 0x0000, 0x0E00,
	  0x0180, 0x0060, 0x0010, 0x0000, 0x1C00, 0x0380, 0x0070, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2560, FONTGAIJI, 0,
	  {
	  0x0000, 0x0040, 0x0080, 0x0100, 0x0200, 0x0200, 0x0400,
	  0x0820, 0x1010, 0x1010, 0x2008, 0x400C, 0x4074, 0x3F82, 0x0002, 0x0000,
	  },
	  0,
	},

	{
	  0x2561, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0008, 0x0008, 0x0008, 0x0210, 0x0110,
	  0x00A0, 0x0060, 0x0050, 0x0088, 0x0100, 0x0200, 0x1C00, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2562, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x3FF8, 0x0400, 0x0400, 0x0400, 0x0400,
	  0x0400, 0x7FFC, 0x0400, 0x0400, 0x0400, 0x0204, 0x01F8, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2563, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	  0x0000, 0x0200, 0x0200, 0x1FF0, 0x0220, 0x0240, 0x0200, 0x0200, 0x0000,
	  },
	  0,
	},

	{
	  0x2564, FONTGAIJI, 0,
	  {
	  0x0000, 0x0400, 0x0400, 0x0400, 0x0400, 0x7FFC, 0x0402,
	  0x0404, 0x0408, 0x0430, 0x0200, 0x0200, 0x0200, 0x0200, 0x0200, 0x0000,
	  },
	  0,
	},

	{
	  0x2565, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	  0x0F00, 0x0080, 0x0040, 0x0040, 0x0040, 0x0040, 0x1FF8, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2566, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x1FC0, 0x0020, 0x0010, 0x0010,
	  0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x3FFE, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2567, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0FE0, 0x0010,
	  0x0010, 0x0010, 0x0FD0, 0x0030, 0x0010, 0x0010, 0x0FF0, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2568, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x1FF8, 0x0004, 0x0004, 0x0004, 0x0004,
	  0x0FE4, 0x001C, 0x0004, 0x0004, 0x0004, 0x0008, 0x1FF0, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2569, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0FF8, 0x0000, 0x0000, 0x0000, 0x3FFC,
	  0x0002, 0x0002, 0x0002, 0x0004, 0x0004, 0x0018, 0x0060, 0x0780, 0x0000,
	  },
	  0,
	},

	{
	  0x256a, FONTGAIJI, 0,
	  {
	  0x0000, 0x0010, 0x0808, 0x0808, 0x0808, 0x0808, 0x0808,
	  0x0808, 0x0808, 0x0808, 0x0010, 0x0010, 0x0020, 0x08C0, 0x0700, 0x0000,
	  },
	  0,
	},

	{
	  0x256b, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0100, 0x0100, 0x1100, 0x1100, 0x1100,
	  0x1100, 0x1102, 0x2102, 0x2104, 0x2104, 0x2108, 0x2090, 0x2060, 0x0000,
	  },
	  0,
	},

	{
	  0x256c, FONTGAIJI, 0,
	  {
	  0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
	  0x0800, 0x0802, 0x0804, 0x0808, 0x0810, 0x0820, 0x08C0, 0x0700, 0x0000,
	  },
	  0,
	},

	{
	  0x256d, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x17F0, 0x1008, 0x1004, 0x1004,
	  0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x1004, 0x0FF8, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x256e, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0FE0, 0x1010,
	  0x1010, 0x1010, 0x0010, 0x0020, 0x0020, 0x0040, 0x0180, 0x0600, 0x0000,
	  },
	  0,
	},

	{
	  0x256f, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x1FF8, 0x2004, 0x2004, 0x2004, 0x2004,
	  0x2004, 0x0004, 0x0004, 0x0008, 0x0008, 0x0010, 0x1860, 0x0780, 0x0000,
	  },
	  0,
	},

	{
	  0x2570, FONTGAIJI, 0,
	  {
	  0x0000, 0x0020, 0x0020, 0x0020, 0x1FFE, 0x0420, 0x0420,
	  0x0420, 0x0820, 0x0820, 0x3FFE, 0x0020, 0x0020, 0x0020, 0x0020, 0x0000,
	  },
	  0,
	},

	{
	  0x2571, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x1FF8, 0x0004, 0x0004, 0x0108,
	  0x0130, 0x0140, 0x0100, 0x0100, 0x0100, 0x0100, 0x3FFE, 0x0000, 0x0000,
	  },
	  0,
	},

	{
	  0x2572, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x1FF8, 0x0004, 0x0004, 0x0004, 0x000C,
	  0x1FF4, 0x0004, 0x0004, 0x0008, 0x0008, 0x0010, 0x0060, 0x0780, 0x0000,
	  },
	  0,
	},

	{
	  0x2573, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x1800, 0x0400, 0x0200, 0x0100,
	  0x0002, 0x0002, 0x0004, 0x0004, 0x0008, 0x0030, 0x30C0, 0x0F00, 0x0000,
	  },
	  0,
	},

	{
	  0x2574, FONTGAIJI, 0,
	  {
	  0x0000, 0x010A, 0x010A, 0x010A, 0x1FF0, 0x2008, 0x4004,
	  0x4004, 0x4004, 0x2004, 0x0004, 0x0008, 0x0010, 0x0060, 0x0F80, 0x0000,
	  },
	  0,
	},

	{
	  0x2575, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0100,
	  0x0100, 0x1FE0, 0x0210, 0x0210, 0x0410, 0x0420, 0x0820, 0x1040, 0x0000,
	  },
	  0,
	},

	{
	  0x2576, FONTGAIJI, 0,
	  {
	  0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x0800,
	  0x0FF8, 0x0820, 0x1020, 0x0020, 0x0020, 0x0040, 0x0040, 0x0380, 0x0000,
	  },
	  0,
	},

	{
	 0, 0, 0,
	}
};
