/* $Id: launder-api.h,v 1.21 1999/07/07 16:32:58 proff Exp $
 * $Copyright$
 * $Log: launder-api.h,v $
 * Revision 1.21  1999/07/07 16:32:58  proff
 * add LHLEN macro
 *
 * Revision 1.20  1999/02/24 01:44:00  proff
 * add LAUNDER_THIEVED flag to denote when a packet has been stolen from
 * the network stack
 *
 * Revision 1.19  1999/02/12 21:11:14  proff
 * disable launder_stream_header
 *
 * Revision 1.18  1999/02/05 12:33:39  proff
 * adapt to new build system
 *
 * Revision 1.17  1999/02/05 07:29:29  proff
 * new ioctls
 *
 * Revision 1.16  1999/02/02 19:16:10  proff
 * spelling police
 *
 * Revision 1.15  1999/02/02 19:04:08  proff
 * consistency changes
 *
 * correct argument for LAUNDERIOCDETACH
 *
 * add THEIVE/ALOOF ioctls
 *
 * Revision 1.14  1999/01/31 12:49:00  proff
 * add M_LAUNDER mbuf flag
 *
 * rationalise LAUNDERIOCMONOGAMOUS -> LAUNDERIOCMONOGAM
 *
 * Revision 1.13  1999/01/30 20:18:38  proff
 * new flags: LAUNDER_{PPP,IPFLOW}
 *
 * Revision 1.12  1999/01/30 18:38:28  proff
 * Add LAUNDER{MUTLICAST,BROARDCAST} flags
 *
 * Revision 1.11  1999/01/30 16:31:59  proff
 * int/u_int consistency
 *
 * Revision 1.10  1999/01/26 16:00:55  proff
 * remove checksumming code. implementation showed launder checksuming to
 * be a bad design decision, primarily stemming from conflict between the
 * protocol-independent nature of the launder device, and inherent
 * protocol dependency of checksumming operations. cksum flags have been
 * maintained for the case where data originated from the local host, and
 * for userland clients to set when the data is being forwarded to or
 * through the localhost protocol stack.
 *
 * Revision 1.9  1999/01/26 10:20:59  proff
 * spelling police
 *
 * Revision 1.8  1999/01/26 07:00:07  proff
 * New ioctl:
 *
 * 	LAUNDERIOCSTATS
 *
 * Revision 1.7  1999/01/24 20:02:24  proff
 * launder_input() prototype change
 *
 * Revision 1.6  1999/01/23 08:17:12  proff
 * New ioctl:
 *
 * 	LAUNDERIOCDETACH
 *
 * Add kernel prototype for launder_input()
 *
 * Revision 1.5  1999/01/23 05:15:48  proff
 * u_32 -> u_int where applicable.
 *
 * New ioctls:
 *
 * 	LAUNDERIOCPROMISC
 * 	LAUNDERIOCMONOGAMOUS
 *
 * Additional field lh_type (packet type) for launder_hdr.
 *
 * Revision 1.4  1999/01/23 02:01:05  proff
 * LAUNDERIOCSNAPLEN
 *
 * Revision 1.3  1999/01/23 01:56:01  proff
 * ip/tcp checksum request/generation support via LAUNDER_{IP,TCP}SUM{,OK,REQ,CHECK}
 * DLT types are now depreciated and replaced with LP_* [Launder Protocol].
 * the new flag LAUNDER_IGNORE indicates that a given packet should be skipped,
 * when written to the launder device.
 *
 * Revision 1.2  1999/01/22 15:04:19  proff
 * api/ioctl additions for promisc mode
 *
 * Revision 1.1.1.1  1999/01/22 03:32:43  proff
 * initial import
 *
 */

#ifndef LAUNDER_API_H
#define LAUNDER_API_H 

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#ifdef _KERNEL
#include <sys/mbuf.h>
#endif
#include <netinet/in.h>
#include <net/if.h>

/*
 * packet type codes.
 */
typedef enum
{
    LP_ETHER,		/* Ethernet 10/100 Mb */
    LP_IP		/* Raw IP */
} launder_pkt_t;

#define LAUNDER_ALIGNMENT sizeof(void *)
#define LAUNDER_WORDALIGN(x) (((x)+(LAUNDER_ALIGNMENT-1))&~(LAUNDER_ALIGNMENT-1))
#define LHLEN LAUNDER_WORDALIGN(sizeof(struct launder_hdr))

typedef enum
{
    LAUNDER_INPUT	= (1<<0),	/* else output */
    LAUNDER_PROMISC	= (1<<1),	/* incoming packet not for us */
    LAUNDER_IGNORE	= (1<<2),	/* skip this packet */
    LAUNDER_IPSUM	= (1<<3),	/* packet checksum has been checked already */
    LAUNDER_IPSUMOK	= (1<<4),	/* and the cksum was ok (else bad) */
    LAUNDER_TCPSUM	= (1<<5),	/* packet checksum has been checked already */
    LAUNDER_TCPSUMOK	= (1<<6),	/* and the cksum was ok (else bad) */
    LAUNDER_UDPSUM	= (1<<7),	/* packet checksum has been checked already */
    LAUNDER_UDPSUMOK	= (1<<8),	/* and the cksum was ok (else bad) */
    LAUNDER_MULTICAST	= (1<<9),	/* multicast packet */
    LAUNDER_BROARDCAST	= (1<<10),	/* broardcast packet */
    LAUNDER_PPP		= (1<<11),	/* packet via PPP device */
    LAUNDER_IPFLOW	= (1<<12),	/* packet via ipflow_fastforward */
    LAUNDER_THIEVED	= (1<<13),	/* packet thieved */
} launder_flags;

struct launder_hdr
{
    int lh_hdrlen;		/* length of lh header + alignment */
    int lh_caplen;		/* length of captured data */
    u_int lh_flags;		/* flags */
    int lh_ifnum;		/* icoming/outgoing interface */
    launder_pkt_t lh_type;	/* packet type */
    struct timeval lh_tstamp;	/* time stamp */
};

struct launder_stats
{
    u_int64_t ls_dropped;	/* packets dropped for any reason */
    u_int64_t ls_drop_queue;	/* packets dropped due to queue full / out of mbufs */
};

struct launder_attach		/* for LAUNDERIOCATTACH */
{
    int la_ifnum;		/* returned: launder iface number */
    char la_ifname[IFNAMSIZ];	/* iface name */
};

struct launder_if_flags
{
    int lf_ifnum;		/* iface number */
    u_int if_flags;		/* iface flags */
};

#define LAUNDER_DEBUG		(1<<0)	/* enable debuging */
#define LAUNDER_FAILOPEN	(1<<1)	/* route packets on client close/failure */

#define LAUNDERIOCGSET	_IOW('F', 0, u_int)	/* set global flags */
#define LAUNDERIOCGGET	_IOR('F', 1, u_int)	/* get global flags */
#define LAUNDERIOCTIMEOUT	_IOW('F', 2, struct timeval)
#define LAUNDERIOCMINQUEUE	_IOW('F', 3, u_int)
#define LAUNDERIOCMAXQUEUE	_IOW('F', 4, u_int)
#define LAUNDERIOCACTIVATE	_IOWR('F', 5, int)	/* 0 = off, 1 = on */
#define LAUNDERIOCATTACH	_IOWR('F', 6, struct launder_attach)
#define LAUNDERIOCDETACH	_IOWR('F', 7, int)
#define LAUNDERIOCSNAPLEN	_IOW('F', 8, u_int)	/* >0, truncate packets */
#define LAUNDERIOCPROMISC	_IOW('F', 9, int)	/* launder, as a latin lover */
#define LAUNDERIOCMONOGAM	_IOW('F', 10, int)	/* one woman, one launder device */
#define LAUNDERIOCSTATS	_IOR('F', 11, int)	/* launder statistics */
#define LAUNDERIOCTHIEVE	_IOR('F', 12, int)	/* enable packet stealing on iface */
#define LAUNDERIOCALOOF	_IOR('F', 13, int)	/* disable packet stealing on iface */
#define LAUNDERIOCIFSET	_IOW('F', 12 struct launder_if_flags)	/* set iface flags */
#define LAUNDERIOCIFGET	_IOR('F', 13, struct launder_if_flags)	/* get iface flags */
#else
#  error blah
#endif

#if defined(__NetBSD__) || defined(__FreeBSD__)
# ifdef _KERNEL
#   define M_LAUNDER M_LINK2	/* custom mbuf m_flag, to avoid loopbacks */
int launder_input(struct ifnet *ifp, struct mbuf **mp, launder_pkt_t type, int flags);
# endif /* _KERNEL */

#ifndef _KERNEL
#define LAUNDER_IFNAMSIZE	8
#define LAUNDER_HDR_VERSION	1

struct launder_timeval
{
    u_32 lt_sec;
    u_32 lt_usec;
};

#ifdef notyet
struct launder_stream_hdr
{
    u_32 lh_version;		/* launder header version */
    u_32 lh_caplen;		/* length of captured data */
    u_32 lh_flags;		/* flags */
    u_32 lh_type;		/* packet type */
    struct launder_timeval lh_tstamp;	/* time stamp */
    char lh_ifname[LAUNDER_IFNAMSIZE];	/* iface name */
};
#endif
#endif /* !_KERNEL */
#endif /* LAUNDER_API_H */
