$NetBSD$
--- wcfxo/wcfxo.c.orig	2007-04-16 14:56:31.000000000 +0100
+++ wcfxo/wcfxo.c	2008-10-30 09:33:39.000000000 +0000
@@ -1,5 +1,5 @@
 /*
- * Wilcard X100P FXO Interface Driver for Zapata Telephony interface
+ * Wildcard X100P FXO Interface Driver for Zapata Telephony interface
  *
  * Ported on FreeBSD by
  *      Alexander Timoshenko <gonzo@portaone.com>, PortaOne software
@@ -33,7 +33,6 @@
 /* $Id: wcfxo.c 858 2004-06-23 10:25:52Z gonzo $ */
 
 #include <sys/param.h>  /* defines used in kernel.h */
-#include <sys/module.h>
 #include <sys/systm.h>
 #include <sys/errno.h>
 #include <sys/kernel.h> /* types used in module initialization */
@@ -42,7 +41,9 @@
 #include <sys/malloc.h>
 #include <sys/lock.h>
 #include <sys/endian.h>
+#if defined(__FreeBSD__)
 #include <sys/bus.h>  /* structs, prototypes for pci bus stuff */
+#include <sys/module.h>
 
 #include <machine/bus.h>
 #include <sys/rman.h>
@@ -60,14 +61,21 @@
 #include <dev/pci/pcireg.h>
 #include <dev/pci/pcivar.h>
 #endif
+#include <ddb/ddb.h>
 
+#elif defined(__NetBSD__)
+#include <sys/device.h>
+#include <uvm/uvm_extern.h>     /* for PAGE_SIZE */
+
+#include <dev/pci/pcireg.h>
+#include <dev/pci/pcivar.h>
+#include <dev/pci/pcidevs.h>
+#endif /* __NetBSD__ */
 
 #include "zaptel.h"
 #include "wcfxovar.h"
 #include "wcfxoreg.h"
 
-#include <ddb/ddb.h>
-
 
 #define DEBUG 1
 #define ZERO_BATT_RING 1
@@ -126,6 +134,8 @@
 #define MIN(a,b) (((a)<(b))?(a):(b))
 #endif
 
+MALLOC_DEFINE(M_TDM, "wcfxo", "wcfxo interface data structures");
+
 
 static char * card_configuration = 0;
 
@@ -141,7 +151,7 @@
 
 
 static struct wcfxo_ident wcfxo_ident_table[] = {
-	/* {vendor, device, subverndor, card info }, */
+	/* {vendor, device, subvendor, card info }, */
 	{ 0xe159, 0x0001, 0x8085,	&wcx101p },
 	{ 0xe159, 0x0001, 0x8086, 	&generic },
 	{ 0x1057, 0x5608, -1, 		&wcx100p },
@@ -178,8 +188,14 @@
 	{ "FCC", 0, 0, 1, 0, 0, 2, 0 } /* Russia */
 };
 
+#if defined(__NetBSD__)
+typedef struct device * device_t;
+
+int wcfxodebug = 1;
+#endif
 
 struct wcfxo_softc {
+#if defined(__FreeBSD__)
 	const struct 		wcfxo_device_description * sc_desc;
 	/* card-global dynamic data */
 	int					barmuxed;
@@ -197,6 +213,17 @@
 #else
 	struct cdev *		d;
 #endif
+#elif defined(__NetBSD__)
+	struct device		sc_dv;		/* generic device */
+	bus_space_tag_t		sc_iot;
+	bus_space_handle_t	sc_ioh;
+	bus_addr_t		sc_iob;
+	bus_size_t		sc_iosize;
+
+	void			*sc_ih;
+	bus_dma_tag_t		sc_dmat;
+	pci_chipset_tag_t	sc_pct;
+#endif
 	char 				*variety;
 	struct zt_span 		span;
 	struct zt_chan 		chan;
@@ -238,7 +265,12 @@
 	bus_space_handle_t 	wc_base_addr_handle;
 	int					wc_ioport_rid;
 
-	struct wcfxo_data	wc_ldata;
+#ifdef __FreeBSD__
+	struct wcfxo_data		wc_ldata;
+#elif defined(__NetBSD__)
+	struct wcfxo_dma	sc_read;
+	struct wcfxo_dma	sc_write;
+#endif
 #ifdef ZERO_BATT_RING
 	int 				onhook;
 #endif
@@ -249,24 +281,38 @@
 void 		wcfxo_enable_interrupts(struct wcfxo_softc *);
 void 		wcfxo_start_dma(struct wcfxo_softc *);
 static void wcfxo_dma_map_addr(void *, bus_dma_segment_t *, int, int);
-static int	wcfxo_detach(device_t );
+static int	wcfxo_detach(device_t
+#ifdef __NetBSD__
+, int
+#endif
+);
+
 static void wcfxo_sysctl_init(void);
 static void wcfxo_sysctl_destroy(void);
 void		wcfxo_generate_description(struct wcfxo_softc *sc);
 
 /* sysctl stuff */
+#ifdef __FreeBSD__
 extern struct sysctl_oid * zt_root;
 static struct sysctl_oid * wcfxo_root;
 static struct sysctl_ctx_list wcfxo_clist;
+#endif
 
 /* syscall handlers */
+#ifdef __FreeBSD__
 d_open_t wcfxo_sys_open;
 d_close_t wcfxo_sys_close;
 d_read_t wcfxo_sys_read;
+#elif defined(__NetBSD__)
+dev_type_open(wcfxo_sys_open);
+dev_type_close(wcfxo_sys_close);
+dev_type_read(wcfxo_sys_read);
+#endif
 
 
 
 /* Character device entry points */
+#if defined(__FreeBSD__)
 static struct cdevsw wcfxo_cdevsw = {
 #if __FreeBSD_version < 502103
 #ifdef MAJOR_AUTO
@@ -282,6 +328,16 @@
 	.d_close =   wcfxo_sys_close,
 	.d_read  =   wcfxo_sys_read
 };
+#elif defined(__NetBSD__)
+int wcfxo_match(struct device *, struct cfdata *, void *);
+static void wcfxo_attach(struct device *, struct device *, void *);
+
+CFATTACH_DECL(wcfxo, sizeof(struct wcfxo_softc),
+        wcfxo_match, wcfxo_attach, wcfxo_detach, NULL);
+/* no cdevsw, because there's no read/write interface as of yet */
+static void wcfxo_dma_free(struct wcfxo_softc *sc, struct wcfxo_dma *dma);
+static int wcfxo_dma_malloc(struct wcfxo_softc *sc, struct wcfxo_dma *dma);
+#endif
 
 static int debug = 0;
 static int monitor = 0;
@@ -523,7 +579,7 @@
 	WRITE1(WC_FSCDELAY, 0x2);
 
 	/* Setup DMA Addresses */
-	write_dma_addr = vtophys(sc->wc_ldata.wc_writechunk);
+	write_dma_addr = vtophys((vaddr_t) WRITECHUNK(sc));
 	
 	WRITE4(WC_DMAWS, (unsigned int)write_dma_addr); /* Write start */
 	WRITE4(WC_DMAWI, (unsigned int)write_dma_addr +
@@ -532,7 +588,7 @@
 				ZT_CHUNKSIZE * 16 - 4); /* End */
 
 	/* read_dma_addr = vtophys(sc->wc_ldata.wc_readchunk); */
-	read_dma_addr =  vtophys(sc->wc_ldata.wc_readchunk);
+	read_dma_addr =  vtophys((vaddr_t) READCHUNK(sc));
 
 	WRITE4(WC_DMARS, (unsigned int)read_dma_addr); /* Read start */
 	WRITE4(WC_DMARI, (unsigned int)read_dma_addr +
@@ -561,24 +617,43 @@
 /*
  * Return identification string if this is device is ours.
  */
+#ifdef __FreeBSD__
 static int
-wcfxo_probe(device_t dev)
+wcfxs_probe(device_t dev)
+#elif defined(__NetBSD__)
+static int wcfxs_probe(struct device *dev, struct cfdata *cf, void *aux)
+#endif
 {
-	uint16_t		vid;
+        uint16_t		vid;
 	uint16_t		devid;
 	uint16_t		svid;
 	struct wcfxo_ident 	*ident;
-
+#ifdef __NetBSD__
+	struct pci_attach_args *pa = aux;
+	pcireg_t subdev;
+
+	subdev = pci_conf_read(pa->pa_pc, pa->pa_tag, PCI_SUBSYS_ID_REG);
+        
+	vid	= PCI_VENDOR(pa->pa_id);
+	devid	= PCI_PRODUCT(pa->pa_id);
+	svid	= PCI_VENDOR(subdev);
+#elif defined(__FreeBSD__)
 	vid	= pci_get_vendor(dev);
 	devid 	= pci_get_device(dev);
 	svid 	= pci_get_subvendor(dev);
+#endif
 	for (ident = wcfxo_ident_table; ident->device_info != NULL; ident++) {
 		if ((ident->vid == vid) && (ident->did == devid) &&
 			(ident->svid == svid || ident->svid == -1)) {
 
+#ifdef __FreeBSD__
 			printf("ZapTel device: vendor=%x device=%x subvendor=%x\n", 
 				vid, devid, svid);
 			device_set_desc(dev, ident->device_info->name);
+#elif defined(__NetBSD__)
+			aprint_normal("ZapTel device: vendor=%x device=%x subvendor=%x\n", 
+				vid, devid, svid);
+#endif
 			return (0);
 		}
 	}
@@ -596,13 +671,17 @@
 		/* Read is at interrupt address.  Valid data is available at 
 		 * normal offset 
 		 */ 
-		readchunk = sc->wc_ldata.wc_readchunk;
+		readchunk = READCHUNK(sc);
 	else
-		readchunk = sc->wc_ldata.wc_readchunk + ZT_CHUNKSIZE * 2;
+		readchunk = READCHUNK(sc) + ZT_CHUNKSIZE * 2;
 
+#ifdef __FreeBSD__
 	bus_dmamap_sync(sc->wc_ldata.wc_read_tag,
 		sc->wc_ldata.wc_read_dmamap, BUS_DMASYNC_PREWRITE);
-
+#elif defined(__NetBSD__)
+	bus_dmamap_sync(sc->sc_dmat, sc->sc_read.dma_map, 0,
+		sc->sc_read.dma_map->dm_mapsize, BUS_DMASYNC_PREWRITE);
+#endif
 	/* Keep track of how quickly our peg alternates */
 	sc->pegtimer+=ZT_CHUNKSIZE;
 	sc->alt = 0;
@@ -679,8 +758,13 @@
 	/* Receive the result */
 	zt_receive(&sc->span);
 
+#ifdef __FreeBSD__
 	bus_dmamap_sync(sc->wc_ldata.wc_read_tag,
 		sc->wc_ldata.wc_read_dmamap, BUS_DMASYNC_POSTWRITE);
+#elif defined(__NetBSD__)
+	bus_dmamap_sync(sc->sc_dmat, sc->sc_read.dma_map, 0,
+		sc->sc_read.dma_map->dm_mapsize, BUS_DMASYNC_POSTWRITE);
+#endif
 }
 
 
@@ -705,15 +789,20 @@
 
 	if (ints & 0x01)  {
 		/* Write is at interrupt address.  Start writing from normal offset */
-		writechunk = sc->wc_ldata.wc_writechunk;
+		writechunk = WRITECHUNK(sc);
 	} else {
-		writechunk = sc->wc_ldata.wc_writechunk + ZT_CHUNKSIZE * 2;
+		writechunk = WRITECHUNK(sc) + ZT_CHUNKSIZE * 2;
 	}
 
 	zt_transmit(&sc->span);
 
+#ifdef __FreeBSD__
 	bus_dmamap_sync(sc->wc_ldata.wc_write_tag,
 		sc->wc_ldata.wc_write_dmamap, BUS_DMASYNC_PREREAD);
+#elif defined(__NetBSD__)
+	bus_dmamap_sync(sc->sc_dmat, sc->sc_read.dma_map, 0,
+		sc->sc_write.dma_map->dm_mapsize, BUS_DMASYNC_PREREAD);
+#endif
 	for (x=0;x<ZT_CHUNKSIZE;x++) {
 		/* Send a sample, as a 32-bit word, and be sure to indicate that a command follows */
 		if (sc->flags & FLAG_INVERTSER)
@@ -773,10 +862,16 @@
 	}
 
 
+#ifdef __FreeBSD__
 	bus_dmamap_sync(sc->wc_ldata.wc_write_tag,
 		sc->wc_ldata.wc_write_dmamap, BUS_DMASYNC_POSTREAD);
+#elif defined(__NetBSD__)
+	bus_dmamap_sync(sc->sc_dmat, sc->sc_read.dma_map, 0,
+		sc->sc_write.dma_map->dm_mapsize, BUS_DMASYNC_POSTREAD);
+#endif
 }
 
+#ifdef __FreeBSD__
 static int wcfxo_init_daa(struct wcfxo_softc *sc)
 {
 	unsigned char reg15;
@@ -883,9 +978,9 @@
 	return 0;
 }
 
+#endif /* __FreeBSD__ */
 
-
-
+#ifdef __FreeBSD__
 static 
 int wcfxo_dma_allocate(struct wcfxo_softc * sc)
 {
@@ -910,7 +1005,7 @@
 	}
 
 	error = bus_dmamem_alloc(sc->wc_ldata.wc_write_tag,
-		(void **)&sc->wc_ldata.wc_writechunk, BUS_DMA_NOWAIT,
+		(void **)&WRITECHUNK(sc), BUS_DMA_NOWAIT,
 		&sc->wc_ldata.wc_write_dmamap);
 
 	if (error) {
@@ -922,13 +1017,13 @@
 	}
 
 	error = bus_dmamap_load(sc->wc_ldata.wc_write_tag,
-		sc->wc_ldata.wc_write_dmamap, sc->wc_ldata.wc_writechunk,
+		sc->wc_ldata.wc_write_dmamap, WRITECHUNK(sc),
 		ZT_MAX_CHUNKSIZE * 2 * 2 * 2 * 4, wcfxo_dma_map_addr,
 		&sc->wc_ldata.wc_write_dmaaddr, 0);
 
 	if (error) {
 			printf("wcfxo: can't load dma mapping");
-			bus_dmamem_free(sc->wc_ldata.wc_write_tag, sc->wc_ldata.wc_writechunk, 
+			bus_dmamem_free(sc->wc_ldata.wc_write_tag, WRITECHUNK(sc),
 								sc->wc_ldata.wc_write_dmamap);
 			/* destroy map */
 			bus_dmamap_destroy(sc->wc_ldata.wc_write_tag, sc->wc_ldata.wc_write_dmamap);
@@ -959,7 +1054,7 @@
 	}
 
 	error = bus_dmamem_alloc(sc->wc_ldata.wc_read_tag,
-		(void **)&sc->wc_ldata.wc_readchunk, BUS_DMA_NOWAIT,
+		(void **)&READCHUNK(sc), BUS_DMA_NOWAIT,
 		&sc->wc_ldata.wc_read_dmamap);
 
 	if (error) {
@@ -971,13 +1066,13 @@
 	}
 
 	error = bus_dmamap_load(sc->wc_ldata.wc_read_tag,
-		sc->wc_ldata.wc_read_dmamap, sc->wc_ldata.wc_readchunk,
+		sc->wc_ldata.wc_read_dmamap, READCHUNK(sc),
 		ZT_MAX_CHUNKSIZE * 2 * 2 * 2 * 4, wcfxo_dma_map_addr,
 		&sc->wc_ldata.wc_read_dmaaddr, BUS_DMA_NOWAIT);
 
 	if (error) {
 			printf("wcfxo: can't load dma mapping");
-			bus_dmamem_free(sc->wc_ldata.wc_read_tag, sc->wc_ldata.wc_readchunk, 
+			bus_dmamem_free(sc->wc_ldata.wc_read_tag, READCHUNK(sc),
 								sc->wc_ldata.wc_read_dmamap);
 			/* destroy map */
 			bus_dmamap_destroy(sc->wc_ldata.wc_read_tag, sc->wc_ldata.wc_read_dmamap);
@@ -990,9 +1085,9 @@
 
 	return 0;
 }
+#endif /* __FreeBSD__ */
 
-
-#if __FreeBSD_version < 700031
+#if INTERRUPT_VOID
 static void
 #else
 static int 
@@ -1009,7 +1104,7 @@
 
 	ints = READ1(WC_INTSTAT);
 	if (!ints)
-#if __FreeBSD_version < 700031
+#if INTERRUPT_VOID
 		return;
 #else
 		return FILTER_HANDLED;
@@ -1030,7 +1125,7 @@
 		printf("FXO PCI Master abort\n");
 		/* Stop DMA andlet the watchdog start it again */
 		wcfxo_stop_dma(sc);
-#if __FreeBSD_version < 700031
+#if INTERRUPT_VOID
 		return;
 #else
 		return FILTER_HANDLED;
@@ -1039,7 +1134,7 @@
 
 	if (ints & 0x20) {
 		printf("PCI Target abort\n");
-#if __FreeBSD_version < 700031
+#if INTERRUPT_VOID
 		return;
 #else
 		return FILTER_HANDLED;
@@ -1133,11 +1228,14 @@
 		}
 	}
 
-#if __FreeBSD_version >= 700031
+#if INTERRUPT_VOID
+	return;
+#else
 	return FILTER_HANDLED;
 #endif
 }
 
+#ifdef __FreeBSD__
 static void wcfxo_sysctl_init()
 {
 	sysctl_ctx_init(&wcfxo_clist);
@@ -1180,10 +1278,10 @@
 {
 	sysctl_ctx_free(&wcfxo_clist);
 }
-
-
+#endif /* __FreeBSD__ */
 
 /* Attach function is only called if the probe is successful */
+#ifdef __FreeBSD__
 static int
 wcfxo_attach(device_t dev)
 {
@@ -1338,10 +1436,10 @@
 	wcfxo_start_dma(sc);
 
 	/* Initialize Write/Buffers to all blank data */
-	memset((void *)(sc->wc_ldata.wc_writechunk), 0, 
+	memset((void *)WRITECHUNK(sc), 0, 
 			ZT_MAX_CHUNKSIZE * 2 * 2 * 2 * 4);
 
-	memset((void *)(sc->wc_ldata.wc_readchunk), 0, 
+	memset((void *)READCHUNK(sc), 0, 
 			ZT_MAX_CHUNKSIZE * 2 * 2 * 2 * 4);
 
 	/* Initialize DAA (after it's started) */
@@ -1365,7 +1463,235 @@
 	return error;
 }
 
+#elif defined(__NetBSD__)
+static void wcfxo_attach(struct device *parent, struct device *dev, void *aux)
+{
+	struct wcfxo_softc *sc = (struct wcfxo_softc *) dev;
+	struct pci_attach_args *pa = aux;
+	pci_chipset_tag_t pc = pa->pa_pc;
+	pcireg_t subdev;
+	pci_intr_handle_t ih;
+	const char *intrstr;
+	struct wcfxo_ident *id;
+	int i;
+	int error;
+	int opermode;
+
+#ifdef _LKM
+	malloc_type_attach(M_TDM);  /* XXX this  belongs elsewhere */
+#endif
+
+	/* read the subdevice information - XXX code duplication */
+	subdev = pci_conf_read(pc, pa->pa_tag, PCI_SUBSYS_ID_REG);
+
+	for (id = wcfxo_ident_table ; id->device_info != NULL; id++)
+		if (id->vid == PCI_VENDOR(pa->pa_id) &&
+			id->did == PCI_PRODUCT(pa->pa_id) &&
+			(id->svid == PCI_VENDOR(subdev) ||
+			id->svid == (pci_vendor_id_t) -1))
+			break;
+
+	if (id->device_info == NULL) {
+		printf("Card info not found\n");
+		return;
+	}
+
+	printf(": %s\n",id->device_info->name);
+
+#ifdef OPERMODE
+	opermode=OPERMODE;
+#else
+	opermode=0;
+#endif
+	if (opermode < 0 ||
+	    opermode >= sizeof(fxo_modes) / sizeof(fxo_modes[0])) {
+		int i;
+
+		printf("Invalid/unknown operating mode %d specified.  Please choose one of:\n", opermode);
+		for (i = 0; i < sizeof(fxo_modes) / sizeof(fxo_modes[0]); i++)
+			printf("  %d (%s)\n", i, fxo_modes[i].name);
+		error = ENODEV;
+		goto fail;
+	}
+	aprint_normal("%s: operating mode: %s\n", 
+		sc->sc_dv.dv_xname, fxo_modes[opermode].name);
+	sc->opermode = opermode;
+
+	/*
+	 * Make sure bus mastering, ioports, and memory mapping are enabled.
+	 */
+	pci_conf_write(pc, pa->pa_tag, PCI_COMMAND_STATUS_REG,
+		pci_conf_read(pc, pa->pa_tag, PCI_COMMAND_STATUS_REG) |
+		PCI_COMMAND_MASTER_ENABLE | PCI_COMMAND_IO_ENABLE |
+		PCI_COMMAND_MEM_ENABLE);
+
+	if (!(pci_conf_read(pc, pa->pa_tag, PCI_COMMAND_STATUS_REG) &
+		PCI_COMMAND_IO_ENABLE)) {
+		printf("%s: failed to enable I/O ports\n",
+			sc->sc_dv.dv_xname);
+		goto fail;
+	}
+	if (!(pci_conf_read(pc, pa->pa_tag, PCI_COMMAND_STATUS_REG) &
+		PCI_COMMAND_MEM_ENABLE)) {
+		printf("%s: failed to enable memory mapping\n",
+			sc->sc_dv.dv_xname);
+		goto fail;
+	}
+
+	if ((error = pci_mapreg_map(pa, PCIR_BARS, PCI_MAPREG_TYPE_IO, 0,
+		&sc->sc_iot, &sc->sc_ioh, &sc->sc_iob, &sc->sc_iosize)) != 0) {
+	    aprint_error("%s: can't map i/o space, error = %d\n",
+		sc->sc_dv.dv_xname, error);
+	    goto fail;
+	}
+	sc->sc_pct = pc;
+	sc->sc_dmat = pa->pa_dmat;
+	sc->pos = sc->sc_dv.dv_unit;
+	sc->variety = id->device_info->name;
+	sc->flags = id->device_info->flags;
+	sc->usecount = 0;
+
+	/*
+	 * so far as I can tell, this is just wrong; we don't need to
+	 * scan for anything, because zaptel's already loaded; all we
+	 * need is zt_register
+	 */
+	// zaptel_attach_mi(&sc->sc_dv);
+
+	/*
+	 * Set up DMA mappings
+	 */
+	if (!wcfxo_dma_malloc(sc, &sc->sc_read))
+	    goto fail;
+	if (!wcfxo_dma_malloc(sc, &sc->sc_write))
+	    goto fail_1;
+
+	if (wcfxo_initialize(sc)) {
+	    unsigned char x;
+
+	    /* set reset low */
+	    x = READ1(WC_CNTL);
+	    WRITE1(WC_CNTL, (~0x1) & x);
+	    aprint_error("%s: unable to initialize FXO\n",
+		sc->sc_dv.dv_xname);
+	    goto fail_2;
+	}
+
+	/* Map and establish the interrupt */
+	if (pci_intr_map(pa, &ih)) {
+	    aprint_error("%s: can't map interrupt\n", sc->sc_dv.dv_xname);
+	    goto fail;
+	}
+
+	intrstr = pci_intr_string(pc, ih);
+	sc->sc_ih = pci_intr_establish(pc, ih, IPL_NET, wcfxo_interrupt, sc);
+	if (sc->sc_ih == NULL) {
+	    aprint_error("%s: unable to establish interrupt",
+		sc->sc_dv.dv_xname);
+	    if (intrstr != NULL)
+		aprint_normal(" at %s", intrstr);
+	    aprint_normal("\n");
+	    goto fail;
+	}
+	aprint_normal("%s: interrupting at %s\n",sc->sc_dv.dv_xname, intrstr);
+
+	if (wcfxo_hardware_init(sc)) {
+		unsigned char x;
+
+		/* set reset low */
+		x = READ1(WC_CNTL);
+		WRITE1(WC_CNTL, (~0x1) & x);
+
+		goto fail_2;
+	}
+
+	wcfxo_generate_description(sc);
+
+	/* Initialize buffers to 0 */
+	memset((void *) sc->sc_read.chunk, 0, WCFXO_SIZE);
+	memset((void *) sc->sc_write.chunk, 0, WCFXO_SIZE);
+
+	wcfxo_enable_interrupts(sc);
+	wcfxo_start_dma(sc);
+printf("wcfxo started\n");
+
+	return;
+
+ fail_2:
+	wcfxo_dma_free(sc, &sc->sc_write);
+ fail_1:
+	wcfxo_dma_free(sc, &sc->sc_read);
+ fail:
+	return;
+}
+
+/* wcfxo_dma_malloc() returns 0 on failure, 1 on success */
+static int
+wcfxo_dma_malloc(struct wcfxo_softc *sc, struct wcfxo_dma *dma)
+{
+	int error;
+
+	/* set up read buffer first */
+	if ((error = bus_dmamem_alloc(sc->sc_dmat, WCFXO_SIZE, PAGE_SIZE, 0,
+	    &dma->dma_seg, 1, &dma->dma_nseg, BUS_DMA_NOWAIT)) != 0) {
+		aprint_error(
+		    "%s: unable to allocate chunk, error = %d\n",
+		    sc->sc_dv.dv_xname, error);
+		goto fail_0;
+	}
+
+	if ((error = bus_dmamem_map(sc->sc_dmat, &dma->dma_seg,
+	    dma->dma_nseg, WCFXO_SIZE, (caddr_t *)&dma->chunk,
+	    BUS_DMA_NOWAIT)) != 0) {
+		aprint_error(
+		    "%s: unable to map chunk, error = %d\n",
+		    sc->sc_dv.dv_xname, error);
+		goto fail_1;
+	}
+
+	if ((error = bus_dmamap_create(sc->sc_dmat, WCFXO_SIZE, 1, WCFXO_SIZE,
+								   0, 0, &dma->dma_map)) != 0) {
+		aprint_error("%s: unable to create DMA map, "
+		    "error = %d\n",sc->sc_dv.dv_xname, error);
+		goto fail_2;
+	}
+
+	if ((error = bus_dmamap_load(sc->sc_dmat, dma->dma_map,
+	     dma->chunk, WCFXO_SIZE, NULL, BUS_DMA_NOWAIT)) != 0) {
+		aprint_error(
+		    "%s: unable to load DMA map, error = %d\n",
+		    sc->sc_dv.dv_xname, error);
+		goto fail_3;
+	}
+
+	/* success! */
+	return 1;
+
+ fail_3:
+	bus_dmamap_destroy(sc->sc_dmat, dma->dma_map);
+ fail_2:
+	bus_dmamem_unmap(sc->sc_dmat, (caddr_t)dma->chunk, WCFXO_SIZE);
+ fail_1:
+	bus_dmamem_free(sc->sc_dmat, &dma->dma_seg,
+	    dma->dma_nseg);
+ fail_0:
+	return 0;
+}
+
+static void
+wcfxo_dma_free(struct wcfxo_softc *sc, struct wcfxo_dma *dma)
+{
+	int size = ZT_MAX_CHUNKSIZE * 2 * 2 * 2 * 4; /* XXX magic */
+
+	bus_dmamap_destroy(sc->sc_dmat, dma->dma_map);
+	bus_dmamem_unmap(sc->sc_dmat, (caddr_t)dma->chunk, size);
+	bus_dmamem_free(sc->sc_dmat, &dma->dma_seg,
+	    dma->dma_nseg);
+}
+#endif
+
 /* Detach device. */
+#ifdef _FreeBSD__
 static int
 wcfxo_detach(device_t dev)
 {
@@ -1405,7 +1731,7 @@
 		if (sc->wc_ldata.wc_read_tag) {
 			bus_dmamap_unload(sc->wc_ldata.wc_read_tag,
 				sc->wc_ldata.wc_read_dmamap);
-			bus_dmamem_free(sc->wc_ldata.wc_read_tag, sc->wc_ldata.wc_readchunk,
+			bus_dmamem_free(sc->wc_ldata.wc_read_tag, READCHUNK(sc),
 			sc->wc_ldata.wc_read_dmamap);
 			bus_dma_tag_destroy(sc->wc_ldata.wc_read_tag);
 		}
@@ -1413,7 +1739,7 @@
 		if (sc->wc_ldata.wc_write_tag) {
 			bus_dmamap_unload(sc->wc_ldata.wc_write_tag,
 				sc->wc_ldata.wc_write_dmamap);
-			bus_dmamem_free(sc->wc_ldata.wc_write_tag, sc->wc_ldata.wc_writechunk,
+			bus_dmamem_free(sc->wc_ldata.wc_write_tag, WRITECHUNK(sc),
 				sc->wc_ldata.wc_write_dmamap);
 			bus_dma_tag_destroy(sc->wc_ldata.wc_write_tag);
 		}
@@ -1439,6 +1765,45 @@
 	}
 	return (0);
 }
+#elif defined(__NetBSD__)
+static int
+wcfxo_detach(struct device* self, int flags)
+{
+	struct wcfxo_softc *sc = (struct wcfxo_softc *) self;
+
+	if (sc) {
+		/* don't unload if module is in use */
+		if (sc->usecount)
+			return (EBUSY);
+	}
+
+	wcfxo_disable_interrupts(sc);
+	if (sc->sc_ih != NULL)
+	    pci_intr_disestablish(sc->sc_pct, sc->sc_ih);
+	wcfxo_stop_dma(sc);
+	wcfxo_reset_tdm(sc);
+
+	/* free read/write dma buffers */
+	wcfxo_dma_free(sc, &sc->sc_read);
+	wcfxo_dma_free(sc, &sc->sc_write);
+
+	/* Reset PCI chip and registers */
+	WRITE1(WC_CNTL, 0x0e);
+
+	wcfxo_release(sc);
+
+	if (sc->sc_iosize)
+	    bus_space_unmap(sc->sc_iot, sc->sc_ioh, sc->sc_iosize);
+
+#ifdef _LKM
+	malloc_type_detach(M_TDM);  /* XXX this  belongs elsewhere */
+#endif
+	aprint_naive("FXO detach!\n");
+
+	return (0);
+}
+#endif
+
 
 /* Called during system shutdown after sync. */
 
@@ -1473,6 +1838,35 @@
 	return (0);
 }
 
+#ifdef __NetBSD__
+int
+wcfxo_match(struct device *parent, struct cfdata *match, void *aux)
+{
+        struct pci_attach_args *pa = aux;
+        pcireg_t subdev;
+        struct wcfxo_ident *id;
+
+        /* read the subdevice information */
+        subdev = pci_conf_read(pa->pa_pc, pa->pa_tag, PCI_SUBSYS_ID_REG);
+
+        for (id = wcfxo_ident_table; id->device_info != NULL; id++) {
+                if (id->vid == PCI_VENDOR(pa->pa_id) &&
+                        id->did == PCI_PRODUCT(pa->pa_id) &&
+                        (id->svid == PCI_VENDOR(subdev) ||
+                        id->svid == (pci_vendor_id_t) -1)) {
+
+                        printf("FXO device: ");
+                        printf("vendor=%x ",PCI_VENDOR(pa->pa_id));
+                        printf("product=%x ",PCI_PRODUCT(pa->pa_id));
+                        printf("subvendor=%x\n",PCI_VENDOR(subdev));
+                        return (1);
+                }
+        }
+        return (0);
+}
+#endif
+
+#ifdef __FreeBSD__
 /* 
  * syscall routines 
  * We will use them to emulate Linux /proc behaviour --
@@ -1589,3 +1983,4 @@
 /* DRIVER_MODULE(wcfxo, pci, wcfxo_driver, wcfxo_devclass, 0, 0); */
 DECLARE_MODULE(wcfxo, wcfxo_pci_mod, SI_SUB_DRIVERS, SI_ORDER_MIDDLE);
 #endif
+#endif /* __FreeBSD__ */
