$NetBSD$
--- zaptel/zaptel-compat.h.orig	2006-06-22 16:36:09.000000000 +0100
+++ zaptel/zaptel-compat.h	2008-10-30 09:35:15.000000000 +0000
@@ -1,10 +1,18 @@
 #ifndef OS_H
 #define OS_H
 
-#ifdef _KERNEL
-
 #define timer_t struct callout
 
+#ifdef __FreeBSD__
+#if __FreeBSD_version < 700031
+#define INTERRUPT_VOID
+#endif
+#endif
+
+#ifndef FILTER_HANDLED
+#define FILTER_HANDLED 0 
+#endif
+
 /* Locking stuff */
 #ifdef __FreeBSD__
 #	if __FreeBSD_version < 501000
@@ -29,7 +37,6 @@
 							flags, 0, curthread); 
 #		define	ZAP_MGR_DESTROY_LOCK(_lock) lockdestroy(&(_lock))
 #	endif
-#endif
 /* fileops */
 #if __FreeBSD_version < 501000
 typedef int fo_rdwr_t(struct file *fp, struct uio *uio,
@@ -61,10 +68,63 @@
 #define MIN(a,b) (((a)<(b))?(a):(b))
 #define MAX(a,b) (((a)>(b))?(a):(b))
 
+#endif /* version < 501000 */
+typedef struct thread zt_proc_t;
+#define ZT_CHAN(x) ((struct zt_chan *)((x)->si_drv1))
+#define ZT_TIMER(x) ((struct zt_chan *)((x)->si_drv1))
+#endif /* FreeBSD */
+
+#ifdef __NetBSD__
+#       define lock_t   struct simplelock
+#       define ZAP_LOCK(_lock) simple_lock(&(_lock))
+#       define ZAP_UNLOCK(_lock) simple_unlock(&(_lock))
+#       define ZAP_LOCK_INIT(_lock, name) simple_lock_init(&(_lock))
+#       define ZAP_LOCK_DESTROY(_lock) do{}while(0)
+        /* lockmgr locks */
+#       define  ZAP_MGR_LOCK(_lock, flags) lockmgr(&(_lock), \ flags, 0)
+#if (__NetBSD_Version__ < 399001400)
+typedef struct proc zt_proc_t;
+typedef struct ucred * kauth_cred_t;
+#else
+typedef struct lwp zt_proc_t;
+#endif /* version < 399001400 */
+#include <sys/exec.h>
+#include <sys/lkm.h>
+#define ZT_CHAN(x) (((struct zt_fileinfo *)((x)->f_data))->data)
+#define ZT_TIMER(x) (((struct zt_fileinfo *)((x)->f_data))->data)
+
+/* for stashing in file structures; data might hold a chan or timer */
+struct zt_fileinfo {
+	/* each open gets a new unit, but the minor device must ALSO
+	 * be saved.
+	 */
+	int unit;
+	int minor;
+	void *data;
+};
+
+#define MOD_LOAD                LKM_E_LOAD
+#define MOD_UNLOAD              LKM_E_UNLOAD
+
+#define ovbcopy(src, dst, len)		memmove((dst), (src), (len))
+
+#endif /* __NetBSD__ */
+
+/* newer NetBSD has pseudo-returns to avoid overloading ENXIO */
+#if defined (__NetBSD__) && (__NetBSD_Version__ >= 299001600)
+#define EZTCLONE EMOVEFD
+#else
+#define EZTCLONE ENXIO
+#endif
+
+/* NetBSD has changed some of the args of sysctl_createv() to be const */
+#if defined (__NetBSD__) && (__NetBSD_Version__ < 399000600)
+# define __SYSCTL_CONST
+#else
+# define __SYSCTL_CONST const
 #endif
 
 int schluffen(void *q);
 void _selwakeup(void * arg);
 
-#endif /* _KERNEL */
 #endif /* OS_H */
