atf_test_case noflags
noflags_head() {
    atf_set "descr" "Tests fsu_cat with no flags"
}
noflags_body() {
    if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
    echo "abcdef" > expout
    ${FSU_DIR}/src/fsu_write/fsu_write ${FSU_IMG} file < expout

    atf_check '${FSU_DIR}/src/fsu_cat/fsu_cat ${FSU_IMG} file | grep -v sysctl_createv' 0 expout ignore
}
noflags_cleanup() {
    ${FSU_DIR}/src/fsu_rm/fsu_rm ${FSU_IMG} file
}

atf_test_case bfile
bfile_head() {
    atf_set "descr" "Tests fsu_cat with no flags"
}
bfile_body() {
   if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
    if [ ! -f /usr/src/sys/rump/librump/rumpkern/rump.c ]; then
	atf_fail "file: /usr/src/sys/rump/librump/rumpkern/rump.c not found"
    fi

    ${FSU_DIR}/src/fsu_write/fsu_write ${FSU_IMG} file \
	< /usr/src/sys/rump/librump/rumpkern/rump.c
    cat /usr/src/sys/rump/librump/rumpkern/rump.c > expout
    atf_check '${FSU_DIR}/src/fsu_cat/fsu_cat ${FSU_IMG} file | grep -v sysctl_createv' 0 expout ignore
}
bfile_cleanup() {
    ${FSU_DIR}/src/fsu_rm/fsu_rm ${FSU_IMG} file
}

atf_init_test_cases() {
    atf_add_test_case noflags
    atf_add_test_case bfile
}
