atf_test_case noflags
noflags_head() {
    atf_set "descr" "Tests fsu_diff with no flags"
}
noflags_body() {
    if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
    echo "test" | ${FSU_DIR}/src/fsu_write/fsu_write ${FSU_IMG} f1
    ${FSU_DIR}/src/fsu_cp/fsu_cp ${FSU_IMG} f1 f2
    echo "test2" | ${FSU_DIR}/src/fsu_write/fsu_write ${FSU_IMG} f3

    atf_check '${FSU_DIR}/src/fsu_diff/fsu_diff ${FSU_IMG} f1 f2' 0 ignore ignore
    atf_check '${FSU_DIR}/src/fsu_diff/fsu_diff ${FSU_IMG} f1 f3' 1 ignore ignore
}
noflags_cleanup() {
    ${FSU_DIR}/src/fsu_rm/fsu_rm ${FSU_IMG} f1 f2 f3
}

atf_test_case Rflag
Rflag_head() {
    atf_set "descr" "Tests fsu_diff with R flag"
}
Rflag_body() {
    if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
     atf_check '${FSU_DIR}/src/fsu_diff/fsu_diff ${FSU_IMG} / /' 0 ignore ignore
}

atf_init_test_cases() {
    atf_add_test_case noflags
    atf_add_test_case Rflag
}
