/* $NetBSD: main.c,v 1.3 2009/11/06 11:47:41 stacktic Exp $ */

/*
 * Copyright (c) 2008 Arnaud Ysmal.  All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if HAVE_NBCOMPAT_H
#include <nbcompat.h>
#endif

#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <rump/ukfs.h>

#include <fsu_mount.h>

#include "fsu_console.h"

static void usage(void);
extern _Bool fsu_readonly;

int
main(int argc, char *argv[])
{
	struct ukfs *fs;
	int rv;
	char *fname;
	const char *fstype, *fsdevice;

	fstype = fsdevice = NULL;
	setprogname(argv[0]);
	fsu_readonly = true;

	fs = fsu_mount(&argc, &argv);
	if (fs == NULL) {
		usage();
		/* NOTREACHED */
	}
        fstype = fsu_get_fstype();
        fsdevice = fsu_get_device();

	fname = NULL;
	if ((rv = getopt(argc, argv, "s:")) != -1)
		switch (rv) {
		case 's':
			fname = optarg;
			break;
		case '?':
		default:
			ukfs_release(fs, 0);
			usage();
		}
	optind = 1;
#ifndef __linux__
        optreset = 1;
#endif
	return fsu_console(fs, fstype, fsdevice, fname);
}

static void
usage(void)
{

	fprintf(stderr, "usage: %s %s [-s file]\n", getprogname(),
		fsu_mount_usage());
	exit(EXIT_FAILURE);
}
