/* $NetBSD: rump_syscalls.c,v 1.36 2009/07/21 23:59:20 pooka Exp $ */

/*
 * System call vector and marshalling for rump.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.228 2009/07/19 02:50:44 rmind Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: rump_syscalls.c,v 1.36 2009/07/21 23:59:20 pooka Exp $");

#include <sys/types.h>
#include <sys/param.h>
#include <sys/proc.h>
#include <sys/syscall.h>
#include <sys/syscallargs.h>
#include <rump/rumpuser.h>
#include "rump_private.h"

#if	BYTE_ORDER == BIG_ENDIAN
#define SPARG(p,k)	((p)->k.be.datum)
#else /* LITTLE_ENDIAN, I hope dearly */
#define SPARG(p,k)	((p)->k.le.datum)
#endif

int rump_enosys(void);
int
rump_enosys()
{

	return ENOSYS;
}

ssize_t rump_sys_read(int, void *, size_t);
ssize_t
rump_sys_read(int fd, void * buf, size_t nbyte)
{
	register_t retval = 0;
	int error = 0;
	struct sys_read_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, nbyte) = nbyte;

	error = rump_sysproxy(SYS_read, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_read,rump_enosys);

ssize_t rump_sys_write(int, const void *, size_t);
ssize_t
rump_sys_write(int fd, const void * buf, size_t nbyte)
{
	register_t retval = 0;
	int error = 0;
	struct sys_write_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, nbyte) = nbyte;

	error = rump_sysproxy(SYS_write, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_write,rump_enosys);

int rump_sys_open(const char *, int, mode_t);
int
rump_sys_open(const char * path, int flags, mode_t mode)
{
	register_t retval = 0;
	int error = 0;
	struct sys_open_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, mode) = mode;

	error = rump_sysproxy(SYS_open, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_open,rump_enosys);

int rump_sys_close(int);
int
rump_sys_close(int fd)
{
	register_t retval = 0;
	int error = 0;
	struct sys_close_args callarg;

	SPARG(&callarg, fd) = fd;

	error = rump_sysproxy(SYS_close, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_close,rump_enosys);

int rump_sys_link(const char *, const char *);
int
rump_sys_link(const char * path, const char * link)
{
	register_t retval = 0;
	int error = 0;
	struct sys_link_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, link) = link;

	error = rump_sysproxy(SYS_link, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_link,rump_enosys);

int rump_sys_unlink(const char *);
int
rump_sys_unlink(const char * path)
{
	register_t retval = 0;
	int error = 0;
	struct sys_unlink_args callarg;

	SPARG(&callarg, path) = path;

	error = rump_sysproxy(SYS_unlink, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_unlink,rump_enosys);

int rump_sys_chdir(const char *);
int
rump_sys_chdir(const char * path)
{
	register_t retval = 0;
	int error = 0;
	struct sys_chdir_args callarg;

	SPARG(&callarg, path) = path;

	error = rump_sysproxy(SYS_chdir, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_chdir,rump_enosys);

int rump_sys_fchdir(int);
int
rump_sys_fchdir(int fd)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fchdir_args callarg;

	SPARG(&callarg, fd) = fd;

	error = rump_sysproxy(SYS_fchdir, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fchdir,rump_enosys);

int rump_sys_chmod(const char *, mode_t);
int
rump_sys_chmod(const char * path, mode_t mode)
{
	register_t retval = 0;
	int error = 0;
	struct sys_chmod_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rump_sysproxy(SYS_chmod, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_chmod,rump_enosys);

int rump_sys_chown(const char *, uid_t, gid_t);
int
rump_sys_chown(const char * path, uid_t uid, gid_t gid)
{
	register_t retval = 0;
	int error = 0;
	struct sys_chown_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, uid) = uid;
	SPARG(&callarg, gid) = gid;

	error = rump_sysproxy(SYS_chown, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_chown,rump_enosys);

int rump_sys_unmount(const char *, int);
int
rump_sys_unmount(const char * path, int flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_unmount_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_unmount, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_unmount,rump_enosys);

ssize_t rump_sys_recvmsg(int, struct msghdr *, int);
ssize_t
rump_sys_recvmsg(int s, struct msghdr * msg, int flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_recvmsg_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, msg) = msg;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_recvmsg, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_recvmsg,rump_enosys);

ssize_t rump_sys_sendmsg(int, const struct msghdr *, int);
ssize_t
rump_sys_sendmsg(int s, const struct msghdr * msg, int flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_sendmsg_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, msg) = msg;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_sendmsg, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_sendmsg,rump_enosys);

ssize_t rump_sys_recvfrom(int, void *, size_t, int, struct sockaddr *, unsigned int *);
ssize_t
rump_sys_recvfrom(int s, void * buf, size_t len, int flags, struct sockaddr * from, unsigned int * fromlenaddr)
{
	register_t retval = 0;
	int error = 0;
	struct sys_recvfrom_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, len) = len;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, from) = from;
	SPARG(&callarg, fromlenaddr) = fromlenaddr;

	error = rump_sysproxy(SYS_recvfrom, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_recvfrom,rump_enosys);

int rump_sys_accept(int, struct sockaddr *, unsigned int *);
int
rump_sys_accept(int s, struct sockaddr * name, unsigned int * anamelen)
{
	register_t retval = 0;
	int error = 0;
	struct sys_accept_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, anamelen) = anamelen;

	error = rump_sysproxy(SYS_accept, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_accept,rump_enosys);

int rump_sys_getpeername(int, struct sockaddr *, unsigned int *);
int
rump_sys_getpeername(int fdes, struct sockaddr * asa, unsigned int * alen)
{
	register_t retval = 0;
	int error = 0;
	struct sys_getpeername_args callarg;

	SPARG(&callarg, fdes) = fdes;
	SPARG(&callarg, asa) = asa;
	SPARG(&callarg, alen) = alen;

	error = rump_sysproxy(SYS_getpeername, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_getpeername,rump_enosys);

int rump_sys_getsockname(int, struct sockaddr *, unsigned int *);
int
rump_sys_getsockname(int fdes, struct sockaddr * asa, unsigned int * alen)
{
	register_t retval = 0;
	int error = 0;
	struct sys_getsockname_args callarg;

	SPARG(&callarg, fdes) = fdes;
	SPARG(&callarg, asa) = asa;
	SPARG(&callarg, alen) = alen;

	error = rump_sysproxy(SYS_getsockname, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_getsockname,rump_enosys);

int rump_sys_access(const char *, int);
int
rump_sys_access(const char * path, int flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_access_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_access, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_access,rump_enosys);

int rump_sys_chflags(const char *, u_long);
int
rump_sys_chflags(const char * path, u_long flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_chflags_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_chflags, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_chflags,rump_enosys);

int rump_sys_fchflags(int, u_long);
int
rump_sys_fchflags(int fd, u_long flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fchflags_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_fchflags, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fchflags,rump_enosys);

void rump_sys_sync(void);
void
rump_sys_sync(void )
{
	register_t retval = 0;
	int error = 0;

	error = rump_sysproxy(SYS_sync, rump_sysproxy_arg,
	    (uint8_t *)NULL, 0, &retval);
	if (error) {
		retval = -1;
	}
}
__weak_alias(sys_sync,rump_enosys);

int rump_sys_dup(int);
int
rump_sys_dup(int fd)
{
	register_t retval = 0;
	int error = 0;
	struct sys_dup_args callarg;

	SPARG(&callarg, fd) = fd;

	error = rump_sysproxy(SYS_dup, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_dup,rump_enosys);

int rump_sys_ioctl(int, u_long, void *);
int
rump_sys_ioctl(int fd, u_long com, void * data)
{
	register_t retval = 0;
	int error = 0;
	struct sys_ioctl_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, com) = com;
	SPARG(&callarg, data) = data;

	error = rump_sysproxy(SYS_ioctl, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_ioctl,rump_enosys);

int rump_sys_revoke(const char *);
int
rump_sys_revoke(const char * path)
{
	register_t retval = 0;
	int error = 0;
	struct sys_revoke_args callarg;

	SPARG(&callarg, path) = path;

	error = rump_sysproxy(SYS_revoke, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_revoke,rump_enosys);

int rump_sys_symlink(const char *, const char *);
int
rump_sys_symlink(const char * path, const char * link)
{
	register_t retval = 0;
	int error = 0;
	struct sys_symlink_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, link) = link;

	error = rump_sysproxy(SYS_symlink, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_symlink,rump_enosys);

ssize_t rump_sys_readlink(const char *, char *, size_t);
ssize_t
rump_sys_readlink(const char * path, char * buf, size_t count)
{
	register_t retval = 0;
	int error = 0;
	struct sys_readlink_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, count) = count;

	error = rump_sysproxy(SYS_readlink, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_readlink,rump_enosys);

int rump_sys_chroot(const char *);
int
rump_sys_chroot(const char * path)
{
	register_t retval = 0;
	int error = 0;
	struct sys_chroot_args callarg;

	SPARG(&callarg, path) = path;

	error = rump_sysproxy(SYS_chroot, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_chroot,rump_enosys);

int rump_sys_dup2(int, int);
int
rump_sys_dup2(int from, int to)
{
	register_t retval = 0;
	int error = 0;
	struct sys_dup2_args callarg;

	SPARG(&callarg, from) = from;
	SPARG(&callarg, to) = to;

	error = rump_sysproxy(SYS_dup2, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_dup2,rump_enosys);

int rump_sys_fcntl(int, int, void *);
int
rump_sys_fcntl(int fd, int cmd, void * arg)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fcntl_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, cmd) = cmd;
	SPARG(&callarg, arg) = arg;

	error = rump_sysproxy(SYS_fcntl, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fcntl,rump_enosys);

int rump_sys_fsync(int);
int
rump_sys_fsync(int fd)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fsync_args callarg;

	SPARG(&callarg, fd) = fd;

	error = rump_sysproxy(SYS_fsync, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fsync,rump_enosys);

int rump_sys_connect(int, const struct sockaddr *, unsigned int);
int
rump_sys_connect(int s, const struct sockaddr * name, unsigned int namelen)
{
	register_t retval = 0;
	int error = 0;
	struct sys_connect_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, namelen) = namelen;

	error = rump_sysproxy(SYS_connect, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_connect,rump_enosys);

int rump_sys_bind(int, const struct sockaddr *, unsigned int);
int
rump_sys_bind(int s, const struct sockaddr * name, unsigned int namelen)
{
	register_t retval = 0;
	int error = 0;
	struct sys_bind_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, namelen) = namelen;

	error = rump_sysproxy(SYS_bind, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_bind,rump_enosys);

int rump_sys_setsockopt(int, int, int, const void *, unsigned int);
int
rump_sys_setsockopt(int s, int level, int name, const void * val, unsigned int valsize)
{
	register_t retval = 0;
	int error = 0;
	struct sys_setsockopt_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, level) = level;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, val) = val;
	SPARG(&callarg, valsize) = valsize;

	error = rump_sysproxy(SYS_setsockopt, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_setsockopt,rump_enosys);

int rump_sys_listen(int, int);
int
rump_sys_listen(int s, int backlog)
{
	register_t retval = 0;
	int error = 0;
	struct sys_listen_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, backlog) = backlog;

	error = rump_sysproxy(SYS_listen, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_listen,rump_enosys);

int rump_sys_getsockopt(int, int, int, void *, unsigned int *);
int
rump_sys_getsockopt(int s, int level, int name, void * val, unsigned int * avalsize)
{
	register_t retval = 0;
	int error = 0;
	struct sys_getsockopt_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, level) = level;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, val) = val;
	SPARG(&callarg, avalsize) = avalsize;

	error = rump_sysproxy(SYS_getsockopt, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_getsockopt,rump_enosys);

ssize_t rump_sys_readv(int, const struct iovec *, int);
ssize_t
rump_sys_readv(int fd, const struct iovec * iovp, int iovcnt)
{
	register_t retval = 0;
	int error = 0;
	struct sys_readv_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, iovp) = iovp;
	SPARG(&callarg, iovcnt) = iovcnt;

	error = rump_sysproxy(SYS_readv, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_readv,rump_enosys);

ssize_t rump_sys_writev(int, const struct iovec *, int);
ssize_t
rump_sys_writev(int fd, const struct iovec * iovp, int iovcnt)
{
	register_t retval = 0;
	int error = 0;
	struct sys_writev_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, iovp) = iovp;
	SPARG(&callarg, iovcnt) = iovcnt;

	error = rump_sysproxy(SYS_writev, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_writev,rump_enosys);

int rump_sys_fchown(int, uid_t, gid_t);
int
rump_sys_fchown(int fd, uid_t uid, gid_t gid)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fchown_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, uid) = uid;
	SPARG(&callarg, gid) = gid;

	error = rump_sysproxy(SYS_fchown, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fchown,rump_enosys);

int rump_sys_fchmod(int, mode_t);
int
rump_sys_fchmod(int fd, mode_t mode)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fchmod_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, mode) = mode;

	error = rump_sysproxy(SYS_fchmod, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fchmod,rump_enosys);

int rump_sys_rename(const char *, const char *);
int
rump_sys_rename(const char * from, const char * to)
{
	register_t retval = 0;
	int error = 0;
	struct sys_rename_args callarg;

	SPARG(&callarg, from) = from;
	SPARG(&callarg, to) = to;

	error = rump_sysproxy(SYS_rename, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_rename,rump_enosys);

int rump_sys_flock(int, int);
int
rump_sys_flock(int fd, int how)
{
	register_t retval = 0;
	int error = 0;
	struct sys_flock_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, how) = how;

	error = rump_sysproxy(SYS_flock, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_flock,rump_enosys);

int rump_sys_mkfifo(const char *, mode_t);
int
rump_sys_mkfifo(const char * path, mode_t mode)
{
	register_t retval = 0;
	int error = 0;
	struct sys_mkfifo_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rump_sysproxy(SYS_mkfifo, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_mkfifo,rump_enosys);

ssize_t rump_sys_sendto(int, const void *, size_t, int, const struct sockaddr *, unsigned int);
ssize_t
rump_sys_sendto(int s, const void * buf, size_t len, int flags, const struct sockaddr * to, unsigned int tolen)
{
	register_t retval = 0;
	int error = 0;
	struct sys_sendto_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, len) = len;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, to) = to;
	SPARG(&callarg, tolen) = tolen;

	error = rump_sysproxy(SYS_sendto, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_sendto,rump_enosys);

int rump_sys_shutdown(int, int);
int
rump_sys_shutdown(int s, int how)
{
	register_t retval = 0;
	int error = 0;
	struct sys_shutdown_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, how) = how;

	error = rump_sysproxy(SYS_shutdown, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_shutdown,rump_enosys);

int rump_sys_socketpair(int, int, int, int *);
int
rump_sys_socketpair(int domain, int type, int protocol, int * rsv)
{
	register_t retval = 0;
	int error = 0;
	struct sys_socketpair_args callarg;

	SPARG(&callarg, domain) = domain;
	SPARG(&callarg, type) = type;
	SPARG(&callarg, protocol) = protocol;
	SPARG(&callarg, rsv) = rsv;

	error = rump_sysproxy(SYS_socketpair, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_socketpair,rump_enosys);

int rump_sys_mkdir(const char *, mode_t);
int
rump_sys_mkdir(const char * path, mode_t mode)
{
	register_t retval = 0;
	int error = 0;
	struct sys_mkdir_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rump_sysproxy(SYS_mkdir, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_mkdir,rump_enosys);

int rump_sys_rmdir(const char *);
int
rump_sys_rmdir(const char * path)
{
	register_t retval = 0;
	int error = 0;
	struct sys_rmdir_args callarg;

	SPARG(&callarg, path) = path;

	error = rump_sysproxy(SYS_rmdir, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_rmdir,rump_enosys);

int rump_sys_nfssvc(int, void *);
int
rump_sys_nfssvc(int flag, void * argp)
{
	register_t retval = 0;
	int error = 0;
	struct sys_nfssvc_args callarg;

	SPARG(&callarg, flag) = flag;
	SPARG(&callarg, argp) = argp;

	error = rump_sysproxy(SYS_nfssvc, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_nfssvc,rump_enosys);

ssize_t rump_sys_pread(int, void *, size_t, off_t);
ssize_t
rump_sys_pread(int fd, void * buf, size_t nbyte, off_t offset)
{
	register_t retval = 0;
	int error = 0;
	struct sys_pread_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, nbyte) = nbyte;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;

	error = rump_sysproxy(SYS_pread, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_pread,rump_enosys);

ssize_t rump_sys_pwrite(int, const void *, size_t, off_t);
ssize_t
rump_sys_pwrite(int fd, const void * buf, size_t nbyte, off_t offset)
{
	register_t retval = 0;
	int error = 0;
	struct sys_pwrite_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, nbyte) = nbyte;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;

	error = rump_sysproxy(SYS_pwrite, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_pwrite,rump_enosys);

off_t rump_sys_lseek(int, off_t, int);
off_t
rump_sys_lseek(int fd, off_t offset, int whence)
{
	register_t retval = 0;
	int error = 0;
	struct sys_lseek_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;
	SPARG(&callarg, whence) = whence;

	error = rump_sysproxy(SYS_lseek, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_lseek,rump_enosys);

int rump_sys_truncate(const char *, off_t);
int
rump_sys_truncate(const char * path, off_t length)
{
	register_t retval = 0;
	int error = 0;
	struct sys_truncate_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, length) = length;

	error = rump_sysproxy(SYS_truncate, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_truncate,rump_enosys);

int rump_sys_ftruncate(int, off_t);
int
rump_sys_ftruncate(int fd, off_t length)
{
	register_t retval = 0;
	int error = 0;
	struct sys_ftruncate_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, length) = length;

	error = rump_sysproxy(SYS_ftruncate, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_ftruncate,rump_enosys);

int rump_sys___sysctl(const int *, u_int, void *, size_t *, const void *, size_t);
int
rump_sys___sysctl(const int * name, u_int namelen, void * old, size_t * oldlenp, const void * new, size_t newlen)
{
	register_t retval = 0;
	int error = 0;
	struct sys___sysctl_args callarg;

	SPARG(&callarg, name) = name;
	SPARG(&callarg, namelen) = namelen;
	SPARG(&callarg, old) = old;
	SPARG(&callarg, oldlenp) = oldlenp;
	SPARG(&callarg, new) = new;
	SPARG(&callarg, newlen) = newlen;

	error = rump_sysproxy(SYS___sysctl, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___sysctl,rump_enosys);

int rump_sys_reboot(int, char *);
int
rump_sys_reboot(int opt, char * bootstr)
{
	register_t retval = 0;
	int error = 0;
	struct sys_reboot_args callarg;

	SPARG(&callarg, opt) = opt;
	SPARG(&callarg, bootstr) = bootstr;

	error = rump_sysproxy(SYS_reboot, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_reboot,rump_enosys);

int rump_sys_poll(struct pollfd *, u_int, int);
int
rump_sys_poll(struct pollfd * fds, u_int nfds, int timeout)
{
	register_t retval = 0;
	int error = 0;
	struct sys_poll_args callarg;

	SPARG(&callarg, fds) = fds;
	SPARG(&callarg, nfds) = nfds;
	SPARG(&callarg, timeout) = timeout;

	error = rump_sysproxy(SYS_poll, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_poll,rump_enosys);

int rump_sys_fdatasync(int);
int
rump_sys_fdatasync(int fd)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fdatasync_args callarg;

	SPARG(&callarg, fd) = fd;

	error = rump_sysproxy(SYS_fdatasync, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fdatasync,rump_enosys);

int rump_sys_lchmod(const char *, mode_t);
int
rump_sys_lchmod(const char * path, mode_t mode)
{
	register_t retval = 0;
	int error = 0;
	struct sys_lchmod_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rump_sysproxy(SYS_lchmod, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_lchmod,rump_enosys);

int rump_sys_lchown(const char *, uid_t, gid_t);
int
rump_sys_lchown(const char * path, uid_t uid, gid_t gid)
{
	register_t retval = 0;
	int error = 0;
	struct sys_lchown_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, uid) = uid;
	SPARG(&callarg, gid) = gid;

	error = rump_sysproxy(SYS_lchown, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_lchown,rump_enosys);

int rump_sys_fchroot(int);
int
rump_sys_fchroot(int fd)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fchroot_args callarg;

	SPARG(&callarg, fd) = fd;

	error = rump_sysproxy(SYS_fchroot, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fchroot,rump_enosys);

int rump_sys_lchflags(const char *, u_long);
int
rump_sys_lchflags(const char * path, u_long flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_lchflags_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_lchflags, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_lchflags,rump_enosys);

int rump_sys_kqueue(void);
int
rump_sys_kqueue(void )
{
	register_t retval = 0;
	int error = 0;

	error = rump_sysproxy(SYS_kqueue, rump_sysproxy_arg,
	    (uint8_t *)NULL, 0, &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_kqueue,rump_enosys);

int rump_sys_fsync_range(int, int, off_t, off_t);
int
rump_sys_fsync_range(int fd, int flags, off_t start, off_t length)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fsync_range_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, start) = start;
	SPARG(&callarg, length) = length;

	error = rump_sysproxy(SYS_fsync_range, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fsync_range,rump_enosys);

int rump_sys_getvfsstat(struct statvfs *, size_t, int);
int
rump_sys_getvfsstat(struct statvfs * buf, size_t bufsize, int flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_getvfsstat_args callarg;

	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, bufsize) = bufsize;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_getvfsstat, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_getvfsstat,rump_enosys);

int rump_sys_statvfs1(const char *, struct statvfs *, int);
int
rump_sys_statvfs1(const char * path, struct statvfs * buf, int flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_statvfs1_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_statvfs1, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_statvfs1,rump_enosys);

int rump_sys_fstatvfs1(int, struct statvfs *, int);
int
rump_sys_fstatvfs1(int fd, struct statvfs * buf, int flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fstatvfs1_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_fstatvfs1, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fstatvfs1,rump_enosys);

int rump_sys_extattrctl(const char *, int, const char *, int, const char *);
int
rump_sys_extattrctl(const char * path, int cmd, const char * filename, int attrnamespace, const char * attrname)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattrctl_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, cmd) = cmd;
	SPARG(&callarg, filename) = filename;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;

	error = rump_sysproxy(SYS_extattrctl, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattrctl,rump_enosys);

int rump_sys_extattr_set_file(const char *, int, const char *, const void *, size_t);
int
rump_sys_extattr_set_file(const char * path, int attrnamespace, const char * attrname, const void * data, size_t nbytes)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattr_set_file_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rump_sysproxy(SYS_extattr_set_file, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattr_set_file,rump_enosys);

ssize_t rump_sys_extattr_get_file(const char *, int, const char *, void *, size_t);
ssize_t
rump_sys_extattr_get_file(const char * path, int attrnamespace, const char * attrname, void * data, size_t nbytes)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattr_get_file_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rump_sysproxy(SYS_extattr_get_file, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattr_get_file,rump_enosys);

int rump_sys_extattr_delete_file(const char *, int, const char *);
int
rump_sys_extattr_delete_file(const char * path, int attrnamespace, const char * attrname)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattr_delete_file_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;

	error = rump_sysproxy(SYS_extattr_delete_file, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattr_delete_file,rump_enosys);

int rump_sys_extattr_set_fd(int, int, const char *, const void *, size_t);
int
rump_sys_extattr_set_fd(int fd, int attrnamespace, const char * attrname, const void * data, size_t nbytes)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattr_set_fd_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rump_sysproxy(SYS_extattr_set_fd, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattr_set_fd,rump_enosys);

ssize_t rump_sys_extattr_get_fd(int, int, const char *, void *, size_t);
ssize_t
rump_sys_extattr_get_fd(int fd, int attrnamespace, const char * attrname, void * data, size_t nbytes)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattr_get_fd_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rump_sysproxy(SYS_extattr_get_fd, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattr_get_fd,rump_enosys);

int rump_sys_extattr_delete_fd(int, int, const char *);
int
rump_sys_extattr_delete_fd(int fd, int attrnamespace, const char * attrname)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattr_delete_fd_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;

	error = rump_sysproxy(SYS_extattr_delete_fd, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattr_delete_fd,rump_enosys);

int rump_sys_extattr_set_link(const char *, int, const char *, const void *, size_t);
int
rump_sys_extattr_set_link(const char * path, int attrnamespace, const char * attrname, const void * data, size_t nbytes)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattr_set_link_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rump_sysproxy(SYS_extattr_set_link, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattr_set_link,rump_enosys);

ssize_t rump_sys_extattr_get_link(const char *, int, const char *, void *, size_t);
ssize_t
rump_sys_extattr_get_link(const char * path, int attrnamespace, const char * attrname, void * data, size_t nbytes)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattr_get_link_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rump_sysproxy(SYS_extattr_get_link, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattr_get_link,rump_enosys);

int rump_sys_extattr_delete_link(const char *, int, const char *);
int
rump_sys_extattr_delete_link(const char * path, int attrnamespace, const char * attrname)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattr_delete_link_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;

	error = rump_sysproxy(SYS_extattr_delete_link, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattr_delete_link,rump_enosys);

ssize_t rump_sys_extattr_list_fd(int, int, void *, size_t);
ssize_t
rump_sys_extattr_list_fd(int fd, int attrnamespace, void * data, size_t nbytes)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattr_list_fd_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rump_sysproxy(SYS_extattr_list_fd, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattr_list_fd,rump_enosys);

ssize_t rump_sys_extattr_list_file(const char *, int, void *, size_t);
ssize_t
rump_sys_extattr_list_file(const char * path, int attrnamespace, void * data, size_t nbytes)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattr_list_file_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rump_sysproxy(SYS_extattr_list_file, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattr_list_file,rump_enosys);

ssize_t rump_sys_extattr_list_link(const char *, int, void *, size_t);
ssize_t
rump_sys_extattr_list_link(const char * path, int attrnamespace, void * data, size_t nbytes)
{
	register_t retval = 0;
	int error = 0;
	struct sys_extattr_list_link_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rump_sysproxy(SYS_extattr_list_link, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_extattr_list_link,rump_enosys);

int rump_sys_setxattr(const char *, const char *, void *, size_t, int);
int
rump_sys_setxattr(const char * path, const char * name, void * value, size_t size, int flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_setxattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_setxattr, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_setxattr,rump_enosys);

int rump_sys_lsetxattr(const char *, const char *, void *, size_t, int);
int
rump_sys_lsetxattr(const char * path, const char * name, void * value, size_t size, int flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_lsetxattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_lsetxattr, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_lsetxattr,rump_enosys);

int rump_sys_fsetxattr(int, const char *, void *, size_t, int);
int
rump_sys_fsetxattr(int fd, const char * name, void * value, size_t size, int flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fsetxattr_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS_fsetxattr, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fsetxattr,rump_enosys);

int rump_sys_getxattr(const char *, const char *, void *, size_t);
int
rump_sys_getxattr(const char * path, const char * name, void * value, size_t size)
{
	register_t retval = 0;
	int error = 0;
	struct sys_getxattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;

	error = rump_sysproxy(SYS_getxattr, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_getxattr,rump_enosys);

int rump_sys_lgetxattr(const char *, const char *, void *, size_t);
int
rump_sys_lgetxattr(const char * path, const char * name, void * value, size_t size)
{
	register_t retval = 0;
	int error = 0;
	struct sys_lgetxattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;

	error = rump_sysproxy(SYS_lgetxattr, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_lgetxattr,rump_enosys);

int rump_sys_fgetxattr(int, const char *, void *, size_t);
int
rump_sys_fgetxattr(int fd, const char * name, void * value, size_t size)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fgetxattr_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;

	error = rump_sysproxy(SYS_fgetxattr, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fgetxattr,rump_enosys);

int rump_sys_listxattr(const char *, char *, size_t);
int
rump_sys_listxattr(const char * path, char * list, size_t size)
{
	register_t retval = 0;
	int error = 0;
	struct sys_listxattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, list) = list;
	SPARG(&callarg, size) = size;

	error = rump_sysproxy(SYS_listxattr, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_listxattr,rump_enosys);

int rump_sys_llistxattr(const char *, char *, size_t);
int
rump_sys_llistxattr(const char * path, char * list, size_t size)
{
	register_t retval = 0;
	int error = 0;
	struct sys_llistxattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, list) = list;
	SPARG(&callarg, size) = size;

	error = rump_sysproxy(SYS_llistxattr, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_llistxattr,rump_enosys);

int rump_sys_flistxattr(int, char *, size_t);
int
rump_sys_flistxattr(int fd, char * list, size_t size)
{
	register_t retval = 0;
	int error = 0;
	struct sys_flistxattr_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, list) = list;
	SPARG(&callarg, size) = size;

	error = rump_sysproxy(SYS_flistxattr, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_flistxattr,rump_enosys);

int rump_sys_removexattr(const char *, const char *);
int
rump_sys_removexattr(const char * path, const char * name)
{
	register_t retval = 0;
	int error = 0;
	struct sys_removexattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;

	error = rump_sysproxy(SYS_removexattr, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_removexattr,rump_enosys);

int rump_sys_lremovexattr(const char *, const char *);
int
rump_sys_lremovexattr(const char * path, const char * name)
{
	register_t retval = 0;
	int error = 0;
	struct sys_lremovexattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;

	error = rump_sysproxy(SYS_lremovexattr, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_lremovexattr,rump_enosys);

int rump_sys_fremovexattr(int, const char *);
int
rump_sys_fremovexattr(int fd, const char * name)
{
	register_t retval = 0;
	int error = 0;
	struct sys_fremovexattr_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, name) = name;

	error = rump_sysproxy(SYS_fremovexattr, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys_fremovexattr,rump_enosys);

int rump_sys___getdents30(int, char *, size_t);
int
rump_sys___getdents30(int fd, char * buf, size_t count)
{
	register_t retval = 0;
	int error = 0;
	struct sys___getdents30_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, count) = count;

	error = rump_sysproxy(SYS___getdents30, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___getdents30,rump_enosys);

int rump_sys___socket30(int, int, int);
int
rump_sys___socket30(int domain, int type, int protocol)
{
	register_t retval = 0;
	int error = 0;
	struct sys___socket30_args callarg;

	SPARG(&callarg, domain) = domain;
	SPARG(&callarg, type) = type;
	SPARG(&callarg, protocol) = protocol;

	error = rump_sysproxy(SYS___socket30, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___socket30,rump_enosys);

int rump_sys___getfh30(const char *, void *, size_t *);
int
rump_sys___getfh30(const char * fname, void * fhp, size_t * fh_size)
{
	register_t retval = 0;
	int error = 0;
	struct sys___getfh30_args callarg;

	SPARG(&callarg, fname) = fname;
	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;

	error = rump_sysproxy(SYS___getfh30, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___getfh30,rump_enosys);

int rump_sys___fhopen40(const void *, size_t, int);
int
rump_sys___fhopen40(const void * fhp, size_t fh_size, int flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys___fhopen40_args callarg;

	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS___fhopen40, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___fhopen40,rump_enosys);

int rump_sys___fhstatvfs140(const void *, size_t, struct statvfs *, int);
int
rump_sys___fhstatvfs140(const void * fhp, size_t fh_size, struct statvfs * buf, int flags)
{
	register_t retval = 0;
	int error = 0;
	struct sys___fhstatvfs140_args callarg;

	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, flags) = flags;

	error = rump_sysproxy(SYS___fhstatvfs140, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___fhstatvfs140,rump_enosys);

int rump_sys___mount50(const char *, const char *, int, void *, size_t);
int
rump_sys___mount50(const char * type, const char * path, int flags, void * data, size_t data_len)
{
	register_t retval = 0;
	int error = 0;
	struct sys___mount50_args callarg;

	SPARG(&callarg, type) = type;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, data_len) = data_len;

	error = rump_sysproxy(SYS___mount50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___mount50,rump_enosys);

int rump_sys___select50(int, fd_set *, fd_set *, fd_set *, struct timeval *);
int
rump_sys___select50(int nd, fd_set * in, fd_set * ou, fd_set * ex, struct timeval * tv)
{
	register_t retval = 0;
	int error = 0;
	struct sys___select50_args callarg;

	SPARG(&callarg, nd) = nd;
	SPARG(&callarg, in) = in;
	SPARG(&callarg, ou) = ou;
	SPARG(&callarg, ex) = ex;
	SPARG(&callarg, tv) = tv;

	error = rump_sysproxy(SYS___select50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___select50,rump_enosys);

int rump_sys___utimes50(const char *, const struct timeval *);
int
rump_sys___utimes50(const char * path, const struct timeval * tptr)
{
	register_t retval = 0;
	int error = 0;
	struct sys___utimes50_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, tptr) = tptr;

	error = rump_sysproxy(SYS___utimes50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___utimes50,rump_enosys);

int rump_sys___futimes50(int, const struct timeval *);
int
rump_sys___futimes50(int fd, const struct timeval * tptr)
{
	register_t retval = 0;
	int error = 0;
	struct sys___futimes50_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, tptr) = tptr;

	error = rump_sysproxy(SYS___futimes50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___futimes50,rump_enosys);

int rump_sys___lutimes50(const char *, const struct timeval *);
int
rump_sys___lutimes50(const char * path, const struct timeval * tptr)
{
	register_t retval = 0;
	int error = 0;
	struct sys___lutimes50_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, tptr) = tptr;

	error = rump_sysproxy(SYS___lutimes50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___lutimes50,rump_enosys);

int rump_sys___kevent50(int, const struct kevent *, size_t, struct kevent *, size_t, const struct timespec *);
int
rump_sys___kevent50(int fd, const struct kevent * changelist, size_t nchanges, struct kevent * eventlist, size_t nevents, const struct timespec * timeout)
{
	register_t retval = 0;
	int error = 0;
	struct sys___kevent50_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, changelist) = changelist;
	SPARG(&callarg, nchanges) = nchanges;
	SPARG(&callarg, eventlist) = eventlist;
	SPARG(&callarg, nevents) = nevents;
	SPARG(&callarg, timeout) = timeout;

	error = rump_sysproxy(SYS___kevent50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___kevent50,rump_enosys);

int rump_sys___pselect50(int, fd_set *, fd_set *, fd_set *, const struct timespec *, const sigset_t *);
int
rump_sys___pselect50(int nd, fd_set * in, fd_set * ou, fd_set * ex, const struct timespec * ts, const sigset_t * mask)
{
	register_t retval = 0;
	int error = 0;
	struct sys___pselect50_args callarg;

	SPARG(&callarg, nd) = nd;
	SPARG(&callarg, in) = in;
	SPARG(&callarg, ou) = ou;
	SPARG(&callarg, ex) = ex;
	SPARG(&callarg, ts) = ts;
	SPARG(&callarg, mask) = mask;

	error = rump_sysproxy(SYS___pselect50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___pselect50,rump_enosys);

int rump_sys___pollts50(struct pollfd *, u_int, const struct timespec *, const sigset_t *);
int
rump_sys___pollts50(struct pollfd * fds, u_int nfds, const struct timespec * ts, const sigset_t * mask)
{
	register_t retval = 0;
	int error = 0;
	struct sys___pollts50_args callarg;

	SPARG(&callarg, fds) = fds;
	SPARG(&callarg, nfds) = nfds;
	SPARG(&callarg, ts) = ts;
	SPARG(&callarg, mask) = mask;

	error = rump_sysproxy(SYS___pollts50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___pollts50,rump_enosys);

int rump_sys___stat50(const char *, struct stat *);
int
rump_sys___stat50(const char * path, struct stat * ub)
{
	register_t retval = 0;
	int error = 0;
	struct sys___stat50_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, ub) = ub;

	error = rump_sysproxy(SYS___stat50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___stat50,rump_enosys);

int rump_sys___fstat50(int, struct stat *);
int
rump_sys___fstat50(int fd, struct stat * sb)
{
	register_t retval = 0;
	int error = 0;
	struct sys___fstat50_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, sb) = sb;

	error = rump_sysproxy(SYS___fstat50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___fstat50,rump_enosys);

int rump_sys___lstat50(const char *, struct stat *);
int
rump_sys___lstat50(const char * path, struct stat * ub)
{
	register_t retval = 0;
	int error = 0;
	struct sys___lstat50_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, ub) = ub;

	error = rump_sysproxy(SYS___lstat50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___lstat50,rump_enosys);

int rump_sys___mknod50(const char *, mode_t, dev_t);
int
rump_sys___mknod50(const char * path, mode_t mode, dev_t dev)
{
	register_t retval = 0;
	int error = 0;
	struct sys___mknod50_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;
	SPARG(&callarg, dev) = dev;

	error = rump_sysproxy(SYS___mknod50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___mknod50,rump_enosys);

int rump_sys___fhstat50(const void *, size_t, struct stat *);
int
rump_sys___fhstat50(const void * fhp, size_t fh_size, struct stat * sb)
{
	register_t retval = 0;
	int error = 0;
	struct sys___fhstat50_args callarg;

	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;
	SPARG(&callarg, sb) = sb;

	error = rump_sysproxy(SYS___fhstat50, rump_sysproxy_arg,
	    (uint8_t *)&callarg, sizeof(callarg), &retval);
	if (error) {
		retval = -1;
		rumpuser_seterrno(error);
	}
	return retval;
}
__weak_alias(sys___fhstat50,rump_enosys);

#define	s(type)	sizeof(type)
#define	n(type)	(sizeof(type)/sizeof (register_t))
#define	ns(type)	n(type), s(type)

struct sysent rump_sysent[] = {
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 0 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 1 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 2 = unrumped */
	{ ns(struct sys_read_args), 0,
	    (sy_call_t *)sys_read },			/* 3 = read */
	{ ns(struct sys_write_args), 0,
	    (sy_call_t *)sys_write },			/* 4 = write */
	{ ns(struct sys_open_args), 0,
	    (sy_call_t *)sys_open },			/* 5 = open */
	{ ns(struct sys_close_args), 0,
	    (sy_call_t *)sys_close },			/* 6 = close */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 7 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 8 = unrumped */
	{ ns(struct sys_link_args), 0,
	    (sy_call_t *)sys_link },			/* 9 = link */
	{ ns(struct sys_unlink_args), 0,
	    (sy_call_t *)sys_unlink },			/* 10 = unlink */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 11 = obsolete execv */
	{ ns(struct sys_chdir_args), 0,
	    (sy_call_t *)sys_chdir },			/* 12 = chdir */
	{ ns(struct sys_fchdir_args), 0,
	    (sy_call_t *)sys_fchdir },			/* 13 = fchdir */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 14 = unrumped */
	{ ns(struct sys_chmod_args), 0,
	    (sy_call_t *)sys_chmod },			/* 15 = chmod */
	{ ns(struct sys_chown_args), 0,
	    (sy_call_t *)sys_chown },			/* 16 = chown */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 17 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 18 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 19 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 20 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 21 = unrumped */
	{ ns(struct sys_unmount_args), 0,
	    (sy_call_t *)sys_unmount },			/* 22 = unmount */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 23 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 24 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 25 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 26 = unrumped */
	{ ns(struct sys_recvmsg_args), 0,
	    (sy_call_t *)sys_recvmsg },			/* 27 = recvmsg */
	{ ns(struct sys_sendmsg_args), 0,
	    (sy_call_t *)sys_sendmsg },			/* 28 = sendmsg */
	{ ns(struct sys_recvfrom_args), 0,
	    (sy_call_t *)sys_recvfrom },		/* 29 = recvfrom */
	{ ns(struct sys_accept_args), 0,
	    (sy_call_t *)sys_accept },			/* 30 = accept */
	{ ns(struct sys_getpeername_args), 0,
	    (sy_call_t *)sys_getpeername },		/* 31 = getpeername */
	{ ns(struct sys_getsockname_args), 0,
	    (sy_call_t *)sys_getsockname },		/* 32 = getsockname */
	{ ns(struct sys_access_args), 0,
	    (sy_call_t *)sys_access },			/* 33 = access */
	{ ns(struct sys_chflags_args), 0,
	    (sy_call_t *)sys_chflags },			/* 34 = chflags */
	{ ns(struct sys_fchflags_args), 0,
	    (sy_call_t *)sys_fchflags },		/* 35 = fchflags */
	{ 0, 0, 0,
	    (sy_call_t *)sys_sync },			/* 36 = sync */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 37 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 38 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 39 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 40 = unrumped */
	{ ns(struct sys_dup_args), 0,
	    (sy_call_t *)sys_dup },			/* 41 = dup */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 42 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 43 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 44 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 45 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 46 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 47 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 48 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 49 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 50 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 51 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 52 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 53 = unrumped */
	{ ns(struct sys_ioctl_args), 0,
	    (sy_call_t *)sys_ioctl },			/* 54 = ioctl */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 55 = unrumped */
	{ ns(struct sys_revoke_args), 0,
	    (sy_call_t *)sys_revoke },			/* 56 = revoke */
	{ ns(struct sys_symlink_args), 0,
	    (sy_call_t *)sys_symlink },			/* 57 = symlink */
	{ ns(struct sys_readlink_args), 0,
	    (sy_call_t *)sys_readlink },		/* 58 = readlink */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 59 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 60 = unrumped */
	{ ns(struct sys_chroot_args), 0,
	    (sy_call_t *)sys_chroot },			/* 61 = chroot */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 62 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 63 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 64 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 65 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 66 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 67 = obsolete vread */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 68 = obsolete vwrite */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 69 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 70 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 71 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 72 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 73 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 74 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 75 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 76 = obsolete vhangup */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 77 = obsolete vlimit */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 78 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 79 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 80 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 81 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 82 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 83 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 84 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 85 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 86 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 87 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 88 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 89 = unrumped */
	{ ns(struct sys_dup2_args), 0,
	    (sy_call_t *)sys_dup2 },			/* 90 = dup2 */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 91 = unimplemented getdopt */
	{ ns(struct sys_fcntl_args), 0,
	    (sy_call_t *)sys_fcntl },			/* 92 = fcntl */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 93 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 94 = unimplemented setdopt */
	{ ns(struct sys_fsync_args), 0,
	    (sy_call_t *)sys_fsync },			/* 95 = fsync */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 96 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 97 = unrumped */
	{ ns(struct sys_connect_args), 0,
	    (sy_call_t *)sys_connect },			/* 98 = connect */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 99 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 100 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 101 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 102 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 103 = unrumped */
	{ ns(struct sys_bind_args), 0,
	    (sy_call_t *)sys_bind },			/* 104 = bind */
	{ ns(struct sys_setsockopt_args), 0,
	    (sy_call_t *)sys_setsockopt },		/* 105 = setsockopt */
	{ ns(struct sys_listen_args), 0,
	    (sy_call_t *)sys_listen },			/* 106 = listen */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 107 = obsolete vtimes */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 108 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 109 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 110 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 111 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 112 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 113 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 114 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 115 = obsolete vtrace */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 116 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 117 = unrumped */
	{ ns(struct sys_getsockopt_args), 0,
	    (sy_call_t *)sys_getsockopt },		/* 118 = getsockopt */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 119 = obsolete resuba */
	{ ns(struct sys_readv_args), 0,
	    (sy_call_t *)sys_readv },			/* 120 = readv */
	{ ns(struct sys_writev_args), 0,
	    (sy_call_t *)sys_writev },			/* 121 = writev */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 122 = unrumped */
	{ ns(struct sys_fchown_args), 0,
	    (sy_call_t *)sys_fchown },			/* 123 = fchown */
	{ ns(struct sys_fchmod_args), 0,
	    (sy_call_t *)sys_fchmod },			/* 124 = fchmod */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 125 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 126 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 127 = unrumped */
	{ ns(struct sys_rename_args), 0,
	    (sy_call_t *)sys_rename },			/* 128 = rename */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 129 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 130 = unrumped */
	{ ns(struct sys_flock_args), 0,
	    (sy_call_t *)sys_flock },			/* 131 = flock */
	{ ns(struct sys_mkfifo_args), 0,
	    (sy_call_t *)sys_mkfifo },			/* 132 = mkfifo */
	{ ns(struct sys_sendto_args), 0,
	    (sy_call_t *)sys_sendto },			/* 133 = sendto */
	{ ns(struct sys_shutdown_args), 0,
	    (sy_call_t *)sys_shutdown },		/* 134 = shutdown */
	{ ns(struct sys_socketpair_args), 0,
	    (sy_call_t *)sys_socketpair },		/* 135 = socketpair */
	{ ns(struct sys_mkdir_args), 0,
	    (sy_call_t *)sys_mkdir },			/* 136 = mkdir */
	{ ns(struct sys_rmdir_args), 0,
	    (sy_call_t *)sys_rmdir },			/* 137 = rmdir */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 138 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 139 = obsolete 4.2 sigreturn */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 140 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 141 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 142 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 143 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 144 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 145 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 146 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 147 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 148 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 149 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 150 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 151 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 152 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 153 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 154 = unimplemented */
	{ ns(struct sys_nfssvc_args), 0,
	    (sy_call_t *)sys_nomodule },		/* 155 = nfssvc */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 156 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 157 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 158 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 159 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 160 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 161 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 162 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 163 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 164 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 165 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 166 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 167 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 168 = unimplemented */
#if (defined(SYSVSEM) || !defined(_KERNEL_OPT)) && !defined(_LP64)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 169 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 169 = excluded 1.0 semsys */
#endif
#if (defined(SYSVMSG) || !defined(_KERNEL_OPT)) && !defined(_LP64)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 170 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 170 = excluded 1.0 msgsys */
#endif
#if (defined(SYSVSHM) || !defined(_KERNEL_OPT)) && !defined(_LP64)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 171 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 171 = excluded 1.0 shmsys */
#endif
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 172 = unimplemented */
	{ ns(struct sys_pread_args), 0,
	    (sy_call_t *)sys_pread },			/* 173 = pread */
	{ ns(struct sys_pwrite_args), 0,
	    (sy_call_t *)sys_pwrite },			/* 174 = pwrite */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 175 = unrumped */
#if defined(NTP) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 176 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 176 = excluded ntp_adjtime */
#endif
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 177 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 178 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 179 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 180 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 181 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 182 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 183 = unrumped */
#if defined(LFS) || !defined(_KERNEL)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 184 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 185 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 186 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 187 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 184 = excluded lfs_bmapv */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 185 = excluded lfs_markv */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 186 = excluded lfs_segclean */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 187 = excluded lfs_segwait */
#endif
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 188 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 189 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 190 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 191 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 192 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 193 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 194 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 195 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 196 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 197 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 198 = unrumped */
	{ ns(struct sys_lseek_args), 0,
	    (sy_call_t *)sys_lseek },			/* 199 = lseek */
	{ ns(struct sys_truncate_args), 0,
	    (sy_call_t *)sys_truncate },		/* 200 = truncate */
	{ ns(struct sys_ftruncate_args), 0,
	    (sy_call_t *)sys_ftruncate },		/* 201 = ftruncate */
	{ ns(struct sys___sysctl_args), 0,
	    (sy_call_t *)sys___sysctl },		/* 202 = __sysctl */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 203 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 204 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 205 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 206 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 207 = unrumped */
	{ ns(struct sys_reboot_args), 0,
	    (sy_call_t *)sys_reboot },			/* 208 = reboot */
	{ ns(struct sys_poll_args), 0,
	    (sy_call_t *)sys_poll },			/* 209 = poll */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 210 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 211 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 212 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 213 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 214 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 215 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 216 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 217 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 218 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 219 = unimplemented */
#if defined(SYSVSEM) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 220 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 221 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 222 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 223 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 220 = excluded compat_14_semctl */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 221 = excluded semget */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 222 = excluded semop */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 223 = excluded semconfig */
#endif
#if defined(SYSVMSG) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 224 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 225 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 226 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 227 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 224 = excluded compat_14_msgctl */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 225 = excluded msgget */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 226 = excluded msgsnd */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 227 = excluded msgrcv */
#endif
#if defined(SYSVSHM) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 228 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 229 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 230 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 231 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 228 = excluded shmat */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 229 = excluded compat_14_shmctl */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 230 = excluded shmdt */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 231 = excluded shmget */
#endif
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 232 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 233 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 234 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 235 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 236 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 237 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 238 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 239 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 240 = unrumped */
	{ ns(struct sys_fdatasync_args), 0,
	    (sy_call_t *)sys_fdatasync },		/* 241 = fdatasync */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 242 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 243 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 244 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 245 = unimplemented sys_sigqueue */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 246 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 247 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 248 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 249 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 250 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 251 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 252 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 253 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 254 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 255 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 256 = unimplemented sys__ksem_timedwait */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 257 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 258 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 259 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 260 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 261 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 262 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 263 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 264 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 265 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 266 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 267 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 268 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 269 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 270 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 271 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 272 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 273 = unrumped */
	{ ns(struct sys_lchmod_args), 0,
	    (sy_call_t *)sys_lchmod },			/* 274 = lchmod */
	{ ns(struct sys_lchown_args), 0,
	    (sy_call_t *)sys_lchown },			/* 275 = lchown */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 276 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 277 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 278 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 279 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 280 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 281 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 282 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 283 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 284 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 285 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 286 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 287 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 288 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 289 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 290 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 291 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 292 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 293 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 294 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 295 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 296 = unrumped */
	{ ns(struct sys_fchroot_args), 0,
	    (sy_call_t *)sys_fchroot },			/* 297 = fchroot */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 298 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 299 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 300 = unrumped */
#if defined(SYSVSEM) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 301 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 301 = excluded ____semctl13 */
#endif
#if defined(SYSVMSG) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 302 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 302 = excluded __msgctl13 */
#endif
#if defined(SYSVSHM) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 303 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 303 = excluded __shmctl13 */
#endif
	{ ns(struct sys_lchflags_args), 0,
	    (sy_call_t *)sys_lchflags },		/* 304 = lchflags */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 305 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 306 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 307 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 308 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 309 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 310 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 311 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 312 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 313 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 314 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 315 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 316 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 317 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 318 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 319 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 320 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 321 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 322 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 323 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 324 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 325 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 326 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 327 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 328 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 329 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 330 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 331 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 332 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 333 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 334 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 335 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 336 = obsolete sys_sa_unblockyield */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 337 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 338 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 339 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 340 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 341 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 342 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 343 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)sys_kqueue },			/* 344 = kqueue */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 345 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 346 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 347 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 348 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 349 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 350 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 351 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 352 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 353 = unimplemented */
	{ ns(struct sys_fsync_range_args), 0,
	    (sy_call_t *)sys_fsync_range },		/* 354 = fsync_range */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 355 = unrumped */
	{ ns(struct sys_getvfsstat_args), 0,
	    (sy_call_t *)sys_getvfsstat },		/* 356 = getvfsstat */
	{ ns(struct sys_statvfs1_args), 0,
	    (sy_call_t *)sys_statvfs1 },		/* 357 = statvfs1 */
	{ ns(struct sys_fstatvfs1_args), 0,
	    (sy_call_t *)sys_fstatvfs1 },		/* 358 = fstatvfs1 */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 359 = unrumped */
	{ ns(struct sys_extattrctl_args), 0,
	    (sy_call_t *)sys_extattrctl },		/* 360 = extattrctl */
	{ ns(struct sys_extattr_set_file_args), 0,
	    (sy_call_t *)sys_extattr_set_file },	/* 361 = extattr_set_file */
	{ ns(struct sys_extattr_get_file_args), 0,
	    (sy_call_t *)sys_extattr_get_file },	/* 362 = extattr_get_file */
	{ ns(struct sys_extattr_delete_file_args), 0,
	    (sy_call_t *)sys_extattr_delete_file },	/* 363 = extattr_delete_file */
	{ ns(struct sys_extattr_set_fd_args), 0,
	    (sy_call_t *)sys_extattr_set_fd },		/* 364 = extattr_set_fd */
	{ ns(struct sys_extattr_get_fd_args), 0,
	    (sy_call_t *)sys_extattr_get_fd },		/* 365 = extattr_get_fd */
	{ ns(struct sys_extattr_delete_fd_args), 0,
	    (sy_call_t *)sys_extattr_delete_fd },	/* 366 = extattr_delete_fd */
	{ ns(struct sys_extattr_set_link_args), 0,
	    (sy_call_t *)sys_extattr_set_link },	/* 367 = extattr_set_link */
	{ ns(struct sys_extattr_get_link_args), 0,
	    (sy_call_t *)sys_extattr_get_link },	/* 368 = extattr_get_link */
	{ ns(struct sys_extattr_delete_link_args), 0,
	    (sy_call_t *)sys_extattr_delete_link },	/* 369 = extattr_delete_link */
	{ ns(struct sys_extattr_list_fd_args), 0,
	    (sy_call_t *)sys_extattr_list_fd },		/* 370 = extattr_list_fd */
	{ ns(struct sys_extattr_list_file_args), 0,
	    (sy_call_t *)sys_extattr_list_file },	/* 371 = extattr_list_file */
	{ ns(struct sys_extattr_list_link_args), 0,
	    (sy_call_t *)sys_extattr_list_link },	/* 372 = extattr_list_link */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 373 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 374 = unrumped */
	{ ns(struct sys_setxattr_args), 0,
	    (sy_call_t *)sys_setxattr },		/* 375 = setxattr */
	{ ns(struct sys_lsetxattr_args), 0,
	    (sy_call_t *)sys_lsetxattr },		/* 376 = lsetxattr */
	{ ns(struct sys_fsetxattr_args), 0,
	    (sy_call_t *)sys_fsetxattr },		/* 377 = fsetxattr */
	{ ns(struct sys_getxattr_args), 0,
	    (sy_call_t *)sys_getxattr },		/* 378 = getxattr */
	{ ns(struct sys_lgetxattr_args), 0,
	    (sy_call_t *)sys_lgetxattr },		/* 379 = lgetxattr */
	{ ns(struct sys_fgetxattr_args), 0,
	    (sy_call_t *)sys_fgetxattr },		/* 380 = fgetxattr */
	{ ns(struct sys_listxattr_args), 0,
	    (sy_call_t *)sys_listxattr },		/* 381 = listxattr */
	{ ns(struct sys_llistxattr_args), 0,
	    (sy_call_t *)sys_llistxattr },		/* 382 = llistxattr */
	{ ns(struct sys_flistxattr_args), 0,
	    (sy_call_t *)sys_flistxattr },		/* 383 = flistxattr */
	{ ns(struct sys_removexattr_args), 0,
	    (sy_call_t *)sys_removexattr },		/* 384 = removexattr */
	{ ns(struct sys_lremovexattr_args), 0,
	    (sy_call_t *)sys_lremovexattr },		/* 385 = lremovexattr */
	{ ns(struct sys_fremovexattr_args), 0,
	    (sy_call_t *)sys_fremovexattr },		/* 386 = fremovexattr */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 387 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 388 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 389 = unrumped */
	{ ns(struct sys___getdents30_args), 0,
	    (sy_call_t *)sys___getdents30 },		/* 390 = __getdents30 */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 391 = ignored old posix_fadvise */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 392 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 393 = unrumped */
	{ ns(struct sys___socket30_args), 0,
	    (sy_call_t *)sys___socket30 },		/* 394 = __socket30 */
	{ ns(struct sys___getfh30_args), 0,
	    (sy_call_t *)sys___getfh30 },		/* 395 = __getfh30 */
	{ ns(struct sys___fhopen40_args), 0,
	    (sy_call_t *)sys___fhopen40 },		/* 396 = __fhopen40 */
	{ ns(struct sys___fhstatvfs140_args), 0,
	    (sy_call_t *)sys___fhstatvfs140 },		/* 397 = __fhstatvfs140 */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 398 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 399 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 400 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 401 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 402 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 403 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 404 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 405 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 406 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 407 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 408 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 409 = unimplemented */
	{ ns(struct sys___mount50_args), 0,
	    (sy_call_t *)sys___mount50 },		/* 410 = __mount50 */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 411 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 412 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 413 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 414 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 415 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 416 = unrumped */
	{ ns(struct sys___select50_args), 0,
	    (sy_call_t *)sys___select50 },		/* 417 = __select50 */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 418 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 419 = unrumped */
	{ ns(struct sys___utimes50_args), 0,
	    (sy_call_t *)sys___utimes50 },		/* 420 = __utimes50 */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 421 = unrumped */
#if defined(LFS) || !defined(_KERNEL)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 422 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 422 = excluded __lfs_segwait50 */
#endif
	{ ns(struct sys___futimes50_args), 0,
	    (sy_call_t *)sys___futimes50 },		/* 423 = __futimes50 */
	{ ns(struct sys___lutimes50_args), 0,
	    (sy_call_t *)sys___lutimes50 },		/* 424 = __lutimes50 */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 425 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 426 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 427 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 428 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 429 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 430 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 431 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 432 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 433 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 434 = unrumped */
	{ ns(struct sys___kevent50_args), 0,
	    (sy_call_t *)sys___kevent50 },		/* 435 = __kevent50 */
	{ ns(struct sys___pselect50_args), 0,
	    (sy_call_t *)sys___pselect50 },		/* 436 = __pselect50 */
	{ ns(struct sys___pollts50_args), 0,
	    (sy_call_t *)sys___pollts50 },		/* 437 = __pollts50 */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 438 = unrumped */
	{ ns(struct sys___stat50_args), 0,
	    (sy_call_t *)sys___stat50 },		/* 439 = __stat50 */
	{ ns(struct sys___fstat50_args), 0,
	    (sy_call_t *)sys___fstat50 },		/* 440 = __fstat50 */
	{ ns(struct sys___lstat50_args), 0,
	    (sy_call_t *)sys___lstat50 },		/* 441 = __lstat50 */
#if defined(SYSVSEM) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 442 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 442 = excluded ____semctl50 */
#endif
#if defined(SYSVSHM) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 443 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 443 = excluded ____shmctl50 */
#endif
#if defined(SYSVMSG) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 444 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 444 = excluded ____msgctl50 */
#endif
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 445 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 446 = unrumped */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 447 = unrumped */
#if defined(NTP) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 448 = unrumped */
#else
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 448 = excluded ___ntp_gettime50 */
#endif
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 449 = unrumped */
	{ ns(struct sys___mknod50_args), 0,
	    (sy_call_t *)sys___mknod50 },		/* 450 = __mknod50 */
	{ ns(struct sys___fhstat50_args), 0,
	    (sy_call_t *)sys___fhstat50 },		/* 451 = __fhstat50 */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 452 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 453 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 454 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 455 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 456 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 457 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 458 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 459 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 460 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 461 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 462 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 463 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 464 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 465 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 466 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 467 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 468 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 469 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 470 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 471 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 472 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 473 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 474 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 475 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 476 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 477 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 478 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 479 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 480 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 481 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 482 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 483 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 484 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 485 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 486 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 487 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 488 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 489 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 490 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 491 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 492 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 493 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 494 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 495 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 496 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 497 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 498 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 499 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 500 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 501 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 502 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 503 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 504 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 505 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 506 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 507 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 508 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 509 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 510 = filler */
	{ 0, 0, 0,
	    (sy_call_t *)rump_enosys },			/* 511 = filler */
};
CTASSERT(__arraycount(rump_sysent) == SYS_NSYSENT);
