/*
 	Copyright (C) 2001  Sony Computer Entertainment Inc.
 
  This file is subject to the terms and conditions of the GNU Library
  General Public License Version 2. See the file "COPYING.LIB" in the 
  main directory of this archive for more details.
*/

// 
// "mathfunc.c"
// 
// 
#include<math.h>
#include<stdio.h>
#include"mathfunc.h"

/* mathematical functions */
// ===========================================================================
// svZ̊֐Q(libvu0)
//
// s̔z`͈ȉ̂悤ɂȂĂ܂. (libvu0Ƃ͓]u)
// 
//     |v[0][0] v[0][1] v[0][2] v[0][3]|
//  m =|v[1][0] v[1][1] v[1][2] v[1][3]|
//     |v[2][0] v[2][1] v[2][2] v[2][3]|
//     |v[3][0] v[3][1] v[3][2] v[3][3]|
// 


// ==========================================================================
//  ps2Samp0ApplyMatrix		xNgɃ}gbNXZB
//  `
//  	void ps2Samp0ApplyMatrix(ps2Samp0FVECTOR v0, ps2Samp0FMATRIX m0, ps2Samp0FVECTOR v1)
//  
//  	v1		:xNg
//  	m0		:}gbNX
//  	v0		o:xNg
// 
//  
//  	}gbNXmɃxNgv0EZāAv1ɗ^
// 
//  		v0=m0*v1
//  Ԃl
//  	Ȃ
// --------------------------------------------------------------------------
void ps2Samp0ApplyMatrix(ps2Samp0FVECTOR v0, ps2Samp0FMATRIX m0,
			 ps2Samp0FVECTOR v1)
{
  ps2Samp0FVECTOR v;
  v[0] = v1[0]*m0[0][0] + v1[1]*m0[0][1] + v1[2]*m0[0][2] + v1[3]*m0[0][3];
  v[1] = v1[0]*m0[1][0] + v1[1]*m0[1][1] + v1[2]*m0[1][2] + v1[3]*m0[1][3];
  v[2] = v1[0]*m0[2][0] + v1[1]*m0[2][1] + v1[2]*m0[2][2] + v1[3]*m0[2][3];
  v[3] = v1[0]*m0[3][0] + v1[1]*m0[3][1] + v1[2]*m0[3][2] + v1[3]*m0[3][3];
  ps2Samp0CopyVector(v0, v);
}

// ==========================================================================
// 
//  ps2Samp0MulMatrix		Q}gbNX̐ς߂
//  `
//  	void ps2Samp0MulMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, ps2Samp0FMATRIX m2)
//  
//  	m1,m2		:}gbNX
//  	m0		o:}gbNX
//  
//  	}gbNXm1Ƀ}gbNXm2EZāAm0ɗ^
// 
//  		m0=m1*m2
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0MulMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1,
		       ps2Samp0FMATRIX m2)
{

  int i, j;
  ps2Samp0FMATRIX m;
   for(i=0; i<4; i++){
     for(j=0; j<4; j++){
       m[i][j] = m1[i][0] * m2[0][j] + m1[i][1] * m2[1][j]
	 + m1[i][2] * m2[2][j] + m1[i][3] * m2[3][j];
     }
   }
   ps2Samp0CopyMatrix(m0, m);

}

// ==========================================================================
// 
//  ps2Samp0OuterProduct		Q̃xNg̊Oς߂
//  `
//  	void ps2Samp0OuterProduct(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, ps2Samp0FVECTOR v2)
//  
//  	v1,v2		:xNg
//  	v0		o:xNg
//  
//  	xNgv1,v2̊Oς߂v0ɗ^
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0OuterProduct(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1,
			  ps2Samp0FVECTOR v2)
{
  v0[0] = v1[1] * v2[2] - v1[2] * v2[1];
  v0[1] = v1[2] * v2[0] - v1[0] * v2[2];
  v0[2] = v1[0] * v2[1] - v1[1] * v2[0];
  v0[3] = 0;
}

// ==========================================================================
// 
//  ps2Samp0InnerProduct		Q̃xNg̓ς߂
//  `
//  	float ps2Samp0InnerProduct(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1)
//  
//  	v0,v1		:xNg
//  
//  	xNgv0,v1̓ς߂
//  Ԃl
//  	
// 
// --------------------------------------------------------------------------
float ps2Samp0InnerProduct(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1)
{
  return (v0[0]*v1[0] + v0[1]*v1[1] + v0[2]*v1[2]);
}

// ==========================================================================
//  ps2Samp0Normalize		xNg̐Ks
//  `
//  	void ps2Samp0Normalize(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1)
//  
//  	v1		:xNg
//  	v0		o:xNg
//  
//  	xNgv0̐Ksv1ɗ^
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0Normalize(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1)
{
  float norm, dnorm;
  norm = sqrt( v1[0]*v1[0] + v1[1]*v1[1] + v1[2]*v1[2] );
  if(norm > 0){
    dnorm = 1.0/norm;
    v0[0] = v1[0]*dnorm;
    v0[1] = v1[1]*dnorm;
    v0[2] = v1[2]*dnorm;
    v0[3] = v1[3];
  }
}

// ==========================================================================
// 
//  ps2Samp0TransposeMatrix	}gbNX̓]us߂
//  `
//  	void ps2Samp0TransposeMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1)
//  
//  	m1		:}gbNX
//  	m0		o:}gbNX
//  
//  	}gbNXm1̓]usm0ɗ^
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0TransposeMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1)
{
  int i,j;
  ps2Samp0FMATRIX t;
  for(i=0; i<4; i++){
    for(j=0; j<4; j++){
      t[i][j] = m1[j][i];
    }
  }
  ps2Samp0CopyMatrix(m0, t);
}

// ==========================================================================
// ps2Samp0InversMatrix	ts (4x4) ߂Bis͐Ɖ肷j
//  `
// 	void ps2Samp0InversMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1);
//  
//  	m1		:}gbNX(] & sړ)
//  	m0		o:}gbNX
//  
//  	}gbNXm1̋ts߂āA}gbNXm0ɗ^
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0InversMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1)
{
  int i,j;
  ps2Samp0FMATRIX m;
  for(i=0; i<4; i++){
    for(j=0; j<4; j++){
      m[i][j] = m1[j][i];
    }
  }
  m[0][3] = -(m1[0][3]*m[0][0] + m1[1][3]*m[0][1] + m1[2][3]*m[0][2]);
  m[1][3] = -(m1[0][3]*m[1][0] + m1[1][3]*m[1][1] + m1[2][3]*m[1][2]);
  m[2][3] = -(m1[0][3]*m[2][0] + m1[1][3]*m[2][1] + m1[2][3]*m[2][2]);
  m[3][0] = m[3][1] = m[3][2] = 0.0;
  m[3][3] = 1;
  ps2Samp0CopyMatrix(m0, m);
}

// ==========================================================================
// ps2Samp0AddVector	4Z (ADD/xyzw)
//  `
// 	void ps2Samp0AddVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, ps2Samp0FVECTOR v2)
//  
//  	v1,v2		:xNg
//  	v0		o:xNg
//  
//  	xNgv1̊evfƃxNgv2̊evfeXZB
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0AddVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, ps2Samp0FVECTOR v2)
{
  v0[0] = v1[0] + v2[0];
  v0[1] = v1[1] + v2[1];
  v0[2] = v1[2] + v2[2];
  v0[3] = v1[3] + v2[3];
}

// ==========================================================================
// ps2Samp0SubVector		4񌸎Z (SUB/xyzw)
//  `
// 	void ps2Samp0SubVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, ps2Samp0FVECTOR v2)
//  
//  	v1,v2		:xNg
//  	v0		o:xNg
//  
//  	xNgv1̊evfƃxNgv2̊evfeXZB
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0SubVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, ps2Samp0FVECTOR v2)
{
  v0[0] = v1[0] - v2[0];
  v0[1] = v1[1] - v2[1];
  v0[2] = v1[2] - v2[2];
  v0[3] = v1[3] - v2[3];
}

// ==========================================================================
// ps2Samp0MulVector	4ώZiMUL/xyzw: ςł͂ȂƂɒӁj
//  `
// 	void ps2Samp0MulVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, ps2Samp0FVECTOR v2)
//  
//  	v1,v2		:xNg
//  	v0		o:xNg
//  
//  	xNgv1̊evfƃxNgv2̊evfeXZB
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0MulVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, ps2Samp0FVECTOR v2)
{
  v0[0] = v1[0] * v2[0];
  v0[1] = v1[1] * v2[1];
  v0[2] = v1[2] * v2[2];
  v0[3] = v1[3] * v2[3];
}

// ==========================================================================
// ps2Samp0ScaleVector	XJ[lZ (MULx/xyzw)
//  `
// 	void ps2Samp0ScaleVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, float t)
//  
//  	v1		:xNg
//  	t		:XJ[
//  	v0		o:xNg
//  
//  	xNgv1ɃXJ[tZăxNgv0ɗ^
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0ScaleVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, float t)
{
  v0[0] = v1[0]*t;
  v0[1] = v1[1]*t;
  v0[2] = v1[2]*t;
  v0[3] = v1[3]*t;
}

// ==========================================================================
// ps2Samp0TransMatrix	s̕sړ
//  `
// 	void ps2Samp0TransMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, ps2Samp0FVECTOR tv);
//  
//  	tv		:ړxNg
//  	m1		:}gbNX
//  	m0		o:}gbNX
//  
//  	^ꂽxNgA}gbNX𕽍sړ
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0TransMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, ps2Samp0FVECTOR tv)
{
  int i,j;
  for(i=0; i<4; i++){
    for(j=0; j<4; j++){
      m0[i][j] = m1[i][j];
    }
  }
  m0[0][3] = m1[0][3] + tv[0];
  m0[1][3] = m1[1][3] + tv[1];
  m0[2][3] = m1[2][3] + tv[2];
  m0[3][3] = m1[3][3] + tv[3];
}

// ==========================================================================
// ps2Samp0CopyVector	  xNg̕ (lq  sq ̑gBalignment check p)
//  `
// 	void ps2Samp0CopyVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1);
//  
//  	v1		:xNg
//  	v0		o:xNg
//  
//  	xNgv1xNgv0ɃRs[B
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0CopyVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1)
{
  v0[0] = v1[0];
  v0[1] = v1[1];
  v0[2] = v1[2];
  v0[3] = v1[3];
}


// ==========================================================================
// ps2Samp0CopyMatrix	     s̕ (lq  sq ̑gBalignment check p)
//  `
// 	void ps2Samp0CopyMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1);
//  
//  	m1		:}gbNX
//  	m0		o:}gbNX
//  
//  	}gbNXm1}gbNXm0ɃRs[B
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0CopyMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1)
{
  int i,j;
  for(i=0; i<4; i++){
    for(j=0; j<4; j++){
      m0[i][j] = m1[i][j];
    }
  }
}

// ==========================================================================
// ps2Samp0FTOI0Vector 	FTOI0
//  `
// 	void ps2Samp0FTOI0Vector(ps2Samp0IVECTOR v0, ps2Samp0FVECTOR v1);
//  
//  	v1		:xNg
//  	v0		o:xNg
//  
//  	^ꂽxNg̗vf𐮐ɕϊ
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0FTOI0Vector(ps2Samp0IVECTOR v0, ps2Samp0FVECTOR v1)
{
  v0[0] = (int)v1[0];
  v0[1] = (int)v1[1];
  v0[2] = (int)v1[2];
  v0[3] = (int)v1[3];
}

// ==========================================================================
// ps2Samp0ITOF0Vector 	ITOF0
//  `
// 	void ps2Samp0ITOF0Vector(ps2Samp0FVECTOR v0, ps2Samp0IVECTOR v1);
//  
//  	v1		:xNg
//  	v0		o:xNg
//  
//  	^ꂽxNg̗vf𐮐ɕϊ
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0ITOF0Vector(ps2Samp0FVECTOR v0, ps2Samp0IVECTOR v1)
{
  v0[0] = (float)v1[0];
  v0[1] = (float)v1[1];
  v0[2] = (float)v1[2];
  v0[3] = (float)v1[3];

}

// ==========================================================================
// ps2Samp0UnitMatrix	Pʍs
//  `
// 	void ps2Samp0UnitMatrix(ps2Samp0FMATRIX m0);
//  
//  	m1		:}gbNX
//  	m0		o:}gbNX
//  
//  	^ꂽsPʍsɕϊ
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0UnitMatrix(ps2Samp0FMATRIX m0)
{
  int i,j;
  for(i=0; i<4; i++){
    for(j=0; j<4; j++){
      m0[i][j] = (i==j)? 1.0 : 0;
    }
  }
}

// ==========================================================================
// ps2Samp0RotMatrixZ	y𒆐SƂs̉]
//  `
// 	void ps2Samp0RotMatrixZ(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, float rz);
//  
//  	rz		:]p(L͈:- ` )
//  	m1		:}gbNX
//  	m0		o:}gbNX
//  
//  	]prtw𒆐SƂ]}gbNX߂āA
// 	}gbNXm1ɍZāǍʂ}gbNX
// 	m0ɗ^
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0RotMatrixZ(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, float rz)
{
  ps2Samp0FMATRIX rot;
  ps2Samp0UnitMatrix(rot);
  /*  rz = rz * (3.141592/180.0);*/
  rot[0][0] = cosf(rz); rot[0][1] = -sinf(rz);
  rot[1][0] = sinf(rz); rot[1][1] = cosf(rz);
  ps2Samp0MulMatrix(m0, rot, m1);
}

// ==========================================================================
// ps2Samp0RotMatrixX	w𒆐SƂs̉]
//  `
// 	void ps2Samp0RotMatrixX(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, float ry);
//  
//  	rx		:]p(L͈:- ` )
//  	m1		:}gbNX
//  	m0		o:}gbNX
//  
//  	]prtw𒆐SƂ]}gbNX߂āA
// 	}gbNXm1ɍZāǍʂ}gbNX
// 	m0ɗ^
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0RotMatrixX(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, float rx)
{
  ps2Samp0FMATRIX rot;
  ps2Samp0UnitMatrix(rot);
  /*  rx = rx * (3.141592/180.0);*/
  rot[1][1] = cosf(rx); rot[1][2] = -sinf(rx);
  rot[2][1] = sinf(rx); rot[2][2] = cosf(rx);
  ps2Samp0MulMatrix(m0, rot, m1);
}

// ==========================================================================
// ps2Samp0RotMatrixY	x𒆐SƂs̉]
//  `
// 	void ps2Samp0RotMatrixY(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, float ry);
//  
//  	ry		:]p(L͈:- ` )
//  	m1		:}gbNX
//  	m0		o:}gbNX
//  
//  	]prtx𒆐SƂ]}gbNX߂āA
// 	}gbNXm1ɍZāǍʂ}gbNX
// 	m0ɗ^
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0RotMatrixY(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, float ry)
{
  ps2Samp0FMATRIX rot;
  ps2Samp0UnitMatrix(rot);
  /*  ry = ry * (3.141592/180.0);*/
  rot[0][0] = cosf(ry); rot[2][0] = sinf(ry);
  rot[0][2] = -sinf(ry); rot[2][2] = cosf(ry);
  ps2Samp0MulMatrix(m0, rot, m1);
}

// ==========================================================================
// ps2Samp0RotMatrix	X,Y,Z𒆐SƂs̉]
//  `
// 	void ps2Samp0RotMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, ps2Samp0FVECTOR rot);
//  
//  	rot		:]pxNg(L͈:- ` )
//  	m1		:}gbNX
//  	m0		o:}gbNX
//  
//  	]pxNgrotX,Y,Zꂼ𒆐SƂ]}gbNX
//       ߁A}gbNXm1ɍZāǍʂ}gbNX
// 	m0ɗ^DZ ,Y, X ̏ɉ]D
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0RotMatrix(ps2Samp0FMATRIX m0, ps2Samp0FMATRIX m1, ps2Samp0FVECTOR rot)
{
  ps2Samp0RotMatrixZ(m0, m1, rot[2]);
  ps2Samp0RotMatrixY(m0, m0, rot[1]);
  ps2Samp0RotMatrixX(m0, m0, rot[0]);
}

// ==========================================================================
// ps2Samp0ClampVector	xNg̃Nv
//  `
// 	void ps2Samp0ClampVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, float min, float max)
//  
//  	v0		o:xNg
//  	v1		:xNg
//  	min		:(؎̂ĉ)
//  	max		:(؎̂ď)
//  
//  	xNgv1̊evf min maxƂăNv
//     v0ɗ^D
//  Ԃl
//  	Ȃ
// 
// --------------------------------------------------------------------------
void ps2Samp0ClampVector(ps2Samp0FVECTOR v0, ps2Samp0FVECTOR v1, float min, float max)
{
  ps2Samp0FVECTOR vect;
  /*
  v0[0] = v1[0]<min ? min : (v1[0]>max ? max : v1[0]);
  v0[1] = v1[1]<min ? min : (v1[1]>max ? max : v1[1]);
  v0[2] = v1[2]<min ? min : (v1[2]>max ? max : v1[2]);
//  v0[2] = v1[2]<min ? min : (v1[2]>max ? max : v1[2]);
  v0[3] = v1[3]<min ? min : (v1[3]>max ? max : v1[3]);
  */
  vect[0] = v1[0]<min ? min : (v1[0]>max ? max : v1[0]);
  vect[1] = v1[1]<min ? min : (v1[1]>max ? max : v1[1]);
  vect[2] = v1[2]<min ? min : (v1[2]>max ? max : v1[2]);
  vect[3] = v1[3]<min ? min : (v1[3]>max ? max : v1[3]);
  ps2Samp0CopyVector(v0,vect);
}


// ==========================================================================
// ps2Samp0CameraMatrix    [hWnɑ΂JWn`
// 
// 	p:  camera position (in the world)
// 	zd: eye direction
// 	yd: vertical direction
// 	xd = zd x yd:  wing direction
// 	yd = yd x xd:  real veritical direction
// 
// 	        | xd0 yd0 zd0 p0 |
// 	M = inv | xd1 yd1 zd1 p1 |
// 	        | xd2 yd2 zd2 p2 |
// 	        |   0   0   0  1 |
void ps2Samp0CameraMatrix(ps2Samp0FMATRIX m, ps2Samp0FVECTOR p, ps2Samp0FVECTOR zd, ps2Samp0FVECTOR yd)
{
	ps2Samp0FMATRIX	m0;
	ps2Samp0FVECTOR	xd;

	ps2Samp0UnitMatrix(m0);
	ps2Samp0OuterProduct(xd, yd, zd);
	ps2Samp0Normalize(m0[0], xd);
	ps2Samp0Normalize(m0[2], zd);
	ps2Samp0OuterProduct(m0[1], m0[2], m0[0]);
	ps2Samp0TransposeMatrix(m0, m0);
	ps2Samp0TransMatrix(m0, m0, p);
	ps2Samp0InversMatrix(m, m0);
}


// ==========================================================================
// ps2Samp0RotCameraMatrix    [hWnɑ΂JWn`(]L)
// 
// 	p:  original camera position (in the world)
// 	zd: original eye direction
// 	yd: original vertical direction
//     rot: rotation vector
// 	direction : real eye direction
// 	vertical  : real veritical direction
//     position  : real camera position
// 
void ps2Samp0RotCameraMatrix(ps2Samp0FMATRIX m, ps2Samp0FVECTOR p, ps2Samp0FVECTOR zd, ps2Samp0FVECTOR yd, ps2Samp0FVECTOR rot)
{
	ps2Samp0FMATRIX	work;
	ps2Samp0FVECTOR direction, vertical, position;

	ps2Samp0UnitMatrix(work);
	ps2Samp0RotMatrixX(work,work,rot[0]);
	ps2Samp0RotMatrixY(work,work,rot[1]);
	ps2Samp0RotMatrixZ(work,work,rot[2]);
	ps2Samp0ApplyMatrix(direction, work, zd);
	ps2Samp0ApplyMatrix(vertical, work, yd);
	ps2Samp0ApplyMatrix(position, work, p);
	ps2Samp0CameraMatrix(m, position, direction, vertical);

}

// ==========================================================================
// ps2Samp0NormalLightMatrix    s(R)xNgs𐶐
// 
//  make normal light matrix
// 	l0-l2:	light direction
// 	    | l0x l0y l0z 0 |
// 	M = | l1x l1y l1z 0 |
// 	    | l2x l1y l2z 0 |
// 	    |   0   0   0 1 |

void ps2Samp0NormalLightMatrix(ps2Samp0FMATRIX m, ps2Samp0FVECTOR l0, ps2Samp0FVECTOR l1, ps2Samp0FVECTOR l2)
{
        ps2Samp0FVECTOR  t;
        ps2Samp0ScaleVector(t, l0, -1); ps2Samp0Normalize(m[0], t);
        ps2Samp0ScaleVector(t, l1, -1); ps2Samp0Normalize(m[1], t);
        ps2Samp0ScaleVector(t, l2, -1); ps2Samp0Normalize(m[2], t);

	m[3][0] = m[3][1] = m[3][2] = 0;
	m[3][3] = 1.0;
}

// =========================================================================
// ps2Samp0LighrColorMatrix   s(R)̃J[s𐶐
// 
//  make normal light matrix
// 	c0-c2:	light color
// 	a:	ambient color
// 
// 	    | c0r c1r c2r ar |
// 	M = | c0g c1g c2g ag |
// 	    | c0b c1b c2b ab |
// 	    |   0   0   0  0 |
// 
void ps2Samp0LightColorMatrix(ps2Samp0FMATRIX m, ps2Samp0FVECTOR c0, ps2Samp0FVECTOR c1, ps2Samp0FVECTOR c2, ps2Samp0FVECTOR a)
{
	ps2Samp0CopyVector(m[0], c0);
	ps2Samp0CopyVector(m[1], c1);
	ps2Samp0CopyVector(m[2], c2);
	ps2Samp0CopyVector(m[3],  a);
	ps2Samp0TransposeMatrix(m, m);
}

// =========================================================================
//  ps2Samp0NormalColorVector     e_̃CeBO̐FvZ
// 
//       local_light:  light direction(matrix)
//       light_color:  light color(matrix)
//       v0:   vertex normal vector
//       c0:   vertex color
// 
//       vect = local_light * v0;   (inner product)
//       0.0 < vect < 1.0;          (clamp)
//       c0   = local_color * vect; (inner product)
// 
void ps2Samp0NormalColorVector(ps2Samp0IVECTOR c0,
		ps2Samp0FMATRIX local_light, ps2Samp0FMATRIX light_color,
			       ps2Samp0FVECTOR v0, ps2Samp0FVECTOR c1){
  ps2Samp0FVECTOR vect;
  ps2Samp0ApplyMatrix(vect, local_light, v0);
  ps2Samp0ClampVector(vect, vect, 0.0, 1.0);
  ps2Samp0ApplyMatrix(vect, light_color, vect);
  ps2Samp0MulVector(vect, c1, vect);
  ps2Samp0ClampVector(vect, vect, 0.0, 255.0);
  ps2Samp0FTOI0Vector(c0, vect);
}

// ========================================================================
// ps2Samp0ViewScreenMatrix      _WnXN[Wnւ̕ϊs
// 
// 	scrz:		distance to screen
// 	ax, ay:		aspect ratio
// 	cx, cy:		center
// 	zmin, zmax:	Z-buffer range
// 	nearz, farz:	near, far edge
// 
void ps2Samp0ViewScreenMatrix(ps2Samp0FMATRIX m, float scrz, float ax, float ay,
	       float cx, float cy, float zmin, float zmax, float nearz, float farz)
{
	float	az, cz;
	ps2Samp0FMATRIX	mt;

	cz = (-zmax * nearz + zmin * farz) / (-nearz + farz);
	az  = farz * nearz * (-zmin + zmax) / (-nearz + farz);
	
	//     | scrz    0  0 0 |
	// m = |    0 scrz  0 0 |
	//     |    0    0  0 1 |
	//     |    0    0  1 0 |
	ps2Samp0UnitMatrix(m);
	m[0][0] = scrz;
	m[1][1] = scrz;
	m[2][2] = 0;
	m[3][3] = 0;
	m[3][2] = 1.0;
	m[2][3] = 1.0;

	//     | ax  0  0 cx |
	// m = |  0 ay  0 cy |
	//     |  0  0 az cz |
	//     |  0  0  0  1 |
	ps2Samp0UnitMatrix(mt);
	mt[0][0] = ax;	mt[1][1] = ay;	mt[2][2] = az;
	mt[0][3] = cx;	mt[1][3] = cy;	mt[2][3] = cz;
	ps2Samp0MulMatrix(m, mt, m);
	return;
}


// ==========================================================================
// ps2Samp0RotTransPers	ϊ
//  `
// 	void ps2Samp0RotTransPers(ps2Samp0IVECTOR v0, ps2Samp0FMATRIX m0, ps2Samp0FVECTOR v1);
//  
//  	v0		o:xNg(XN[W)
//  	m0		:}gbNX
//  	v1		:xNg
//  	mode		:v0[2],v0[3]̒l̐؂ւ
//  			     0:32bitȂŒ菬_(28.4)
//  			     1:32bitȂŒ菬_(32.0)
//  
//  	^ꂽ_XN[WɓϊB
// 	ov0̒ĺAv0[0],v0[1]́A32bittŒ菬_(28.4)A
// 	v0[2],v0[3]mode=0̂Ƃ́A32bitȂŒ菬_(28.4)A
// 	mode=1̂Ƃ́A32bitȂŒ菬_(32.0)ԂB
// 	GIFPACKED[hXYZF2,XYZF3pꍇɂ́Amode=0ɂ
// 	ƁAPACKɐ؂ôŗLpłB
// 
//  Ԃl
//  	ϊ̃xNg̑Svf(Wl)̋t(1/W)ԂD
//       eNX`W STQQlɗp邽߁D
// 
// --------------------------------------------------------------------------
float ps2Samp0RotTransPers(ps2Samp0IVECTOR v0, ps2Samp0FMATRIX m0, ps2Samp0FVECTOR v1, int mode)
{

  float divw;
  ps2Samp0FVECTOR retv;

  ps2Samp0ApplyMatrix(retv, m0, v1);
  divw = 1.0 / retv[3];
  retv[0] = retv[0]*divw;
  retv[1] = retv[1]*divw;
  retv[2] = retv[2]*divw;
  /*    retv[3] = retv[3]*divw;   */
  if(mode==0){
    v0[0] = (int)(retv[0]*16.0);
    v0[1] = (int)(retv[1]*16.0);
    v0[2] = (int)(retv[2]*16.0);
    v0[3] = (int)(retv[3]*16.0);
  }else{
    v0[0] = (int)(retv[0]*16.0);
    v0[1] = (int)(retv[1]*16.0);
    v0[2] = (int)(retv[2]);
    v0[3] = (int)(retv[3]);
  }
  return divw;
}


// output vector contents
void ps2Samp0DumpVector(char *s, ps2Samp0FVECTOR v)
{
	printf(s);
	printf("\t[%8d,%8d,%8d,%8d]\n\r",
	       (int)v[0], (int)v[1], (int)v[2], (int)v[3]);
}

// output matrix contents
void ps2Samp0DumpMatrix(char *s, ps2Samp0FMATRIX m)
{
	puts(s);
	printf("\t[%8d,%8d,%8d,%8d]\n\r",
	       (int)(m[0][0]*10), (int)(m[0][1]*10),
	       (int)(m[0][2]*10), (int)(m[0][3]*10));
	printf("\t[%8d,%8d,%8d,%8d]\n\r",
	       (int)(m[1][0]*10), (int)(m[1][1]*10),
	       (int)(m[1][2]*10), (int)(m[1][3]*10));
	printf("\t[%8d,%8d,%8d,%8d]\n\r",
	       (int)(m[2][0]*10), (int)(m[2][1]*10),
	       (int)(m[2][2]*10), (int)(m[2][3]*10));
	printf("\t[%8d,%8d,%8d,%8d]\n\r",
	       (int)(m[3][0]*10), (int)(m[3][1]*10),
	       (int)(m[3][2]*10), (int)(m[3][3]*10));
}

