/*
 	Copyright (C) 2001  Sony Computer Entertainment Inc.
 
  This file is subject to the terms and conditions of the GNU Library
  General Public License Version 2. See the file "COPYING.LIB" in the 
  main directory of this archive for more details.
*/

// 
// "physics.c"
// 
// 
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <libvu0.h>
#include "physics.h"
#include "blow.h"
#include "gas.h"

extern u_int *My_part_src;

extern u_int *My_part_fire;
extern u_int *My_part1_fire;
extern u_int *My_part_second_pole_fire;
extern u_int *My_part_third_pole_fire;
extern u_int *My_shadow_part_fire;
extern u_int *My_shadow_part1_fire;
extern u_int *My_shadow_part_pole2_fire;
extern u_int *My_shadow_part_pole3_fire;

extern u_int *My_part_gas;
extern u_int *My_part1_gas;
extern u_int *My_part_second_pole_gas;
extern u_int *My_part_third_pole_gas;
extern u_int *My_shadow_part_gas;
extern u_int *My_shadow_part1_gas;
extern u_int *My_shadow_part_pole2_gas;
extern u_int *My_shadow_part_pole3_gas;

// ---- global variables for wind ----
float f_wpower;
float f_wtheta;

//----------------------------------------------------------------------
void SetParticlePositionGas(u_int frame)
{
	float *prev_pos1, *pos1;
	float *src_vel1, *src_vel2, *src_vel3;
	float *vel1, *vel2, *vel3;
	float *prev_pos2, *pos2, *prev_pos3, *pos3;
	
	float *spos1, *prev_spos1;
	float *prev_spos2, *spos2, *prev_spos3, *spos3;
	float *sscale1, *sscale2, *sscale3;
	
	u_int *rgba1, *rgba2, *rgba3;
	u_int *srgba1, *srgba2, *srgba3;
	float accl[3], r1, r2, cosine1, sine1;
	u_int i, j, offset, shadow_offset, part_id, i1;
	int n;
	int iframe;
	
	// ---- pointer for particle ----
	pos1 = (float *)My_part_gas;
	prev_pos1 = pos1;
	vel1  = pos1 + 4;
	rgba1 = (u_int *)(vel1 + 4);
	offset = My_part1_gas - My_part_gas;
	
	src_vel1 = (float *)My_part_src;
	src_vel2 = src_vel1 + 4;
	src_vel3 = src_vel1 + 8;
	
	// set pointer for 2nd, 3rd emitter.
	pos2 = (float *)My_part_second_pole_gas;
	prev_pos2 = pos2;
	vel2  = pos2 + 4;
	rgba2 = (u_int *)(vel2 + 4);
	
	pos3 = (float *)My_part_third_pole_gas;
	prev_pos3 = pos3;
	vel3  = pos3 + 4;
	rgba3 = (u_int *)(vel3 + 4);
	
	// ---- pointer for particle shadow ----
	shadow_offset = My_shadow_part1_gas - My_shadow_part_gas;
	spos1 = (float *)My_shadow_part_gas;
	prev_spos1 = spos1;
	sscale1 = spos1 + 4;
	srgba1 = (u_int *)(sscale1 + 4);
	
	spos2 = (float *)My_shadow_part_pole2_gas;
	prev_spos2 = spos2;
	sscale2 = spos2 + 4;
	srgba2 = (u_int *)(sscale2 + 4);
	
	spos3 = (float *)My_shadow_part_pole3_gas;
	prev_spos3 = spos3;
	sscale3 = spos3 + 4;
	srgba3 = (u_int *)(sscale3 + 4);
	
	if (frame == 0) {
		// --- init wind params ---
		f_wpower = 0.0001f;
		f_wtheta = 0.0f;
		
		for(j = 0; j < GAS_NUM_BLOCK; j++) {
			for(i = 0; i < GAS_NUM_PART; i++) {
				for(n = 0; n < GAS_NUM_EXPLODE ; n++) {	
					src_vel1[0] = 0.0f;
					src_vel1[1] = 0.0f;
					src_vel1[2] = 0.0f;
					src_vel2[0] = 0.0f;
					src_vel2[1] = 0.0f;
					src_vel2[2] = 0.0f;
					src_vel3[0] = 0.0f;
					src_vel3[1] = 0.0f;
					src_vel3[2] = 0.0f;
					
					spos1[0] = pos1[0] = -5.0f;
			 		spos1[1] = pos1[1] = 0.0f;
			 		spos1[2] = pos1[2] = 0.0f;
					
					spos2[0] = pos2[0] = 10.0f;
			 		spos2[1] = pos2[1] = 0.0f;
			 		spos2[2] = pos2[2] = 15.0f;
					
					spos3[0] = pos3[0] = 10.0f;
			 		spos3[1] = pos3[1] = 0.0f;
			 		spos3[2] = pos3[2] = -15.0f;
					
					vel1[0] = src_vel1[0] * GAS_BLUR_LENGTH;
			 		vel1[1] = src_vel1[1] * GAS_BLUR_LENGTH;
			 		vel1[2] = src_vel1[2] * GAS_BLUR_LENGTH;
					
					vel2[0] = src_vel2[0] * GAS_BLUR_LENGTH;
			 		vel2[1] = src_vel2[1] * GAS_BLUR_LENGTH;
			 		vel2[2] = src_vel2[2] * GAS_BLUR_LENGTH;
					
					vel3[0] = src_vel3[0] * GAS_BLUR_LENGTH;
			 		vel3[1] = src_vel3[1] * GAS_BLUR_LENGTH;
			 		vel3[2] = src_vel3[2] * GAS_BLUR_LENGTH;
					
					sscale1[0] = 2.0f;
					sscale2[0] = 2.0f;
					sscale3[0] = 2.0f;
					
					rgba1[0] = GAS_PARTICLE_INTENSITY;
					rgba1[1] = GAS_PARTICLE_INTENSITY;
					rgba1[2] = GAS_PARTICLE_INTENSITY;
					rgba1[3] = GAS_INIT_ALPHA;
					
					rgba2[0] = GAS_PARTICLE_INTENSITY;
					rgba2[1] = GAS_PARTICLE_INTENSITY;
					rgba2[2] = GAS_PARTICLE_INTENSITY;
					rgba2[3] = GAS_INIT_ALPHA;
					
					rgba3[0] = GAS_PARTICLE_INTENSITY;
					rgba3[1] = GAS_PARTICLE_INTENSITY;
					rgba3[2] = GAS_PARTICLE_INTENSITY;
					rgba3[3] = GAS_INIT_ALPHA;
					
					srgba1[0] = GAS_SHADOW_INTENSITY;
					srgba1[1] = GAS_SHADOW_INTENSITY;
					srgba1[2] = GAS_SHADOW_INTENSITY;
					srgba1[3] = GAS_INIT_ALPHA;
					
					srgba2[0] = GAS_SHADOW_INTENSITY;
					srgba2[1] = GAS_SHADOW_INTENSITY;
					srgba2[2] = GAS_SHADOW_INTENSITY;
					srgba2[3] = GAS_INIT_ALPHA;
					
					srgba3[0] = GAS_SHADOW_INTENSITY;
					srgba3[1] = GAS_SHADOW_INTENSITY;
					srgba3[2] = GAS_SHADOW_INTENSITY;
					srgba3[3] = GAS_INIT_ALPHA;
					
					pos1 += 12;
					pos2 += 12;
					pos3 += 12;
					
					spos1 += 12;
					spos2 += 12;
					spos3 += 12;
					
					sscale1 += 12;
					sscale2 += 12;
					sscale3 += 12;
					
					vel1 += 12;
					vel2 += 12;
					vel3 += 12;
					
					rgba1 += 12;
					rgba2 += 12;
					rgba3 += 12;
					
					srgba1 += 12;
					srgba2 += 12;
					srgba3 += 12;
					
					src_vel1  += 12;
					src_vel2 += 12;
					src_vel3  += 12;
				}
			}
			
			pos1  = prev_pos1 + offset;
			vel1  = pos1 + 4;
			rgba1 = (u_int *)(vel1 + 4);
			prev_pos1 = pos1;
			
			pos2 = prev_pos2 + offset;
			vel2 = pos2 + 4;
			rgba2 = (u_int *)(vel2 + 4);
			prev_pos2 = pos2;
			
			pos3 = prev_pos3 + offset;
			vel3 = pos3 + 4;
			rgba3 = (u_int *)(vel3 + 4);
			prev_pos3 = pos3;
			
			spos1 = prev_spos1 + shadow_offset;
			sscale1 = spos1 + 4;
			srgba1 = (u_int *)(sscale1 + 4);
			prev_spos1 = spos1;
			
			spos2 = prev_spos2 + shadow_offset;
			sscale2 = spos2 + 4;
			srgba2 = (u_int *)(sscale2 + 4);
			prev_spos2 = spos2;
			
			spos3 = prev_spos3 + shadow_offset;
			sscale3 = spos3 + 4;
			srgba3 = (u_int *)(sscale3 + 4);
			prev_spos3 = spos3;
		}
		
		return;
	} // if (frame == 0)
	
	iframe = frame % 180;
	r1 = (float)M_PI * (180.0f + 120.0f * sinf((float)iframe *  2.0f * (float)M_PI / 180.0f)) / 180.0f;
	f_wpower = 0.0005f;
	cosine1 = f_wpower * cosf(r1);
	sine1 = f_wpower * sinf(r1);
        
	
	// ===== PARTICLE SETTING ======
	for(j = 0; j < GAS_NUM_BLOCK; j++) {
		for(i = 0; i < GAS_NUM_PART; i++) {
			
			// start to emit or not.
			part_id = j * GAS_NUM_PART + i;
			if (part_id > frame * GAS_PART_BY_FRAME) {
				return;
			}
		
			// --- calc particle position --- 
			// write blur partice shadow
			for(n = 0; n < GAS_NUM_EXPLODE; n++) {
				
				// --- set position of each blur particle ---
				r2 = (float)rand() / (float)RAND_MAX * 0.005f;
				r1 = ((float)rand() / (float)RAND_MAX - 0.5f);
				accl[0] = r1 * r2;
				
				r1 = ((float)rand() / (float)RAND_MAX);
				accl[1] = r1 * 0.001f;
				
				r2 = (float)rand() / (float)RAND_MAX * 0.005f + 0.001f;
				r1 = ((float)rand() / (float)RAND_MAX - 0.5f);
				accl[2] = r1 * r2;
				if (pos1[1] > 2.0f) {
					accl[0] += cosine1;
					accl[2] += sine1;
				}
				
				src_vel1[0] += accl[0];
				src_vel1[1] += accl[1];
				src_vel1[2] += accl[2];
				
				pos1[0] += src_vel1[0];
				pos1[1] += src_vel1[1];
				pos1[2] += src_vel1[2];
				spos1[0] = pos1[0];
				spos1[2] = pos1[2];
				
				// ============================ for 2nd pole ========================
				r2 = (float)rand() / (float)RAND_MAX * 0.005f;
				r1 = ((float)rand() / (float)RAND_MAX - 0.5f);
				accl[0] = r1 * r2;
				r1 = ((float)rand() / (float)RAND_MAX);
				accl[1] = r1 * 0.001f;
				r2 = (float)rand() / (float)RAND_MAX * 0.005f + 0.001f;
				r1 = ((float)rand() / (float)RAND_MAX - 0.5f);
				accl[2] = r1 * r2;
				
				if (pos2[1] > 2.0f) {
					accl[0] += cosine1;
					accl[2] += sine1;
				}
				
				src_vel2[0] += accl[0];
				src_vel2[1] += accl[1];
				src_vel2[2] += accl[2];
				
				pos2[0] += src_vel2[0];
				pos2[1] += src_vel2[1];
				pos2[2] += src_vel2[2];
				spos2[0] = pos2[0];
				spos2[2] = pos2[2];
				
				// --- for 3rd pole ---
				// ============================ for 2nd pole ========================
				r2 = (float)rand() / (float)RAND_MAX * 0.005f;
				r1 = ((float)rand() / (float)RAND_MAX - 0.5f);
				accl[0] = r1 * r2;
				r1 = ((float)rand() / (float)RAND_MAX);
				accl[1] = r1 * 0.001f;
				r2 = (float)rand() / (float)RAND_MAX * 0.005f + 0.001f;
				r1 = ((float)rand() / (float)RAND_MAX - 0.5f);
				accl[2] = r1 * r2;
				
				if (pos3[1] > 2.0f) {
					accl[0] += cosine1;
					accl[2] += sine1;
				}
				
				src_vel3[0] += accl[0];
				src_vel3[1] += accl[1];
				src_vel3[2] += accl[2];
				
				pos3[0] += src_vel3[0];
				pos3[1] += src_vel3[1];
				pos3[2] += src_vel3[2];
				
				spos3[0] = pos3[0];
				spos3[2] = pos3[2];
				
				// --- velocity ---
				vel1[0] = src_vel1[0] * GAS_BLUR_LENGTH;
				vel2[0] = src_vel2[0] * GAS_BLUR_LENGTH;
				vel3[0] = src_vel3[0] * GAS_BLUR_LENGTH;
				vel1[1] = src_vel1[1] * GAS_BLUR_LENGTH;
				vel2[1] = src_vel2[1] * GAS_BLUR_LENGTH;
				vel3[1] = src_vel3[1] * GAS_BLUR_LENGTH;
				vel1[2] = src_vel1[2] * GAS_BLUR_LENGTH;
				vel2[2] = src_vel2[2] * GAS_BLUR_LENGTH;
				vel3[2] = src_vel3[2] * GAS_BLUR_LENGTH;
					
				// --- set scale of shadow ---
				sscale1[0] = 7.0f;
				sscale2[0] = 7.0f;
				sscale3[0] = 7.0f;
				
				// --- alpha decay ---
				i1 = frame % GAS_ALPHA_DEC_FRAME;
				if (i1 == 0 && rgba1[3] != 0) {
				    rgba1[3]--;
				    rgba2[3]--;
					rgba3[3]--;
				}
				
				if (i1 == 0 && srgba1[3] != 0) {
				    srgba1[3]--;
				    srgba2[3]--;
					srgba3[3]--;
				}
				
				// =========== CLIP FOR NO.1 ============
				if (pos1[0] > 40.0f  || pos1[0] < -40.0f ||
				   pos1[1] > 40.0f ||
				   pos1[2] > 40.0f  || pos1[2] < -40.0f ) {
					spos1[0] = pos1[0] = -5.0f;
					spos1[1] = pos1[1] = 0.0f;
					spos1[2] = pos1[2] = 0.0f;
					src_vel1[0] = 0.0f;
					src_vel1[1] = 0.0f;
					src_vel1[2] = 0.0f;
					rgba1[3] = srgba1[3] = GAS_INIT_ALPHA;
				}
				
				// =========== CLIP FOR NO.2 ============
				if (pos2[0] > 40.0f  || pos2[0] < -40.0f ||
				   pos2[1] > 40.0f ||
				   pos2[2] > 40.0f  || pos2[2] < -40.0f ) {
					spos2[0] = pos2[0] = 10.0f;
					spos2[1] = pos2[1] = 0.0f;
					spos2[2] = pos2[2] = 15.0f;
					src_vel2[0] = 0.0f;
					src_vel2[1] = 0.0f;
					src_vel2[2] = 0.0f;
					rgba2[3] = srgba2[3] = GAS_INIT_ALPHA;
				}
				
				// =========== CLIP FOR NO.3 ============
				// for x clip
				if (pos3[0] > 40.0f  || pos3[0] < -40.0f ||
				   pos3[1] > 40.0f ||
				   pos3[2] > 40.0f  || pos3[2] < -40.0f ) {
					spos3[0] = pos3[0] = 10.0f;
					spos3[1] = pos3[1] = 0.0f;
					spos3[2] = pos3[2] = -15.0f;
					src_vel3[0] = 0.0f;
					src_vel3[1] = 0.0f;
					src_vel3[2] = 0.0f;
					rgba3[3] = srgba3[3] = GAS_INIT_ALPHA;
				}
				
				src_vel1 += 12;
				src_vel2 += 12;
				src_vel3 += 12;
				pos1 += 12;
				pos2 += 12;
				pos3 += 12;
				vel1 += 12;
				vel2 += 12;
				vel3 += 12;
				rgba1 += 12;
				rgba2 += 12;
				rgba3 += 12;
				
				spos1 += 12;
				spos2 += 12;
				spos3 += 12;
				sscale1 += 12;
				sscale2 += 12;
				sscale3 += 12;
				srgba1 += 12;
				srgba2 += 12;
				srgba3 += 12;
			}
		}
	
		pos1 = prev_pos1 + offset;
		vel1 = pos1 + 4;
		rgba1 = (u_int *)(vel1 + 4);
		prev_pos1 = pos1;
		
		pos2 = prev_pos2 + offset;
		vel2 = pos2 + 4;
		rgba2 = (u_int *)(vel2 + 4);
		prev_pos2 = pos2;
		
		pos3 = prev_pos3 + offset;
		vel3 = pos3 + 4;
		rgba3 = (u_int *)(vel3 + 4);
		prev_pos3 = pos3;
		
		// --- particle shadow ---
		spos1 = prev_spos1 + shadow_offset;
		sscale1 = spos1 + 4;
		srgba1 = (u_int *)(sscale1 + 4);
		prev_spos1 = spos1;
		
		spos2 = prev_spos2 + shadow_offset;
		sscale2 = spos2 + 4;
		srgba2 = (u_int *)(sscale2 + 4);
		prev_spos2 = spos2;
		
		spos3 = prev_spos3 + shadow_offset;
		sscale3 = spos3 + 4;
		srgba3 = (u_int *)(sscale3 + 4);
		prev_spos3 = spos3;
	}
}

//----------------------------------------------------------------------
void SetParticlePositionFire(u_int frame)
{
	float *prev_pos1, *pos1, *src_vel, *src_vel2, *src_vel_ori;
	float *vel1, *vel2, *vel3;
	float *prev_pos2, *pos2, *prev_pos3, *pos3;
	
	float *spos1, *prev_spos1;
	float *prev_spos2, *spos2, *prev_spos3, *spos3;
	float *sscale1, *sscale2, *sscale3;
	
	u_int *rgba1, *rgba2, *rgba3;
	u_int *srgba1, *srgba2, *srgba3;
	float accl[3], r, r1, r2, v1;
	u_int i, j, offset, shadow_offset, part_id, index;
	int n;
	
	// ---- pointer for particle ----
	pos1 = (float *)My_part_fire;
	prev_pos1 = pos1;
	vel1  = pos1 + 4;
	rgba1 = (u_int *)(vel1 + 4);
	offset = My_part1_fire - My_part_fire;
	
	src_vel = (float *)My_part_src;
	src_vel2 = src_vel + 4;
	src_vel_ori = src_vel + 8;
	
	// set pointer for 2nd, 3rd emitter.
	pos2 = (float *)My_part_second_pole_fire;
	prev_pos2 = pos2;
	vel2  = pos2 + 4;
	rgba2 = (u_int *)(vel2 + 4);
	
	pos3 = (float *)My_part_third_pole_fire;
	prev_pos3 = pos3;
	vel3  = pos3 + 4;
	rgba3 = (u_int *)(vel3 + 4);
	
	// ---- pointer for particle shadow ----
	shadow_offset = My_shadow_part1_fire - My_shadow_part_fire;
	spos1 = (float *)My_shadow_part_fire;
	prev_spos1 = spos1;
	sscale1 = spos1 + 4;
	srgba1 = (u_int *)(sscale1 + 4);
	
	spos2 = (float *)My_shadow_part_pole2_fire;
	prev_spos2 = spos2;
	sscale2 = spos2 + 4;
	srgba2 = (u_int *)(sscale2 + 4);
	
	spos3 = (float *)My_shadow_part_pole3_fire;
	prev_spos3 = spos3;
	sscale3 = spos3 + 4;
	srgba3 = (u_int *)(sscale3 + 4);
	
	if (frame == 0) {
		for (i = 0; i < FIRE_NUM_BLOCK * FIRE_NUM_PART * FIRE_NUM_EXPLODE; i++) {
			fire_bound[i] = 0;
		}
	}
	
	// -- set accl --
	accl[1] = FIRE_GRAVITY;
	
	if (frame == 0) {
		for(j = 0; j < FIRE_NUM_BLOCK; j++) {
			
			for(i = 0; i < FIRE_NUM_PART; i++) {
				
				r = (float)rand() / 0x7fffffff * 2.0f * (float)M_PI;
				r1 = (float)rand() / 0x7fffffff;
				
				for(n = 0; n < FIRE_NUM_EXPLODE ; n++) {	
					// set default velocity
					v1 = (float)rand() / 0x7fffffff;
					src_vel[0] = 0.25f * r1 * cosf(r);
					src_vel[1] = FIRE_LAUNCH_VELOCITY - v1 * 0.3f;
					src_vel[2] = 0.25f * r1 * sinf(r);
					
					src_vel_ori[0] = 0.25f * r1 * cosf(r);
					src_vel_ori[1] = FIRE_LAUNCH_VELOCITY;
					src_vel_ori[2] = 0.25f * r1 * sinf(r);
					r2 = r + FIRE_SPREAD_ANGLE * (float)M_PI * ((float)rand() / 0x7fffffff - 0.5f);
					src_vel2[0] = FIRE_SPREAD_SPEED * cosf(r2);
					src_vel2[1] = FIRE_LAUNCH_VELOCITY;
					src_vel2[2] = FIRE_SPREAD_SPEED * sinf(r2);
					
					spos1[0] = pos1[0] = -5.0f;
			 		spos1[1] = pos1[1] = 0.0f;
			 		spos1[2] = pos1[2] = 0.0f;
					
					spos2[0] = pos2[0] = 10.0f;
			 		spos2[1] = pos2[1] = 0.0f;
			 		spos2[2] = pos2[2] = 15.0f;
					
					spos3[0] = pos3[0] = 10.0f;
			 		spos3[1] = pos3[1] = 0.0f;
			 		spos3[2] = pos3[2] = -15.0f;
					
					vel1[0] = src_vel[0] * FIRE_BLUR_LENGTH;
			 		vel1[1] = src_vel[1] * FIRE_BLUR_LENGTH;
			 		vel1[2] = src_vel[2] * FIRE_BLUR_LENGTH;
					
					vel2[0] = src_vel[0] * FIRE_BLUR_LENGTH;
			 		vel2[1] = src_vel[1] * FIRE_BLUR_LENGTH;
			 		vel2[2] = src_vel[2] * FIRE_BLUR_LENGTH;
					
					vel3[0] = src_vel[0] * FIRE_BLUR_LENGTH;
			 		vel3[1] = src_vel[1] * FIRE_BLUR_LENGTH;
			 		vel3[2] = src_vel[2] * FIRE_BLUR_LENGTH;
					
					sscale1[0] = 2.0f;
					sscale2[0] = 2.0f;
					sscale3[0] = 2.0f;
					
					rgba1[0] = FIRE_PARTICLE_INTENSITY;
					rgba1[1] = FIRE_PARTICLE_INTENSITY;
					rgba1[2] = FIRE_PARTICLE_INTENSITY;
					rgba1[3] = FIRE_INIT_ALPHA;
					
					rgba2[0] = FIRE_PARTICLE_INTENSITY;
					rgba2[1] = FIRE_PARTICLE_INTENSITY;
					rgba2[2] = FIRE_PARTICLE_INTENSITY;
					rgba2[3] = FIRE_INIT_ALPHA;
					
					rgba3[0] = FIRE_PARTICLE_INTENSITY;
					rgba3[1] = FIRE_PARTICLE_INTENSITY;
					rgba3[2] = FIRE_PARTICLE_INTENSITY;
					rgba3[3] = FIRE_INIT_ALPHA;
					
					srgba1[0] = FIRE_SHADOW_INTENSITY;
					srgba1[1] = FIRE_SHADOW_INTENSITY;
					srgba1[2] = FIRE_SHADOW_INTENSITY;
					srgba1[3] = FIRE_INIT_ALPHA;
					
					srgba2[0] = FIRE_SHADOW_INTENSITY;
					srgba2[1] = FIRE_SHADOW_INTENSITY;
					srgba2[2] = FIRE_SHADOW_INTENSITY;
					srgba2[3] = FIRE_INIT_ALPHA;
					
					srgba3[0] = FIRE_SHADOW_INTENSITY;
					srgba3[1] = FIRE_SHADOW_INTENSITY;
					srgba3[2] = FIRE_SHADOW_INTENSITY;
					srgba3[3] = FIRE_INIT_ALPHA;
					
					pos1 += 12;
					pos2 += 12;
					pos3 += 12;
					
					spos1 += 12;
					spos2 += 12;
					spos3 += 12;
					
					sscale1 += 12;
					sscale2 += 12;
					sscale3 += 12;
					
					vel1 += 12;
					vel2 += 12;
					vel3 += 12;
					
					rgba1 += 12;
					rgba2 += 12;
					rgba3 += 12;
					
					srgba1 += 12;
					srgba2 += 12;
					srgba3 += 12;
					
					src_vel  += 12;
					src_vel2 += 12;
					src_vel_ori  += 12;
				}
			}
			
			pos1  = prev_pos1 + offset;
			vel1  = pos1 + 4;
			rgba1 = (u_int *)(vel1 + 4);
			prev_pos1 = pos1;
			
			pos2 = prev_pos2 + offset;
			vel2 = pos2 + 4;
			rgba2 = (u_int *)(vel2 + 4);
			prev_pos2 = pos2;
			
			pos3 = prev_pos3 + offset;
			vel3 = pos3 + 4;
			rgba3 = (u_int *)(vel3 + 4);
			prev_pos3 = pos3;
			
			spos1 = prev_spos1 + shadow_offset;
			sscale1 = spos1 + 4;
			srgba1 = (u_int *)(sscale1 + 4);
			prev_spos1 = spos1;
			
			spos2 = prev_spos2 + shadow_offset;
			sscale2 = spos2 + 4;
			srgba2 = (u_int *)(sscale2 + 4);
			prev_spos2 = spos2;
			
			spos3 = prev_spos3 + shadow_offset;
			sscale3 = spos3 + 4;
			srgba3 = (u_int *)(sscale3 + 4);
			prev_spos3 = spos3;
			
		}
		return;
	}
	
	// ===== PARTICLE SETTING ======
	for(j = 0; j < FIRE_NUM_BLOCK; j++) {
		for(i = 0; i < FIRE_NUM_PART; i++) {
			
			// start to emit or not.
			part_id = j * FIRE_NUM_PART + i;
			if (part_id > frame * FIRE_PART_BY_FRAME) {
				return;
			}
		
			// --- calc particle position --- 
			// write blur partice shadow
			for(n = 0; n < FIRE_NUM_EXPLODE; n++) {
				
				// --- set position of each blur particle ---
				src_vel[1] += accl[1];
				
				pos1[0] += src_vel[0];
				pos1[1] += src_vel[1];
				pos1[2] += src_vel[2];
				spos1[0] = pos1[0];
				spos1[2] = pos1[2];
				
				// --- for 2nd pole ---
				pos2[0] = pos1[0] + 15.0f;
				pos2[1] = pos1[1];
				pos2[2] = pos1[2] + 15.0f;
				spos2[0] = pos2[0];
				spos2[2] = pos2[2];
				
				// --- for 3rd pole ---
				pos3[0] = pos1[0] + 15.0f;
				pos3[1] = pos1[1];
				pos3[2] = pos1[2] - 15.0f;
				spos3[0] = pos3[0];
				spos3[2] = pos3[2];
				
				// --- velocity ---
				vel1[1] = src_vel[1] * FIRE_BLUR_LENGTH;
				vel2[1] = src_vel[1] * FIRE_BLUR_LENGTH;
				vel3[1] = src_vel[1] * FIRE_BLUR_LENGTH;
					
				// --- set scale of shadow ---
				sscale1[0] = 6.0f - pos1[1];
				if (sscale1[0] < 0.0f) sscale1[0] = 0.0f;
				sscale2[0] = 6.0f - pos2[1];
				if (sscale2[0] < 0.0f) sscale2[0] = 0.0f;
				sscale3[0] = 6.0f - pos3[1];
				if (sscale3[0] < 0.0f) sscale3[0] = 0.0f;
				

				// for x clip
				if (pos1[0] > 40.0f || pos1[0] < -40.0f) {
					pos1[0] = -5.0f;
					pos1[1] = 0.0f;
					pos1[2] = 0.0f;
				}
				
				// for y clip
				if (pos1[1] > 100.0f || pos1[1] < 0.0f) {
					index = j * FIRE_NUM_PART * FIRE_NUM_EXPLODE + i * FIRE_NUM_EXPLODE + n;
					if (fire_bound[index] == 0) {
						fire_bound[index] = 1;
						src_vel[0] = src_vel2[0];
						src_vel[2] = src_vel2[2];
						
						src_vel[1] = - FIRE_BOUNCE_COEFF * src_vel[1];
						pos1[1] = 0.0f;
					} else {
						fire_bound[index] = 0;
						pos1[0] = -5.0f;
						pos1[1] = 0.0f;
						pos1[2] = 0.0f;
						src_vel[0] = src_vel_ori[0];
						src_vel[1] = src_vel_ori[1];
						src_vel[2] = src_vel_ori[2];
					}
				}
				
				// for z clip
				if (pos1[2] > 40.0f || pos1[2] < -40.0f) {
					pos1[0] = -5.0f;
					pos1[1] = 0.0f;
					pos1[2] = 0.0f;
				}
				
				src_vel  += 12;
				src_vel2 += 12;
				src_vel_ori += 12;
				pos1 += 12;
				pos2 += 12;
				pos3 += 12;
				vel1 += 12;
				vel2 += 12;
				vel3 += 12;
				rgba1 += 12;
				rgba2 += 12;
				rgba3 += 12;
				
				spos1 += 12;
				spos2 += 12;
				spos3 += 12;
				sscale1 += 12;
				sscale2 += 12;
				sscale3 += 12;
				srgba1 += 12;
				srgba2 += 12;
				srgba3 += 12;
			}
		}
		
		pos1 = prev_pos1 + offset;
		vel1 = pos1 + 4;
		rgba1 = (u_int *)(vel1 + 4);
		prev_pos1 = pos1;
		
		pos2 = prev_pos2 + offset;
		vel2 = pos2 + 4;
		rgba2 = (u_int *)(vel2 + 4);
		prev_pos2 = pos2;
		
		pos3 = prev_pos3 + offset;
		vel3 = pos3 + 4;
		rgba3 = (u_int *)(vel3 + 4);
		prev_pos3 = pos3;
		
		// --- particle shadow ---
		spos1 = prev_spos1 + shadow_offset;
		sscale1 = spos1 + 4;
		srgba1 = (u_int *)(sscale1 + 4);
		prev_spos1 = spos1;
		
		spos2 = prev_spos2 + shadow_offset;
		sscale2 = spos2 + 4;
		srgba2 = (u_int *)(sscale2 + 4);
		prev_spos2 = spos2;
		
		spos3 = prev_spos3 + shadow_offset;
		sscale3 = spos3 + 4;
		srgba3 = (u_int *)(sscale3 + 4);
		prev_spos3 = spos3;
	}
}
