/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class DeclineMoundsMessage
extends AttributeMessage {
    public static final String TAG = "declineMounds";
    private static final String DIRECTION_TAG = "direction";
    private static final String UNIT_TAG = "unit";

    public DeclineMoundsMessage(Unit unit, Direction direction) {
        super(TAG, UNIT_TAG, unit.getId(), DIRECTION_TAG, String.valueOf(direction));
    }

    public DeclineMoundsMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, DIRECTION_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Tile tile;
        Unit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        String directionString = this.getStringAttribute(DIRECTION_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        try {
            tile = unit.getNeighbourTile(directionString);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        LostCityRumour rumour = tile.getLostCityRumour();
        if (rumour == null || rumour.getType() != LostCityRumour.RumourType.MOUNDS) {
            return serverPlayer.clientError("No mounds rumour on tile: " + tile.getId());
        }
        return this.igc(freeColServer).declineMounds(serverPlayer, tile);
    }
}

