"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class SnapshotManagementService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getAllSnapshotsWithPolicy", async (context, request, response) => {
      try {
        var _getRepositoryRes$pay;
        // if no repository input, we need to first get back all repositories
        const getRepositoryRes = await this.catRepositories(context, request, response);
        let repositories;
        if ((_getRepositoryRes$pay = getRepositoryRes.payload) !== null && _getRepositoryRes$pay !== void 0 && _getRepositoryRes$pay.ok) {
          var _getRepositoryRes$pay2;
          repositories = (_getRepositoryRes$pay2 = getRepositoryRes.payload) === null || _getRepositoryRes$pay2 === void 0 ? void 0 : _getRepositoryRes$pay2.response.map(repo => repo.id);
        } else {
          var _getRepositoryRes$pay3;
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: (_getRepositoryRes$pay3 = getRepositoryRes.payload) === null || _getRepositoryRes$pay3 === void 0 ? void 0 : _getRepositoryRes$pay3.error
            }
          });
        }
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        let snapshots = [];
        for (let i = 0; i < repositories.length; i++) {
          const res = await callWithRequest("snapshot.get", {
            repository: repositories[i],
            snapshot: "_all",
            ignore_unavailable: true
          });
          const snapshotWithPolicy = res.snapshots.map(s => {
            var _s$metadata;
            return {
              id: s.snapshot,
              status: s.state,
              start_epoch: s.start_time_in_millis,
              end_epoch: s.end_time_in_millis,
              duration: s.duration_in_millis,
              indices: s.indices.length,
              successful_shards: s.shards.successful,
              failed_shards: s.shards.failed,
              total_shards: s.shards.total,
              repository: repositories[i],
              policy: (_s$metadata = s.metadata) === null || _s$metadata === void 0 ? void 0 : _s$metadata.sm_policy
            };
          });
          snapshots = [...snapshots, ...snapshotWithPolicy];
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              snapshots: snapshots,
              totalSnapshots: snapshots.length
            }
          }
        });
      } catch (err) {
        // If getting a non-existing snapshot, need to handle the missing snapshot exception, and return empty
        return this.errorResponse(response, err, "getAllSnapshotsWithPolicy");
      }
    });
    _defineProperty(this, "getSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.get", {
          repository: repository,
          snapshot: `${id}`,
          ignore_unavailable: true
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res.snapshots[0]
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "getSnapshot");
      }
    });
    _defineProperty(this, "deleteSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("snapshot.delete", {
          repository: repository,
          snapshot: `${id}`
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: resp
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "deleteSnapshot");
      }
    });
    _defineProperty(this, "createSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const params = {
          repository: repository,
          snapshot: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("snapshot.create", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: resp
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "createSnapshot");
      }
    });
    _defineProperty(this, "restoreSnapshot", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          repository
        } = request.query;
        const params = {
          repository: repository,
          snapshot: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("snapshot.restore", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: resp
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "restoreSnapshot");
      }
    });
    _defineProperty(this, "createPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          policyId: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const rawRes = await callWithRequest("ism.createSMPolicy", params);
        const res = {
          seqNo: rawRes._seq_no,
          primaryTerm: rawRes._primary_term,
          id: rawRes._id,
          policy: rawRes.sm_policy
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "createPolicy");
      }
    });
    _defineProperty(this, "updatePolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          seqNo,
          primaryTerm
        } = request.query;
        const params = {
          policyId: id,
          ifSeqNo: seqNo,
          ifPrimaryTerm: primaryTerm,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const rawRes = await callWithRequest("ism.updateSMPolicy", params);
        const res = {
          seqNo: rawRes._seq_no,
          primaryTerm: rawRes._primary_term,
          id: rawRes._id,
          policy: rawRes.sm_policy
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "updatePolicy");
      }
    });
    _defineProperty(this, "getPolicies", async (context, request, response) => {
      try {
        const {
          from,
          size,
          sortField,
          sortOrder,
          queryString
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        let params = {
          from,
          size,
          sortField: `sm_policy.${sortField}`,
          sortOrder,
          queryString: queryString.trim() ? `${queryString.trim()}` : "*"
        };
        const res = await callWithRequest("ism.getSMPolicies", params);
        const policies = res.policies.map(p => ({
          seqNo: p._seq_no,
          primaryTerm: p._primary_term,
          id: p._id,
          policy: p.sm_policy
        }));
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              policies,
              totalPolicies: res.total_policies
            }
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.reason === "Snapshot management config index not found") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                policies: [],
                totalPolicies: 0
              }
            }
          });
        }
        return this.errorResponse(response, err, "getPolicies");
      }
    });
    _defineProperty(this, "getPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getSMPolicy", params);
        const metadata = await callWithRequest("ism.explainSnapshotPolicy", params);
        const documentPolicy = {
          id: id,
          seqNo: getResponse._seq_no,
          primaryTerm: getResponse._primary_term,
          policy: getResponse.sm_policy,
          metadata: metadata.policies[0]
        };
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: documentPolicy
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.reason === "Snapshot management config index not found") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: null
            }
          });
        }
        return this.errorResponse(response, err, "getPolicy");
      }
    });
    _defineProperty(this, "deletePolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          policyId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const deletePolicyResponse = await callWithRequest("ism.deleteSMPolicy", params);
        if (deletePolicyResponse.result !== "deleted") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: deletePolicyResponse.result
            }
          });
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: true
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "deletePolicy");
      }
    });
    _defineProperty(this, "startPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("ism.startSnapshotPolicy", params);
        if (resp.acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to start snapshot policy."
            }
          });
        }
      } catch (err) {
        return this.errorResponse(response, err, "startPolicy");
      }
    });
    _defineProperty(this, "stopPolicy", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const resp = await callWithRequest("ism.stopSnapshotPolicy", params);
        if (resp.acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to stop snapshot policy."
            }
          });
        }
      } catch (err) {
        return this.errorResponse(response, err, "stopPolicy");
      }
    });
    _defineProperty(this, "catRepositories", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("cat.repositories", {
          format: "json"
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "catRepositories");
      }
    });
    _defineProperty(this, "getIndexRecovery", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("indices.recovery", {
          format: "json"
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "getIndexRecovery");
      }
    });
    _defineProperty(this, "catSnapshotIndices", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("cat.indices", {
          format: "json"
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "catSnapshotIndices");
      }
    });
    _defineProperty(this, "catRepositoriesWithSnapshotCount", async (context, request, response) => {
      try {
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("cat.repositories", {
          format: "json"
        });
        for (let i = 0; i < res.length; i++) {
          let catSnapshotResponse = await this._safecatSnapshotForRepo(callWithRequest, res[i].id);
          res[i].snapshotCount = catSnapshotResponse === null || catSnapshotResponse === void 0 ? void 0 : catSnapshotResponse.length;
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "catRepositoriesWithSnapshotCount");
      }
    });
    _defineProperty(this, "deleteRepository", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.deleteRepository", {
          repository: id
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "deleteRepository");
      }
    });
    _defineProperty(this, "getRepository", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.getRepository", {
          repository: id
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "getRepository");
      }
    });
    _defineProperty(this, "createRepository", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          repository: id,
          body: JSON.stringify(request.body)
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const res = await callWithRequest("snapshot.createRepository", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: res
          }
        });
      } catch (err) {
        return this.errorResponse(response, err, "createRepository");
      }
    });
    _defineProperty(this, "errorResponse", (response, error, methodName) => {
      console.error(`Index Management - SnapshotManagementService - ${methodName}:`, error);
      return response.custom({
        statusCode: 200,
        // error?.statusCode || 500,
        body: {
          ok: false,
          error: this.parseEsErrorResponse(error)
        }
      });
    });
    _defineProperty(this, "parseEsErrorResponse", error => {
      if (error.response) {
        try {
          const esErrorResponse = JSON.parse(error.response);
          return esErrorResponse.reason || error.response;
        } catch (parsingError) {
          return error.response;
        }
      }
      return error.message;
    });
  }
  async _safecatSnapshotForRepo(callWithRequest, repositoryName) {
    try {
      const catSnapshotRes = await callWithRequest("cat.snapshots", {
        format: "json",
        repository: repositoryName,
        ignore_unavailable: true
      });
      return catSnapshotRes;
    } catch (err) {
      console.error(`Index Management - SnapshotManagementService - _safeCatSnapshot:`, err);
      return undefined;
    }
  }
}
exports.default = SnapshotManagementService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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