"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationsDashboardsPlugin = void 0;
var _routes = require("./routes");
var _notificationsPlugin = require("./clusters/notificationsPlugin");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
class notificationsDashboardsPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, {
    dataSource
  }) {
    this.logger.debug("notificationsDashboards: Setup");
    const router = core.http.createRouter();
    const notificationsClient = core.opensearch.legacy.createClient('opensearch_notifications', {
      plugins: [_notificationsPlugin.NotificationsPlugin]
    });
    const dataSourceEnabled = !!dataSource;
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_notificationsPlugin.NotificationsPlugin);
    }
    core.http.registerRouteHandlerContext('notificationsContext', (context, request) => {
      return {
        logger: this.logger,
        notificationsClient
      };
    });

    // Register server side APIs
    (0, _routes.defineRoutes)(router, dataSourceEnabled);
    return {};
  }
  start(core) {
    this.logger.debug("notificationsDashboards: Started");
    return {};
  }
  stop() {}
}
exports.notificationsDashboardsPlugin = notificationsDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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