"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDataAdaptor = void 0;
var _json_data_adaptor = require("./json_data_adaptor");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class IndexDataAdaptor {
  constructor(client, directory) {
    _defineProperty(this, "isConfigLocalized", true);
    _defineProperty(this, "directory", void 0);
    _defineProperty(this, "client", void 0);
    this.directory = directory;
    this.client = client;
  }
  async findIntegrationVersions(dirname) {
    const integrationVersions = await this.client.find({
      type: 'integration-template',
      fields: ['name', 'version'],
      search: dirname ? `"${dirname}"` : undefined,
      searchFields: ['name']
    });
    const adaptor = new _json_data_adaptor.JsonCatalogDataAdaptor(integrationVersions.saved_objects.map(obj => obj.attributes));
    return await adaptor.findIntegrationVersions(dirname);
  }
  async readFile(filename, type) {
    // Duplicates a lot of logic from the Json Adaptor version since we need to parse config
    // for an efficient network query anyways
    if (type !== undefined) {
      return {
        ok: false,
        error: new Error('JSON adaptor does not support subtypes (isConfigLocalized: true)')
      };
    }
    const filenameParts = filename.match(/([\w]+)-(\d+(\.\d+)*)\.json/);
    if (!filenameParts) {
      return {
        ok: false,
        error: new Error(`Invalid Config filename: ${filename}`)
      };
    }
    const integrations = await this.client.find({
      type: 'integration-template',
      search: `"${filenameParts[1]}" + "${filenameParts[2]}"`,
      searchFields: ['name', 'version']
    });
    if (integrations.total === 0) {
      return {
        ok: false,
        error: new Error('Config file not found: ' + filename)
      };
    }
    return {
      ok: true,
      value: integrations.saved_objects[0].attributes
    };
  }
  async readFileRaw(_filename, _type) {
    return {
      ok: false,
      error: new Error('JSON adaptor does not support raw files (isConfigLocalized: true)')
    };
  }
  async findIntegrations(dirname = '.') {
    const dir = dirname !== '.' ? dirname : this.directory;
    const integrations = await this.client.find({
      type: 'integration-template',
      fields: ['name'],
      search: dir ? `"${dir}"` : undefined,
      searchFields: ['name']
    });
    const names = integrations.saved_objects.map(obj => obj.attributes.name);
    return {
      ok: true,
      value: [...new Set(names)]
    };
  }
  async getDirectoryType(dirname) {
    const names = await this.findIntegrations(dirname !== null && dirname !== void 0 ? dirname : '.');
    if (!names.value || names.value.length === 0) {
      return 'unknown';
    }
    if (names.value.length === 1) {
      return 'integration';
    }
    return 'repository';
  }
  join(filename) {
    return new IndexDataAdaptor(this.client, filename);
  }
}
exports.IndexDataAdaptor = IndexDataAdaptor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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