from itertools import product

COMMANDS = {
    '9420': '',
    '9429': '',
    '9425': '',
    '9426': '',
    '94a7': '',
    '942a': '',
    '94ab': '',
    '942c': '',
    '94ae': '',
    '942f': '',
    '9779': '<$>{break}<$>',
    '9775': '<$>{break}<$>',
    '9776': '<$>{break}<$>',
    '9770': '<$>{break}<$>',
    '9773': '<$>{break}<$>',
    '10c8': '<$>{break}<$>',
    '10c2': '<$>{break}<$>',
    '166e': '<$>{break}<$>{italic}<$>',
    '166d': '<$>{break}<$>',
    '166b': '<$>{break}<$>',
    '10c4': '<$>{break}<$>',
    '9473': '<$>{break}<$>',
    '977f': '<$>{break}<$>',
    '977a': '<$>{break}<$>',
    '1668': '<$>{break}<$>',
    '1667': '<$>{break}<$>',
    '1664': '<$>{break}<$>',
    '1661': '<$>{break}<$>',
    '10ce': '<$>{break}<$>{italic}<$>',
    '94c8': '<$>{break}<$>',
    '94c7': '<$>{break}<$>',
    '94c4': '<$>{break}<$>',
    '94c2': '<$>{break}<$>',
    '94c1': '<$>{break}<$>',
    '915e': '<$>{break}<$>',
    '915d': '<$>{break}<$>',
    '915b': '<$>{break}<$>',
    '925d': '<$>{break}<$>',
    '925e': '<$>{break}<$>',
    '925b': '<$>{break}<$>',
    '97e6': '<$>{break}<$>',
    '97e5': '<$>{break}<$>',
    '97e3': '<$>{break}<$>',
    '97e0': '<$>{break}<$>',
    '97e9': '<$>{break}<$>',
    '9154': '<$>{break}<$>',
    '9157': '<$>{break}<$>',
    '9151': '<$>{break}<$>',
    '9258': '<$>{break}<$>',
    '9152': '<$>{break}<$>',
    '9257': '<$>{break}<$>',
    '9254': '<$>{break}<$>',
    '9252': '<$>{break}<$>',
    '9158': '<$>{break}<$>',
    '9251': '<$>{break}<$>',
    '94cd': '<$>{break}<$>',
    '94ce': '<$>{break}<$>{italic}<$>',
    '94cb': '<$>{break}<$>',
    '97ef': '<$>{break}<$>{italic}<$>',
    '1373': '<$>{break}<$>',
    '97ec': '<$>{break}<$>',
    '97ea': '<$>{break}<$>',
    '15c7': '<$>{break}<$>',
    '974f': '<$>{break}<$>{italic}<$>',
    '10c1': '<$>{break}<$>',
    '974a': '<$>{break}<$>',
    '974c': '<$>{break}<$>',
    '10c7': '<$>{break}<$>',
    '976d': '<$>{break}<$>',
    '15d6': '<$>{break}<$>',
    '15d5': '<$>{break}<$>',
    '15d3': '<$>{break}<$>',
    '15d0': '<$>{break}<$>',
    '15d9': '<$>{break}<$>',
    '9745': '<$>{break}<$>',
    '9746': '<$>{break}<$>',
    '9740': '<$>{break}<$>',
    '9743': '<$>{break}<$>',
    '9749': '<$>{break}<$>',
    '15df': '<$>{break}<$>',
    '15dc': '<$>{break}<$>',
    '15da': '<$>{break}<$>',
    '15f8': '<$>{break}<$>',
    '94fe': '<$>{break}<$>',
    '94fd': '<$>{break}<$>',
    '94fc': '<$>{break}<$>',
    '94fb': '<$>{break}<$>',
    '944f': '<$>{break}<$>{italic}<$>',
    '944c': '<$>{break}<$>',
    '944a': '<$>{break}<$>',
    '92fc': '<$>{break}<$>',
    '1051': '<$>{break}<$>',
    '1052': '<$>{break}<$>',
    '1054': '<$>{break}<$>',
    '92fe': '<$>{break}<$>',
    '92fd': '<$>{break}<$>',
    '1058': '<$>{break}<$>',
    '157a': '<$>{break}<$>',
    '157f': '<$>{break}<$>',
    '9279': '<$>{break}<$>',
    '94f4': '<$>{break}<$>',
    '94f7': '<$>{break}<$>',
    '94f1': '<$>{break}<$>',
    '9449': '<$>{break}<$>',
    '92fb': '<$>{break}<$>',
    '9446': '<$>{break}<$>',
    '9445': '<$>{break}<$>',
    '9443': '<$>{break}<$>',
    '94f8': '<$>{break}<$>',
    '9440': '<$>{break}<$>',
    '1057': '<$>{break}<$>',
    '9245': '<$>{break}<$>',
    '92f2': '<$>{break}<$>',
    '1579': '<$>{break}<$>',
    '92f7': '<$>{break}<$>',
    '105e': '<$>{break}<$>',
    '92f4': '<$>{break}<$>',
    '1573': '<$>{break}<$>',
    '1570': '<$>{break}<$>',
    '1576': '<$>{break}<$>',
    '1575': '<$>{break}<$>',
    '16c1': '<$>{break}<$>',
    '16c2': '<$>{break}<$>',
    '9168': '<$>{break}<$>',
    '16c7': '<$>{break}<$>',
    '9164': '<$>{break}<$>',
    '9167': '<$>{break}<$>',
    '9161': '<$>{break}<$>',
    '9162': '<$>{break}<$>',
    '947f': '<$>{break}<$>',
    '91c2': '<$>{break}<$>',
    '91c1': '<$>{break}<$>',
    '91c7': '<$>{break}<$>',
    '91c4': '<$>{break}<$>',
    '13e3': '<$>{break}<$>',
    '91c8': '<$>{break}<$>',
    '91d0': '<$>{break}<$>',
    '13e5': '<$>{break}<$>',
    '13c8': '<$>{break}<$>',
    '16cb': '<$>{break}<$>',
    '16cd': '<$>{break}<$>',
    '16ce': '<$>{break}<$>{italic}<$>',
    '916d': '<$>{break}<$>',
    '916e': '<$>{break}<$>{italic}<$>',
    '916b': '<$>{break}<$>',
    '91d5': '<$>{break}<$>',
    '137a': '<$>{break}<$>',
    '91cb': '<$>{break}<$>',
    '91ce': '<$>{break}<$>{italic}<$>',
    '91cd': '<$>{break}<$>',
    '13ec': '<$>{break}<$>',
    '13c1': '<$>{break}<$>',
    '13ea': '<$>{break}<$>',
    '13ef': '<$>{break}<$>{italic}<$>',
    '94f2': '<$>{break}<$>',
    '97fb': '<$>{break}<$>',
    '97fc': '<$>{break}<$>',
    '1658': '<$>{break}<$>',
    '97fd': '<$>{break}<$>',
    '97fe': '<$>{break}<$>',
    '1652': '<$>{break}<$>',
    '1651': '<$>{break}<$>',
    '1657': '<$>{break}<$>',
    '1654': '<$>{break}<$>',
    '10cb': '<$>{break}<$>',
    '97f2': '<$>{break}<$>',
    '97f1': '<$>{break}<$>',
    '97f7': '<$>{break}<$>',
    '97f4': '<$>{break}<$>',
    '165b': '<$>{break}<$>',
    '97f8': '<$>{break}<$>',
    '165d': '<$>{break}<$>',
    '165e': '<$>{break}<$>',
    '15cd': '<$>{break}<$>',
    '10cd': '<$>{break}<$>',
    '9767': '<$>{break}<$>',
    '9249': '<$>{break}<$>',
    '1349': '<$>{break}<$>',
    '91d9': '<$>{break}<$>',
    '1340': '<$>{break}<$>',
    '91d3': '<$>{break}<$>',
    '9243': '<$>{break}<$>',
    '1343': '<$>{break}<$>',
    '91d6': '<$>{break}<$>',
    '1345': '<$>{break}<$>',
    '1346': '<$>{break}<$>',
    '9246': '<$>{break}<$>',
    '94e9': '<$>{break}<$>',
    '94e5': '<$>{break}<$>',
    '94e6': '<$>{break}<$>',
    '94e0': '<$>{break}<$>',
    '94e3': '<$>{break}<$>',
    '15ea': '<$>{break}<$>',
    '15ec': '<$>{break}<$>',
    '15ef': '<$>{break}<$>{italic}<$>',
    '16fe': '<$>{break}<$>',
    '16fd': '<$>{break}<$>',
    '16fc': '<$>{break}<$>',
    '16fb': '<$>{break}<$>',
    '1367': '<$>{break}<$>',
    '94ef': '<$>{break}<$>{italic}<$>',
    '94ea': '<$>{break}<$>',
    '94ec': '<$>{break}<$>',
    '924a': '<$>{break}<$>',
    '91dc': '<$>{break}<$>',
    '924c': '<$>{break}<$>',
    '91da': '<$>{break}<$>',
    '91df': '<$>{break}<$>',
    '134f': '<$>{break}<$>{italic}<$>',
    '924f': '<$>{break}<$>{italic}<$>',
    '16f8': '<$>{break}<$>',
    '16f7': '<$>{break}<$>',
    '16f4': '<$>{break}<$>',
    '16f2': '<$>{break}<$>',
    '16f1': '<$>{break}<$>',
    '15e0': '<$>{break}<$>',
    '15e3': '<$>{break}<$>',
    '15e5': '<$>{break}<$>',
    '15e6': '<$>{break}<$>',
    '15e9': '<$>{break}<$>',
    '9757': '<$>{break}<$>',
    '9754': '<$>{break}<$>',
    '9752': '<$>{break}<$>',
    '9751': '<$>{break}<$>',
    '9758': '<$>{break}<$>',
    '92f1': '<$>{break}<$>',
    '104c': '<$>{break}<$>',
    '104a': '<$>{break}<$>',
    '104f': '<$>{break}<$>{italic}<$>',
    '105d': '<$>{break}<$>',
    '92f8': '<$>{break}<$>',
    '975e': '<$>{break}<$>',
    '975d': '<$>{break}<$>',
    '975b': '<$>{break}<$>',
    '1043': '<$>{break}<$>',
    '1040': '<$>{break}<$>',
    '1046': '<$>{break}<$>',
    '1045': '<$>{break}<$>',
    '1049': '<$>{break}<$>',
    '9479': '<$>{break}<$>',
    '917f': '<$>{break}<$>',
    '9470': '<$>{break}<$>',
    '9476': '<$>{break}<$>',
    '917a': '<$>{break}<$>',
    '9475': '<$>{break}<$>',
    '927a': '<$>{break}<$>',
    '927f': '<$>{break}<$>',
    '134a': '<$>{break}<$>',
    '15fb': '<$>{break}<$>',
    '15fc': '<$>{break}<$>',
    '15fd': '<$>{break}<$>',
    '15fe': '<$>{break}<$>',
    '1546': '<$>{break}<$>',
    '1545': '<$>{break}<$>',
    '1543': '<$>{break}<$>',
    '1540': '<$>{break}<$>',
    '1549': '<$>{break}<$>',
    '13fd': '<$>{break}<$>',
    '13fe': '<$>{break}<$>',
    '13fb': '<$>{break}<$>',
    '13fc': '<$>{break}<$>',
    '92e9': '<$>{break}<$>',
    '92e6': '<$>{break}<$>',
    '9458': '<$>{break}<$>',
    '92e5': '<$>{break}<$>',
    '92e3': '<$>{break}<$>',
    '92e0': '<$>{break}<$>',
    '9270': '<$>{break}<$>',
    '9273': '<$>{break}<$>',
    '9275': '<$>{break}<$>',
    '9276': '<$>{break}<$>',
    '15f1': '<$>{break}<$>',
    '15f2': '<$>{break}<$>',
    '15f4': '<$>{break}<$>',
    '15f7': '<$>{break}<$>',
    '9179': '<$>{break}<$>',
    '9176': '<$>{break}<$>',
    '9175': '<$>{break}<$>',
    '947a': '<$>{break}<$>',
    '9173': '<$>{break}<$>',
    '9170': '<$>{break}<$>',
    '13f7': '<$>{break}<$>',
    '13f4': '<$>{break}<$>',
    '13f2': '<$>{break}<$>',
    '13f1': '<$>{break}<$>',
    '92ef': '<$>{break}<$>{italic}<$>',
    '92ec': '<$>{break}<$>',
    '13f8': '<$>{break}<$>',
    '92ea': '<$>{break}<$>',
    '154f': '<$>{break}<$>{italic}<$>',
    '154c': '<$>{break}<$>',
    '154a': '<$>{break}<$>',
    '16c4': '<$>{break}<$>',
    '16c8': '<$>{break}<$>',
    '97c8': '<$>{break}<$>',
    '164f': '<$>{break}<$>{italic}<$>',
    '164a': '<$>{break}<$>',
    '164c': '<$>{break}<$>',
    '1645': '<$>{break}<$>',
    '1646': '<$>{break}<$>',
    '1640': '<$>{break}<$>',
    '1643': '<$>{break}<$>',
    '1649': '<$>{break}<$>',
    '94df': '<$>{break}<$>',
    '94dc': '<$>{break}<$>',
    '94da': '<$>{break}<$>',
    '135b': '<$>{break}<$>',
    '135e': '<$>{break}<$>',
    '135d': '<$>{break}<$>',
    '1370': '<$>{break}<$>',
    '9240': '<$>{break}<$>',
    '13e9': '<$>{break}<$>',
    '1375': '<$>{break}<$>',
    '1679': '<$>{break}<$>',
    '1358': '<$>{break}<$>',
    '1352': '<$>{break}<$>',
    '1351': '<$>{break}<$>',
    '1376': '<$>{break}<$>',
    '1357': '<$>{break}<$>',
    '1354': '<$>{break}<$>',
    '1379': '<$>{break}<$>',
    '94d9': '<$>{break}<$>',
    '94d6': '<$>{break}<$>',
    '94d5': '<$>{break}<$>',
    '1562': '<$>{break}<$>',
    '94d3': '<$>{break}<$>',
    '94d0': '<$>{break}<$>',
    '13e0': '<$>{break}<$>',
    '13e6': '<$>{break}<$>',
    '976b': '<$>{break}<$>',
    '15c4': '<$>{break}<$>',
    '15c2': '<$>{break}<$>',
    '15c1': '<$>{break}<$>',
    '976e': '<$>{break}<$>{italic}<$>',
    '134c': '<$>{break}<$>',
    '15c8': '<$>{break}<$>',
    '92c8': '<$>{break}<$>',
    '16e9': '<$>{break}<$>',
    '16e3': '<$>{break}<$>',
    '16e0': '<$>{break}<$>',
    '16e6': '<$>{break}<$>',
    '16e5': '<$>{break}<$>',
    '91e5': '<$>{break}<$>',
    '91e6': '<$>{break}<$>',
    '91e0': '<$>{break}<$>',
    '91e3': '<$>{break}<$>',
    '13c4': '<$>{break}<$>',
    '13c7': '<$>{break}<$>',
    '91e9': '<$>{break}<$>',
    '13c2': '<$>{break}<$>',
    '9762': '<$>{break}<$>',
    '15ce': '<$>{break}<$>{italic}<$>',
    '9761': '<$>{break}<$>',
    '15cb': '<$>{break}<$>',
    '9764': '<$>{break}<$>',
    '9768': '<$>{break}<$>',
    '91ef': '<$>{break}<$>{italic}<$>',
    '91ea': '<$>{break}<$>',
    '91ec': '<$>{break}<$>',
    '13ce': '<$>{break}<$>{italic}<$>',
    '13cd': '<$>{break}<$>',
    '97da': '<$>{break}<$>',
    '13cb': '<$>{break}<$>',
    '1362': '<$>{break}<$>',
    '16ec': '<$>{break}<$>',
    '16ea': '<$>{break}<$>',
    '16ef': '<$>{break}<$>{italic}<$>',
    '97c1': '<$>{break}<$>',
    '97c2': '<$>{break}<$>',
    '97c4': '<$>{break}<$>',
    '97c7': '<$>{break}<$>',
    '92cd': '<$>{break}<$>',
    '92ce': '<$>{break}<$>{italic}<$>',
    '92cb': '<$>{break}<$>',
    '92da': '<$>{break}<$>',
    '92dc': '<$>{break}<$>',
    '92df': '<$>{break}<$>',
    '97df': '<$>{break}<$>',
    '155b': '<$>{break}<$>',
    '155e': '<$>{break}<$>',
    '155d': '<$>{break}<$>',
    '97dc': '<$>{break}<$>',
    '1675': '<$>{break}<$>',
    '1676': '<$>{break}<$>',
    '1670': '<$>{break}<$>',
    '1673': '<$>{break}<$>',
    '1662': '<$>{break}<$>',
    '97cb': '<$>{break}<$>',
    '97ce': '<$>{break}<$>{italic}<$>',
    '97cd': '<$>{break}<$>',
    '92c4': '<$>{break}<$>',
    '92c7': '<$>{break}<$>',
    '92c1': '<$>{break}<$>',
    '92c2': '<$>{break}<$>',
    '1551': '<$>{break}<$>',
    '97d5': '<$>{break}<$>',
    '97d6': '<$>{break}<$>',
    '1552': '<$>{break}<$>',
    '97d0': '<$>{break}<$>',
    '1554': '<$>{break}<$>',
    '1557': '<$>{break}<$>',
    '97d3': '<$>{break}<$>',
    '1558': '<$>{break}<$>',
    '167f': '<$>{break}<$>',
    '137f': '<$>{break}<$>',
    '167a': '<$>{break}<$>',
    '92d9': '<$>{break}<$>',
    '92d0': '<$>{break}<$>',
    '92d3': '<$>{break}<$>',
    '92d5': '<$>{break}<$>',
    '92d6': '<$>{break}<$>',
    '10dc': '<$>{break}<$>',
    '9262': '<$>{break}<$>',
    '9261': '<$>{break}<$>',
    '91f8': '<$>{break}<$>',
    '10df': '<$>{break}<$>',
    '9264': '<$>{break}<$>',
    '91f4': '<$>{break}<$>',
    '91f7': '<$>{break}<$>',
    '91f1': '<$>{break}<$>',
    '91f2': '<$>{break}<$>',
    '97d9': '<$>{break}<$>',
    '9149': '<$>{break}<$>',
    '9143': '<$>{break}<$>',
    '9140': '<$>{break}<$>',
    '9146': '<$>{break}<$>',
    '9145': '<$>{break}<$>',
    '9464': '<$>{break}<$>',
    '9467': '<$>{break}<$>',
    '9461': '<$>{break}<$>',
    '9462': '<$>{break}<$>',
    '9468': '<$>{break}<$>',
    '914c': '<$>{break}<$>',
    '914a': '<$>{break}<$>',
    '914f': '<$>{break}<$>{italic}<$>',
    '10d3': '<$>{break}<$>',
    '926b': '<$>{break}<$>',
    '10d0': '<$>{break}<$>',
    '10d6': '<$>{break}<$>',
    '926e': '<$>{break}<$>{italic}<$>',
    '926d': '<$>{break}<$>',
    '91fd': '<$>{break}<$>',
    '91fe': '<$>{break}<$>',
    '10d9': '<$>{break}<$>',
    '91fb': '<$>{break}<$>',
    '91fc': '<$>{break}<$>',
    '946e': '<$>{break}<$>{italic}<$>',
    '946d': '<$>{break}<$>',
    '946b': '<$>{break}<$>',
    '10da': '<$>{break}<$>',
    '10d5': '<$>{break}<$>',
    '9267': '<$>{break}<$>',
    '9268': '<$>{break}<$>',
    '16df': '<$>{break}<$>',
    '16da': '<$>{break}<$>',
    '16dc': '<$>{break}<$>',
    '9454': '<$>{break}<$>',
    '9457': '<$>{break}<$>',
    '9451': '<$>{break}<$>',
    '9452': '<$>{break}<$>',
    '136d': '<$>{break}<$>',
    '136e': '<$>{break}<$>{italic}<$>',
    '136b': '<$>{break}<$>',
    '13d9': '<$>{break}<$>',
    '13da': '<$>{break}<$>',
    '13dc': '<$>{break}<$>',
    '13df': '<$>{break}<$>',
    '1568': '<$>{break}<$>',
    '1561': '<$>{break}<$>',
    '1564': '<$>{break}<$>',
    '1567': '<$>{break}<$>',
    '16d5': '<$>{break}<$>',
    '16d6': '<$>{break}<$>',
    '16d0': '<$>{break}<$>',
    '16d3': '<$>{break}<$>',
    '945d': '<$>{break}<$>',
    '945e': '<$>{break}<$>',
    '16d9': '<$>{break}<$>',
    '945b': '<$>{break}<$>',
    '156b': '<$>{break}<$>',
    '156d': '<$>{break}<$>',
    '156e': '<$>{break}<$>{italic}<$>',
    '105b': '<$>{break}<$>',
    '1364': '<$>{break}<$>',
    '1368': '<$>{break}<$>',
    '1361': '<$>{break}<$>',
    '13d0': '<$>{break}<$>',
    '13d3': '<$>{break}<$>',
    '13d5': '<$>{break}<$>',
    '13d6': '<$>{break}<$>',
    '97a1': '',
    '97a2': '',
    '9723': '',
    '94a1': '',
    '94a4': '',
    '94ad': '',
    '1020': '',
    '10a1': '',
    '10a2': '',
    '1023': '',
    '10a4': '',
    '1025': '',
    '1026': '',
    '10a7': '',
    '10a8': '',
    '1029': '',
    '102a': '',
    '10ab': '',
    '102c': '',
    '10ad': '',
    '10ae': '',
    '102f': '',
    '97ad': '',
    '97a4': '',
    '9725': '',
    '9726': '',
    '97a7': '',
    '97a8': '',
    '9729': '',
    '972a': '',
    '9120': '<$>{end-italic}<$>',   # plain white
    '91a1': '<$>{end-italic}<$>',   # white underlined
    '91a2': '<$>{end-italic}<$>',   # plain green
    '9123': '<$>{end-italic}<$>',   # green underlined
    '91a4': '<$>{end-italic}<$>',   # plain blue
    '9125': '<$>{end-italic}<$>',   # blue underlined
    '9126': '<$>{end-italic}<$>',   # plain cyan
    '91a7': '<$>{end-italic}<$>',   # cyan underlined
    '91a8': '<$>{end-italic}<$>',   # plain red
    '9129': '<$>{end-italic}<$>',   # red underlined
    '912a': '<$>{end-italic}<$>',   # plain yellow
    '91ab': '<$>{end-italic}<$>',   # yellow underlined
    '912c': '<$>{end-italic}<$>',   # plain magenta
    '91ad': '<$>{end-italic}<$>',   # magenta underlined
    '97ae': '<$>{end-italic}<$>',   # plain black
    '972f': '<$>{end-italic}<$>',   # black underlined
    '91ae': '<$>{italic}<$>',
    '912f': '<$>{italic}<$>',
    '94a8': '',
    '9423': '',
    '94a2': '',
}


CHARACTERS = {
    '20': ' ',
    'a1': '!',
    'a2': '"',
    '23': '#',
    'a4': '$',
    '25': '%',
    '26': '&',
    'a7': '\'',
    'a8': '(',
    '29': ')',
    '2a': 'á',
    'ab': '+',
    '2c': ',',
    'ad': '-',
    'ae': '.',
    '2f': '/',
    'b0': '0',
    '31': '1',
    '32': '2',
    'b3': '3',
    '34': '4',
    'b5': '5',
    'b6': '6',
    '37': '7',
    '38': '8',
    'b9': '9',
    'ba': ':',
    '3b': ';',
    'bc': '<',
    '3d': '=',
    '3e': '>',
    'bf': '?',
    '40': '@',
    'c1': 'A',
    'c2': 'B',
    '43': 'C',
    'c4': 'D',
    '45': 'E',
    '46': 'F',
    'c7': 'G',
    'c8': 'H',
    '49': 'I',
    '4a': 'J',
    'cb': 'K',
    '4c': 'L',
    'cd': 'M',
    'ce': 'N',
    '4f': 'O',
    'd0': 'P',
    '51': 'Q',
    '52': 'R',
    'd3': 'S',
    '54': 'T',
    'd5': 'U',
    'd6': 'V',
    '57': 'W',
    '58': 'X',
    'd9': 'Y',
    'da': 'Z',
    '5b': '[',
    'dc': 'é',
    '5d': ']',
    '5e': 'í',
    'df': 'ó',
    'e0': 'ú',
    '61': 'a',
    '62': 'b',
    'e3': 'c',
    '64': 'd',
    'e5': 'e',
    'e6': 'f',
    '67': 'g',
    '68': 'h',
    'e9': 'i',
    'ea': 'j',
    '6b': 'k',
    'ec': 'l',
    '6d': 'm',
    '6e': 'n',
    'ef': 'o',
    '70': 'p',
    'f1': 'q',
    'f2': 'r',
    '73': 's',
    'f4': 't',
    '75': 'u',
    '76': 'v',
    'f7': 'w',
    'f8': 'x',
    '79': 'y',
    '7a': 'z',
    'fb': 'ç',
    '7c': '÷',
    'fd': 'Ñ',
    'fe': 'ñ',
    '7f': '',
    '80': ''
}


SPECIAL_CHARS = {
    '91b0': '®',
    '9131': '°',
    '9132': '½',
    '91b3': '¿',
    '9134': '™',
    '91b5': '¢',
    '91b6': '£',
    '9137': '♪',
    '9138': 'à',
    '91b9': ' ',
    '91ba': 'è',
    '913b': 'â',
    '91bc': 'ê',
    '913d': 'î',
    '913e': 'ô',
    '91bf': 'û'
}


EXTENDED_CHARS = {
    '9220': 'Á',
    '92a1': 'É',
    '92a2': 'Ó',
    '9223': 'Ú',
    '92a4': 'Ü',
    '9225': 'ü',
    '9226': '‘',
    '92a7': '¡',
    '92a8': '*',
    '9229': '’',
    '922a': '—',
    '92ab': '©',
    '922c': '℠',
    '92ad': '•',
    '92ae': '“',
    '922f': '”',
    '92b0': 'À',
    '9231': 'Â',
    '9232': 'Ç',
    '92b3': 'È',
    '9234': 'Ê',
    '92b5': 'Ë',
    '92b6': 'ë',
    '9237': 'Î',
    '9238': 'Ï',
    '92b9': 'ï',
    '92ba': 'Ô',
    '923b': 'Ù',
    '92bc': 'ù',
    '923d': 'Û',
    '923e': '«',
    '92bf': '»',
    '1320': 'Ã',
    '13a1': 'ã',
    '13a2': 'Í',
    '1323': 'Ì',
    '13a4': 'ì',
    '1325': 'Ò',
    '1326': 'ò',
    '13a7': 'Õ',
    '13a8': 'õ',
    '1329': '{',
    '132a': '}',
    '13ab': '\\',
    '132c': '^',
    '13ad': '_',
    '13ae': '¦',
    '132f': '~',
    '13b0': 'Ä',
    '1331': 'ä',
    '1332': 'Ö',
    '13b3': 'ö',
    '1334': 'ß',
    '13b5': '¥',
    '13b6': '¤',
    '1337': '|',
    '1338': 'Å',
    '13b9': 'å',
    '13ba': 'Ø',
    '133b': 'ø',
    '13bc': '┌',
    '133d': '┐',
    '133e': '└',
    '13bf': '┘',
}


# Cursor positioning codes
PAC_HIGH_BYTE_BY_ROW = [
    'xx',
    '91',
    '91',
    '92',
    '92',
    '15',
    '15',
    '16',
    '16',
    '97',
    '97',
    '10',
    '13',
    '13',
    '94',
    '94'
]
PAC_LOW_BYTE_BY_ROW_RESTRICTED = [
    'xx',
    'd0',
    '70',
    'd0',
    '70',
    'd0',
    '70',
    'd0',
    '70',
    'd0',
    '70',
    'd0',
    'd0',
    '70',
    'd0',
    '70'
]

# High order bytes come first, then each key contains a list of low bytes.
# Any of the values in that list, coupled with the high order byte will
# map to the (row, column) tuple.
# This particular dictionary will get transformed to a more suitable form for
# usage like PAC_BYTES_TO_POSITIONING_MAP['91']['d6'] = (1, 12)
PAC_BYTES_TO_POSITIONING_MAP = {
    '91': {
        ('40', 'c1', 'd0', '51', 'c2', '43', 'c4', '45', '46', 'c7', 'c8', '49', '4a', 'cb', '4c', 'cd', 'ce', '4f'): (1, 0),  # noqa
        ('e0', '70', 'f1', '62', '61', 'e3', '64', 'e5', 'e6', '67', '68', 'e9', 'ea', '6b', 'ec', '6d', '6e', 'ef'): (2, 0),  # noqa
        ('52', 'd3'): (1, 4),
        ('54', 'd5'): (1, 8),
        ('d6', '57'): (1, 12),
        ('58', 'd9'): (1, 16),
        ('da', '5b'): (1, 20),
        ('dc', '5d'): (1, 24),
        ('5e', 'df'): (1, 28),

        ('f2', '73'): (2, 4),
        ('f4', '75'): (2, 8),
        ('76', 'f7'): (2, 12),
        ('f8', '79'): (2, 16),
        ('7a', 'fb'): (2, 20),
        ('7c', 'fc', 'fd'): (2, 24),
        ('fe', '7f'): (2, 28)
    },
    '92': {
        ('40', 'c1', '4f', 'd0', '51', 'c2', '43', 'c4', '45', '46', 'c7', 'c8', '49', '4a', 'cb', '4c', 'cd', 'ce'): (3, 0),  # noqa
        ('e0', '61', 'ef', '70', 'f1', '62', 'e3', '64', 'e5', 'e6', '67', '68', 'e9', 'ea', '6b', 'ec', '6d', '6e'): (4, 0),  # noqa
        ('52', 'd3'): (3, 4),
        ('54', 'd5'): (3, 8),
        ('d6', '57'): (3, 12),
        ('58', 'd9'): (3, 16),
        ('da', '5b'): (3, 20),
        ('dc', '5d'): (3, 24),
        ('5e', 'df'): (3, 28),

        ('f2', '73'): (4, 4),
        ('f4', '75'): (4, 8),
        ('76', 'f7'): (4, 12),
        ('f8', '79'): (4, 16),
        ('7a', 'fc', 'fb'): (4, 20),
        ('7c', 'fd'): (4, 24),
        ('fe', '7f'): (4, 28)
    },
    '15': {
        ('40', 'ce', '4f', 'd0', '51', 'c1', 'c2', '43', 'c4', '45', '46', 'c7', 'c8', '49', '4a', 'cb', '4c', 'cd'): (5, 0),  # noqa
        ('e0', 'ef', '70', 'f1', '61', '62', 'e3', '64', 'e5', 'e6', '67', '68', 'e9', 'ea', '6b', 'ec', '6d', '6e'): (6, 0),  # noqa
        ('52', 'd3'): (5, 4),
        ('54', 'd5'): (5, 8),
        ('d6', '57'): (5, 12),
        ('58', 'd9'): (5, 16),
        ('da', '5b'): (5, 20),
        ('dc', '5d'): (5, 24),
        ('5e', 'df'): (5, 28),

        ('f2', '73'): (6, 4),
        ('f4', '75'): (6, 8),
        ('76', 'f7'): (6, 12),
        ('f8', '79'): (6, 16),
        ('7a', 'fb'): (6, 20),
        ('7c', 'fc', 'fd'): (6, 24),
        ('fe', '7f'): (6, 28)
    },
    '16': {
        ('40', 'c1', 'ce', '4f', 'd0', '51', 'c2', '43', 'c4', '45', '46', 'c7', 'c8', '49', '4a', 'cb', '4c', 'cd'): (7, 0),  # noqa
        ('e0', '61', '62', '6e', 'ef', '70', 'f1', '62', 'e3', '64', 'e5', 'e6', '67', '68', 'e9', 'ea', '6b', 'ec', '6d'): (8, 0),  # noqa
        ('52', 'd3'): (7, 4),
        ('54', 'd5'): (7, 8),
        ('d6', '57'): (7, 12),
        ('58', 'd9'): (7, 16),
        ('da', '5b'): (7, 20),
        ('dc', '5d'): (7, 24),
        ('5e', 'df'): (7, 28),

        ('f2', '73'): (8, 4),
        ('f4', '75'): (8, 8),
        ('76', 'f7'): (8, 12),
        ('f8', '79'): (8, 16),
        ('7a', 'fb'): (8, 20),
        ('fc', '7c', 'fd'): (8, 24),
        ('fe', '7f'): (8, 28)
    },
    '97': {
        ('40', 'c1', 'ce', '4f', 'd0', '51', 'c2', '43', 'c4', '45', '46', 'c7', 'c8', '49', '4a', 'cb', '4c', 'cd'): (9, 0),  # noqa
        ('e0', '61', '6e', 'ef', '70', 'f1', '62', 'e3', '64', 'e5', 'e6', '67', '68', 'e9', 'ea', '6b', 'ec', '6d'): (10, 0),  # noqa
        ('52', 'd3'): (9, 4),
        ('54', 'd5'): (9, 8),
        ('d6', '57'): (9, 12),
        ('58', 'd9'): (9, 16),
        ('da', '5b'): (9, 20),
        ('dc', '5d'): (9, 24),
        ('5e', 'df'): (9, 28),

        ('f2', '73'): (10, 4),
        ('f4', '75'): (10, 8),
        ('76', 'f7'): (10, 12),
        ('f8', '79'): (10, 16),
        ('7a', 'fb'): (10, 20),
        ('fc', '7c', 'fd'): (10, 24),
        ('fe', '7f'): (10, 28)
    },
    '10': {
        ('40', 'c1', 'ce', '4f', 'd0', '51', 'c2', '43', 'c4', '45', '46', 'c7', 'c8', '49', '4a', 'cb', '4c', 'cd'): (11, 0),  # noqa
        ('52', 'd3'): (11, 4),
        ('54', 'd5'): (11, 8),
        ('d6', '57'): (11, 12),
        ('58', 'd9'): (11, 16),
        ('da', '5b'): (11, 20),
        ('dc', '5d'): (11, 24),
        ('5e', 'df'): (11, 28),
    },
    '13': {
        ('40', 'c1', 'ce', '4f', 'd0', '51', 'c2', '43', 'c4', '45', '46', 'c7', 'c8', '49', '4a', 'cb', '4c', 'cd'): (12, 0),  # noqa
        ('e0', '61', '62', '6e', 'ef', '70', 'f1', '62', 'e3', '64', 'e5', 'e6', '67', '68', 'e9', 'ea', '6b', 'ec', '6d'): (13, 0),  # noqa
        ('52', 'd3'): (12, 4),
        ('54', 'd5'): (12, 8),
        ('d6', '57'): (12, 12),
        ('58', 'd9'): (12, 16),
        ('da', '5b'): (12, 20),
        ('dc', '5d'): (12, 24),
        ('5e', 'df'): (12, 28),

        ('f2', '73'): (13, 4),
        ('f4', '75'): (13, 8),
        ('76', 'f7'): (13, 12),
        ('f8', '79'): (13, 16),
        ('7a', 'fb'): (13, 20),
        ('7c', 'fc', 'fd'): (13, 24),
        ('fe', '7f'): (13, 28)
    },
    '94': {
        ('40', 'c1', 'ce', '4f', 'd0', '51', 'c2', '43', 'c4', '45', '46', 'c7', 'c8', '49', '4a', 'cb', '4c', 'cd'): (14, 0),  # noqa
        ('e0', '61', '6e', 'ef', '70', 'f1', '62', 'e3', '64', 'e5', 'e6', '67', '68', 'e9', 'ea', '6b', 'ec', '6d'): (15, 0),  # noqa
        ('52', 'd3'): (14, 4),
        ('54', 'd5'): (14, 8),
        ('d6', '57'): (14, 12),
        ('58', 'd9'): (14, 16),
        ('da', '5b'): (14, 20),
        ('dc', '5d'): (14, 24),
        ('5e', 'df'): (14, 28),

        ('f2', '73'): (15, 4),
        ('f4', '75'): (15, 8),
        ('76', 'f7'): (15, 12),
        ('f8', '79'): (15, 16),
        ('7a', 'fb'): (15, 20),
        ('7c', 'fc', 'fd'): (15, 24),
        ('fe', '7f'): (15, 28)
    }
}

# Tab Offset command
# - this moves the positioning 1, 2, or 3 columns to the right
PAC_TAB_OFFSET_COMMANDS = {'97a1': 1, '97a2': 2, '9723': 3}


def _create_position_to_bytes_map(bytes_to_pos):
    result = {}
    for high_byte, low_byte_dict in list(bytes_to_pos.items()):

        # must contain mappings to column, to the tuple of possible values
        for low_byte_list in list(low_byte_dict.keys()):
            column = bytes_to_pos[high_byte][low_byte_list][1]

            row = bytes_to_pos[high_byte][low_byte_list][0]
            if row not in result:
                result[row] = {}

            result[row][column] = tuple(product([high_byte], low_byte_list))
    return result


# (Almost) the reverse of PAC_BYTES_TO_POSITIONING_MAP. Call with arguments
# like for example [15][4] to get the tuple (('94', 'f2'), ('94', '73'))
POSITIONING_TO_PAC_MAP = _create_position_to_bytes_map(
    PAC_BYTES_TO_POSITIONING_MAP
)


def _restructure_bytes_to_position_map(byte_to_pos_map):
    return {
        k_: {
            low_byte: byte_to_pos_map[k_][low_byte_list]
            for low_byte_list in list(v_.keys())
            for low_byte in low_byte_list
        }
        for k_, v_ in list(byte_to_pos_map.items())
    }


# Now use the dict with arguments like ['91']['75'] directly.
PAC_BYTES_TO_POSITIONING_MAP = _restructure_bytes_to_position_map(
    PAC_BYTES_TO_POSITIONING_MAP)


# Inverted character lookup
CHARACTER_TO_CODE = {
    character: code
    for code, character in CHARACTERS.items()
}

SPECIAL_OR_EXTENDED_CHAR_TO_CODE = {
    character: code for code, character in EXTENDED_CHARS.items()
}
SPECIAL_OR_EXTENDED_CHAR_TO_CODE.update(
    {character: code for code, character in SPECIAL_CHARS.items()}
)

# Time to transmit a single codeword = 1 second / 29.97
MICROSECONDS_PER_CODEWORD = 1000.0 * 1000.0 / (30.0 * 1000.0 / 1001.0)


HEADER = 'Scenarist_SCC V1.0'

# taken from
# http://www.theneitherworld.com/mcpoodle/SCC_TOOLS/DOCS/CC_CHARS.HTML
SUBSTITUTE_CHARACTERS = {
    '¡': ["!", "i"],   # inverted exclamation mark
     '¤': ["C"],  # currency
     '¥': ["Y"],  # yen
     '¦': ["-"],  # broken bar
     '©': ["c"],  # copyright sign
     '«': ['"'],  # left pointing double angle quotation mark
     '»': ['"'],  # right pointing double angle quotation mark
     'À': ["A"],
     'Á': ["A"],
     'Â': ["A"],
     'Ã': ["A"],
     'Ä': ["A"],
     'Å': ["A"],
     'Ç': ["C"],
     'È': ["E"],
     'É': ["E"],
     'Ê': ["E"],
     'Ë': ["E"],
     'Ì': ["I"],
     'Í': ["I"],
     'Î': ["I"],
     'Ï': ["I"],
     'Ò': ["O"],
     'Ó': ["O"],
     'Ô': [")"],
     'Õ': ["O"],
     'Ö': ["O"],
     'Ø': ["O"],
     'Ù': ["U"],
     'Ú': ["U"],
     'Û': ["U"],
     'Ü': ["U"],
     'ß': ["s"],
     'ã': ["a"],
     'ä': ["a"],
     'å': ["a"],
     'ë': ["e"],
     'ì': ["i"],
     'ï': ["i"],
     'ò': ["o"],
     'õ': ["o"],
     'ö': ["o"],
     'ø': ["o"],
     'ù': ["u"],
     'ü': ["u"],
     '—': ["-"],  # em dash
     '‘': ["'"],
     '’': ["'"],
     '“': ['"'],
     '”': ['"'],
     '•': ["."],
     '℠': ["s"],
     '┌': ["+"],
     '┐': ["+"],
     '└': ["+"],
     '┘': ["+"]
}

MID_ROW_CODES = [
    "9120", "91a1", "91a2", "9123", "91a4", "9125", "9126",
    "91a7", "91a8", "9129", "912a", "91ab", "912c", "91ad",
    "97ae", "972f", "91ae", "912f", "94a8"
]

BACKGROUND_COLOR_CODES = [
    "1020", "10a1", "10a2", "1023", "10a4", "1025", "1026",
    "10a7", "10a8", "1029", "102a", "10ab", "102c", "10ad",
    "10ae", "102f", "97ad"
]

CUE_STARTING_COMMAND = ['9425', '9426', '94a7', '9429', '9420']

ALL_CHARACTERS = {**CHARACTERS, **SPECIAL_CHARS, **EXTENDED_CHARS}

COMMAND_LABELS = {
    "9420": "Resume Caption Loading",
    "9429": "Resume Direct Captioning",
    "9425": "Roll-Up Captions--2 Rows",
    "9426": "Roll-Up Captions--3 Rows",
    "94a7": "Roll-Up Captions--4 Rows",
    "942a": "Text Restart",
    "94ab": "Resume Text Display",
    "942c": "Erase Displayed Memory",
    "94ae": "Erase Non-displayed Memory",
    "942f": "End Of Caption",
    "9140": "row 01, column 00, with plain white text.",
    "91c1": "row 01, column 00, with white underlined text.",
    "91c2": "row 01, column 00, with plain green text.",
    "9143": "row 01, column 00, with green underlined text.",
    "91c4": "row 01, column 00, with plain blue text.",
    "9145": "row 01, column 00, with blue underlined text.",
    "9146": "row 01, column 00, with plain cyan text.",
    "91c7": "row 01, column 00, with cyan underlined text.",
    "91c8": "row 01, column 00, with plain red text.",
    "9149": "row 01, column 00, with red underlined text.",
    "914a": "row 01, column 00, with plain yellow text.",
    "91cb": "row 01, column 00, with yellow underlined text.",
    "914c": "row 01, column 00, with plain magenta text.",
    "91cd": "row 01, column 00, with magenta underlined text.",
    "91ce": "row 01, column 00, with white italicized text.",
    "914f": "row 01, column 00, with white underlined italicized text.",
    "91d0": "row 01, column 00, with plain white text.",
    "9151": "row 01, column 00, with white underlined text.",
    "9152": "row 01, column 04, with plain white text.",
    "91d3": "row 01, column 04, with white underlined text.",
    "9154": "row 01, column 08, with plain white text.",
    "91d5": "row 01, column 08, with white underlined text.",
    "91d6": "row 01, column 12, with plain white text.",
    "9157": "row 01, column 12, with white underlined text.",
    "9158": "row 01, column 16, with plain white text.",
    "91d9": "row 01, column 16, with white underlined text.",
    "91da": "row 01, column 20, with plain white text.",
    "915b": "row 01, column 20, with white underlined text.",
    "91dc": "row 01, column 24, with plain white text.",
    "915d": "row 01, column 24, with white underlined text.",
    "915e": "row 01, column 28, with plain white text.",
    "91df": "row 01, column 28, with white underlined text.",
    "91e0": "row 02, column 00, with plain white text.",
    "9161": "row 02, column 00, with white underlined text.",
    "9162": "row 02, column 00, with plain green text.",
    "91e3": "row 02, column 00, with green underlined text.",
    "9164": "row 02, column 00, with plain blue text.",
    "91e5": "row 02, column 00, with blue underlined text.",
    "91e6": "row 02, column 00, with plain cyan text.",
    "9167": "row 02, column 00, with cyan underlined text.",
    "9168": "row 02, column 00, with plain red text.",
    "91e9": "row 02, column 00, with red underlined text.",
    "91ea": "row 02, column 00, with plain yellow text.",
    "916b": "row 02, column 00, with yellow underlined text.",
    "91ec": "row 02, column 00, with plain magenta text.",
    "916d": "row 02, column 00, with magenta underlined text.",
    "916e": "row 02, column 00, with white italicized text.",
    "91ef": "row 02, column 00, with white underlined italicized text.",
    "9170": "row 02, column 00, with plain white text.",
    "91f1": "row 02, column 00, with white underlined text.",
    "91f2": "row 02, column 04, with plain white text.",
    "9173": "row 02, column 04, with white underlined text.",
    "91f4": "row 02, column 08, with plain white text.",
    "9175": "row 02, column 08, with white underlined text.",
    "9176": "row 02, column 12, with plain white text.",
    "91f7": "row 02, column 12, with white underlined text.",
    "91f8": "row 02, column 16, with plain white text.",
    "9179": "row 02, column 16, with white underlined text.",
    "917a": "row 02, column 20, with plain white text.",
    "91fb": "row 02, column 20, with white underlined text.",
    "91fc": "row 02, column 24, with plain white text.",
    "91fd": "row 02, column 24, with white underlined text.",
    "91fe": "row 02, column 28, with plain white text.",
    "917f": "row 02, column 28, with white underlined text.",
    "9240": "row 03, column 00, with plain white text.",
    "92c1": "row 03, column 00, with white underlined text.",
    "92c2": "row 03, column 00, with plain green text.",
    "9243": "row 03, column 00, with green underlined text.",
    "92c4": "row 03, column 00, with plain blue text.",
    "9245": "row 03, column 00, with blue underlined text.",
    "9246": "row 03, column 00, with plain cyan text.",
    "92c7": "row 03, column 00, with cyan underlined text.",
    "92c8": "row 03, column 00, with plain red text.",
    "9249": "row 03, column 00, with red underlined text.",
    "924a": "row 03, column 00, with plain yellow text.",
    "92cb": "row 03, column 00, with yellow underlined text.",
    "924c": "row 03, column 00, with plain magenta text.",
    "92cd": "row 03, column 00, with magenta underlined text.",
    "92ce": "row 03, column 00, with white italicized text.",
    "924f": "row 03, column 00, with white underlined italicized text.",
    "92d0": "row 03, column 00, with plain white text.",
    "9251": "row 03, column 00, with white underlined text.",
    "9252": "row 03, column 04, with plain white text.",
    "92d3": "row 03, column 04, with white underlined text.",
    "9254": "row 03, column 08, with plain white text.",
    "92d5": "row 03, column 08, with white underlined text.",
    "92d6": "row 03, column 12, with plain white text.",
    "9257": "row 03, column 12, with white underlined text.",
    "9258": "row 03, column 16, with plain white text.",
    "92d9": "row 03, column 16, with white underlined text.",
    "92da": "row 03, column 20, with plain white text.",
    "925b": "row 03, column 20, with white underlined text.",
    "92dc": "row 03, column 24, with plain white text.",
    "925d": "row 03, column 24, with white underlined text.",
    "925e": "row 03, column 28, with plain white text.",
    "92df": "row 03, column 28, with white underlined text.",
    "92e0": "row 04, column 00, with plain white text.",
    "9261": "row 04, column 00, with white underlined text.",
    "9262": "row 04, column 00, with plain green text.",
    "92e3": "row 04, column 00, with green underlined text.",
    "9264": "row 04, column 00, with plain blue text.",
    "92e5": "row 04, column 00, with blue underlined text.",
    "92e6": "row 04, column 00, with plain cyan text.",
    "9267": "row 04, column 00, with cyan underlined text.",
    "9268": "row 04, column 00, with plain red text.",
    "92e9": "row 04, column 00, with red underlined text.",
    "92ea": "row 04, column 00, with plain yellow text.",
    "926b": "row 04, column 00, with yellow underlined text.",
    "92ec": "row 04, column 00, with plain magenta text.",
    "926d": "row 04, column 00, with magenta underlined text.",
    "926e": "row 04, column 00, with white italicized text.",
    "92ef": "row 04, column 00, with white underlined italicized text.",
    "9270": "row 04, column 00, with plain white text.",
    "92f1": "row 04, column 00, with white underlined text.",
    "92f2": "row 04, column 04, with plain white text.",
    "9273": "row 04, column 04, with white underlined text.",
    "92f4": "row 04, column 08, with plain white text.",
    "9275": "row 04, column 08, with white underlined text.",
    "9276": "row 04, column 12, with plain white text.",
    "92f7": "row 04, column 12, with white underlined text.",
    "92f8": "row 04, column 16, with plain white text.",
    "9279": "row 04, column 16, with white underlined text.",
    "927a": "row 04, column 20, with plain white text.",
    "92fb": "row 04, column 20, with white underlined text.",
    "92fc": "row 04, column 24, with plain white text.",
    "92fd": "row 04, column 24, with white underlined text.",
    "92fe": "row 04, column 28, with plain white text.",
    "927f": "row 04, column 28, with white underlined text.",
    "1540": "row 05, column 00, with plain white text.",
    "15c1": "row 05, column 00, with white underlined text.",
    "15c2": "row 05, column 00, with plain green text.",
    "1543": "row 05, column 00, with green underlined text.",
    "15c4": "row 05, column 00, with plain blue text.",
    "1545": "row 05, column 00, with blue underlined text.",
    "1546": "row 05, column 00, with plain cyan text.",
    "15c7": "row 05, column 00, with cyan underlined text.",
    "15c8": "row 05, column 00, with plain red text.",
    "1549": "row 05, column 00, with red underlined text.",
    "154a": "row 05, column 00, with plain yellow text.",
    "15cb": "row 05, column 00, with yellow underlined text.",
    "154c": "row 05, column 00, with plain magenta text.",
    "15cd": "row 05, column 00, with magenta underlined text.",
    "15ce": "row 05, column 00, with white italicized text.",
    "154f": "row 05, column 00, with white underlined italicized text.",
    "15d0": "row 05, column 00, with plain white text.",
    "1551": "row 05, column 00, with white underlined text.",
    "1552": "row 05, column 04, with plain white text.",
    "15d3": "row 05, column 04, with white underlined text.",
    "1554": "row 05, column 08, with plain white text.",
    "15d5": "row 05, column 08, with white underlined text.",
    "15d6": "row 05, column 12, with plain white text.",
    "1557": "row 05, column 12, with white underlined text.",
    "1558": "row 05, column 16, with plain white text.",
    "15d9": "row 05, column 16, with white underlined text.",
    "15da": "row 05, column 20, with plain white text.",
    "155b": "row 05, column 20, with white underlined text.",
    "15dc": "row 05, column 24, with plain white text.",
    "155d": "row 05, column 24, with white underlined text.",
    "155e": "row 05, column 28, with plain white text.",
    "15df": "row 05, column 28, with white underlined text.",
    "15e0": "row 06, column 00, with plain white text.",
    "1561": "row 06, column 00, with white underlined text.",
    "15462": "row 06, column 00, with plain green text.",
    "15e3": "row 06, column 00, with green underlined text.",
    "1564": "row 06, column 00, with plain blue text.",
    "15e5": "row 06, column 00, with blue underlined text.",
    "15e6": "row 06, column 00, with plain cyan text.",
    "1567": "row 06, column 00, with cyan underlined text.",
    "1568": "row 06, column 00, with plain red text.",
    "15e9": "row 06, column 00, with red underlined text.",
    "15ea": "row 06, column 00, with plain yellow text.",
    "156b": "row 06, column 00, with yellow underlined text.",
    "15ec": "row 06, column 00, with plain magenta text.",
    "156d": "row 06, column 00, with magenta underlined text.",
    "156e": "row 06, column 00, with white italicized text.",
    "15ef": "row 06, column 00, with white underlined italicized text.",
    "1570": "row 06, column 00, with plain white text.",
    "15f1": "row 06, column 00, with white underlined text.",
    "15f2": "row 06, column 04, with plain white text.",
    "1573": "row 06, column 04, with white underlined text.",
    "15f4": "row 06, column 08, with plain white text.",
    "1575": "row 06, column 08, with white underlined text.",
    "1576": "row 06, column 12, with plain white text.",
    "15f7": "row 06, column 12, with white underlined text.",
    "15f8": "row 06, column 16, with plain white text.",
    "1579": "row 06, column 16, with white underlined text.",
    "157a": "row 06, column 20, with plain white text.",
    "15fb": "row 06, column 20, with white underlined text.",
    "15fc": "row 06, column 24, with plain white text.",
    "15fd": "row 06, column 24, with white underlined text.",
    "15fe": "row 06, column 28, with plain white text.",
    "157f": "row 06, column 28, with white underlined text.",
    "1640": "row 07, column 00, with plain white text.",
    "16c1": "row 07, column 00, with white underlined text.",
    "16c2": "row 07, column 00, with plain green text.",
    "1643": "row 07, column 00, with green underlined text.",
    "16c4": "row 07, column 00, with plain blue text.",
    "1645": "row 07, column 00, with blue underlined text.",
    "1646": "row 07, column 00, with plain cyan text.",
    "16c7": "row 07, column 00, with cyan underlined text.",
    "16c8": "row 07, column 00, with plain red text.",
    "1649": "row 07, column 00, with red underlined text.",
    "164a": "row 07, column 00, with plain yellow text.",
    "16cb": "row 07, column 00, with yellow underlined text.",
    "164c": "row 07, column 00, with plain magenta text.",
    "16cd": "row 07, column 00, with magenta underlined text.",
    "16ce": "row 07, column 00, with white italicized text.",
    "164f": "row 07, column 00, with white underlined italicized text.",
    "16d0": "row 07, column 00, with plain white text.",
    "1651": "row 07, column 00, with white underlined text.",
    "1652": "row 07, column 04, with plain white text.",
    "16d3": "row 07, column 04, with white underlined text.",
    "1654": "row 07, column 08, with plain white text.",
    "16d5": "row 07, column 08, with white underlined text.",
    "16d6": "row 07, column 12, with plain white text.",
    "1657": "row 07, column 12, with white underlined text.",
    "1658": "row 07, column 16, with plain white text.",
    "16d9": "row 07, column 16, with white underlined text.",
    "16da": "row 07, column 20, with plain white text.",
    "165b": "row 07, column 20, with white underlined text.",
    "16dc": "row 07, column 24, with plain white text.",
    "165d": "row 07, column 24, with white underlined text.",
    "165e": "row 07, column 28, with plain white text.",
    "16df": "row 07, column 28, with white underlined text.",
    "16e0": "row 08, column 00, with plain white text.",
    "1661": "row 08, column 00, with white underlined text.",
    "16462": "row 08, column 00, with plain green text.",
    "16e3": "row 08, column 00, with green underlined text.",
    "1664": "row 08, column 00, with plain blue text.",
    "16e5": "row 08, column 00, with blue underlined text.",
    "16e6": "row 08, column 00, with plain cyan text.",
    "1667": "row 08, column 00, with cyan underlined text.",
    "1668": "row 08, column 00, with plain red text.",
    "16e9": "row 08, column 00, with red underlined text.",
    "16ea": "row 08, column 00, with plain yellow text.",
    "166b": "row 08, column 00, with yellow underlined text.",
    "16ec": "row 08, column 00, with plain magenta text.",
    "166d": "row 08, column 00, with magenta underlined text.",
    "166e": "row 08, column 00, with white italicized text.",
    "16ef": "row 08, column 00, with white underlined italicized text.",
    "1670": "row 08, column 00, with plain white text.",
    "16f1": "row 08, column 00, with white underlined text.",
    "16f2": "row 08, column 04, with plain white text.",
    "1673": "row 08, column 04, with white underlined text.",
    "16f4": "row 08, column 08, with plain white text.",
    "1675": "row 08, column 08, with white underlined text.",
    "1676": "row 08, column 12, with plain white text.",
    "16f7": "row 08, column 12, with white underlined text.",
    "16f8": "row 08, column 16, with plain white text.",
    "1679": "row 08, column 16, with white underlined text.",
    "167a": "row 08, column 20, with plain white text.",
    "16fb": "row 08, column 20, with white underlined text.",
    "16fc": "row 08, column 24, with plain white text.",
    "16fd": "row 08, column 24, with white underlined text.",
    "16fe": "row 08, column 28, with plain white text.",
    "167f": "row 08, column 28, with white underlined text.",
    "9740": "row 09, column 00, with plain white text.",
    "97c1": "row 09, column 00, with white underlined text.",
    "97c2": "row 09, column 00, with plain green text.",
    "9743": "row 09, column 00, with green underlined text.",
    "97c4": "row 09, column 00, with plain blue text.",
    "9745": "row 09, column 00, with blue underlined text.",
    "9746": "row 09, column 00, with plain cyan text.",
    "97c7": "row 09, column 00, with cyan underlined text.",
    "97c8": "row 09, column 00, with plain red text.",
    "9749": "row 09, column 00, with red underlined text.",
    "974a": "row 09, column 00, with plain yellow text.",
    "97cb": "row 09, column 00, with yellow underlined text.",
    "974c": "row 09, column 00, with plain magenta text.",
    "97cd": "row 09, column 00, with magenta underlined text.",
    "97ce": "row 09, column 00, with white italicized text.",
    "974f": "row 09, column 00, with white underlined italicized text.",
    "97d0": "row 09, column 00, with plain white text.",
    "9751": "row 09, column 00, with white underlined text.",
    "9752": "row 09, column 04, with plain white text.",
    "97d3": "row 09, column 04, with white underlined text.",
    "9754": "row 09, column 08, with plain white text.",
    "97d5": "row 09, column 08, with white underlined text.",
    "97d6": "row 09, column 12, with plain white text.",
    "9757": "row 09, column 12, with white underlined text.",
    "9758": "row 09, column 16, with plain white text.",
    "97d9": "row 09, column 16, with white underlined text.",
    "97da": "row 09, column 20, with plain white text.",
    "975b": "row 09, column 20, with white underlined text.",
    "97dc": "row 09, column 24, with plain white text.",
    "975d": "row 09, column 24, with white underlined text.",
    "975e": "row 09, column 28, with plain white text.",
    "97df": "row 09, column 28, with white underlined text.",
    "97e0": "row 10, column 00, with plain white text.",
    "9761": "row 10, column 00, with white underlined text.",
    "9762": "row 10, column 00, with plain green text.",
    "97e3": "row 10, column 00, with green underlined text.",
    "9764": "row 10, column 00, with plain blue text.",
    "97e5": "row 10, column 00, with blue underlined text.",
    "97e6": "row 10, column 00, with plain cyan text.",
    "9767": "row 10, column 00, with cyan underlined text.",
    "9768": "row 10, column 00, with plain red text.",
    "97e9": "row 10, column 00, with red underlined text.",
    "97ea": "row 10, column 00, with plain yellow text.",
    "976b": "row 10, column 00, with yellow underlined text.",
    "97ec": "row 10, column 00, with plain magenta text.",
    "976d": "row 10, column 00, with magenta underlined text.",
    "976e": "row 10, column 00, with white italicized text.",
    "97ef": "row 10, column 00, with white underlined italicized text.",
    "9770": "row 10, column 00, with plain white text.",
    "97f1": "row 10, column 00, with white underlined text.",
    "97f2": "row 10, column 04, with plain white text.",
    "9773": "row 10, column 04, with white underlined text.",
    "97f4": "row 10, column 08, with plain white text.",
    "9775": "row 10, column 08, with white underlined text.",
    "9776": "row 10, column 12, with plain white text.",
    "97f7": "row 10, column 12, with white underlined text.",
    "97f8": "row 10, column 16, with plain white text.",
    "9779": "row 10, column 16, with white underlined text.",
    "977a": "row 10, column 20, with plain white text.",
    "97fb": "row 10, column 20, with white underlined text.",
    "97fc": "row 10, column 24, with plain white text.",
    "97fd": "row 10, column 24, with white underlined text.",
    "97fe": "row 10, column 28, with plain white text.",
    "977f": "row 10, column 28, with white underlined text.",
    "1040": "row 11, column 00, with plain white text.",
    "10c1": "row 11, column 00, with white underlined text.",
    "10c2": "row 11, column 00, with plain green text.",
    "1043": "row 11, column 00, with green underlined text.",
    "10c4": "row 11, column 00, with plain blue text.",
    "1045": "row 11, column 00, with blue underlined text.",
    "1046": "row 11, column 00, with plain cyan text.",
    "10c7": "row 11, column 00, with cyan underlined text.",
    "10c8": "row 11, column 00, with plain red text.",
    "1049": "row 11, column 00, with red underlined text.",
    "104a": "row 11, column 00, with plain yellow text.",
    "10cb": "row 11, column 00, with yellow underlined text.",
    "104c": "row 11, column 00, with plain magenta text.",
    "10cd": "row 11, column 00, with magenta underlined text.",
    "10ce": "row 11, column 00, with white italicized text.",
    "104f": "row 11, column 00, with white underlined italicized text.",
    "10d0": "row 11, column 00, with plain white text.",
    "1051": "row 11, column 00, with white underlined text.",
    "1052": "row 11, column 04, with plain white text.",
    "10d3": "row 11, column 04, with white underlined text.",
    "1054": "row 11, column 08, with plain white text.",
    "10d5": "row 11, column 08, with white underlined text.",
    "10d6": "row 11, column 12, with plain white text.",
    "1057": "row 11, column 12, with white underlined text.",
    "1058": "row 11, column 16, with plain white text.",
    "10d9": "row 11, column 16, with white underlined text.",
    "10da": "row 11, column 20, with plain white text.",
    "105b": "row 11, column 20, with white underlined text.",
    "10dc": "row 11, column 24, with plain white text.",
    "105d": "row 11, column 24, with white underlined text.",
    "105e": "row 11, column 28, with plain white text.",
    "10df": "row 11, column 28, with white underlined text.",
    "1340": "row 12, column 00, with plain white text.",
    "13c1": "row 12, column 00, with white underlined text.",
    "13c2": "row 12, column 00, with plain green text.",
    "1343": "row 12, column 00, with green underlined text.",
    "13c4": "row 12, column 00, with plain blue text.",
    "1345": "row 12, column 00, with blue underlined text.",
    "1346": "row 12, column 00, with plain cyan text.",
    "13c7": "row 12, column 00, with cyan underlined text.",
    "13c8": "row 12, column 00, with plain red text.",
    "1349": "row 12, column 00, with red underlined text.",
    "134a": "row 12, column 00, with plain yellow text.",
    "13cb": "row 12, column 00, with yellow underlined text.",
    "134c": "row 12, column 00, with plain magenta text.",
    "13cd": "row 12, column 00, with magenta underlined text.",
    "13ce": "row 12, column 00, with white italicized text.",
    "134f": "row 12, column 00, with white underlined italicized text.",
    "13d0": "row 12, column 00, with plain white text.",
    "1351": "row 12, column 00, with white underlined text.",
    "1352": "row 12, column 04, with plain white text.",
    "13d3": "row 12, column 04, with white underlined text.",
    "1354": "row 12, column 08, with plain white text.",
    "13d5": "row 12, column 08, with white underlined text.",
    "13d6": "row 12, column 12, with plain white text.",
    "1357": "row 12, column 12, with white underlined text.",
    "1358": "row 12, column 16, with plain white text.",
    "13d9": "row 12, column 16, with white underlined text.",
    "13da": "row 12, column 20, with plain white text.",
    "135b": "row 12, column 20, with white underlined text.",
    "13dc": "row 12, column 24, with plain white text.",
    "135d": "row 12, column 24, with white underlined text.",
    "135e": "row 12, column 28, with plain white text.",
    "13df": "row 12, column 28, with white underlined text.",
    "13e0": "row 13, column 00, with plain white text.",
    "1361": "row 13, column 00, with white underlined text.",
    "13462": "row 13, column 00, with plain green text.",
    "13e3": "row 13, column 00, with green underlined text.",
    "1364": "row 13, column 00, with plain blue text.",
    "13e5": "row 13, column 00, with blue underlined text.",
    "13e6": "row 13, column 00, with plain cyan text.",
    "1367": "row 13, column 00, with cyan underlined text.",
    "1368": "row 13, column 00, with plain red text.",
    "13e9": "row 13, column 00, with red underlined text.",
    "13ea": "row 13, column 00, with plain yellow text.",
    "136b": "row 13, column 00, with yellow underlined text.",
    "13ec": "row 13, column 00, with plain magenta text.",
    "136d": "row 13, column 00, with magenta underlined text.",
    "136e": "row 13, column 00, with white italicized text.",
    "13ef": "row 13, column 00, with white underlined italicized text.",
    "1370": "row 13, column 00, with plain white text.",
    "13f1": "row 13, column 00, with white underlined text.",
    "13f2": "row 13, column 04, with plain white text.",
    "1373": "row 13, column 04, with white underlined text.",
    "13f4": "row 13, column 08, with plain white text.",
    "1375": "row 13, column 08, with white underlined text.",
    "1376": "row 13, column 12, with plain white text.",
    "13f7": "row 13, column 12, with white underlined text.",
    "13f8": "row 13, column 16, with plain white text.",
    "1379": "row 13, column 16, with white underlined text.",
    "137a": "row 13, column 20, with plain white text.",
    "13fb": "row 13, column 20, with white underlined text.",
    "13fc": "row 13, column 24, with plain white text.",
    "13fd": "row 13, column 24, with white underlined text.",
    "13fe": "row 13, column 28, with plain white text.",
    "137f": "row 13, column 28, with white underlined text.",
    "9440": "row 14, column 00, with plain white text.",
    "94c1": "row 14, column 00, with white underlined text.",
    "94c2": "row 14, column 00, with plain green text.",
    "9443": "row 14, column 00, with green underlined text.",
    "94c4": "row 14, column 00, with plain blue text.",
    "9445": "row 14, column 00, with blue underlined text.",
    "9446": "row 14, column 00, with plain cyan text.",
    "94c7": "row 14, column 00, with cyan underlined text.",
    "94c8": "row 14, column 00, with plain red text.",
    "9449": "row 14, column 00, with red underlined text.",
    "944a": "row 14, column 00, with plain yellow text.",
    "94cb": "row 14, column 00, with yellow underlined text.",
    "944c": "row 14, column 00, with plain magenta text.",
    "94cd": "row 14, column 00, with magenta underlined text.",
    "94ce": "row 14, column 00, with white italicized text.",
    "944f": "row 14, column 00, with white underlined italicized text.",
    "94d0": "row 14, column 00, with plain white text.",
    "9451": "row 14, column 00, with white underlined text.",
    "9452": "row 14, column 04, with plain white text.",
    "94d3": "row 14, column 04, with white underlined text.",
    "9454": "row 14, column 08, with plain white text.",
    "94d5": "row 14, column 08, with white underlined text.",
    "94d6": "row 14, column 12, with plain white text.",
    "9457": "row 14, column 12, with white underlined text.",
    "9458": "row 14, column 16, with plain white text.",
    "94d9": "row 14, column 16, with white underlined text.",
    "94da": "row 14, column 20, with plain white text.",
    "945b": "row 14, column 20, with white underlined text.",
    "94dc": "row 14, column 24, with plain white text.",
    "945d": "row 14, column 24, with white underlined text.",
    "945e": "row 14, column 28, with plain white text.",
    "94df": "row 14, column 28, with white underlined text.",
    "94e0": "row 15, column 00, with plain white text.",
    "9461": "row 15, column 00, with white underlined text.",
    "9462": "row 15, column 00, with plain green text.",
    "94e3": "row 15, column 00, with green underlined text.",
    "9464": "row 15, column 00, with plain blue text.",
    "94e5": "row 15, column 00, with blue underlined text.",
    "94e6": "row 15, column 00, with plain cyan text.",
    "9467": "row 15, column 00, with cyan underlined text.",
    "9468": "row 15, column 00, with plain red text.",
    "94e9": "row 15, column 00, with red underlined text.",
    "94ea": "row 15, column 00, with plain yellow text.",
    "946b": "row 15, column 00, with yellow underlined text.",
    "94ec": "row 15, column 00, with plain magenta text.",
    "946d": "row 15, column 00, with magenta underlined text.",
    "946e": "row 15, column 00, with white italicized text.",
    "94ef": "row 15, column 00, with white underlined italicized text.",
    "9470": "row 15, column 00, with plain white text.",
    "94f1": "row 15, column 00, with white underlined text.",
    "94f2": "row 15, column 04, with plain white text.",
    "9473": "row 15, column 04, with white underlined text.",
    "94f4": "row 15, column 08, with plain white text.",
    "9475": "row 15, column 08, with white underlined text.",
    "9476": "row 15, column 12, with plain white text.",
    "94f7": "row 15, column 12, with white underlined text.",
    "94f8": "row 15, column 16, with plain white text.",
    "9479": "row 15, column 16, with white underlined text.",
    "947a": "row 15, column 20, with plain white text.",
    "94fb": "row 15, column 20, with white underlined text.",
    "94fc": "row 15, column 24, with plain white text.",
    "94fd": "row 15, column 24, with white underlined text.",
    "94fe": "row 15, column 28, with plain white text.",
    "947f": "row 15, column 28, with white underlined text.",
    "97a1": "Tab Offset 1 column",
    "97a2": "Tab Offset 2 columns",
    "9723": "Tab Offset 3 columns",
    "94a1": "BackSpace",
    "94a4": "Delete to End of Row",
    "94ad": "Carriage Return",
    "1020": "Background White",
    "10a1": "Background Semi-Transparent White",
    "10a2": "Background Green",
    "1023": "Background Semi-Transparent Green",
    "10a4": "Background Blue",
    "1025": "Background Semi-Transparent Blue",
    "1026": "Background Cyan",
    "10a7": "Background Semi-Transparent Cyan",
    "10a8": "Background Red",
    "1029": "Background Semi-Transparent Red",
    "102a": "Background Yellow",
    "10ab": "Background Semi-Transparent Yellow",
    "102c": "Background Magenta",
    "10ad": "Background Semi-Transparent Magenta",
    "10ae": "Background Black",
    "102f": "Background Semi-Transparent Black",
    "97ad": "Background Transparent",
    "97a4": "Standard Character Set",
    "9725": "Double-Size Character Set",
    "9726": "First Private Character Set",
    "97a7": "Second Private Character Set",
    "97a8": "People`s Republic of China Character Set",
    "9729": "Korean Standard Character Set",
    "972a": "First Registered Character Set",
    "9120": "White Plain",
    "91a1": "White Underline",
    "91a2": "Green Plain",
    "9123": "Green Underline",
    "91a4": "Blue Plain",
    "9125": "Blue Underline",
    "9126": "Cyan Plain",
    "91a7": "Cyan Underline",
    "91a8": "Red Plain",
    "9129": "Red Underline",
    "912a": "Yellow Plain",
    "91ab": "Yellow Underline",
    "912c": "Magenta Plain",
    "91ad": "Magenta Underline",
    "97ae": "Black Plain",
    "972f": "Black Underline",
    "91ae": "Italics",
    "912f": "Italics Underline",
    "94a8": "Flash ON",
    "9423": "Alarm Off",
    "94a2": "Alarm On"
}

SCC_STYLES = ["bold", "italic", "underline", "plain", "underlined italicized"]

ITALICS_COMMANDS = {
    key: COMMAND_LABELS[key] for key in COMMAND_LABELS if "italic" in COMMAND_LABELS[key].lower()
}

UNDERLINE_COMMANDS = {
    key: COMMAND_LABELS[key] for key in COMMAND_LABELS if
    "italic" not in COMMAND_LABELS[key].lower() and
    "underline" in COMMAND_LABELS[key].lower()
}

PLAIN_TEXT_COMMANDS = {
    key: COMMAND_LABELS[key] for key in COMMAND_LABELS if "plain" in COMMAND_LABELS[key].lower()
}

STYLE_SETTING_COMMANDS = {
    **ITALICS_COMMANDS, **UNDERLINE_COMMANDS, **PLAIN_TEXT_COMMANDS
}
