<?php
/**
 * DeleteService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * DeleteService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class DeleteService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation postDelete
     *
     * Delete data
     *
     * @param  \InfluxDB2\Model\DeletePredicateRequest $delete_predicate_request Time range parameters and an optional **delete predicate expression**.  To select points to delete within the specified time range, pass a **delete predicate expression** in the &#x60;predicate&#x60; property of the request body. If you don&#39;t pass a &#x60;predicate&#x60;, InfluxDB deletes all data with timestamps in the specified time range.  #### Related guides  - [Delete data](https://docs.influxdata.com/influxdb/v2.3/write-data/delete-data/). - Learn how to use [delete predicate syntax](https://docs.influxdata.com/influxdb/v2.3/reference/syntax/delete-predicate/). (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org The organization to delete data from. If you pass both &#x60;orgID&#x60; and &#x60;org&#x60;, they must both be valid.  #### InfluxDB Cloud  - Doesn&#39;t require &#x60;org&#x60; or &#x60;orgID&#x60;. - Deletes data from the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. (optional)
     * @param  string $bucket The name or ID of the bucket to delete data from. If you pass both &#x60;bucket&#x60; and &#x60;bucketID&#x60;, &#x60;bucketID&#x60; takes precedence. (optional)
     * @param  string $org_id The ID of the organization to delete data from. If you pass both &#x60;orgID&#x60; and &#x60;org&#x60;, they must both be valid.  #### InfluxDB Cloud  - Doesn&#39;t require &#x60;org&#x60; or &#x60;orgID&#x60;. - Deletes data from the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. (optional)
     * @param  string $bucket_id The ID of the bucket to delete data from. If you pass both &#x60;bucket&#x60; and &#x60;bucketID&#x60;, &#x60;bucketID&#x60; takes precedence. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postDelete($delete_predicate_request, $zap_trace_span = null, $org = null, $bucket = null, $org_id = null, $bucket_id = null)
    {
        $this->postDeleteWithHttpInfo($delete_predicate_request, $zap_trace_span, $org, $bucket, $org_id, $bucket_id);
    }

    /**
     * Operation postDeleteWithHttpInfo
     *
     * Delete data
     *
     * @param  \InfluxDB2\Model\DeletePredicateRequest $delete_predicate_request Time range parameters and an optional **delete predicate expression**.  To select points to delete within the specified time range, pass a **delete predicate expression** in the &#x60;predicate&#x60; property of the request body. If you don&#39;t pass a &#x60;predicate&#x60;, InfluxDB deletes all data with timestamps in the specified time range.  #### Related guides  - [Delete data](https://docs.influxdata.com/influxdb/v2.3/write-data/delete-data/). - Learn how to use [delete predicate syntax](https://docs.influxdata.com/influxdb/v2.3/reference/syntax/delete-predicate/). (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org The organization to delete data from. If you pass both &#x60;orgID&#x60; and &#x60;org&#x60;, they must both be valid.  #### InfluxDB Cloud  - Doesn&#39;t require &#x60;org&#x60; or &#x60;orgID&#x60;. - Deletes data from the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. (optional)
     * @param  string $bucket The name or ID of the bucket to delete data from. If you pass both &#x60;bucket&#x60; and &#x60;bucketID&#x60;, &#x60;bucketID&#x60; takes precedence. (optional)
     * @param  string $org_id The ID of the organization to delete data from. If you pass both &#x60;orgID&#x60; and &#x60;org&#x60;, they must both be valid.  #### InfluxDB Cloud  - Doesn&#39;t require &#x60;org&#x60; or &#x60;orgID&#x60;. - Deletes data from the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. (optional)
     * @param  string $bucket_id The ID of the bucket to delete data from. If you pass both &#x60;bucket&#x60; and &#x60;bucketID&#x60;, &#x60;bucketID&#x60; takes precedence. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postDeleteWithHttpInfo($delete_predicate_request, $zap_trace_span = null, $org = null, $bucket = null, $org_id = null, $bucket_id = null)
    {
        $request = $this->postDeleteRequest($delete_predicate_request, $zap_trace_span, $org, $bucket, $org_id, $bucket_id);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'postDelete'
     *
     * @param  \InfluxDB2\Model\DeletePredicateRequest $delete_predicate_request Time range parameters and an optional **delete predicate expression**.  To select points to delete within the specified time range, pass a **delete predicate expression** in the &#x60;predicate&#x60; property of the request body. If you don&#39;t pass a &#x60;predicate&#x60;, InfluxDB deletes all data with timestamps in the specified time range.  #### Related guides  - [Delete data](https://docs.influxdata.com/influxdb/v2.3/write-data/delete-data/). - Learn how to use [delete predicate syntax](https://docs.influxdata.com/influxdb/v2.3/reference/syntax/delete-predicate/). (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org The organization to delete data from. If you pass both &#x60;orgID&#x60; and &#x60;org&#x60;, they must both be valid.  #### InfluxDB Cloud  - Doesn&#39;t require &#x60;org&#x60; or &#x60;orgID&#x60;. - Deletes data from the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. (optional)
     * @param  string $bucket The name or ID of the bucket to delete data from. If you pass both &#x60;bucket&#x60; and &#x60;bucketID&#x60;, &#x60;bucketID&#x60; takes precedence. (optional)
     * @param  string $org_id The ID of the organization to delete data from. If you pass both &#x60;orgID&#x60; and &#x60;org&#x60;, they must both be valid.  #### InfluxDB Cloud  - Doesn&#39;t require &#x60;org&#x60; or &#x60;orgID&#x60;. - Deletes data from the bucket in the organization associated with the authorization (API token).  #### InfluxDB OSS  - Requires either &#x60;org&#x60; or &#x60;orgID&#x60;. (optional)
     * @param  string $bucket_id The ID of the bucket to delete data from. If you pass both &#x60;bucket&#x60; and &#x60;bucketID&#x60;, &#x60;bucketID&#x60; takes precedence. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postDeleteRequest($delete_predicate_request, $zap_trace_span = null, $org = null, $bucket = null, $org_id = null, $bucket_id = null)
    {
        // verify the required parameter 'delete_predicate_request' is set
        if ($delete_predicate_request === null || (is_array($delete_predicate_request) && count($delete_predicate_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $delete_predicate_request when calling postDelete'
            );
        }

        $resourcePath = '/api/v2/delete';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($org !== null) {
            $queryParams['org'] = ObjectSerializer::toQueryValue($org);
        }
        // query params
        if ($bucket !== null) {
            $queryParams['bucket'] = ObjectSerializer::toQueryValue($bucket);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // query params
        if ($bucket_id !== null) {
            $queryParams['bucketID'] = ObjectSerializer::toQueryValue($bucket_id);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;
        if (isset($delete_predicate_request)) {
            $_tempBody = $delete_predicate_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
