/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.action;

import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class CombineAction
extends AbstractSelectedAction {
    public static final String ID = "edit.combinePaths";
    private CompositeFigure prototype;
    private boolean isCombineAction;

    public CombineAction(DrawingEditor drawingEditor) {
        this(drawingEditor, new SVGPathFigure(true), true);
    }

    public CombineAction(DrawingEditor drawingEditor, SVGPathFigure sVGPathFigure) {
        this(drawingEditor, sVGPathFigure, true);
    }

    public CombineAction(DrawingEditor drawingEditor, SVGPathFigure sVGPathFigure, boolean bl) {
        super(drawingEditor);
        this.prototype = sVGPathFigure;
        this.isCombineAction = bl;
        this.labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.labels.configureAction(this, ID);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.isCombineAction ? this.canGroup() : this.canUngroup());
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean canGroup() {
        boolean bl;
        boolean bl2 = bl = this.getView().getSelectionCount() > 1;
        if (bl) {
            for (Figure figure : this.getView().getSelectedFigures()) {
                if (figure instanceof SVGPathFigure) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    protected boolean canUngroup() {
        return this.getView() != null && this.getView().getSelectionCount() == 1 && this.prototype != null && this.getView().getSelectedFigures().iterator().next().getClass().equals(this.prototype.getClass()) && ((CompositeFigure)this.getView().getSelectedFigures().iterator().next()).getChildCount() > 1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isCombineAction) {
            this.combineActionPerformed(actionEvent);
        } else {
            this.splitActionPerformed(actionEvent);
        }
    }

    public void combineActionPerformed(ActionEvent actionEvent) {
        final DrawingView drawingView = this.getView();
        Drawing drawing = drawingView.getDrawing();
        if (this.canGroup()) {
            Serializable serializable2;
            final List<Figure> list = drawing.sort(drawingView.getSelectedFigures());
            final int[] nArray = new int[list.size()];
            final int[] nArray2 = new int[list.size()];
            int n = 0;
            for (Serializable serializable2 : list) {
                nArray[n] = drawing.indexOf((Figure)serializable2);
                nArray2[n] = ((CompositeFigure)serializable2).getChildCount();
                ++n;
            }
            final CompositeFigure compositeFigure = (CompositeFigure)this.prototype.clone();
            this.combinePaths(drawingView, compositeFigure, list, nArray[0]);
            serializable2 = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    return CombineAction.this.labels.getTextProperty(CombineAction.ID);
                }

                @Override
                public void redo() throws CannotRedoException {
                    super.redo();
                    CombineAction.this.combinePaths(drawingView, compositeFigure, list, nArray[0]);
                }

                @Override
                public void undo() throws CannotUndoException {
                    super.undo();
                    CombineAction.this.splitPath(drawingView, compositeFigure, list, nArray, nArray2);
                }

                @Override
                public boolean addEdit(UndoableEdit undoableEdit) {
                    return super.addEdit(undoableEdit);
                }
            };
            this.fireUndoableEditHappened((UndoableEdit)((Object)serializable2));
        }
    }

    public void splitActionPerformed(ActionEvent actionEvent) {
        final DrawingView drawingView = this.getView();
        Drawing drawing = drawingView.getDrawing();
        if (this.canUngroup()) {
            final CompositeFigure compositeFigure = (CompositeFigure)drawingView.getSelectedFigures().iterator().next();
            final LinkedList<Figure> linkedList = new LinkedList<Figure>();
            final int[] nArray = new int[compositeFigure.getChildCount()];
            final int[] nArray2 = new int[compositeFigure.getChildCount()];
            int n = 0;
            int n2 = drawing.indexOf(compositeFigure);
            for (Figure figure : compositeFigure.getChildren()) {
                SVGPathFigure sVGPathFigure = new SVGPathFigure(true);
                for (Map.Entry<AttributeKey, Object> entry : compositeFigure.getAttributes().entrySet()) {
                    sVGPathFigure.set(entry.getKey(), entry.getValue());
                }
                linkedList.add(sVGPathFigure);
                nArray[n] = n2 + n;
                nArray2[n] = 1;
                ++n;
            }
            this.splitPath(drawingView, compositeFigure, linkedList, nArray, nArray2);
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    return CombineAction.this.labels.getTextProperty("edit.splitPath");
                }

                @Override
                public void redo() throws CannotRedoException {
                    super.redo();
                    CombineAction.this.splitPath(drawingView, compositeFigure, linkedList, nArray, nArray2);
                }

                @Override
                public void undo() throws CannotUndoException {
                    super.undo();
                    CombineAction.this.combinePaths(drawingView, compositeFigure, linkedList, nArray[0]);
                }
            };
            this.fireUndoableEditHappened(abstractUndoableEdit);
        }
    }

    public void splitPath(DrawingView drawingView, CompositeFigure compositeFigure, List<Figure> list, int[] nArray, int[] nArray2) {
        drawingView.clearSelection();
        Iterator iterator = new LinkedList<Figure>(compositeFigure.getChildren()).iterator();
        compositeFigure.basicRemoveAllChildren();
        drawingView.getDrawing().remove(compositeFigure);
        SVGPathFigure sVGPathFigure = (SVGPathFigure)compositeFigure;
        sVGPathFigure.flattenTransform();
        for (int i = 0; i < list.size(); ++i) {
            CompositeFigure compositeFigure2 = (CompositeFigure)list.get(i);
            drawingView.getDrawing().add(nArray[i], compositeFigure2);
            compositeFigure2.willChange();
            for (int j = 0; j < nArray2[i]; ++j) {
                Figure figure = (Figure)iterator.next();
                figure.willChange();
                compositeFigure2.basicAdd(figure);
            }
            compositeFigure2.changed();
        }
        drawingView.addToSelection(list);
    }

    public void combinePaths(DrawingView drawingView, CompositeFigure compositeFigure, Collection<Figure> collection, int n) {
        Cloneable cloneable;
        drawingView.getDrawing().basicRemoveAll(collection);
        drawingView.clearSelection();
        drawingView.getDrawing().add(n, compositeFigure);
        compositeFigure.willChange();
        compositeFigure.basicRemoveAllChildren();
        AffineTransform affineTransform = (AffineTransform)collection.iterator().next().get(SVGAttributeKeys.TRANSFORM);
        for (Figure object : collection) {
            cloneable = (AffineTransform)object.get(SVGAttributeKeys.TRANSFORM);
            if (cloneable == affineTransform || cloneable != null && affineTransform != null && ((AffineTransform)cloneable).equals(affineTransform)) continue;
            affineTransform = null;
            break;
        }
        for (Map.Entry entry : collection.iterator().next().getAttributes().entrySet()) {
            compositeFigure.set((AttributeKey)entry.getKey(), entry.getValue());
        }
        compositeFigure.set(SVGAttributeKeys.TRANSFORM, affineTransform);
        for (Figure figure : collection) {
            cloneable = (SVGPathFigure)figure;
            if (affineTransform == null) {
                ((SVGPathFigure)cloneable).flattenTransform();
            }
            LinkedList<Figure> linkedList = new LinkedList<Figure>(((AbstractCompositeFigure)cloneable).getChildren());
            ((AbstractCompositeFigure)cloneable).basicRemoveAllChildren();
            for (Figure figure2 : linkedList) {
                SVGBezierFigure sVGBezierFigure = (SVGBezierFigure)figure2;
                figure2.willChange();
                compositeFigure.basicAdd(figure2);
            }
        }
        compositeFigure.changed();
        drawingView.addToSelection(compositeFigure);
    }
}

