'''OpenGL extension EXT.pvrtc_sRGB

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.pvrtc_sRGB to provide a more 
Python-friendly API

Overview (from the spec)
	
	The response from electronic display systems given RGB tristimulus values 
	for each pixel is non-linear.  Gamma correction is the process of encoding 
	or decoding images in a manner that will correct for non-linear response 
	profiles of output devices.  The displayed results of gamma-corrected pixel 
	data are more consistent and predictable for the author of such pixel data 
	than it would otherwise be with linearly encoded pixel data.
	
	This EXT_pvrtc_sRGB extension specifies additional tokens for gamma 
	corrected PVRTC compressed sRGB data.  
	
	Texture assets are developed and evaluated for use in OpenGL applications 
	using electronic displays with non-linear responses.  This extension 
	provides a better measure of consistency between textures developed within 
	an asset toolchain and their final rendered result with an OpenGL 
	application that uses those textures.
	
	Conventional OpenGL texture tristimulus values as well as their alpha 
	component are encoded linearly.  The textures introduced by this extension 
	are encoded with gamma correction in the tristimulus components but 
	linearly in the alpha component.
	
	When gamma corrected texture samples are fetched and operated on by ALU 
	operations in an OpenGL shading program those samples will be converted 
	from gamma corrected space to linear space for logical simplicity and 
	performance of the shader.
	
	Texture filtering operations as well as mipmap generation are carried out 
	in linear space.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/pvrtc_sRGB.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.pvrtc_sRGB import *
from OpenGL.raw.GLES2.EXT.pvrtc_sRGB import _EXTENSION_NAME

def glInitPvrtcSrgbEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION