/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa;

import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAKey;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class EdDSAPublicKey
implements EdDSAKey,
PublicKey {
    private static final long serialVersionUID = 9837459837498475L;
    private final GroupElement A;
    private final GroupElement Aneg;
    private final byte[] Abyte;
    private final EdDSAParameterSpec edDsaSpec;
    private static final int OID_OLD = 100;
    private static final int OID_ED25519 = 112;
    private static final int OID_BYTE = 8;
    private static final int IDLEN_BYTE = 3;

    public EdDSAPublicKey(EdDSAPublicKeySpec edDSAPublicKeySpec) {
        this.A = edDSAPublicKeySpec.getA();
        this.Aneg = edDSAPublicKeySpec.getNegativeA();
        this.Abyte = this.A.toByteArray();
        this.edDsaSpec = edDSAPublicKeySpec.getParams();
    }

    public EdDSAPublicKey(X509EncodedKeySpec x509EncodedKeySpec) throws InvalidKeySpecException {
        this(new EdDSAPublicKeySpec(EdDSAPublicKey.decode(x509EncodedKeySpec.getEncoded()), (EdDSAParameterSpec)EdDSANamedCurveTable.getByName("Ed25519")));
    }

    @Override
    public String getAlgorithm() {
        return "EdDSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (!this.edDsaSpec.equals(EdDSANamedCurveTable.getByName("Ed25519"))) {
            return null;
        }
        int n = 12 + this.Abyte.length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        byArray[n2++] = 48;
        byArray[n2++] = (byte)(n - 2);
        byArray[n2++] = 48;
        byArray[n2++] = 5;
        byArray[n2++] = 6;
        byArray[n2++] = 3;
        byArray[n2++] = 43;
        byArray[n2++] = 101;
        byArray[n2++] = 112;
        byArray[n2++] = 3;
        byArray[n2++] = (byte)(1 + this.Abyte.length);
        byArray[n2++] = 0;
        System.arraycopy(this.Abyte, 0, byArray, n2, this.Abyte.length);
        return byArray;
    }

    private static byte[] decode(byte[] byArray) throws InvalidKeySpecException {
        try {
            int n = 44;
            byte by = 5;
            byte by2 = byArray[8];
            if (by2 == 100) {
                n = 47;
                by = 8;
            } else if (by2 == 112) {
                if (byArray[3] == 7) {
                    n = 46;
                    by = 7;
                }
            } else {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            if (byArray.length != n) {
                throw new InvalidKeySpecException("invalid key spec length");
            }
            int n2 = 0;
            if (byArray[n2++] != 48 || byArray[n2++] != n - 2 || byArray[n2++] != 48 || byArray[n2++] != by || byArray[n2++] != 6 || byArray[n2++] != 3 || byArray[n2++] != 43 || byArray[n2++] != 101) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            ++n2;
            if (by2 == 100 ? byArray[n2++] != 10 || byArray[n2++] != 1 || byArray[n2++] != 1 : by == 7 && (byArray[n2++] != 5 || byArray[n2++] != 0)) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            if (byArray[n2++] != 3 || byArray[n2++] != 33 || byArray[n2++] != 0) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            byte[] byArray2 = new byte[32];
            System.arraycopy(byArray, n2, byArray2, 0, 32);
            return byArray2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidKeySpecException(indexOutOfBoundsException);
        }
    }

    @Override
    public EdDSAParameterSpec getParams() {
        return this.edDsaSpec;
    }

    public GroupElement getA() {
        return this.A;
    }

    public GroupElement getNegativeA() {
        return this.Aneg;
    }

    public byte[] getAbyte() {
        return this.Abyte;
    }

    public int hashCode() {
        return Arrays.hashCode(this.Abyte);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EdDSAPublicKey)) {
            return false;
        }
        EdDSAPublicKey edDSAPublicKey = (EdDSAPublicKey)object;
        return Arrays.equals(this.Abyte, edDSAPublicKey.getAbyte()) && this.edDsaSpec.equals(edDSAPublicKey.getParams());
    }
}

