;;; czech.el --- Quail package for inputting Czech -*-coding: iso-2022-7bit;-*-

;; Copyright (C) 1998, 2001, 2006  Free Software Foundation, Inc.
;; Copyright (C) 2010 Richard Zidlicky

;; Author: Milan Zamazal <pdm@zamazal.org>
;; Maintainer: Pavel Jan,Bm(Bk <Pavel@Janik.cz>
;; Keywords: i18n, multilingual, input method, Czech

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Synched up with: FSF 22.0.50.6

;;; Commentary:

;; This file defines the following Czech keyboards:
;; - "standard" Czech keyboard in the Windows NT 105 keys version (both
;;   "QWERTZ" and "QWERTY" versions)
;; - three non-standard Czech keyboards for programmers

;;; Code:

(require 'quail)


(quail-define-package
 "czech" "Czech" "CZ" t
 "\"Standard\" Czech keyboard in the Windows NT 105 keys version."
 nil t t t t nil nil nil nil nil t)

(quail-define-rules
 ("1" ?+)
 ("2" ?,Bl(B)
 ("3" ?,B9(B)
 ("4" ?,Bh(B)
 ("5" ?,Bx(B)
 ("6" ?,B>(B)
 ("7" ?,B}(B)
 ("8" ?,Ba(B)
 ("9" ?,Bm(B)
 ("0" ?,Bi(B)
 ("!" ?1)
 ("@" ?2)
 ("#" ?3)
 ("$" ?4)
 ("%" ?5)
 ("^" ?6)
 ("&" ?7)
 ("*" ?8)
 ("(" ?9)
 (")" ?0)
 ("-" ?=)
 ("_" ?%)
 ("[" ?,Bz(B)
 ("{" ?/)
 ("]" ?\))
 ("}" ?\()
 ("|" ?`)
 (";" ?,By(B)
 (":" ?\")
 ("'" ?,B'(B)
 ("\"" ?!)
 ("<" ??)
 (">" ?:)
 ("/" ?-)
 ("?" ?_)
 ("`" ?\;)
 ("y" ?z)
 ("z" ?y)
 ("Y" ?Z)
 ("Z" ?Y)
 ("\\a" ?,Bd(B)
 ("\\o" ?,Bv(B)
 ("\\s" ?,B_(B)
 ("\\u" ?,B|(B)
 ("\\A" ?,BD(B)
 ("\\O" ?,BV(B)
 ("\\S" ?,B_(B)
 ("\\U" ?,B\(B)
 ("~u" ?,By(B)
 ("~U" ?,BY(B)
 ("=a" ?,Ba(B)
 ("+c" ?,Bh(B)
 ("+d" ?,Bo(B)
 ("=e" ?,Bi(B)
 ("+e" ?,Bl(B)
 ("=i" ?,Bm(B)
 ("+n" ?,Br(B)
 ("=o" ?,Bs(B)
 ("+r" ?,Bx(B)
 ("+s" ?,B9(B)
 ("+t" ?,B;(B)
 ("=u" ?,Bz(B)
 ("=z" ?,B}(B)
 ("+y" ?,B>(B)
 ("=A" ?,BA(B)
 ("+C" ?,BH(B)
 ("+D" ?,BO(B)
 ("=E" ?,BI(B)
 ("+E" ?,BL(B)
 ("=I" ?,BM(B)
 ("+N" ?,BR(B)
 ("=O" ?,BS(B)
 ("+R" ?,BX(B)
 ("+S" ?,B)(B)
 ("+T" ?,B+(B)
 ("=U" ?,BZ(B)
 ("=Z" ?,B](B)
 ("+Y" ?,B.(B)
 ("=1" ?!)
 ("=2" ?@)
 ("=3" ?#)
 ("=4" ?$)
 ("=5" ?%)
 ("=6" ?^)
 ("=7" ?&)
 ("=8" ?*)
 ("=9" ?\()
 ("=0" ?\))
 ("+1" ?!)
 ("+2" ?@)
 ("+3" ?#)
 ("+4" ?$)
 ("+5" ?%)
 ("+6" ?^)
 ("+7" ?&)
 ("+8" ?*)
 ("+9" ?\()
 ("+0" ?\))
 ("=<" ?<)
 ("=>" ?>)
 ("=[" ?\[)
 ("=]" ?\])
 ("={" ?{)
 ("=}" ?})
 ([kp-1] ?1)
 ([kp-2] ?2)
 ([kp-3] ?3)
 ([kp-4] ?4)
 ([kp-5] ?5)
 ([kp-6] ?6)
 ([kp-7] ?7)
 ([kp-8] ?8)
 ([kp-9] ?9)
 ([kp-0] ?0)
 ([kp-add] ?+))

(quail-define-package
 "czech-qwerty" "Czech" "CZ" t
 "\"Standard\" Czech keyboard in the Windows NT 105 keys version, QWERTY layout."
 nil t nil nil t nil nil nil nil nil t)

(quail-define-rules
 ("1" ?+)
 ("2" ?,Bl(B)
 ("3" ?,B9(B)
 ("4" ?,Bh(B)
 ("5" ?,Bx(B)
 ("6" ?,B>(B)
 ("7" ?,B}(B)
 ("8" ?,Ba(B)
 ("9" ?,Bm(B)
 ("0" ?,Bi(B)
 ("!" ?1)
 ("@" ?2)
 ("#" ?3)
 ("$" ?4)
 ("%" ?5)
 ("^" ?6)
 ("&" ?7)
 ("*" ?8)
 ("(" ?9)
 (")" ?0)
 ("-" ?=)
 ("_" ?%)
 ("[" ?,Bz(B)
 ("{" ?/)
 ("]" ?\))
 ("}" ?\()
 ("|" ?`)
 (";" ?,By(B)
 (":" ?\")
 ("'" ?,B'(B)
 ("\"" ?!)
 ("<" ??)
 (">" ?:)
 ("/" ?-)
 ("?" ?_)
 ("`" ?\;)
 ("\\a" ?,Bd(B)
 ("\\o" ?,Bv(B)
 ("\\s" ?,B_(B)
 ("\\u" ?,B|(B)
 ("\\A" ?,BD(B)
 ("\\O" ?,BV(B)
 ("\\S" ?,B_(B)
 ("\\U" ?,B\(B)
 ("~u" ?,By(B)
 ("~U" ?,BY(B)
 ("=a" ?,Ba(B)
 ("+c" ?,Bh(B)
 ("+d" ?,Bo(B)
 ("=e" ?,Bi(B)
 ("+e" ?,Bl(B)
 ("=i" ?,Bm(B)
 ("+n" ?,Br(B)
 ("=o" ?,Bs(B)
 ("+r" ?,Bx(B)
 ("+s" ?,B9(B)
 ("+t" ?,B;(B)
 ("=u" ?,Bz(B)
 ("=y" ?,B}(B)
 ("+z" ?,B>(B)
 ("=A" ?,BA(B)
 ("+C" ?,BH(B)
 ("+D" ?,BO(B)
 ("=E" ?,BI(B)
 ("+E" ?,BL(B)
 ("=I" ?,BM(B)
 ("+N" ?,BR(B)
 ("=O" ?,BS(B)
 ("+R" ?,BX(B)
 ("+S" ?,B)(B)
 ("+T" ?,B+(B)
 ("=Y" ?,B](B)
 ("+Z" ?,B.(B)
 ("=U" ?,BZ(B)
 ("=1" ?!)
 ("=2" ?@)
 ("=3" ?#)
 ("=4" ?$)
 ("=5" ?%)
 ("=6" ?^)
 ("=7" ?&)
 ("=8" ?*)
 ("=9" ?\()
 ("=0" ?\))
 ("+1" ?!)
 ("+2" ?@)
 ("+3" ?#)
 ("+4" ?$)
 ("+5" ?%)
 ("+6" ?^)
 ("+7" ?&)
 ("+8" ?*)
 ("+9" ?\()
 ("+0" ?\))
 ("=<" ?<)
 ("=>" ?>)
 ("=[" ?\[)
 ("=]" ?\])
 ("={" ?{)
 ("=}" ?})
 ([kp-1] ?1)
 ([kp-2] ?2)
 ([kp-3] ?3)
 ([kp-4] ?4)
 ([kp-5] ?5)
 ([kp-6] ?6)
 ([kp-7] ?7)
 ([kp-8] ?8)
 ([kp-9] ?9)
 ([kp-0] ?0)
 ([kp-add] ?+))

(quail-define-package
 "czech-prog-1" "Czech" "CZ" t
 "Czech (non-standard) keyboard for programmers #1.

All digits except of `1' are replaced by Czech characters as on the standard
Czech keyboard.
`1' is replaced by `+'.
`+' is a dead key.  Multiple presses of the dead key generate various accents.
All other keys are the same as on standard US keyboard."
 nil t nil nil t nil nil nil nil nil t)

(quail-define-rules
 ("1" ?+)
 ("2" ?,Bl(B)
 ("3" ?,B9(B)
 ("4" ?,Bh(B)
 ("5" ?,Bx(B)
 ("6" ?,B>(B)
 ("7" ?,B}(B)
 ("8" ?,Ba(B)
 ("9" ?,Bm(B)
 ("0" ?,Bi(B)
 ("+1" ?1)
 ("+2" ?2)
 ("+3" ?3)
 ("+4" ?4)
 ("+5" ?5)
 ("+6" ?6)
 ("+7" ?7)
 ("+8" ?8)
 ("+9" ?9)
 ("+0" ?0)
 ("+a" ?,Ba(B)
 ("++a" ?,Bd(B)
 ("+c" ?,Bh(B)
 ("+d" ?,Bo(B)
 ("+e" ?,Bi(B)
 ("++e" ?,Bl(B)
 ("+i" ?,Bm(B)
 ("+l" ?,Be(B)
 ("++l" ?,B5(B)
 ("+n" ?,Br(B)
 ("+o" ?,Bs(B)
 ("++o" ?,Bv(B)
 ("+++o" ?,Bt(B)
 ("+r" ?,Bx(B)
 ("++r" ?,B`(B)
 ("+s" ?,B9(B)
 ("++s" ?,B_(B)
 ("+t" ?,B;(B)
 ("+u" ?,Bz(B)
 ("++u" ?,By(B)
 ("+++u" ?,B|(B)
 ("+y" ?,B}(B)
 ("+z" ?,B>(B)
 ("+A" ?,BA(B)
 ("++A" ?,BD(B)
 ("+C" ?,BH(B)
 ("+D" ?,BO(B)
 ("+E" ?,BI(B)
 ("++E" ?,BL(B)
 ("+I" ?,BM(B)
 ("+L" ?,BE(B)
 ("++L" ?,B%(B)
 ("+N" ?,BR(B)
 ("+O" ?,BS(B)
 ("++O" ?,BV(B)
 ("+++O" ?,BT(B)
 ("+R" ?,BX(B)
 ("++R" ?,B@(B)
 ("+S" ?,B)(B)
 ("++S" ?,B_(B)
 ("+T" ?,B+(B)
 ("+U" ?,BZ(B)
 ("++U" ?,BY(B)
 ("+++U" ?,B\(B)
 ("+Y" ?,B](B)
 ("+Z" ?,B.(B)
 ([kp-1] ?1)
 ([kp-2] ?2)
 ([kp-3] ?3)
 ([kp-4] ?4)
 ([kp-5] ?5)
 ([kp-6] ?6)
 ([kp-7] ?7)
 ([kp-8] ?8)
 ([kp-9] ?9)
 ([kp-0] ?0)
 ([kp-add] ?+))

(quail-define-package
 "czech-prog-2" "Czech" "CZ" t
 "Czech (non-standard) keyboard for programmers #2.

All digits except of `1' are replaced by Czech characters as on the standard
Czech keyboard.
`1' is replaced by `,By(B'.
`+' is a dead key.  Multiple presses of the dead key generate various accents.
All other keys are the same as on standard US keyboard."
 nil t nil nil t nil nil nil nil nil t)

(quail-define-rules
 ("1" ?,By(B)
 ("2" ?,Bl(B)
 ("3" ?,B9(B)
 ("4" ?,Bh(B)
 ("5" ?,Bx(B)
 ("6" ?,B>(B)
 ("7" ?,B}(B)
 ("8" ?,Ba(B)
 ("9" ?,Bm(B)
 ("0" ?,Bi(B)
 ("+1" ?1)
 ("+2" ?2)
 ("+3" ?3)
 ("+4" ?4)
 ("+5" ?5)
 ("+6" ?6)
 ("+7" ?7)
 ("+8" ?8)
 ("+9" ?9)
 ("+0" ?0)
 ("+a" ?,Ba(B)
 ("++a" ?,Bd(B)
 ("+c" ?,Bh(B)
 ("+d" ?,Bo(B)
 ("+e" ?,Bi(B)
 ("++e" ?,Bl(B)
 ("+i" ?,Bm(B)
 ("+l" ?,Be(B)
 ("++l" ?,B5(B)
 ("+n" ?,Br(B)
 ("+o" ?,Bs(B)
 ("++o" ?,Bv(B)
 ("+++o" ?,Bt(B)
 ("+r" ?,Bx(B)
 ("++r" ?,B`(B)
 ("+s" ?,B9(B)
 ("++s" ?,B_(B)
 ("+t" ?,B;(B)
 ("+u" ?,Bz(B)
 ("++u" ?,By(B)
 ("+++u" ?,B|(B)
 ("+y" ?,B}(B)
 ("+z" ?,B>(B)
 ("+A" ?,BA(B)
 ("++A" ?,BD(B)
 ("+C" ?,BH(B)
 ("+D" ?,BO(B)
 ("+E" ?,BI(B)
 ("++E" ?,BL(B)
 ("+I" ?,BM(B)
 ("+L" ?,BE(B)
 ("++L" ?,B%(B)
 ("+N" ?,BR(B)
 ("+O" ?,BS(B)
 ("++O" ?,BV(B)
 ("+++O" ?,BT(B)
 ("+R" ?,BX(B)
 ("++R" ?,B@(B)
 ("+S" ?,B)(B)
 ("++S" ?,B_(B)
 ("+T" ?,B+(B)
 ("+U" ?,BZ(B)
 ("++U" ?,BY(B)
 ("+++U" ?,B\(B)
 ("+Y" ?,B](B)
 ("+Z" ?,B.(B)
 ([kp-1] ?1)
 ([kp-2] ?2)
 ([kp-3] ?3)
 ([kp-4] ?4)
 ([kp-5] ?5)
 ([kp-6] ?6)
 ([kp-7] ?7)
 ([kp-8] ?8)
 ([kp-9] ?9)
 ([kp-0] ?0)
 ([kp-add] ?+))

(quail-define-package
 "czech-prog-3" "Czech" "CZ" t
 "Czech (non-standard) keyboard for programmers compatible with the default
keyboard from the obsolete `emacs-czech' package.

All digits except of `1' are replaced by Czech characters as on the standard
Czech keyboard.
`[' and `]' are replaced with `,Bz(B' and `,By(B', respectively.
There are two dead keys on `=' and `+'.  Characters with diaresis are
accessible through `+='.
All other keys are the same as on standard US keyboard."
 nil t nil nil t nil nil nil nil nil t)

(quail-define-rules
 ("2" ?,Bl(B)
 ("3" ?,B9(B)
 ("4" ?,Bh(B)
 ("5" ?,Bx(B)
 ("6" ?,B>(B)
 ("7" ?,B}(B)
 ("8" ?,Ba(B)
 ("9" ?,Bm(B)
 ("0" ?,Bi(B)
 ("[" ?,Bz(B)
 ("]" ?,By(B)
 ("==" ?=)
 ("++" ?+)
 ("=+" ?+)
 ("=[" ?\[)
 ("=]" ?\])
 ("+[" ?\[)
 ("+]" ?\])
 ("=1" ?1)
 ("=2" ?2)
 ("=3" ?3)
 ("=4" ?4)
 ("=5" ?5)
 ("=6" ?6)
 ("=7" ?7)
 ("=8" ?8)
 ("=9" ?9)
 ("=0" ?0)
 ("+1" ?1)
 ("+2" ?2)
 ("+3" ?3)
 ("+4" ?4)
 ("+5" ?5)
 ("+6" ?6)
 ("+7" ?7)
 ("+8" ?8)
 ("+9" ?9)
 ("+0" ?0)
 ("=A" ?,BA(B)
 ("+A" ?,BD(B)
 ("+=A" ?,BD(B)
 ("+C" ?,BH(B)
 ("+D" ?,BO(B)
 ("=E" ?,BI(B)
 ("+E" ?,BL(B)
 ("=I" ?,BM(B)
 ("=L" ?,B%(B)
 ("+L" ?,BE(B)
 ("+N" ?,BR(B)
 ("=O" ?,BS(B)
 ("+O" ?,BT(B)
 ("+=O" ?,BV(B)
 ("=R" ?,B@(B)
 ("+R" ?,BX(B)
 ("+S" ?,B)(B)
 ("=S" ?,B_(B)
 ("+T" ?,B+(B)
 ("=U" ?,BZ(B)
 ("+U" ?,BY(B)
 ("+=U" ?,B\(B)
 ("=Y" ?,B](B)
 ("+Z" ?,B.(B)
 ("=a" ?,Ba(B)
 ("+a" ?,Bd(B)
 ("+=a" ?,Bd(B)
 ("+c" ?,Bh(B)
 ("+d" ?,Bo(B)
 ("=e" ?,Bi(B)
 ("+e" ?,Bl(B)
 ("=i" ?,Bm(B)
 ("=l" ?,B5(B)
 ("+l" ?,Be(B)
 ("+n" ?,Br(B)
 ("=o" ?,Bs(B)
 ("+o" ?,Bt(B)
 ("+=o" ?,Bv(B)
 ("=r" ?,B`(B)
 ("+r" ?,Bx(B)
 ("+s" ?,B9(B)
 ("=s" ?,B_(B)
 ("+t" ?,B;(B)
 ("=u" ?,Bz(B)
 ("+u" ?,By(B)
 ("+=u" ?,B|(B)
 ("=y" ?,B}(B)
 ("+z" ?,B>(B)
 ([kp-1] ?1)
 ([kp-2] ?2)
 ([kp-3] ?3)
 ([kp-4] ?4)
 ([kp-5] ?5)
 ([kp-6] ?6)
 ([kp-7] ?7)
 ([kp-8] ?8)
 ([kp-9] ?9)
 ([kp-0] ?0)
 ([kp-add] ?+))

;; XEmacs change; czech-translit from Richard Zidlicky

;; enter Czech accented keys by combination of ASCII letters.
;; Works well because the used double letter combinations are very rare
;; - with the exception of "ie" which is frequent in words of foreign origin.
;; To deal with foreign words and names it is essential to have toggle-input-method
;; bound to a very convenient key

(quail-define-package
 "czech-translit" "Czech" "cz-tr" t   ; name, language, title guidance
 "Intuitively transliterated keyboard layout for Czech:
    aa -> ,Aa(B, ee -> ,Ai(B, AA -> ,AA(B ...
    cc -> ,Bh(B, rr -> ,Bx(B , tt -> ,B;(B ...
    nj -> ,Br(B, dj -> ,Bo(B
    ie -> ,Bl(B
    uu -> ,Az(B
    uo -> ,By(B
exceptions and strange cases:
    iee -> i,Ai(B
    iie -> ie
    eee -> ee
other
    iii -> i
"
  nil t     ; translation-keys, forget-last-selection
  t t       ; deterministic,  kbd-translate 
  t nil     ; show-layout, create-decode-map
  nil nil   ; maximum-shortest (non-greedy), overlay-plist
  nil nil   ; update-translation-function, conversion-keys
  t         ; simple
)

(quail-define-rules
 ("aa" ?,Aa(B)
 ("ee" ?,Ai(B)
 ("eee" ["ee"])
 ("ii" ?,Am(B)
 ("ie" ?,Bl(B)
 ("iee" ["i,Ai(B"])
 ("iie" ["ie"])
 ("iii" ?i)
 ("oo" ?,As(B)
 ("uu" ?,Az(B)
 ("uo" ?,By(B)
 ("yy" ?,A}(B)
 ("AA" ?,AA(B)
 ("EE" ?,AI(B)
 ("II" ?,AM(B)
 ("III" ?,AM(B)
 ("OO" ?,AS(B)
 ("UU" ?,AZ(B)
 ("YY" ?,A](B)
 ("cc" ?,Bh(B)
 ("dj" ?,Bo(B)
 ("nj" ?,Br(B)
 ("rr" ?,Bx(B)
 ("ss" ?,B9(B)
 ("tt" ?,B;(B)
 ("zz" ?,B>(B)
 ("CC" ?,BH(B)
 ("DJ" ?,BO(B)
 ("NJ" ?,BR(B)
 ("RR" ?,BX(B)
 ("SS" ?,B)(B)
 ("TT" ?,B+(B)
 ("ZZ" ?,B.(B)
 ("IE" ?,BL(B)
)

;;; arch-tag: 0a27dffc-a5e1-479f-9da2-a9eb91b34d8a
;;; czech.el ends here
