/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.containerengine.model.CreateClusterKubeconfigContentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateKubeconfigRequest
extends BmcRequest<CreateClusterKubeconfigContentDetails> {
    private String clusterId;
    private String opcRequestId;
    private CreateClusterKubeconfigContentDetails createClusterKubeconfigContentDetails;

    public String getClusterId() {
        return this.clusterId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public CreateClusterKubeconfigContentDetails getCreateClusterKubeconfigContentDetails() {
        return this.createClusterKubeconfigContentDetails;
    }

    @InternalSdk
    public CreateClusterKubeconfigContentDetails getBody$() {
        return this.createClusterKubeconfigContentDetails;
    }

    public Builder toBuilder() {
        return new Builder().clusterId(this.clusterId).opcRequestId(this.opcRequestId).createClusterKubeconfigContentDetails(this.createClusterKubeconfigContentDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",clusterId=").append(String.valueOf(this.clusterId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",createClusterKubeconfigContentDetails=").append(String.valueOf((Object)this.createClusterKubeconfigContentDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateKubeconfigRequest)) {
            return false;
        }
        CreateKubeconfigRequest other = (CreateKubeconfigRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.clusterId, other.clusterId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.createClusterKubeconfigContentDetails, (Object)other.createClusterKubeconfigContentDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.clusterId == null ? 43 : this.clusterId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.createClusterKubeconfigContentDetails == null ? 43 : this.createClusterKubeconfigContentDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateKubeconfigRequest, CreateClusterKubeconfigContentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String clusterId = null;
        private String opcRequestId = null;
        private CreateClusterKubeconfigContentDetails createClusterKubeconfigContentDetails = null;

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder createClusterKubeconfigContentDetails(CreateClusterKubeconfigContentDetails createClusterKubeconfigContentDetails) {
            this.createClusterKubeconfigContentDetails = createClusterKubeconfigContentDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateKubeconfigRequest o) {
            this.clusterId(o.getClusterId());
            this.opcRequestId(o.getOpcRequestId());
            this.createClusterKubeconfigContentDetails(o.getCreateClusterKubeconfigContentDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateKubeconfigRequest build() {
            CreateKubeconfigRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateClusterKubeconfigContentDetails body) {
            this.createClusterKubeconfigContentDetails(body);
            return this;
        }

        public CreateKubeconfigRequest buildWithoutInvocationCallback() {
            CreateKubeconfigRequest request = new CreateKubeconfigRequest();
            request.clusterId = this.clusterId;
            request.opcRequestId = this.opcRequestId;
            request.createClusterKubeconfigContentDetails = this.createClusterKubeconfigContentDetails;
            return request;
        }
    }
}

