/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.dev.wizard.WebServiceFromWSDLPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;

public class WebServiceFromWSDL
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor>,
WizardDescriptor.ValidatingPanel<WizardDescriptor>,
ChangeListener {
    private WebServiceFromWSDLPanel component;
    private WizardDescriptor wizardDescriptor;
    private Project project;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public WebServiceFromWSDL(WizardDescriptor wizardDescriptor, Project project) {
        this.wizardDescriptor = wizardDescriptor;
        this.project = project;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new WebServiceFromWSDLPanel(this.project);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        HelpCtx helpCtx = null;
        if (this.getComponent() != null && (helpCtx = this.component.getHelpCtx()) != null) {
            return helpCtx;
        }
        return new HelpCtx(WebServiceFromWSDL.class);
    }

    public void readSettings(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        this.component.read(this.wizardDescriptor);
        Object substitute = this.component.getClientProperty("NewProjectWizard_Title");
        if (substitute != null) {
            this.wizardDescriptor.putProperty("NewProjectWizard_Title", substitute);
        }
    }

    public void storeSettings(WizardDescriptor settings) {
        this.component.store(settings);
        settings.putProperty("NewProjectWizard_Title", null);
    }

    public boolean isValid() {
        this.getComponent();
        return this.component.isValid(this.wizardDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    public void validate() throws WizardValidationException {
        this.component.validate(this.wizardDescriptor);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    private void fireChange() {
        Mutex.EVENT.readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ChangeEvent e = new ChangeEvent(this);
                WebServiceFromWSDL webServiceFromWSDL = WebServiceFromWSDL.this;
                synchronized (webServiceFromWSDL) {
                    Iterator it = WebServiceFromWSDL.this.listeners.iterator();
                    while (it.hasNext()) {
                        ((ChangeListener)it.next()).stateChanged(e);
                    }
                }
            }
        });
    }
}

