/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.svg;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.parser.ElementLoader;
import com.github.weisj.jsvg.parser.LoaderContext;
import com.github.weisj.jsvg.parser.ResourceLoader;
import com.github.weisj.jsvg.parser.SVGLoader;
import com.github.weisj.jsvg.renderer.awt.NullPlatformSupport;
import com.github.weisj.jsvg.renderer.awt.PlatformSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.openide.util.CachedHiDPIIcon;
import org.openide.util.Parameters;
import org.openide.util.svg.DenyingElementLoader;

final class SVGIcon
extends CachedHiDPIIcon {
    private static final Logger LOG = Logger.getLogger(SVGIcon.class.getName());
    private static final int MAX_DIMENSION_PIXELS = 8192;
    private static final ThreadLocal<SVGLoader> SVG_LOADER = new ThreadLocal<SVGLoader>(){

        @Override
        protected SVGLoader initialValue() {
            return new SVGLoader();
        }
    };
    private final URL url;
    private WeakReference<SVGDocument> svgDocumentWeakRef;
    private SVGDocument svgDocumentStrongRef;

    private SVGIcon(URL url, SVGDocument initialSVGDocument, int width, int height) {
        super(width, height);
        Parameters.notNull((CharSequence)"url", (Object)url);
        Parameters.notNull((CharSequence)"initialSVGDocument", (Object)initialSVGDocument);
        this.url = url;
        this.svgDocumentStrongRef = initialSVGDocument;
        this.svgDocumentWeakRef = new WeakReference<SVGDocument>(initialSVGDocument);
    }

    public static Icon load(URL url) throws IOException {
        Parameters.notNull((CharSequence)"url", (Object)url);
        Dimension size = new Dimension();
        SVGDocument initialSVGDocument = SVGIcon.loadSVGDocument(url, size);
        return new SVGIcon(url, initialSVGDocument, size.width, size.height);
    }

    private synchronized SVGDocument getSVGDocument() throws IOException {
        SVGDocument ret = (SVGDocument)this.svgDocumentWeakRef.get();
        if (ret != null) {
            this.svgDocumentStrongRef = null;
            return ret;
        }
        ret = SVGIcon.loadSVGDocument(this.url, null);
        this.svgDocumentWeakRef = new WeakReference<SVGDocument>(ret);
        return ret;
    }

    private static SVGDocument loadSVGDocument(URL url, Dimension toSize) throws IOException {
        FloatSize documentSize;
        SVGDocument svgDocument;
        Parameters.notNull((CharSequence)"url", (Object)url);
        try (InputStream is = url.openStream();){
            ArrayList externalResourceExceptions = new ArrayList();
            ResourceLoader resourceLoader = nnuri -> {
                IOException e = new IOException("External resource loading from SVG file not permitted (" + nnuri + " from " + url + ")");
                externalResourceExceptions.add(e);
                throw e;
            };
            DenyingElementLoader elementLoader = new DenyingElementLoader();
            svgDocument = SVG_LOADER.get().load(is, null, LoaderContext.builder().resourceLoader(resourceLoader).elementLoader((ElementLoader)elementLoader).build());
            if (!elementLoader.getAttemptedExternalURLsLoaded().isEmpty()) {
                throw new IOException("SVG loading failed; external document loading prohibited (" + elementLoader.getAttemptedExternalURLsLoaded() + ")");
            }
            if (!externalResourceExceptions.isEmpty()) {
                IOException e = new IOException("SVG loading failed due to disallowed external resources");
                for (IOException e2 : externalResourceExceptions) {
                    e.addSuppressed(e2);
                }
                throw e;
            }
            if (svgDocument == null) {
                throw new IOException("SVG loading failed for " + url + " (SVGLoader.load returned null)");
            }
            documentSize = svgDocument.size();
        }
        if (toSize != null) {
            int width = (int)Math.ceil(documentSize.getWidth());
            int height = (int)Math.ceil(documentSize.getHeight());
            int widthLimited = Math.min(8192, width);
            int heightLimited = Math.min(8192, height);
            if (width != widthLimited || height != heightLimited) {
                LOG.log(Level.WARNING, "SVG image {0} too large (dimensions were {1}x{2}, each side can be at most {3}px)", new Object[]{url, width, height, 8192});
            } else if (width <= 1 && height <= 1) {
                LOG.log(Level.WARNING, "SVG image {0} did not specify a width/height, or is incorrectly sized", url);
            }
            toSize.width = widthLimited;
            toSize.height = heightLimited;
        }
        return svgDocument;
    }

    private static RenderingHints createHints() {
        LinkedHashMap<RenderingHints.Key, Object> hints = new LinkedHashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        return new RenderingHints(hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image createAndPaintImage(Component c, ColorModel colorModel, int deviceWidth, int deviceHeight, double scale) {
        BufferedImage img = SVGIcon.createBufferedImage((ColorModel)colorModel, (int)deviceWidth, (int)deviceHeight);
        Graphics2D g = img.createGraphics();
        try {
            g.scale(scale, scale);
            try {
                SVGDocument svgDocument = this.getSVGDocument();
                g.addRenderingHints(SVGIcon.createHints());
                svgDocument.renderWithPlatform((PlatformSupport)NullPlatformSupport.INSTANCE, g, null);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unexpected exception while re-loading an SVG file that previously loaded successfully", e);
            }
        }
        finally {
            g.dispose();
        }
        return img;
    }
}

