/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.csl.spi.ErrorFilter;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.api.gsf.ErrorBadgingRule;
import org.netbeans.modules.html.editor.api.gsf.HtmlErrorFilterContext;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.hints.HtmlHintsProvider;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.WebPageMetadata;
import org.openide.filesystems.FileObject;

public class HtmlErrorFilter
implements ErrorFilter {
    public static final String DISABLE_ERROR_CHECKS_KEY = "disable_error_checking";
    private static final ErrorFilter INSTANCE = new HtmlErrorFilter(false);
    private static final ErrorFilter INSTANCE_BADGING = new HtmlErrorFilter(true);
    private HintsProvider htmlHintsProvider = new HtmlHintsProvider();
    private HintsProvider.HintsManager htmlHintsManager = HintsProvider.HintsManager.getManagerForMimeType((String)"text/html");
    private boolean onlyBadges;

    private HtmlErrorFilter(boolean badging) {
        this();
        this.onlyBadges = badging;
    }

    public HtmlErrorFilter() {
    }

    public List<? extends Error> filter(ParserResult parserResult) {
        if (!(parserResult instanceof HtmlParserResult)) {
            return null;
        }
        HtmlErrorFilterContext context = new HtmlErrorFilterContext();
        context.setOnlyBadging(this.onlyBadges);
        context.parserResult = parserResult;
        context.manager = this.htmlHintsManager;
        context.doc = (BaseDocument)parserResult.getSnapshot().getSource().getDocument(false);
        ArrayList hints = new ArrayList();
        this.htmlHintsProvider.computeErrors(this.htmlHintsManager, (RuleContext)context, hints, new ArrayList());
        ArrayList<BadgingDefaultError> filtered = new ArrayList<BadgingDefaultError>(hints.size());
        block5: for (Hint h : hints) {
            Severity severity;
            Rule rule = h.getRule();
            if (!rule.showInTasklist()) continue;
            HintSeverity hs = rule.getDefaultSeverity();
            switch (hs) {
                case ERROR: {
                    severity = Severity.ERROR;
                    break;
                }
                case WARNING: {
                    severity = Severity.WARNING;
                    break;
                }
                case INFO: {
                    severity = Severity.INFO;
                    break;
                }
                default: {
                    continue block5;
                }
            }
            int ast_from = parserResult.getSnapshot().getEmbeddedOffset(h.getRange().getStart());
            int ast_to = parserResult.getSnapshot().getEmbeddedOffset(h.getRange().getEnd());
            if (ast_from == -1 || ast_to == -1) continue;
            BadgingDefaultError e = new BadgingDefaultError("error", h.getDescription(), h.getDescription(), h.getFile(), h.getRange().getStart(), h.getRange().getEnd(), severity, rule instanceof ErrorBadgingRule);
            filtered.add(e);
        }
        return filtered;
    }

    public static boolean isErrorCheckingEnabled(Parser.Result result) {
        return !HtmlErrorFilter.isErrorCheckingDisabledForFile(result) && HtmlErrorFilter.isErrorCheckingEnabledForMimetype(result);
    }

    public static boolean isErrorCheckingDisabledForFile(Parser.Result result) {
        FileObject fo = result.getSnapshot().getSource().getFileObject();
        return fo != null && fo.getAttribute(DISABLE_ERROR_CHECKS_KEY) != null;
    }

    public static boolean isErrorCheckingEnabledForMimetype(Parser.Result result) {
        return HtmlPreferences.isHtmlErrorCheckingEnabledForMimetype(WebPageMetadata.getContentMimeType((Parser.Result)result, (boolean)true));
    }

    private class BadgingDefaultError
    extends DefaultError
    implements Error.Badging {
        private boolean badging;

        public BadgingDefaultError(String key, String displayName, String description, FileObject file, int start, int end, Severity severity, boolean badging) {
            super(key, displayName, description, file, start, end, severity);
            this.badging = badging;
        }

        public boolean showExplorerBadge() {
            return this.badging;
        }
    }

    public static class Factory
    implements ErrorFilter.Factory {
        public ErrorFilter createErrorFilter(String featureName) {
            switch (featureName) {
                case "tasklist": {
                    return INSTANCE;
                }
                case "errorBadges": {
                    return INSTANCE_BADGING;
                }
            }
            return null;
        }
    }
}

