/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide.ui;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.javaee.wildfly.ide.ui.AddServerLocationVisualPanel;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyInstantiatingIterator;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginProperties;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.openide.WizardDescriptor;
import org.openide.modules.SpecificationVersion;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddServerLocationPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private static final String J2SE_PLATFORM_VERSION_17 = "1.7";
    private final WildflyInstantiatingIterator instantiatingIterator;
    private AddServerLocationVisualPanel component;
    private WizardDescriptor wizard;
    private final transient Set<ChangeListener> listeners = ConcurrentHashMap.newKeySet(2);

    public AddServerLocationPanel(WildflyInstantiatingIterator instantiatingIterator) {
        this.instantiatingIterator = instantiatingIterator;
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        new ArrayList<ChangeListener>(this.listeners).forEach(l -> l.stateChanged(ev));
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddServerLocationVisualPanel();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("j2eeplugins_registering_app_server_jboss_location");
    }

    public boolean isValid() {
        String locationStr = this.component.getInstallLocation();
        if (locationStr == null || locationStr.trim().length() < 1) {
            this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"MSG_SpecifyServerLocation"));
            return false;
        }
        File path = new File(locationStr);
        if (!WildflyPluginUtils.isGoodJBServerLocation(path)) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"MSG_InvalidServerLocation"));
            return false;
        }
        if (!this.runningOnCorrectJdk(path)) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"MSG_InvalidJDK"));
            return false;
        }
        this.wizard.putProperty("WizardPanel_errorMessage", null);
        this.wizard.putProperty("WizardPanel_infoMessage", null);
        WildflyPluginProperties.getInstance().setInstallLocation(this.component.getInstallLocation());
        WildflyPluginProperties.getInstance().setConfigLocation(this.component.getConfigurationLocation());
        WildflyPluginProperties.getInstance().setDomainLocation(this.component.getConfigurationLocation());
        WildflyPluginProperties.getInstance().saveProperties();
        this.instantiatingIterator.setInstallLocation(locationStr);
        this.instantiatingIterator.setAdminPort("" + WildflyPluginProperties.getInstance().getAdminPort());
        return true;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void readSettings(Object settings) {
        if (this.wizard == null) {
            this.wizard = (WizardDescriptor)settings;
        }
    }

    public void storeSettings(Object settings) {
        String installLocation = ((AddServerLocationVisualPanel)this.getComponent()).getInstallLocation();
        if (installLocation == null) {
            return;
        }
        this.instantiatingIterator.setInstallLocation(installLocation);
        this.instantiatingIterator.setConfigFile(((AddServerLocationVisualPanel)this.getComponent()).getConfigurationLocation());
        this.instantiatingIterator.setServer("standalone");
        String serverPath = ((AddServerLocationVisualPanel)this.getComponent()).getInstallLocation() + File.separatorChar + "standalone";
        this.instantiatingIterator.setServerPath(serverPath);
        this.instantiatingIterator.setDeployDir(WildflyPluginUtils.getDeployDir(serverPath));
        this.instantiatingIterator.setAdminPort("" + WildflyPluginProperties.getInstance().getAdminPort());
        this.instantiatingIterator.setHost("localhost");
        this.instantiatingIterator.setPort("8080");
        this.instantiatingIterator.setPortOffset("0");
    }

    public boolean isFinishPanel() {
        return true;
    }

    private boolean runningOnCorrectJdk(File path) {
        SpecificationVersion defPlatVersion = JavaPlatformManager.getDefault().getDefaultPlatform().getSpecification().getVersion();
        if (!J2SE_PLATFORM_VERSION_17.equals(defPlatVersion.toString())) {
            return true;
        }
        WildflyPluginUtils.Version version = WildflyPluginUtils.getServerVersion(path);
        return version != null && version.compareToIgnoreUpdate(WildflyPluginUtils.WILDFLY_10_0_0) < 0;
    }
}

