/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.netbeans.modules.cloud.oracle.assets.PropertiesGenerator;
import org.netbeans.modules.cloud.oracle.assets.TempFileGenerator;
import org.netbeans.spi.lsp.CommandProvider;

public class ConfigFileProvider
implements CommandProvider {
    private static final String GET_CONFIG_FILE_PATH = "nbls.config.file.path";
    private final TempFileGenerator applicationPropertiesFileGenerator = new TempFileGenerator("application-", ".properties", "nbls.config.file.path", false);
    private final TempFileGenerator bootstrapPropertiesFileGenerator = new TempFileGenerator("bootstrap-", ".properties", "nbls.config.file.path", false);

    public Set<String> getCommands() {
        return Collections.singleton(GET_CONFIG_FILE_PATH);
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        CompletableFuture<Object> ret = new CompletableFuture<Object>();
        Properties applicationProps = new Properties();
        Properties bootstrapProps = new Properties();
        PropertiesGenerator propGen = new PropertiesGenerator(false);
        applicationProps.putAll(propGen.getApplication());
        bootstrapProps.putAll(propGen.getBootstrap());
        String applicationPropertiesPath = null;
        String bootstrapPropertiesPath = null;
        try {
            if (!bootstrapProps.isEmpty()) {
                Path bootstrapProperties = this.bootstrapPropertiesFileGenerator.writePropertiesFile(bootstrapProps);
                bootstrapPropertiesPath = bootstrapProperties.toAbsolutePath().toString();
            }
            if (!applicationProps.isEmpty()) {
                Path applicationProperties = this.applicationPropertiesFileGenerator.writePropertiesFile(applicationProps);
                applicationPropertiesPath = applicationProperties.toAbsolutePath().toString();
            }
            ret.complete(new ConfigFilesResponse(applicationPropertiesPath, bootstrapPropertiesPath));
        }
        catch (IOException ex) {
            ret.completeExceptionally(ex);
            return ret;
        }
        return ret;
    }

    private class ConfigFilesResponse {
        final String applicationProperties;
        final String bootstrapProperties;

        public ConfigFilesResponse(String applicationProperties, String bootstrapProperties) {
            this.applicationProperties = applicationProperties;
            this.bootstrapProperties = bootstrapProperties;
        }
    }
}

