/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.MPPReader;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MppCleanUtility {
    private ProjectFile m_project;
    private DirectoryEntry m_projectDir;

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 2) {
                System.out.println("Usage: MppClean <input mpp file name> <output mpp file name>");
            } else {
                System.out.println("Clean started.");
                long l = System.currentTimeMillis();
                MppCleanUtility mppCleanUtility = new MppCleanUtility();
                mppCleanUtility.process(stringArray[0], stringArray[1]);
                long l2 = System.currentTimeMillis() - l;
                System.out.println("Clean completed in " + l2 + "ms");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void process(String string, String string2) throws MPXJException, IOException {
        Object object2;
        String string3;
        String string4;
        MPPReader mPPReader = new MPPReader();
        this.m_project = mPPReader.read(string);
        int n = NumberHelper.getInt(this.m_project.getProjectProperties().getMppFileType());
        switch (n) {
            case 8: {
                string4 = "   1";
                string3 = "FixDeferFix   0";
                break;
            }
            case 9: {
                string4 = "   19";
                string3 = "Var2Data";
                break;
            }
            case 12: {
                string4 = "   112";
                string3 = "Var2Data";
                break;
            }
            case 14: {
                string4 = "   114";
                string3 = "Var2Data";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported file type " + n);
            }
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(fileInputStream);
        fileInputStream.close();
        DirectoryNode directoryNode = pOIFSFileSystem.getRoot();
        this.m_projectDir = (DirectoryEntry)directoryNode.getEntry(string4);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object2 : this.m_project.getTasks()) {
            this.mapText(((Task)object2).getName(), hashMap);
        }
        this.processReplacements((DirectoryEntry)this.m_projectDir.getEntry("TBkndTask"), string3, hashMap, true);
        hashMap.clear();
        for (Object object2 : this.m_project.getResources()) {
            this.mapText(((Resource)object2).getName(), hashMap);
            this.mapText(((Resource)object2).getInitials(), hashMap);
        }
        this.processReplacements((DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc"), string3, hashMap, true);
        hashMap.clear();
        ProjectProperties projectProperties = this.m_project.getProjectProperties();
        this.mapText(projectProperties.getProjectTitle(), hashMap);
        this.processReplacements(this.m_projectDir, "Props", hashMap, true);
        hashMap.clear();
        this.mapText(projectProperties.getProjectTitle(), hashMap);
        this.mapText(projectProperties.getSubject(), hashMap);
        this.mapText(projectProperties.getAuthor(), hashMap);
        this.mapText(projectProperties.getKeywords(), hashMap);
        this.mapText(projectProperties.getComments(), hashMap);
        this.processReplacements(directoryNode, "\u0005SummaryInformation", hashMap, false);
        hashMap.clear();
        this.mapText(projectProperties.getManager(), hashMap);
        this.mapText(projectProperties.getCompany(), hashMap);
        this.mapText(projectProperties.getCategory(), hashMap);
        this.processReplacements(directoryNode, "\u0005DocumentSummaryInformation", hashMap, false);
        object2 = new FileOutputStream(string2);
        pOIFSFileSystem.writeFilesystem((OutputStream)object2);
        ((OutputStream)object2).flush();
        ((FileOutputStream)object2).close();
        pOIFSFileSystem.close();
    }

    private void processReplacements(DirectoryEntry directoryEntry, String string, Map<String, String> map, boolean bl) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string2.length() - string.length();
            }
        });
        DocumentEntry documentEntry = (DocumentEntry)directoryEntry.getEntry(string);
        DocumentInputStream documentInputStream = new DocumentInputStream(documentEntry);
        int n = documentInputStream.available();
        byte[] byArray = new byte[n];
        documentInputStream.read(byArray);
        documentInputStream.close();
        for (String string2 : arrayList) {
            String string3 = map.get(string2);
            this.replaceData(byArray, string2, string3, bl);
        }
        documentEntry.delete();
        directoryEntry.createDocument(string, new ByteArrayInputStream(byArray));
    }

    private void mapText(String string, Map<String, String> map) {
        char c = '\u0000';
        if (string != null && string.length() != 0 && !map.containsKey(string)) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (Character.isUpperCase(c2)) {
                    stringBuilder.append('X');
                    continue;
                }
                if (Character.isLowerCase(c2)) {
                    stringBuilder.append('x');
                    continue;
                }
                if (Character.isDigit(c2)) {
                    stringBuilder.append('0');
                    continue;
                }
                if (Character.isLetter(c2)) {
                    if (c == '\u0000') {
                        c = c2;
                    }
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(c2);
            }
            map.put(string, stringBuilder.toString());
        }
    }

    private void replaceData(byte[] byArray, String string, String string2, boolean bl) {
        boolean bl2 = false;
        byte[] byArray2 = this.getBytes(string, bl);
        byte[] byArray3 = this.getBytes(string2, bl);
        int n = byArray.length - byArray2.length;
        for (int i = 0; i <= n; ++i) {
            if (!this.compareBytes(byArray2, byArray, i)) continue;
            System.arraycopy(byArray3, 0, byArray, i, byArray3.length);
            i += byArray3.length;
            System.out.println(string + " -> " + string2);
            bl2 = true;
        }
        if (!bl2) {
            System.out.println("Failed to find " + string);
        }
    }

    private byte[] getBytes(String string, boolean bl) {
        byte[] byArray;
        if (bl) {
            byte[] byArray2;
            int n = 0;
            try {
                byArray2 = string.getBytes("UTF-16");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray2 = string.getBytes();
            }
            if (byArray2.length > 2 && byArray2[0] == -2 && byArray2[1] == -1) {
                n = 2;
            }
            byArray = new byte[byArray2.length - n];
            for (int i = n; i < byArray2.length - 1; i += 2) {
                byArray[i - n] = byArray2[i + 1];
                byArray[i + 1 - n] = byArray2[i];
            }
        } else {
            byArray = new byte[string.length() + 1];
            System.arraycopy(string.getBytes(), 0, byArray, 0, string.length());
        }
        return byArray;
    }

    private boolean compareBytes(byte[] byArray, byte[] byArray2, int n) {
        boolean bl = true;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[n + i]) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

