/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.join;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.lucene.search.TotalHits;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestResponse;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.legacy.domain.Field;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.executor.ElasticHitsExecutor;
import org.opensearch.sql.legacy.executor.join.ElasticUtils;
import org.opensearch.sql.legacy.executor.join.HashJoinElasticExecutor;
import org.opensearch.sql.legacy.executor.join.MetaSearchResult;
import org.opensearch.sql.legacy.executor.join.NestedLoopsElasticExecutor;
import org.opensearch.sql.legacy.executor.join.QueryPlanElasticExecutor;
import org.opensearch.sql.legacy.executor.join.SearchHitsResult;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.legacy.pit.PointInTimeHandlerImpl;
import org.opensearch.sql.legacy.query.SqlElasticRequestBuilder;
import org.opensearch.sql.legacy.query.join.HashJoinElasticRequestBuilder;
import org.opensearch.sql.legacy.query.join.JoinRequestBuilder;
import org.opensearch.sql.legacy.query.join.NestedLoopsElasticRequestBuilder;
import org.opensearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import org.opensearch.sql.legacy.query.planner.HashJoinQueryPlanRequestBuilder;

public abstract class ElasticJoinExecutor
extends ElasticHitsExecutor {
    protected List<SearchHit> results;
    protected MetaSearchResult metaResults = new MetaSearchResult();
    protected final int MAX_RESULTS_ON_ONE_FETCH = 10000;
    private Set<String> aliasesOnReturn = new HashSet<String>();
    private boolean allFieldsReturn;
    protected String[] indices;

    protected ElasticJoinExecutor(Client client, JoinRequestBuilder requestBuilder) {
        List<Field> firstTableReturnedField = requestBuilder.getFirstTable().getReturnedFields();
        List<Field> secondTableReturnedField = requestBuilder.getSecondTable().getReturnedFields();
        this.allFieldsReturn = !(firstTableReturnedField != null && firstTableReturnedField.size() != 0 || secondTableReturnedField != null && secondTableReturnedField.size() != 0);
        this.indices = this.getIndices(requestBuilder);
        this.client = client;
    }

    public void sendResponse(RestChannel channel) throws IOException {
        long len;
        XContentBuilder builder = null;
        try {
            builder = ElasticUtils.hitsAsStringResultZeroCopy(this.results, this.metaResults, this);
            BytesRestResponse bytesRestResponse = new BytesRestResponse(RestStatus.OK, builder);
            len = bytesRestResponse.content().length();
            channel.sendResponse((RestResponse)bytesRestResponse);
        }
        catch (IOException e) {
            try {
                if (builder != null) {
                    builder.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        LOG.debug("[MCB] Successfully send response with size of {}. Thread id = {}", (Object)len, (Object)Thread.currentThread().getId());
    }

    @Override
    public void run() throws IOException, SqlParseException {
        try {
            long timeBefore = System.currentTimeMillis();
            if (((Boolean)LocalClusterState.state().getSettingValue(Settings.Key.SQL_PAGINATION_API_SEARCH_AFTER)).booleanValue()) {
                this.pit = new PointInTimeHandlerImpl(this.client, this.indices);
                this.pit.create();
            }
            this.results = this.innerRun();
            long joinTimeInMilli = System.currentTimeMillis() - timeBefore;
            this.metaResults.setTookImMilli(joinTimeInMilli);
        }
        catch (Exception e) {
            LOG.error("Failed during join query run.", (Throwable)e);
            throw new IllegalStateException("Error occurred during join query run", e);
        }
        finally {
            if (((Boolean)LocalClusterState.state().getSettingValue(Settings.Key.SQL_PAGINATION_API_SEARCH_AFTER)).booleanValue()) {
                try {
                    this.pit.delete();
                }
                catch (RuntimeException e) {
                    Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                    LOG.info("Error deleting point in time {} ", (Object)this.pit);
                }
            }
        }
    }

    protected abstract List<SearchHit> innerRun() throws IOException, SqlParseException;

    @Override
    public SearchHits getHits() {
        return new SearchHits(this.results.toArray(new SearchHit[this.results.size()]), new TotalHits((long)this.results.size(), TotalHits.Relation.EQUAL_TO), 1.0f);
    }

    public static ElasticJoinExecutor createJoinExecutor(Client client, SqlElasticRequestBuilder requestBuilder) {
        if (requestBuilder instanceof HashJoinQueryPlanRequestBuilder) {
            return new QueryPlanElasticExecutor(client, (HashJoinQueryPlanRequestBuilder)requestBuilder);
        }
        if (requestBuilder instanceof HashJoinElasticRequestBuilder) {
            HashJoinElasticRequestBuilder hashJoin = (HashJoinElasticRequestBuilder)requestBuilder;
            return new HashJoinElasticExecutor(client, hashJoin);
        }
        if (requestBuilder instanceof NestedLoopsElasticRequestBuilder) {
            NestedLoopsElasticRequestBuilder nestedLoops = (NestedLoopsElasticRequestBuilder)requestBuilder;
            return new NestedLoopsElasticExecutor(client, nestedLoops);
        }
        throw new RuntimeException("Unsuported requestBuilder of type: " + String.valueOf(requestBuilder.getClass()));
    }

    protected void mergeSourceAndAddAliases(Map<String, Object> secondTableHitSource, SearchHit searchHit, String t1Alias, String t2Alias) {
        Map<String, Object> results = this.mapWithAliases(searchHit.getSourceAsMap(), t1Alias);
        results.putAll(this.mapWithAliases(secondTableHitSource, t2Alias));
        searchHit.getSourceAsMap().clear();
        searchHit.getSourceAsMap().putAll(results);
    }

    protected Map<String, Object> mapWithAliases(Map<String, Object> source, String alias) {
        HashMap<String, Object> mapWithAliases = new HashMap<String, Object>();
        for (Map.Entry<String, Object> fieldNameToValue : source.entrySet()) {
            if (!this.aliasesOnReturn.contains(fieldNameToValue.getKey())) {
                mapWithAliases.put(alias + "." + fieldNameToValue.getKey(), fieldNameToValue.getValue());
                continue;
            }
            mapWithAliases.put(fieldNameToValue.getKey(), fieldNameToValue.getValue());
        }
        return mapWithAliases;
    }

    protected void onlyReturnedFields(Map<String, Object> fieldsMap, List<Field> required, boolean allRequired) {
        HashMap<String, Object> filteredMap = new HashMap<String, Object>();
        if (this.allFieldsReturn || allRequired) {
            filteredMap.putAll(fieldsMap);
            return;
        }
        for (Field field : required) {
            String name;
            String returnName = name = field.getName();
            String alias = field.getAlias();
            if (alias != null && alias != "") {
                returnName = alias;
                this.aliasesOnReturn.add(alias);
            }
            filteredMap.put(returnName, this.deepSearchInMap(fieldsMap, name));
        }
        fieldsMap.clear();
        fieldsMap.putAll(filteredMap);
    }

    protected Object deepSearchInMap(Map<String, Object> fieldsMap, String name) {
        if (name.contains(".")) {
            String[] path = name.split("\\.");
            Map currentObject = fieldsMap;
            for (int i = 0; i < path.length - 1; ++i) {
                Object valueFromCurrentMap = currentObject.get(path[i]);
                if (valueFromCurrentMap == null) {
                    return null;
                }
                if (!Map.class.isAssignableFrom(valueFromCurrentMap.getClass())) {
                    return null;
                }
                currentObject = (Map)valueFromCurrentMap;
            }
            return currentObject.get(path[path.length - 1]);
        }
        return fieldsMap.get(name);
    }

    protected void addUnmatchedResults(List<SearchHit> combinedResults, Collection<SearchHitsResult> firstTableSearchHits, List<Field> secondTableReturnedFields, int currentNumOfIds, int totalLimit, String t1Alias, String t2Alias) {
        boolean limitReached = false;
        for (SearchHitsResult hitsResult : firstTableSearchHits) {
            if (!hitsResult.isMatchedWithOtherTable()) {
                for (SearchHit hit : hitsResult.getSearchHits()) {
                    SearchHit unmachedResult = this.createUnmachedResult(secondTableReturnedFields, hit.docId(), t1Alias, t2Alias, hit);
                    combinedResults.add(unmachedResult);
                    if (++currentNumOfIds < totalLimit) continue;
                    limitReached = true;
                    break;
                }
            }
            if (!limitReached) continue;
            break;
        }
    }

    protected SearchHit createUnmachedResult(List<Field> secondTableReturnedFields, int docId, String t1Alias, String t2Alias, SearchHit hit) {
        String unmatchedId = hit.getId() + "|0";
        HashMap documentFields = new HashMap();
        HashMap metaFields = new HashMap();
        hit.getFields().forEach((fieldName, docField) -> (MapperService.META_FIELDS_BEFORE_7DOT8.contains(fieldName) ? metaFields : documentFields).put(fieldName, docField));
        SearchHit searchHit = new SearchHit(docId, unmatchedId, documentFields, metaFields);
        searchHit.sourceRef(hit.getSourceRef());
        searchHit.getSourceAsMap().clear();
        searchHit.getSourceAsMap().putAll(hit.getSourceAsMap());
        Map<String, Object> emptySecondTableHitSource = this.createNullsSource(secondTableReturnedFields);
        this.mergeSourceAndAddAliases(emptySecondTableHitSource, searchHit, t1Alias, t2Alias);
        return searchHit;
    }

    protected Map<String, Object> createNullsSource(List<Field> secondTableReturnedFields) {
        HashMap<String, Object> nulledSource = new HashMap<String, Object>();
        for (Field field : secondTableReturnedFields) {
            if (field.getName().equals("*")) continue;
            nulledSource.put(field.getName(), null);
        }
        return nulledSource;
    }

    protected void updateMetaSearchResults(SearchResponse searchResponse) {
        this.metaResults.addSuccessfulShards(searchResponse.getSuccessfulShards());
        this.metaResults.addFailedShards(searchResponse.getFailedShards());
        this.metaResults.addTotalNumOfShards(searchResponse.getTotalShards());
        this.metaResults.updateTimeOut(searchResponse.isTimedOut());
    }

    public SearchResponse getResponseWithHits(TableInJoinRequestBuilder tableRequest, int size, SearchResponse previousResponse) {
        return this.getResponseWithHits(tableRequest.getRequestBuilder(), tableRequest.getOriginalSelect(), size, previousResponse, this.pit);
    }

    public String[] getIndices(JoinRequestBuilder joinRequestBuilder) {
        return (String[])Stream.concat(Stream.of(joinRequestBuilder.getFirstTable().getOriginalSelect().getIndexArr()), Stream.of(joinRequestBuilder.getSecondTable().getOriginalSelect().getIndexArr())).distinct().toArray(String[]::new);
    }
}

