/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.commons.model.IOCType;
import org.opensearch.securityanalytics.threatIntel.model.IocStoreConfig;

public class DefaultIocStoreConfig
extends IocStoreConfig
implements Writeable,
ToXContent {
    private static final Logger log = LogManager.getLogger(DefaultIocStoreConfig.class);
    public static final String DEFAULT_FIELD = "default";
    public static final String IOC_TO_INDEX_DETAILS_FIELD = "ioc_to_index_details";
    private final List<IocToIndexDetails> iocToIndexDetails;

    public DefaultIocStoreConfig(List<IocToIndexDetails> iocToIndexDetails) {
        this.iocToIndexDetails = iocToIndexDetails;
    }

    public DefaultIocStoreConfig(StreamInput sin) throws IOException {
        this.iocToIndexDetails = Collections.unmodifiableList(sin.readList(IocToIndexDetails::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.iocToIndexDetails);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(DEFAULT_FIELD);
        builder.startObject().field(IOC_TO_INDEX_DETAILS_FIELD, this.iocToIndexDetails);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static DefaultIocStoreConfig parse(XContentParser xcp) throws IOException {
        ArrayList<IocToIndexDetails> iocToIndexDetails = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block8: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "default": {
                    continue block8;
                }
                case "ioc_to_index_details": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        iocToIndexDetails = null;
                        continue block8;
                    }
                    iocToIndexDetails = new ArrayList<IocToIndexDetails>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        iocToIndexDetails.add(IocToIndexDetails.parse(xcp));
                    }
                    continue block8;
                }
            }
            xcp.skipChildren();
        }
        return new DefaultIocStoreConfig(iocToIndexDetails);
    }

    @Override
    public String name() {
        return DEFAULT_FIELD;
    }

    public List<IocToIndexDetails> getIocToIndexDetails() {
        return this.iocToIndexDetails;
    }

    public static class IocToIndexDetails
    implements Writeable,
    ToXContent {
        public static final String IOC_TYPE_FIELD = "ioc_type";
        public static final String INDEX_PATTERN_FIELD = "index_pattern";
        public static final String ACTIVE_INDEX_FIELD = "active_index";
        private final IOCType iocType;
        private final String indexPattern;
        private final String activeIndex;

        public IocToIndexDetails(IOCType iocType, String indexPattern, String activeIndex) {
            this.iocType = iocType;
            this.indexPattern = indexPattern;
            this.activeIndex = activeIndex;
        }

        public IocToIndexDetails(StreamInput sin) throws IOException {
            this(new IOCType(sin.readString()), sin.readString(), sin.readString());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.iocType.toString());
            out.writeString(this.indexPattern);
            out.writeString(this.activeIndex);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(IOC_TYPE_FIELD, this.iocType.toString()).field(INDEX_PATTERN_FIELD, this.indexPattern).field(ACTIVE_INDEX_FIELD, this.activeIndex).endObject();
        }

        public static IocToIndexDetails parse(XContentParser xcp) throws IOException {
            IOCType iocType = null;
            String indexPattern = null;
            String activeIndex = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                switch (fieldName) {
                    case "ioc_type": {
                        iocType = IocToIndexDetails.toIocType(xcp.text());
                        continue block10;
                    }
                    case "index_pattern": {
                        indexPattern = xcp.text();
                        continue block10;
                    }
                    case "active_index": {
                        activeIndex = xcp.text();
                        continue block10;
                    }
                }
                xcp.skipChildren();
            }
            return new IocToIndexDetails(iocType, indexPattern, activeIndex);
        }

        public static IOCType toIocType(String name) {
            try {
                return new IOCType(name);
            }
            catch (IllegalArgumentException e) {
                log.error("Invalid Ioc type, cannot be parsed.", (Throwable)e);
                return null;
            }
        }

        public IOCType getIocType() {
            return this.iocType;
        }

        public String getIndexPattern() {
            return this.indexPattern;
        }

        public String getActiveIndex() {
            return this.activeIndex;
        }
    }
}

