/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.rest.RestCreateWorkflowAction;
import org.opensearch.flowframework.rest.RestDeleteWorkflowAction;
import org.opensearch.flowframework.rest.RestDeprovisionWorkflowAction;
import org.opensearch.flowframework.rest.RestGetWorkflowAction;
import org.opensearch.flowframework.rest.RestGetWorkflowStateAction;
import org.opensearch.flowframework.rest.RestGetWorkflowStepAction;
import org.opensearch.flowframework.rest.RestProvisionWorkflowAction;
import org.opensearch.flowframework.rest.RestSearchWorkflowAction;
import org.opensearch.flowframework.rest.RestSearchWorkflowStateAction;
import org.opensearch.flowframework.transport.CreateWorkflowAction;
import org.opensearch.flowframework.transport.CreateWorkflowTransportAction;
import org.opensearch.flowframework.transport.DeleteWorkflowAction;
import org.opensearch.flowframework.transport.DeleteWorkflowTransportAction;
import org.opensearch.flowframework.transport.DeprovisionWorkflowAction;
import org.opensearch.flowframework.transport.DeprovisionWorkflowTransportAction;
import org.opensearch.flowframework.transport.GetWorkflowAction;
import org.opensearch.flowframework.transport.GetWorkflowStateAction;
import org.opensearch.flowframework.transport.GetWorkflowStateTransportAction;
import org.opensearch.flowframework.transport.GetWorkflowStepAction;
import org.opensearch.flowframework.transport.GetWorkflowStepTransportAction;
import org.opensearch.flowframework.transport.GetWorkflowTransportAction;
import org.opensearch.flowframework.transport.ProvisionWorkflowAction;
import org.opensearch.flowframework.transport.ProvisionWorkflowTransportAction;
import org.opensearch.flowframework.transport.ReprovisionWorkflowAction;
import org.opensearch.flowframework.transport.ReprovisionWorkflowTransportAction;
import org.opensearch.flowframework.transport.SearchWorkflowAction;
import org.opensearch.flowframework.transport.SearchWorkflowStateAction;
import org.opensearch.flowframework.transport.SearchWorkflowStateTransportAction;
import org.opensearch.flowframework.transport.SearchWorkflowTransportAction;
import org.opensearch.flowframework.transport.handler.SearchHandler;
import org.opensearch.flowframework.util.EncryptorUtils;
import org.opensearch.flowframework.workflow.WorkflowProcessSorter;
import org.opensearch.flowframework.workflow.WorkflowStepFactory;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.impl.SdkClientFactory;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.ScalingExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

public class FlowFrameworkPlugin
extends Plugin
implements ActionPlugin,
SystemIndexPlugin {
    private FlowFrameworkSettings flowFrameworkSettings;

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        Settings settings = environment.settings();
        this.flowFrameworkSettings = new FlowFrameworkSettings(clusterService, settings);
        MachineLearningNodeClient mlClient = new MachineLearningNodeClient(client);
        SdkClient sdkClient = SdkClientFactory.createSdkClient((Client)client, (NamedXContentRegistry)xContentRegistry, (Boolean)FlowFrameworkSettings.FLOW_FRAMEWORK_MULTI_TENANCY_ENABLED.get(settings) != false ? Map.ofEntries(Map.entry("remote_metadata_type", (String)FlowFrameworkSettings.REMOTE_METADATA_TYPE.get(settings)), Map.entry("remote_metadata_endpoint", (String)FlowFrameworkSettings.REMOTE_METADATA_ENDPOINT.get(settings)), Map.entry("remote_metadata_region", (String)FlowFrameworkSettings.REMOTE_METADATA_REGION.get(settings)), Map.entry("remote_metadata_service_name", (String)FlowFrameworkSettings.REMOTE_METADATA_SERVICE_NAME.get(settings)), Map.entry("tenant_aware", "true"), Map.entry("tenant_id", "tenant_id")) : Collections.emptyMap(), (Executor)client.threadPool().executor("generic"));
        EncryptorUtils encryptorUtils = new EncryptorUtils(clusterService, client, sdkClient, xContentRegistry);
        FlowFrameworkIndicesHandler flowFrameworkIndicesHandler = new FlowFrameworkIndicesHandler(client, sdkClient, clusterService, encryptorUtils, xContentRegistry);
        WorkflowStepFactory workflowStepFactory = new WorkflowStepFactory(threadPool, mlClient, flowFrameworkIndicesHandler, this.flowFrameworkSettings, client);
        WorkflowProcessSorter workflowProcessSorter = new WorkflowProcessSorter(workflowStepFactory, threadPool, this.flowFrameworkSettings);
        SearchHandler searchHandler = new SearchHandler(settings, clusterService, client, sdkClient, FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES);
        return List.of(workflowStepFactory, workflowProcessSorter, encryptorUtils, flowFrameworkIndicesHandler, searchHandler, this.flowFrameworkSettings, sdkClient);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestCreateWorkflowAction(this.flowFrameworkSettings), new RestDeleteWorkflowAction(this.flowFrameworkSettings), new RestProvisionWorkflowAction(this.flowFrameworkSettings), new RestDeprovisionWorkflowAction(this.flowFrameworkSettings), new RestSearchWorkflowAction(this.flowFrameworkSettings), new RestGetWorkflowStateAction(this.flowFrameworkSettings), new RestGetWorkflowAction(this.flowFrameworkSettings), new RestGetWorkflowStepAction(this.flowFrameworkSettings), new RestSearchWorkflowStateAction(this.flowFrameworkSettings));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)CreateWorkflowAction.INSTANCE, CreateWorkflowTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteWorkflowAction.INSTANCE, DeleteWorkflowTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ProvisionWorkflowAction.INSTANCE, ProvisionWorkflowTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeprovisionWorkflowAction.INSTANCE, DeprovisionWorkflowTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchWorkflowAction.INSTANCE, SearchWorkflowTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetWorkflowStateAction.INSTANCE, GetWorkflowStateTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetWorkflowAction.INSTANCE, GetWorkflowTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetWorkflowStepAction.INSTANCE, GetWorkflowStepTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchWorkflowStateAction.INSTANCE, SearchWorkflowStateTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ReprovisionWorkflowAction.INSTANCE, ReprovisionWorkflowTransportAction.class, new Class[0]));
    }

    public List<Setting<?>> getSettings() {
        return List.of(FlowFrameworkSettings.FLOW_FRAMEWORK_ENABLED, FlowFrameworkSettings.MAX_WORKFLOWS, FlowFrameworkSettings.MAX_WORKFLOW_STEPS, FlowFrameworkSettings.WORKFLOW_REQUEST_TIMEOUT, FlowFrameworkSettings.TASK_REQUEST_RETRY_DURATION, FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES, FlowFrameworkSettings.FLOW_FRAMEWORK_MULTI_TENANCY_ENABLED, FlowFrameworkSettings.REMOTE_METADATA_TYPE, FlowFrameworkSettings.REMOTE_METADATA_ENDPOINT, FlowFrameworkSettings.REMOTE_METADATA_REGION, FlowFrameworkSettings.REMOTE_METADATA_SERVICE_NAME);
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return List.of(new ScalingExecutorBuilder("opensearch_workflow", 1, Math.max(4, OpenSearchExecutors.allocatedProcessors((Settings)settings) - 1), TimeValue.timeValueMinutes((long)1L), "thread_pool.flow_framework.opensearch_workflow"), new ScalingExecutorBuilder("opensearch_provision_workflow", 1, Math.max(8, OpenSearchExecutors.allocatedProcessors((Settings)settings) - 1), TimeValue.timeValueMinutes((long)5L), "thread_pool.flow_framework.opensearch_provision_workflow"), new ScalingExecutorBuilder("opensearch_deprovision_workflow", 1, Math.max(4, OpenSearchExecutors.allocatedProcessors((Settings)settings) - 1), TimeValue.timeValueMinutes((long)1L), "thread_pool.flow_framework.opensearch_deprovision_workflow"));
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return List.of(new SystemIndexDescriptor(".plugins-flow-framework-config", "Flow Framework Config index"), new SystemIndexDescriptor(".plugins-flow-framework-templates", "Flow Framework Global Context index"), new SystemIndexDescriptor(".plugins-flow-framework-state", "Flow Framework Workflow State index"));
    }
}

