/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ingest.DeletePipelineRequest;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.client.Client;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;

public class DeleteIngestPipelineStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(DeleteIngestPipelineStep.class);
    private final Client client;
    public static final String NAME = "delete_ingest_pipeline";
    public static final Set<String> REQUIRED_INPUTS = Set.of("pipeline_id");
    public static final Set<String> OPTIONAL_INPUTS = Collections.emptySet();
    public static final Set<String> PROVIDED_OUTPUTS = Set.of("pipeline_id");

    public DeleteIngestPipelineStep(Client client) {
        this.client = client;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params, String tenantId) {
        PlainActionFuture deletePipelineFuture = PlainActionFuture.newFuture();
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(REQUIRED_INPUTS, OPTIONAL_INPUTS, currentNodeInputs, outputs, previousNodeInputs, params);
            String pipelineId = (String)inputs.get("pipeline_id");
            DeletePipelineRequest deletePipelineRequest = new DeletePipelineRequest(pipelineId);
            this.client.admin().cluster().deletePipeline(deletePipelineRequest, ActionListener.wrap(acknowledgedResponse -> {
                logger.info("Deleted IngestPipeline: {}", (Object)pipelineId);
                deletePipelineFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry("pipeline_id", pipelineId)), currentNodeInputs.getWorkflowId(), currentNodeInputs.getNodeId()));
            }, ex -> {
                Exception e = WorkflowStepException.getSafeException(ex);
                String errorMessage = e == null ? ParameterizedMessageFactory.INSTANCE.newMessage("Failed to delete the ingest pipeline {}", (Object)pipelineId).getFormattedMessage() : e.getMessage();
                logger.error(errorMessage, (Throwable)e);
                deletePipelineFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, ExceptionsHelper.status((Throwable)e))));
            }));
        }
        catch (Exception e) {
            deletePipelineFuture.onFailure(e);
        }
        return deletePipelineFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean allowDeleteRequired() {
        return true;
    }
}

