/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.factory;

import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.neuralsearch.processor.NormalizationProcessor;
import org.opensearch.neuralsearch.processor.NormalizationProcessorWorkflow;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationFactory;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationTechnique;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizationFactory;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizationTechnique;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchPhaseResultsProcessor;

public class NormalizationProcessorFactory
implements Processor.Factory<SearchPhaseResultsProcessor> {
    @Generated
    private static final Logger log = LogManager.getLogger(NormalizationProcessorFactory.class);
    public static final String NORMALIZATION_CLAUSE = "normalization";
    public static final String COMBINATION_CLAUSE = "combination";
    public static final String TECHNIQUE = "technique";
    public static final String PARAMETERS = "parameters";
    private final NormalizationProcessorWorkflow normalizationProcessorWorkflow;
    private ScoreNormalizationFactory scoreNormalizationFactory;
    private ScoreCombinationFactory scoreCombinationFactory;

    public SearchPhaseResultsProcessor create(Map<String, Processor.Factory<SearchPhaseResultsProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) throws Exception {
        Map normalizationClause = ConfigurationUtils.readOptionalMap((String)"normalization-processor", (String)tag, config, (String)NORMALIZATION_CLAUSE);
        ScoreNormalizationTechnique normalizationTechnique = ScoreNormalizationFactory.DEFAULT_METHOD;
        if (Objects.nonNull(normalizationClause)) {
            String normalizationTechniqueName = ConfigurationUtils.readStringProperty((String)"normalization-processor", (String)tag, (Map)normalizationClause, (String)TECHNIQUE, (String)"min_max");
            normalizationTechnique = this.scoreNormalizationFactory.createNormalization(normalizationTechniqueName);
        }
        Map combinationClause = ConfigurationUtils.readOptionalMap((String)"normalization-processor", (String)tag, config, (String)COMBINATION_CLAUSE);
        ScoreCombinationTechnique scoreCombinationTechnique = ScoreCombinationFactory.DEFAULT_METHOD;
        if (Objects.nonNull(combinationClause)) {
            String combinationTechnique = ConfigurationUtils.readStringProperty((String)"normalization-processor", (String)tag, (Map)combinationClause, (String)TECHNIQUE, (String)"arithmetic_mean");
            Map combinationParams = ConfigurationUtils.readOptionalMap((String)"normalization-processor", (String)tag, (Map)combinationClause, (String)PARAMETERS);
            scoreCombinationTechnique = this.scoreCombinationFactory.createCombination(combinationTechnique, combinationParams);
        }
        log.info("Creating search phase results processor of type [{}] with normalization [{}] and combination [{}]", (Object)"normalization-processor", (Object)normalizationTechnique, (Object)scoreCombinationTechnique);
        return new NormalizationProcessor(tag, description, normalizationTechnique, scoreCombinationTechnique, this.normalizationProcessorWorkflow);
    }

    @Generated
    public NormalizationProcessorFactory(NormalizationProcessorWorkflow normalizationProcessorWorkflow, ScoreNormalizationFactory scoreNormalizationFactory, ScoreCombinationFactory scoreCombinationFactory) {
        this.normalizationProcessorWorkflow = normalizationProcessorWorkflow;
        this.scoreNormalizationFactory = scoreNormalizationFactory;
        this.scoreCombinationFactory = scoreCombinationFactory;
    }
}

