/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.normalization;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.opensearch.neuralsearch.processor.normalization.L2ScoreNormalizationTechnique;
import org.opensearch.neuralsearch.processor.normalization.MinMaxScoreNormalizationTechnique;
import org.opensearch.neuralsearch.processor.normalization.RRFNormalizationTechnique;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizationTechnique;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizationUtil;

public class ScoreNormalizationFactory {
    private static final ScoreNormalizationUtil scoreNormalizationUtil = new ScoreNormalizationUtil();
    public static final ScoreNormalizationTechnique DEFAULT_METHOD = new MinMaxScoreNormalizationTechnique();
    private final Map<String, Function<Map<String, Object>, ScoreNormalizationTechnique>> scoreNormalizationMethodsMap = Map.of("min_max", params -> new MinMaxScoreNormalizationTechnique(), "l2", params -> new L2ScoreNormalizationTechnique(), "rrf", params -> new RRFNormalizationTechnique((Map<String, Object>)params, scoreNormalizationUtil));

    public ScoreNormalizationTechnique createNormalization(String technique) {
        return this.createNormalization(technique, Map.of());
    }

    public ScoreNormalizationTechnique createNormalization(String technique, Map<String, Object> params) {
        return Optional.ofNullable(this.scoreNormalizationMethodsMap.get(technique)).orElseThrow(() -> new IllegalArgumentException("provided normalization technique is not supported")).apply(params);
    }
}

