/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.FailedNodeException;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.action.configupdate.ConfigUpdateAction;
import org.opensearch.security.action.configupdate.ConfigUpdateRequest;
import org.opensearch.security.action.configupdate.ConfigUpdateResponse;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.threadpool.ThreadPool;

public class FlushCacheApiAction
extends AbstractApiAction {
    private static final Logger LOGGER = LogManager.getLogger(FlushCacheApiAction.class);
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, "/cache"), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/cache", "GET is not supported for /cache endpoint and will be removed in the next major version. Use DELETE instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.PUT, "/cache", "PUT is not supported for /cache endpoint and will be removed in the next major version. Use DELETE instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.POST, "/cache", "POST is not supported for /cache endpoint and will be removed in the next major version. Use DELETE instead.")));

    @Inject
    public FlushCacheApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.CACHE, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(this::flushCacheApiRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    private void flushCacheApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.allMethodsNotImplemented().override(RestRequest.Method.DELETE, (channel, request, client) -> client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(CType.lcStringValues().toArray(new String[0])), (ActionListener)new ActionListener<ConfigUpdateResponse>(){

            public void onResponse(ConfigUpdateResponse configUpdateResponse) {
                if (configUpdateResponse.hasFailures()) {
                    LOGGER.error("Cannot flush cache due to", (Throwable)configUpdateResponse.failures().get(0));
                    Responses.internalServerError(channel, "Cannot flush cache due to " + ((FailedNodeException)configUpdateResponse.failures().get(0)).getMessage() + ".");
                    return;
                }
                LOGGER.debug("cache flushed successfully");
                Responses.ok(channel, "Cache flushed successfully.");
            }

            public void onFailure(Exception e) {
                LOGGER.error("Cannot flush cache due to", (Throwable)e);
                Responses.internalServerError(channel, "Cannot flush cache due to " + e.getMessage() + ".");
            }
        }));
    }

    @Override
    protected CType<?> getConfigType() {
        return null;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
    }
}

