/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.legacy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.RealtimeRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.indices.SystemIndexRegistry;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.SecurityRoles;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.User;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportRequest;

public class SystemIndexAccessEvaluator {
    Logger log = LogManager.getLogger(this.getClass());
    private final String securityIndex;
    private final AuditLog auditLog;
    private final IndexResolverReplacer irr;
    private final boolean filterSecurityIndex;
    private final WildcardMatcher systemIndexMatcher;
    private final WildcardMatcher superAdminAccessOnlyIndexMatcher;
    private final WildcardMatcher deniedActionsMatcher;
    private final boolean isSystemIndexEnabled;
    private final boolean isSystemIndexPermissionEnabled;

    public SystemIndexAccessEvaluator(Settings settings, AuditLog auditLog, IndexResolverReplacer irr) {
        this.securityIndex = settings.get("plugins.security.config_index_name", ".opendistro_security");
        this.auditLog = auditLog;
        this.irr = irr;
        this.filterSecurityIndex = settings.getAsBoolean("plugins.security.filter_securityindex_from_all_requests", Boolean.valueOf(false));
        this.systemIndexMatcher = WildcardMatcher.from(settings.getAsList("plugins.security.system_indices.indices", ConfigConstants.SECURITY_SYSTEM_INDICES_DEFAULT));
        this.superAdminAccessOnlyIndexMatcher = WildcardMatcher.from(this.securityIndex);
        this.isSystemIndexEnabled = settings.getAsBoolean("plugins.security.system_indices.enabled", ConfigConstants.SECURITY_SYSTEM_INDICES_ENABLED_DEFAULT);
        boolean restoreSecurityIndexEnabled = settings.getAsBoolean("plugins.security.unsupported.restore.securityindex.enabled", Boolean.valueOf(false));
        List<String> deniedActionPatternsList = SystemIndexAccessEvaluator.deniedActionPatterns();
        ArrayList<String> deniedActionPatternsListNoSnapshot = new ArrayList<String>(deniedActionPatternsList);
        deniedActionPatternsListNoSnapshot.add("indices:admin/close*");
        deniedActionPatternsListNoSnapshot.add("cluster:admin/snapshot/restore*");
        this.deniedActionsMatcher = WildcardMatcher.from(restoreSecurityIndexEnabled ? deniedActionPatternsList : deniedActionPatternsListNoSnapshot);
        this.isSystemIndexPermissionEnabled = settings.getAsBoolean("plugins.security.system_indices.permission.enabled", ConfigConstants.SECURITY_SYSTEM_INDICES_PERMISSIONS_DEFAULT);
    }

    private static List<String> deniedActionPatterns() {
        ArrayList<String> securityIndexDeniedActionPatternsList = new ArrayList<String>();
        securityIndexDeniedActionPatternsList.add("indices:data/write*");
        securityIndexDeniedActionPatternsList.add("indices:admin/delete*");
        securityIndexDeniedActionPatternsList.add("indices:admin/mapping/delete*");
        securityIndexDeniedActionPatternsList.add("indices:admin/mapping/put*");
        securityIndexDeniedActionPatternsList.add("indices:admin/freeze*");
        securityIndexDeniedActionPatternsList.add("indices:admin/settings/update*");
        securityIndexDeniedActionPatternsList.add("indices:admin/aliases");
        return securityIndexDeniedActionPatternsList;
    }

    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, Task task, String action, IndexResolverReplacer.Resolved requestedResolved, PrivilegesEvaluatorResponse presponse, SecurityRoles securityRoles, User user, IndexNameExpressionResolver resolver, ClusterService clusterService) {
        this.evaluateSystemIndicesAccess(action, requestedResolved, request, task, presponse, securityRoles, user, resolver, clusterService);
        if (requestedResolved.isLocalAll() || requestedResolved.getAllIndices().contains(this.securityIndex) || this.requestContainsAnySystemIndices(requestedResolved)) {
            if (request instanceof SearchRequest) {
                ((SearchRequest)request).requestCache(Boolean.FALSE);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disable search request cache for this request");
                }
            }
            if (request instanceof RealtimeRequest) {
                ((RealtimeRequest)request).realtime(Boolean.FALSE.booleanValue());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disable realtime for this request");
                }
            }
        }
        return presponse;
    }

    private boolean requestContainsAnySystemIndices(IndexResolverReplacer.Resolved requestedResolved) {
        return !this.getAllSystemIndices(requestedResolved).isEmpty();
    }

    private Set<String> getAllSystemIndices(IndexResolverReplacer.Resolved requestedResolved) {
        Set<String> systemIndices = requestedResolved.getAllIndices().stream().filter(this.securityIndex::equals).collect(Collectors.toSet());
        if (this.isSystemIndexEnabled) {
            systemIndices.addAll(this.systemIndexMatcher.getMatchAny(requestedResolved.getAllIndices(), Collectors.toList()));
            systemIndices.addAll(SystemIndexRegistry.matchesSystemIndexPattern(requestedResolved.getAllIndices()));
        }
        return systemIndices;
    }

    private boolean requestContainsAnyProtectedSystemIndices(IndexResolverReplacer.Resolved requestedResolved) {
        return !this.getAllProtectedSystemIndices(requestedResolved).isEmpty();
    }

    private List<String> getAllProtectedSystemIndices(IndexResolverReplacer.Resolved requestedResolved) {
        return new ArrayList<String>(this.superAdminAccessOnlyIndexMatcher.getMatchAny(requestedResolved.getAllIndices(), Collectors.toList()));
    }

    private boolean requestContainsAnyRegularIndices(IndexResolverReplacer.Resolved requestedResolved) {
        Set<String> allIndices = requestedResolved.getAllIndices();
        Set<String> allSystemIndices = this.getAllSystemIndices(requestedResolved);
        List<String> allProtectedSystemIndices = this.getAllProtectedSystemIndices(requestedResolved);
        return allIndices.stream().anyMatch(index -> !allSystemIndices.contains(index) && !allProtectedSystemIndices.contains(index));
    }

    private boolean isActionAllowed(String action) {
        return this.deniedActionsMatcher.test(action);
    }

    private void evaluateSystemIndicesAccess(String action, IndexResolverReplacer.Resolved requestedResolved, ActionRequest request, Task task, PrivilegesEvaluatorResponse presponse, SecurityRoles securityRoles, User user, IndexNameExpressionResolver resolver, ClusterService clusterService) {
        boolean containsSystemIndex = this.requestContainsAnySystemIndices(requestedResolved);
        boolean containsRegularIndex = this.requestContainsAnyRegularIndices(requestedResolved);
        boolean serviceAccountUser = user.isServiceAccount();
        if (this.isSystemIndexPermissionEnabled) {
            if (serviceAccountUser && containsRegularIndex) {
                this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
                if (!containsSystemIndex && this.log.isInfoEnabled()) {
                    this.log.info("{} not permitted for a service account {} on non-system indices.", (Object)action, (Object)securityRoles);
                } else if (containsSystemIndex && this.log.isDebugEnabled()) {
                    List regularIndices = requestedResolved.getAllIndices().stream().filter(index -> !this.getAllSystemIndices(requestedResolved).contains(index) && !this.getAllProtectedSystemIndices(requestedResolved).contains(index)).collect(Collectors.toList());
                    this.log.debug("Service account cannot access regular indices: {}", regularIndices);
                }
                presponse.allowed = false;
                presponse.markComplete();
                return;
            }
            boolean containsProtectedIndex = this.requestContainsAnyProtectedSystemIndices(requestedResolved);
            if (containsProtectedIndex) {
                this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
                if (this.log.isInfoEnabled()) {
                    this.log.info("{} not permitted for a regular user {} on protected system indices {}", (Object)action, (Object)securityRoles, (Object)String.join((CharSequence)", ", this.getAllProtectedSystemIndices(requestedResolved)));
                }
                presponse.allowed = false;
                presponse.markComplete();
                return;
            }
            if (containsSystemIndex && !securityRoles.hasExplicitIndexPermission(requestedResolved, user, new String[]{"system:admin/system_index"}, resolver, clusterService)) {
                this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
                if (this.log.isInfoEnabled()) {
                    this.log.info("No {} permission for user roles {} to System Indices {}", (Object)action, (Object)securityRoles, (Object)String.join((CharSequence)", ", this.getAllSystemIndices(requestedResolved)));
                }
                presponse.allowed = false;
                presponse.markComplete();
                return;
            }
        }
        if (this.isSystemIndexEnabled && user.isPluginUser() && !requestedResolved.isLocalAll()) {
            Set matchingSystemIndices = SystemIndexRegistry.matchesPluginSystemIndexPattern((String)user.getName().replace("plugin:", ""), requestedResolved.getAllIndices());
            if (requestedResolved.getAllIndices().equals(matchingSystemIndices)) {
                presponse.allowed = true;
                presponse.markComplete();
            } else {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Plugin {} can only perform {} on it's own registered System Indices. System indices from request that match plugin's registered system indices: {}", (Object)user.getName(), (Object)action, (Object)matchingSystemIndices);
                }
                presponse.allowed = false;
                presponse.getMissingPrivileges();
                presponse.markComplete();
            }
            return;
        }
        if (this.isActionAllowed(action)) {
            if (requestedResolved.isLocalAll()) {
                if (this.filterSecurityIndex) {
                    this.irr.replace((TransportRequest)request, false, "*", "-" + this.securityIndex);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Filtered '{}' from {}, resulting list with *,-{} is {}", (Object)this.securityIndex, (Object)requestedResolved, (Object)this.securityIndex, (Object)this.irr.resolveRequest(request));
                    }
                } else {
                    this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
                    this.log.warn("{} for '_all' indices is not allowed for a regular user", (Object)action);
                    presponse.allowed = false;
                    presponse.markComplete();
                }
            } else if (containsSystemIndex && !this.isSystemIndexPermissionEnabled) {
                if (this.filterSecurityIndex) {
                    HashSet<String> allWithoutSecurity = new HashSet<String>(requestedResolved.getAllIndices());
                    allWithoutSecurity.remove(this.securityIndex);
                    if (allWithoutSecurity.isEmpty()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Filtered '{}' but resulting list is empty", (Object)this.securityIndex);
                        }
                        presponse.allowed = false;
                        presponse.markComplete();
                        return;
                    }
                    this.irr.replace((TransportRequest)request, false, allWithoutSecurity.toArray(new String[0]));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Filtered '{}', resulting list is {}", (Object)this.securityIndex, allWithoutSecurity);
                    }
                } else {
                    this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
                    String foundSystemIndexes = String.join((CharSequence)", ", this.getAllSystemIndices(requestedResolved));
                    this.log.warn("{} for '{}' index is not allowed for a regular user", (Object)action, (Object)foundSystemIndexes);
                    presponse.allowed = false;
                    presponse.markComplete();
                }
            }
        }
    }
}

