/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Logger;

public class ChannelUtil {
    private static final Logger logger = Logger.getLogger(ChannelUtil.class.getName());
    protected static final int BLOCK_SIZE = 65536;

    public static void writeFully(WritableByteChannel c, ByteBuffer b) throws IOException {
        if (b.isDirect()) {
            ChannelUtil.writeFullyInternal(c, b);
            return;
        }
        int limit = b.limit();
        if (limit < 65536) {
            ChannelUtil.writeFullyInternal(c, b);
            return;
        }
        int nBlocks = limit / 65536;
        if (limit % 65536 != 0) {
            ++nBlocks;
        }
        ByteBuffer wb = ByteBuffer.allocateDirect(65536);
        int i = 0;
        int pos = 0;
        while (i < nBlocks) {
            b.position(pos).limit(Math.min(pos + 65536, limit));
            ChannelUtil.writeFullyInternal(c, (ByteBuffer)wb.put(b).flip());
            wb.clear();
            ++i;
            pos += 65536;
        }
    }

    public static void writeFully(GatheringByteChannel c, ByteBuffer[] b, long size) throws IOException {
        if (size == 0L) {
            for (ByteBuffer byteBuffer : b) {
                size += (long)byteBuffer.remaining();
            }
        }
        for (long remain = size; remain > 0L; remain -= c.write(b)) {
        }
    }

    protected static int writeFullyInternal(WritableByteChannel c, ByteBuffer b) throws IOException {
        int written = 0;
        while (b.remaining() > 0) {
            written += c.write(b);
        }
        return written;
    }

    public static ByteBuffer readFully(ReadableByteChannel c, ByteBuffer b) throws IOException {
        int bytesRead;
        while (b.remaining() > 0 && (bytesRead = c.read(b)) != -1) {
        }
        return b;
    }

    public static ByteBuffer readFully(FileChannel c, long off, ByteBuffer b) throws IOException {
        int bytesRead;
        while (b.remaining() > 0 && (bytesRead = c.read(b, off)) != -1) {
            off += (long)bytesRead;
        }
        return b;
    }

    public static void transferFully(FileChannel src, FileChannel dst) throws IOException {
        long size = src.size();
        for (long written = 0L; written < size; written += src.transferTo(written, size - written, dst)) {
        }
    }

    public static void transferFully(FileChannel src, long position, long count, FileChannel dst) throws IOException {
        while (count > 0L) {
            long n = src.transferTo(position, count, dst);
            count -= n;
            position += n;
        }
    }
}

