/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ltr.stats.suppliers.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchType;
import org.opensearch.client.Client;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;

public class StoreUtils {
    private static final String FEATURE_SET_KEY = "featureset";
    private static final String FEATURE_SET_NAME_KEY = "name";
    private static final String FEATURES_KEY = "features";
    private final Client client;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public StoreUtils(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = new IndexNameExpressionResolver(new ThreadContext(clusterService.getSettings()));
    }

    public boolean checkLtrStoreExists(String storeName) {
        return this.clusterService.state().getRoutingTable().hasIndex(storeName);
    }

    public List<String> getAllLtrStoreNames() {
        String[] names = this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), (IndicesRequest)new ClusterStateRequest().indices(new String[]{".ltrstore", ".ltrstore_*"}));
        return Arrays.asList(names);
    }

    public String getLtrStoreHealthStatus(String storeName) {
        if (!this.checkLtrStoreExists(storeName)) {
            throw new IndexNotFoundException(storeName);
        }
        ClusterIndexHealth indexHealth = new ClusterIndexHealth(this.clusterService.state().metadata().index(storeName), this.clusterService.state().getRoutingTable().index(storeName));
        return indexHealth.getStatus().name().toLowerCase(Locale.getDefault());
    }

    public Map<String, Integer> extractFeatureSetStats(String storeName) {
        HashMap<String, Integer> featureSetStats = new HashMap<String, Integer>();
        SearchHits featureSetHits = this.searchStore(storeName, FEATURE_SET_KEY);
        for (SearchHit featureSetHit : featureSetHits) {
            this.extractFeatureSetFromFeatureSetHit(featureSetHit).ifPresent(featureSet -> {
                List features = (List)featureSet.get(FEATURES_KEY);
                featureSetStats.put((String)featureSet.get(FEATURE_SET_NAME_KEY), features.size());
            });
        }
        return featureSetStats;
    }

    private Optional<Map<String, Object>> extractFeatureSetFromFeatureSetHit(SearchHit featureSetHit) {
        Map featureSet;
        Map featureSetMap = featureSetHit.getSourceAsMap();
        if (featureSetMap != null && featureSetMap.containsKey(FEATURE_SET_KEY) && (featureSet = (Map)featureSetMap.get(FEATURE_SET_KEY)) != null && featureSet.containsKey(FEATURES_KEY) && featureSet.containsKey(FEATURE_SET_NAME_KEY)) {
            return Optional.of(featureSet);
        }
        return Optional.empty();
    }

    public long getModelCount(String storeName) {
        return this.searchStore((String)storeName, (String)"model").getTotalHits().value;
    }

    private SearchHits searchStore(String storeName, String docType) {
        return ((SearchResponse)this.client.prepareSearch(new String[]{storeName}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)docType)).get()).getHits();
    }
}

