/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.certificate.ocsp;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.encoder.Asn1Encoder;
import de.rub.nds.asn1.model.Asn1EncapsulatingBitString;
import de.rub.nds.asn1.model.Asn1EncapsulatingOctetString;
import de.rub.nds.asn1.model.Asn1Enumerated;
import de.rub.nds.asn1.model.Asn1Explicit;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.model.Asn1PrimitiveBitString;
import de.rub.nds.asn1.model.Asn1PrimitiveGeneralizedTime;
import de.rub.nds.asn1.model.Asn1PrimitiveOctetString;
import de.rub.nds.asn1.model.Asn1Sequence;
import de.rub.nds.asn1.parser.Asn1Parser;
import de.rub.nds.asn1.parser.ParserException;
import de.rub.nds.asn1.translator.ParseOcspTypesContext;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.certificate.ocsp.CertificateStatus;
import de.rub.nds.tlsattacker.core.certificate.ocsp.CertificateStatusParser;
import de.rub.nds.tlsattacker.core.certificate.ocsp.OCSPResponse;
import de.rub.nds.tlsattacker.core.certificate.ocsp.OCSPResponseTypes;
import de.rub.nds.tlsattacker.core.util.Asn1ToolInitializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.bouncycastle.crypto.tls.Certificate;

public class OCSPResponseParser {
    public static OCSPResponse parseResponse(byte[] encodedResponse) throws ParserException, IOException {
        Asn1ToolInitializer.initAsn1Tool();
        OCSPResponse responseMessage = new OCSPResponse();
        responseMessage.setEncodedResponse(encodedResponse);
        Asn1Parser asn1Parser = new Asn1Parser(encodedResponse, false);
        List decodedResponse = asn1Parser.parse(ParseOcspTypesContext.NAME);
        Asn1Sequence outerSequence = (Asn1Sequence)decodedResponse.get(0);
        Asn1Enumerated responseStatusObject = (Asn1Enumerated)outerSequence.getChildren().get(0);
        int responseStatus = responseStatusObject.getValue().intValue();
        if (responseStatus != 0) {
            return responseMessage;
        }
        Asn1Explicit responseBytesObject = (Asn1Explicit)outerSequence.getChildren().get(1);
        Asn1Sequence responseBytesSequence = (Asn1Sequence)responseBytesObject.getChildren().get(0);
        Asn1ObjectIdentifier responseTypeObject = (Asn1ObjectIdentifier)responseBytesSequence.getChildren().get(0);
        String responseTypeIdentifier = responseTypeObject.getValue();
        responseMessage.setResponseStatus(responseStatus);
        responseMessage.setResponseTypeIdentifier(responseTypeIdentifier);
        if (!responseTypeIdentifier.equals(OCSPResponseTypes.BASIC.getOID())) {
            throw new NotImplementedException("This response type is not supported. Identifier: " + responseTypeIdentifier);
        }
        OCSPResponseParser.parseBasicResponse(responseBytesSequence, responseMessage);
        return responseMessage;
    }

    private static void parseBasicResponse(Asn1Sequence basicResponseSequence, OCSPResponse responseMessage) throws IOException {
        Asn1EncapsulatingOctetString basicOscpResponseEncapsulated = (Asn1EncapsulatingOctetString)basicResponseSequence.getChildren().get(1);
        Asn1Sequence basicOcspResponse = (Asn1Sequence)basicOscpResponseEncapsulated.getChildren().get(0);
        Asn1Sequence tbsResponseData = (Asn1Sequence)basicOcspResponse.getChildren().get(0);
        List responderName = null;
        byte[] responderKey = null;
        Integer responseDataVersion = null;
        String producedAt = null;
        Asn1Sequence certificateStatusSequence = null;
        for (Asn1Encodable responseDataObject : tbsResponseData.getChildren()) {
            if (responseDataObject instanceof Asn1Explicit) {
                Asn1Explicit currentObject = (Asn1Explicit)responseDataObject;
                Asn1Encodable childObject = (Asn1Encodable)((Asn1Explicit)responseDataObject).getChildren().get(0);
                switch (currentObject.getOffset()) {
                    case 0: {
                        responseDataVersion = ((Asn1Integer)childObject).getValue().intValue();
                        break;
                    }
                    case 1: {
                        if (certificateStatusSequence == null) {
                            responderName = ((Asn1Sequence)childObject).getChildren();
                            break;
                        }
                        OCSPResponseParser.parseBasicResponseExtensions((Asn1Sequence)childObject, responseMessage);
                        break;
                    }
                    case 2: {
                        if (childObject instanceof Asn1PrimitiveOctetString) {
                            responderKey = ((Asn1PrimitiveOctetString)childObject).getValue();
                            break;
                        }
                        if (!(childObject instanceof Asn1EncapsulatingOctetString)) break;
                        responderKey = (byte[])((Asn1EncapsulatingOctetString)childObject).getContent().getValue();
                    }
                }
                continue;
            }
            if (responseDataObject instanceof Asn1PrimitiveGeneralizedTime) {
                producedAt = ((Asn1PrimitiveGeneralizedTime)responseDataObject).getValue();
                continue;
            }
            if (!(responseDataObject instanceof Asn1Sequence)) continue;
            certificateStatusSequence = (Asn1Sequence)responseDataObject;
        }
        LinkedList<CertificateStatus> certificateStatusList = new LinkedList<CertificateStatus>();
        if (certificateStatusSequence != null) {
            for (Asn1Encodable singleCertificateStatusSequence : certificateStatusSequence.getChildren()) {
                if (!(singleCertificateStatusSequence instanceof Asn1Sequence)) continue;
                certificateStatusList.add(CertificateStatusParser.parseCertificateStatus((Asn1Sequence)singleCertificateStatusSequence));
            }
        }
        responseMessage.setResponseDataVersion(responseDataVersion);
        if (responderKey != null) {
            responseMessage.setResponderKey(responderKey);
        }
        if (responderName != null) {
            responseMessage.setResponderName(responderName);
        }
        if (producedAt != null) {
            responseMessage.setProducedAt(producedAt);
        }
        responseMessage.setCertificateStatusList(certificateStatusList);
        OCSPResponseParser.parseBasicResponseSignature(basicOcspResponse, responseMessage);
    }

    private static void parseBasicResponseSignature(Asn1Sequence basicOcspResponse, OCSPResponse responseMessage) throws IOException {
        Asn1PrimitiveBitString signatureBitString;
        Asn1Sequence signatureAlgorithmSequence = (Asn1Sequence)basicOcspResponse.getChildren().get(1);
        String signatureAlgorithmIdentifier = ((Asn1ObjectIdentifier)signatureAlgorithmSequence.getChildren().get(0)).getValue();
        byte[] signature = null;
        Asn1Encodable signatureObject = (Asn1Encodable)basicOcspResponse.getChildren().get(2);
        if (signatureObject instanceof Asn1PrimitiveBitString) {
            signatureBitString = (Asn1PrimitiveBitString)signatureObject;
            signature = signatureBitString.getValue();
        } else if (signatureObject instanceof Asn1EncapsulatingBitString && (signature = (byte[])(signatureBitString = (Asn1EncapsulatingBitString)signatureObject).getContent().getValue())[0] == 0 && signature.length % 2 == 1) {
            signature = Arrays.copyOfRange(signature, 1, signature.length);
        }
        Asn1Explicit certs = null;
        if (basicOcspResponse.getChildren().size() > 3) {
            certs = (Asn1Explicit)basicOcspResponse.getChildren().get(3);
        }
        Certificate certificate = null;
        if (certs != null) {
            Asn1Sequence certOuterSequence = (Asn1Sequence)certs.getChildren().get(0);
            Asn1Sequence certSequence = (Asn1Sequence)certOuterSequence.getChildren().get(0);
            LinkedList<Asn1Sequence> toEncode = new LinkedList<Asn1Sequence>();
            toEncode.add(certSequence);
            Asn1Encoder asn1Encoder = new Asn1Encoder(toEncode);
            byte[] certificateSequenceEncoded = asn1Encoder.encode();
            byte[] certificateSequenceEncodedWithLength = ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.intToBytes((int)certificateSequenceEncoded.length, (int)3), certificateSequenceEncoded});
            ByteArrayInputStream stream = new ByteArrayInputStream(ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.intToBytes((int)certificateSequenceEncodedWithLength.length, (int)3), certificateSequenceEncodedWithLength}));
            certificate = Certificate.parse((InputStream)stream);
        }
        responseMessage.setSignatureAlgorithmIdentifier(signatureAlgorithmIdentifier);
        responseMessage.setSignature(signature);
        if (certificate != null) {
            responseMessage.setCertificate(certificate);
        }
    }

    private static void parseBasicResponseExtensions(Asn1Sequence extensionSequence, OCSPResponse responseMessage) {
        Asn1Sequence innerExtensionSequence = (Asn1Sequence)extensionSequence.getChildren().get(0);
        Asn1ObjectIdentifier extensionIdentifier = (Asn1ObjectIdentifier)innerExtensionSequence.getChildren().get(0);
        BigInteger nonce = null;
        if (extensionIdentifier.getValue().equals(OCSPResponseTypes.NONCE.getOID())) {
            Asn1EncapsulatingOctetString encapsulatedNonce = (Asn1EncapsulatingOctetString)innerExtensionSequence.getChildren().get(1);
            Asn1PrimitiveOctetString nonceOctetString = (Asn1PrimitiveOctetString)encapsulatedNonce.getChildren().get(0);
            nonce = new BigInteger(1, nonceOctetString.getValue());
        }
        if (nonce != null) {
            responseMessage.setNonce(nonce);
        }
    }
}

