/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ClientKeyExchangeParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHClientKeyExchangeParser<T extends ECDHClientKeyExchangeMessage>
extends ClientKeyExchangeParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ECDHClientKeyExchangeParser(int startposition, byte[] array, ProtocolVersion version, Config config) {
        super(startposition, array, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(ECDHClientKeyExchangeMessage msg) {
        LOGGER.debug("Parsing ECDHClientKeyExchangeMessage");
        this.parseSerializedPublicKeyLength(msg);
        this.parseSerializedPublicKey(msg);
    }

    protected void parseEcDhParams(T msg) {
        this.parseSerializedPublicKeyLength((ECDHClientKeyExchangeMessage)msg);
        this.parseSerializedPublicKey((ECDHClientKeyExchangeMessage)msg);
    }

    @Override
    protected T createHandshakeMessage() {
        return (T)new ECDHClientKeyExchangeMessage();
    }

    private void parseSerializedPublicKeyLength(ECDHClientKeyExchangeMessage msg) {
        msg.setPublicKeyLength(this.parseIntField(1));
        LOGGER.debug("SerializedPublicKeyLength: " + msg.getPublicKeyLength().getValue());
    }

    private void parseSerializedPublicKey(ECDHClientKeyExchangeMessage msg) {
        msg.setPublicKey(this.parseByteArrayField((Integer)msg.getPublicKeyLength().getValue()));
        LOGGER.debug("SerializedPublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPublicKey().getValue())));
    }
}

