/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.SSLUtils;
import de.rub.nds.tlsattacker.core.crypto.SignatureCalculator;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateVerifyPreparator
extends HandshakeMessagePreparator<CertificateVerifyMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private SignatureAndHashAlgorithm algorithm;
    private byte[] signature;
    private final CertificateVerifyMessage msg;

    public CertificateVerifyPreparator(Chooser chooser, CertificateVerifyMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing CertificateVerifiyMessage");
        this.algorithm = this.chooser.getSelectedSigHashAlgorithm();
        this.signature = new byte[0];
        try {
            this.signature = this.createSignature();
        }
        catch (CryptoException E) {
            LOGGER.warn("Could not generate Signature! Using empty one instead!", (Throwable)E);
        }
        this.prepareSignature(this.msg);
        this.prepareSignatureLength(this.msg);
        this.prepareSignatureHashAlgorithm(this.msg);
    }

    private byte[] createSignature() throws CryptoException {
        byte[] toBeSigned = this.chooser.getContext().getDigest().getRawBytes();
        if (this.chooser.getSelectedProtocolVersion().isTLS13()) {
            toBeSigned = this.chooser.getConnectionEndType() == ConnectionEndType.CLIENT ? ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.hexStringToByteArray((String)"20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020"), "TLS 1.3, client CertificateVerify".getBytes(), {0}, this.chooser.getContext().getDigest().digest(this.chooser.getSelectedProtocolVersion(), this.chooser.getSelectedCipherSuite())}) : ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.hexStringToByteArray((String)"20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020"), "TLS 1.3, server CertificateVerify".getBytes(), {0}, this.chooser.getContext().getDigest().digest(this.chooser.getSelectedProtocolVersion(), this.chooser.getSelectedCipherSuite())});
        } else if (this.chooser.getSelectedProtocolVersion().isSSL()) {
            byte[] handshakeMessageContent = this.chooser.getContext().getDigest().getRawBytes();
            byte[] masterSecret = this.chooser.getMasterSecret();
            return SSLUtils.calculateSSLCertificateVerifySignature(handshakeMessageContent, masterSecret);
        }
        this.algorithm = this.chooser.getSelectedSigHashAlgorithm();
        return SignatureCalculator.generateSignature(this.algorithm, this.chooser, toBeSigned);
    }

    private void prepareSignature(CertificateVerifyMessage msg) {
        msg.setSignature(this.signature);
        LOGGER.debug("Signature: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignature().getValue())));
    }

    private void prepareSignatureLength(CertificateVerifyMessage msg) {
        msg.setSignatureLength(((byte[])msg.getSignature().getValue()).length);
        LOGGER.debug("SignatureLength: " + msg.getSignatureLength().getValue());
    }

    private void prepareSignatureHashAlgorithm(CertificateVerifyMessage msg) {
        msg.setSignatureHashAlgorithm(this.algorithm.getByteValue());
        LOGGER.debug("SignatureHasAlgorithm: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignatureHashAlgorithm().getValue())));
    }
}

