/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.security;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.time.Duration;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.parosproxy.paros.security.CertData;
import org.parosproxy.paros.security.MissingRootCertificateException;
import org.parosproxy.paros.security.SslCertificateService;

public final class SslCertificateServiceImpl
implements SslCertificateService {
    private static final int SITE_CERTIFICATE_START_ADJUSTMENT = 30;
    private static final int SITE_CERTIFICATE_END_VALIDITY_PERIOD = 368;
    private X509Certificate caCert = null;
    private PublicKey caPubKey = null;
    private PrivateKey caPrivKey = null;
    private final AtomicLong serial;
    private static final SslCertificateService singleton = new SslCertificateServiceImpl();

    private SslCertificateServiceImpl() {
        Security.addProvider(new BouncyCastleProvider());
        Random rnd = new Random();
        rnd.setSeed(System.currentTimeMillis());
        long sl = (long)rnd.nextInt() << 32 | (long)rnd.nextInt() & 0xFFFFFFFFL;
        this.serial = new AtomicLong(sl &= 0xFFFFFFFFFFFFL);
    }

    @Override
    public synchronized void initializeRootCA(KeyStore keystore) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        if (keystore == null) {
            this.caCert = null;
            this.caPrivKey = null;
            this.caPubKey = null;
        } else {
            this.caCert = (X509Certificate)keystore.getCertificate("owasp_zap_root_ca");
            this.caPrivKey = (RSAPrivateKey)keystore.getKey("owasp_zap_root_ca", SslCertificateService.PASSPHRASE);
            this.caPubKey = this.caCert.getPublicKey();
        }
    }

    @Override
    public KeyStore createCertForHost(String hostname) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, SignatureException, NoSuchProviderException, InvalidKeyException, IOException {
        return this.createCertForHost(new CertData(hostname));
    }

    @Override
    public KeyStore createCertForHost(CertData certData) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException, NoSuchProviderException, SignatureException, KeyStoreException, IOException, UnrecoverableKeyException {
        ContentSigner sigGen;
        if (this.caCert == null || this.caPrivKey == null || this.caPubKey == null) {
            throw new MissingRootCertificateException(this.getClass() + " wasn't initialized! Got to options 'Dynamic SSL Certs' and create one.");
        }
        CertData.Name[] certDataNames = certData.getSubjectAlternativeNames();
        GeneralName[] subjectAlternativeNames = new GeneralName[certDataNames.length];
        for (int i = 0; i < certDataNames.length; ++i) {
            CertData.Name certDataName = certDataNames[i];
            subjectAlternativeNames[i] = new GeneralName(certDataName.getType(), certDataName.getValue());
        }
        if (certData.getCommonName() == null && subjectAlternativeNames.length == 0) {
            throw new IllegalArgumentException("commonName is null and no subjectAlternativeNames are specified");
        }
        KeyPair mykp = this.createKeyPair();
        PrivateKey privKey = mykp.getPrivate();
        PublicKey pubKey = mykp.getPublic();
        X500NameBuilder namebld = new X500NameBuilder(BCStyle.INSTANCE);
        if (certData.getCommonName() != null) {
            namebld.addRDN(BCStyle.CN, certData.getCommonName());
        }
        namebld.addRDN(BCStyle.OU, "Zed Attack Proxy Project");
        namebld.addRDN(BCStyle.O, "OWASP");
        namebld.addRDN(BCStyle.C, "xx");
        namebld.addRDN(BCStyle.EmailAddress, "zaproxy-develop@googlegroups.com");
        long currentTime = System.currentTimeMillis();
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(new X509CertificateHolder(this.caCert.getEncoded()).getSubject(), BigInteger.valueOf(this.serial.getAndIncrement()), new Date(currentTime - Duration.ofDays(30L).toMillis()), new Date(currentTime + Duration.ofDays(368L).toMillis()), namebld.build(), pubKey);
        certGen.addExtension(Extension.subjectKeyIdentifier, false, new SubjectKeyIdentifier(pubKey.getEncoded()));
        certGen.addExtension(Extension.basicConstraints, false, new BasicConstraints(false));
        certGen.addExtension(Extension.extendedKeyUsage, false, new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_serverAuth}));
        if (subjectAlternativeNames.length > 0) {
            certGen.addExtension(Extension.subjectAlternativeName, certData.isSubjectAlternativeNameIsCritical(), new GeneralNames(subjectAlternativeNames));
        }
        try {
            sigGen = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(this.caPrivKey);
        }
        catch (OperatorCreationException e) {
            throw new CertificateException(e);
        }
        X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certGen.build(sigGen));
        cert.checkValidity(new Date());
        cert.verify(this.caPubKey);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        Certificate[] chain = new Certificate[2];
        chain[1] = this.caCert;
        chain[0] = cert;
        ks.setKeyEntry("owasp_zap_root_ca", privKey, PASSPHRASE, chain);
        return ks;
    }

    private KeyPair createKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(Long.toString(System.currentTimeMillis()).getBytes());
        keyGen.initialize(2048, random);
        KeyPair keypair = keyGen.generateKeyPair();
        return keypair;
    }

    public static SslCertificateService getService() {
        return singleton;
    }
}

