/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

public enum MaxAccess {
    notAccessible("not-accessible"),
    accessibleForNotify("accessible-for-notify"),
    writeOnly("write-only"),
    readOnly("read-only"),
    readWrite("read-write"),
    readCreate("read-create");

    private String smiValue;

    private MaxAccess(String smiValue) {
        this.smiValue = smiValue;
    }

    public String getSmiValue() {
        return this.smiValue;
    }

    public static MaxAccess fromSmiValue(String smiValue) {
        for (MaxAccess v : MaxAccess.values()) {
            if (!v.getSmiValue().equals(smiValue)) continue;
            return v;
        }
        return null;
    }

    public boolean isReadOnly() {
        return this == readOnly;
    }

    public boolean isWritable() {
        return this.ordinal() >= readWrite.ordinal();
    }

    public boolean isCreatable() {
        return this == readCreate;
    }
}

